/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MRole;
import org.compiere.model.MTree;
import org.compiere.model.MTree_Node;
import org.compiere.model.MTree_NodeBP;
import org.compiere.model.MTree_NodeMM;
import org.compiere.model.MTree_NodePR;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.KeyNamePair;

public class TreeMaintenance {
    public int m_WindowNo = 0;
    public MTree m_tree;
    public static CLogger log = CLogger.getCLogger(TreeMaintenance.class);

    public KeyNamePair[] getTreeData() {
        return DB.getKeyNamePairs(MRole.getDefault().addAccessSQL("SELECT AD_Tree_ID, Name FROM AD_Tree WHERE TreeType NOT IN ('BB','PC') ORDER BY 2", "AD_Tree", false, true), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ListItem> getTreeItemData() {
        ArrayList<ListItem> data = new ArrayList<ListItem>();
        String fromClause = this.m_tree.getSourceTableName(false);
        String columnNameX = this.m_tree.getSourceTableName(true);
        String actionColor = this.m_tree.getActionColorName();
        String sql = "SELECT t." + columnNameX + "_ID,t.Name,t.Description,t.IsSummary," + actionColor + " FROM " + fromClause + " ORDER BY 2";
        sql = MRole.getDefault().addAccessSQL(sql, "t", true, false);
        log.config(sql);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ListItem item = new ListItem(rs.getInt(1), rs.getString(2), rs.getString(3), "Y".equals(rs.getString(4)), rs.getString(5));
                data.add(item);
            }
        }
        catch (Exception e) {
            try {
                log.log(Level.SEVERE, sql, e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return data;
    }

    public void addNode(ListItem item) {
        if (item != null) {
            if (this.m_tree.isProduct()) {
                MTree_NodePR node = new MTree_NodePR(this.m_tree, item.id);
                node.save();
            } else if (this.m_tree.isBPartner()) {
                MTree_NodeBP node = new MTree_NodeBP(this.m_tree, item.id);
                node.save();
            } else if (this.m_tree.isMenu()) {
                MTree_NodeMM node = new MTree_NodeMM(this.m_tree, item.id);
                node.save();
            } else {
                MTree_Node node = new MTree_Node(this.m_tree, item.id);
                node.save();
            }
        }
    }

    public void deleteNode(ListItem item) {
        if (item != null) {
            if (this.m_tree.isProduct()) {
                MTree_NodePR node = MTree_NodePR.get(this.m_tree, item.id);
                if (node != null) {
                    node.delete(true);
                }
            } else if (this.m_tree.isBPartner()) {
                MTree_NodeBP node = MTree_NodeBP.get(this.m_tree, item.id);
                if (node != null) {
                    node.delete(true);
                }
            } else if (this.m_tree.isMenu()) {
                MTree_NodeMM node = MTree_NodeMM.get(this.m_tree, item.id);
                if (node != null) {
                    node.delete(true);
                }
            } else {
                MTree_Node node = MTree_Node.get(this.m_tree, item.id);
                if (node != null) {
                    node.delete(true);
                }
            }
        }
    }

    public class ListItem {
        public int id;
        public String name;
        public String description;
        public boolean isSummary;
        public String imageIndicator;

        public ListItem(int ID2, String Name2, String Description2, boolean summary, String ImageIndicator) {
            this.id = ID2;
            this.name = Name2;
            this.description = Description2;
            this.isSummary = summary;
            this.imageIndicator = ImageIndicator;
        }

        public String toString() {
            String retValue = this.name;
            if (this.description != null && this.description.length() > 0) {
                retValue = retValue + " (" + this.description + ")";
            }
            return retValue;
        }
    }
}

