/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import com.f3p.adempiere.riba.model.MEffects;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.apps.form.GenForm;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.IMiniTable;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class DistintaManuale
extends GenForm {
    private static final long serialVersionUID = 2872767371244295934L;
    public int m_WindowNo = 0;
    public DecimalFormat m_format = DisplayType.getNumberFormat(12);
    private String m_sql;
    public int m_noSelected = 0;
    private int m_AD_Client_ID = 0;
    private int m_AD_Org_ID = 0;
    public boolean m_isLocked = false;
    public MEffects m_eff = null;
    public static CLogger log = CLogger.getCLogger(DistintaManuale.class);
    public Trx trx = null;

    public ArrayList<BankInfo> getBankAccountData() {
        ArrayList<BankInfo> data = new ArrayList<BankInfo>();
        this.m_AD_Client_ID = Env.getAD_Client_ID(Env.getCtx());
        this.m_AD_Org_ID = Env.getAD_Org_ID(Env.getCtx());
        String sql = "SELECT b.C_Bank_ID,b.Name  AS Name FROM C_Bank b WHERE   b.IsActive='Y' and b.IsOwnBank='Y' ORDER BY 2";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                boolean transfers = false;
                BankInfo bi = new BankInfo(rs.getInt(1), rs.getString(2), transfers);
                data.add(bi);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        return data;
    }

    public void prepareTable(IMiniTable miniTable) {
        this.m_sql = miniTable.prepareTable(new ColumnInfo[]{new ColumnInfo(" ", "r.RB_Effects_ID", IDColumn.class, false, false, null), new ColumnInfo("Scadenza", "r.DueDate ", Timestamp.class, true, true, null), new ColumnInfo("BPartner", "bp.Name ", String.class, true, true, null), new ColumnInfo("Banca", "b.A_Name", String.class, true, true, null), new ColumnInfo("IBAN", "b.IBAN", String.class, true, true, null), new ColumnInfo("Importo", "r.DiscountAmt", BigDecimal.class, true, true, null), new ColumnInfo("Documento", "f.DocumentNo", String.class, true, true, null), new ColumnInfo("DataDoc", "r.DateInvoiced", Timestamp.class, true, true, null), new ColumnInfo("Riferimento", "r.RB_Invoice_ID", Integer.class, true, true, null)}, "RB_EFFECTS r LEFT OUTER JOIN C_BPartner bp ON (r.C_BPartner_ID=bp.C_BPartner_ID ) LEFT OUTER JOIN C_BP_BankAccount b ON (r.C_BP_BankAccount_ID=b.C_BP_BankAccount_ID) LEFT OUTER JOIN C_Invoice f ON (r.C_Invoice_ID=f.C_invoice_ID)", " r.AD_Client_ID=?  AND r.AD_Org_ID= ?  and Status='NEW' and (r.C_BANK_ID = 0 or r.C_BANK_ID is null) and (r.RB_distinct_number = 0 or r.RB_distinct_number is null)  and TRUNC(r.duedate) >= ?  and TRUNC(r.duedate) <= ?  and TRUNC(r.DateInvoiced) >= ?  and TRUNC(r.DateInvoiced) <= ? ", true, "r");
    }

    public void loadTableInfo(BankInfo bi, Timestamp dateDa, Timestamp datea, Timestamp dateDocDa, Timestamp dateDoca, IMiniTable miniTable) {
        log.info("");
        if (this.m_sql == null) {
            return;
        }
        String sql = this.m_sql;
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            int index = 1;
            pstmt.setInt(index++, this.m_AD_Client_ID);
            pstmt.setInt(index++, this.m_AD_Org_ID);
            pstmt.setTimestamp(index++, dateDa);
            pstmt.setTimestamp(index++, datea);
            pstmt.setTimestamp(index++, dateDocDa);
            pstmt.setTimestamp(index++, dateDoca);
            ResultSet rs = pstmt.executeQuery();
            miniTable.loadTable(rs);
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
    }

    public BigDecimal cercaDistinta(BankInfo bi) {
        BigDecimal inc = new BigDecimal(1);
        BigDecimal numeroDist = Env.ZERO;
        this.m_AD_Client_ID = Env.getAD_Client_ID(Env.getCtx());
        this.m_AD_Org_ID = Env.getAD_Org_ID(Env.getCtx());
        String sql = "select max(rb_distinct_number) from adempiere.rb_effects where c_bank_id = ? ";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, bi.C_Bank_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                if (rs.getBigDecimal(1) == null) continue;
                numeroDist = rs.getBigDecimal(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        return numeroDist.add(inc);
    }

    public String calculateSelection(IMiniTable miniTable) {
        this.m_noSelected = 0;
        BigDecimal invoiceAmt = new BigDecimal(0.0);
        int rows = miniTable.getRowCount();
        int i = 0;
        while (i < rows) {
            IDColumn id = (IDColumn)miniTable.getValueAt(i, 0);
            if (id.isSelected()) {
                BigDecimal amt = (BigDecimal)miniTable.getValueAt(i, 5);
                if (amt != null) {
                    invoiceAmt = invoiceAmt.add(amt);
                }
                ++this.m_noSelected;
            }
            ++i;
        }
        StringBuffer info = new StringBuffer();
        info.append(this.m_noSelected).append(" ").append(Msg.getMsg(Env.getCtx(), "Selected")).append(" - ");
        info.append(this.m_format.format(invoiceAmt)).append(" Totale");
        return info.toString();
    }

    public String generateDistSelect(IMiniTable miniTable, Timestamp payDate, BankInfo bi, BigDecimal Numdist) {
        log.info("");
        String trxName = null;
        this.trx = null;
        this.m_eff = new MEffects(Env.getCtx(), 0, trxName);
        int p_Banck_id = bi.C_Bank_ID;
        int rows = miniTable.getRowCount();
        int line = 0;
        int i = 0;
        while (i < rows) {
            IDColumn id = (IDColumn)miniTable.getValueAt(i, 0);
            if (id.isSelected()) {
                int p_RB_Effects_ID = id.getRecord_ID();
                line += 10;
                String sql = "UPDATE RB_Effects set C_BANK_ID = ? \t, RB_submission_date = ?  , RB_distinct_number = ? \t, Status = 'PRT'  WHERE   RB_Effects_ID = ? ";
                Object[] oParams = new Object[]{p_Banck_id, payDate, Numdist, p_RB_Effects_ID};
                int n = DB.executeUpdateEx(sql, oParams, trxName);
            }
            ++i;
        }
        if (line == 0) {
            return "No select";
        }
        return null;
    }

    @Override
    public void configureMiniTable(IMiniTable miniTable) {
    }

    @Override
    public void saveSelection(IMiniTable miniTable) {
    }

    public class BankInfo {
        public int C_Bank_ID;
        String Name;
        boolean Transfers;

        public BankInfo(int newC_Bank_ID, String newName, boolean newTransfers) {
            this.C_Bank_ID = newC_Bank_ID;
            this.Name = newName;
        }

        public String toString() {
            return this.Name;
        }
    }
}

