/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import com.qwerty.pa.model.Mqweittransdate;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MTax;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class CorrispettiviAliq {
    private static final long serialVersionUID = 2872767371244295934L;
    public int m_WindowNo = 0;
    public DecimalFormat m_format = DisplayType.getNumberFormat(12);
    private String m_sql;
    public int m_noSelected = 0;
    private int m_AD_Client_ID = 0;
    private int m_AD_User_ID = 0;
    private int m_AD_Org_ID = 0;
    public boolean m_isLocked = false;
    private static BigDecimal ONEHUNDRED = new BigDecimal(100);
    public static CLogger log = CLogger.getCLogger(CorrispettiviAliq.class);
    public Trx trx = null;

    public void prepareTable(IMiniTable miniTable) {
        this.m_sql = miniTable.prepareTable(new ColumnInfo[]{new ColumnInfo(" ", "r.qweit_transdate_ID", IDColumn.class, false, false, null), new ColumnInfo("Data", "r.dateday ", Timestamp.class, true, true, null), new ColumnInfo("Iva1", "r.importouno", BigDecimal.class, false, false, null), new ColumnInfo("Iva2", "r.importodue", BigDecimal.class, false, false, null), new ColumnInfo("Iva3", "r.importotre", BigDecimal.class, false, false, null), new ColumnInfo("Iva4", "r.importoquattro", BigDecimal.class, false, false, null), new ColumnInfo("Iva5", "r.importocinque", BigDecimal.class, false, false, null)}, "qweit_transdate r", " r.AD_Client_ID=?  AND r.AD_Org_ID= ?  and r.createdby = ?  ", true, "r");
    }

    public void loadTableInfo(Timestamp dateDa, IMiniTable miniTable) {
        log.config("");
        if (this.m_sql == null) {
            return;
        }
        String sql = this.m_sql;
        try {
            int index = 1;
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(index++, this.m_AD_Client_ID);
            pstmt.setInt(index++, this.m_AD_Org_ID);
            pstmt.setInt(index++, this.m_AD_User_ID);
            ResultSet rs = pstmt.executeQuery();
            miniTable.loadTable(rs);
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
    }

    public void caricatab(Timestamp dateDa, int Account_ID, int C_DocType_ID, int c_tax1_id, int c_tax2_id, int c_tax3_id, int c_tax4_id, int c_tax5_id) {
        this.m_AD_Client_ID = Env.getAD_Client_ID(Env.getCtx());
        this.m_AD_Org_ID = Env.getAD_Org_ID(Env.getCtx());
        this.m_AD_User_ID = Env.getAD_User_ID(Env.getCtx());
        String sql = "delete from qweit_transdate  where createdby = ? and ad_client_id = ? and ad_org_id = ? ";
        Object[] oParams = new Object[]{this.m_AD_User_ID, this.m_AD_Client_ID, this.m_AD_Org_ID};
        int no = DB.executeUpdateEx(sql, oParams, null);
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(dateDa);
        Date primaData = calendar1.getTime();
        calendar1.add(2, 1);
        Date ulData = calendar1.getTime();
        Date eventDate = primaData;
        Date dataA = ulData;
        Date dat = eventDate;
        while (dat.compareTo(dataA) < 0) {
            Timestamp com_data = new Timestamp(eventDate.getTime());
            Mqweittransdate datex = new Mqweittransdate(Env.getCtx(), 0, null);
            datex.setAD_Org_ID(this.m_AD_Org_ID);
            datex.setdateday(com_data);
            datex.setAccount_ID(Account_ID);
            datex.setC_BPartnerDr_ID(1000000);
            datex.setC_DocType_ID(C_DocType_ID);
            datex.setc_tax1_id(c_tax1_id);
            datex.setc_tax2_id(c_tax2_id);
            datex.setc_tax3_id(c_tax3_id);
            datex.setc_tax4_id(c_tax4_id);
            datex.setc_tax5_id(c_tax5_id);
            datex.setc_tax6_id(0);
            datex.setc_tax7_id(0);
            datex.setimportouno(Env.ZERO);
            datex.setimportodue(Env.ZERO);
            datex.setimportotre(Env.ZERO);
            datex.setimportoquattro(Env.ZERO);
            datex.setimportocinque(Env.ZERO);
            datex.setimportosei(Env.ZERO);
            datex.setimportosette(Env.ZERO);
            datex.setIsGenerated(false);
            datex.saveEx();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(eventDate);
            calendar.add(5, 1);
            dat = eventDate = calendar.getTime();
        }
    }

    public String calculateSelection(IMiniTable miniTable) {
        this.m_noSelected = 0;
        BigDecimal importo = new BigDecimal(0.0);
        BigDecimal invoiceAmt1 = new BigDecimal(0.0);
        BigDecimal invoiceAmt2 = new BigDecimal(0.0);
        BigDecimal invoiceAmt3 = new BigDecimal(0.0);
        BigDecimal invoiceAmt4 = new BigDecimal(0.0);
        BigDecimal invoiceAmt5 = new BigDecimal(0.0);
        int rows = miniTable.getRowCount();
        int i = 0;
        while (i < rows) {
            IDColumn id = (IDColumn)miniTable.getValueAt(i, 0);
            if (id.isSelected()) {
                int qweit_transdate_ID = id.getRecord_ID();
                Mqweittransdate aggex = new Mqweittransdate(Env.getCtx(), qweit_transdate_ID, null);
                BigDecimal amt1 = (BigDecimal)miniTable.getValueAt(i, 2);
                if (amt1 != null) {
                    aggex.setimportouno(amt1);
                }
                invoiceAmt1 = invoiceAmt1.add(amt1);
                BigDecimal amt2 = (BigDecimal)miniTable.getValueAt(i, 3);
                if (amt2 != null) {
                    aggex.setimportodue(amt2);
                }
                invoiceAmt2 = invoiceAmt2.add(amt2);
                BigDecimal amt3 = (BigDecimal)miniTable.getValueAt(i, 4);
                if (amt3 != null) {
                    aggex.setimportotre(amt3);
                }
                invoiceAmt3 = invoiceAmt3.add(amt3);
                BigDecimal amt4 = (BigDecimal)miniTable.getValueAt(i, 5);
                if (amt4 != null) {
                    aggex.setimportoquattro(amt4);
                }
                invoiceAmt4 = invoiceAmt4.add(amt4);
                BigDecimal amt5 = (BigDecimal)miniTable.getValueAt(i, 6);
                if (amt5 != null) {
                    aggex.setimportocinque(amt5);
                }
                invoiceAmt5 = invoiceAmt5.add(amt2);
                aggex.saveEx();
                ++this.m_noSelected;
            }
            ++i;
        }
        StringBuffer info = new StringBuffer();
        info.append(this.m_noSelected).append(" ").append(Msg.getMsg(Env.getCtx(), "Selected")).append(" - ");
        info.append(" Totale1 ").append(this.m_format.format(invoiceAmt1));
        info.append(" Totale2 ").append(this.m_format.format(invoiceAmt2));
        info.append(" Totale3 ").append(this.m_format.format(invoiceAmt3));
        info.append(" Totale4 ").append(this.m_format.format(invoiceAmt4));
        info.append(" Totale5 ").append(this.m_format.format(invoiceAmt5));
        return info.toString();
    }

    public String generateDistSelect(IMiniTable miniTable) {
        log.info("");
        this.trx = null;
        int rows = miniTable.getRowCount();
        int line = 0;
        int i = 0;
        while (i < rows) {
            IDColumn id = (IDColumn)miniTable.getValueAt(i, 0);
            if (id.isSelected()) {
                int qweit_transdate_ID = id.getRecord_ID();
                this.createInvoice(qweit_transdate_ID);
                line += 10;
            }
            ++i;
        }
        if (line == 0) {
            return "No select";
        }
        return null;
    }

    public MInvoice createInvoice(int qweit_transdate_ID) {
        String bprule;
        Integer Price_id;
        Integer SaleRep_id;
        Integer bppag_id;
        Integer bpl_id;
        MInvoice realinvoice;
        Mqweittransdate datex;
        block13: {
            datex = new Mqweittransdate(Env.getCtx(), qweit_transdate_ID, null);
            realinvoice = new MInvoice(Env.getCtx(), 0, null);
            realinvoice.setAD_Org_ID(datex.getAD_Org_ID());
            realinvoice.setC_BPartner_ID(datex.getC_BPartnerDr_ID());
            bpl_id = 0;
            bppag_id = 0;
            SaleRep_id = 0;
            Price_id = 0;
            bprule = null;
            String sql = "SELECT l.C_BPartner_Location_ID , p.C_PaymentTerm_ID , p.PaymentRule , p.SalesRep_ID , p.M_PriceList_ID  FROM C_BPartner p LEFT OUTER JOIN C_BPartner_Location l ON (p.C_BPartner_ID=l.C_BPartner_ID AND l.IsBillTo='Y' AND l.IsActive='Y')  WHERE p.IsActive='Y' AND p.C_BPartner_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, datex.getC_BPartnerDr_ID());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        bpl_id = rs.getInt("C_BPartner_Location_ID");
                        bppag_id = rs.getInt("C_PaymentTerm_ID");
                        bprule = rs.getString("PaymentRule");
                        SaleRep_id = rs.getInt("SalesRep_ID");
                        Price_id = rs.getInt("M_PriceList_ID");
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, "bPartner", e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block13;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        realinvoice.setC_BPartner_Location_ID(bpl_id);
        realinvoice.setC_Charge_ID(0);
        realinvoice.setC_DocType_ID(datex.getC_DocType_ID());
        realinvoice.setC_DocTypeTarget_ID(datex.getC_DocType_ID());
        realinvoice.setC_PaymentTerm_ID(bppag_id);
        realinvoice.setPaymentRule(bprule);
        realinvoice.setSalesRep_ID(SaleRep_id);
        realinvoice.setM_PriceList_ID(Price_id);
        realinvoice.setC_Project_ID(0);
        realinvoice.setDateAcct(datex.getdateday());
        realinvoice.setDateInvoiced(datex.getdateday());
        realinvoice.setIsSOTrx(true);
        realinvoice.setDescription("");
        realinvoice.setC_Order_ID(0);
        realinvoice.saveEx();
        int k = 0;
        int codtax = 0;
        BigDecimal importo = Env.ZERO;
        k = 1;
        while (k < 6) {
            if (k == 1) {
                codtax = datex.getc_tax1_id();
                importo = datex.getimportouno();
            }
            if (k == 2) {
                codtax = datex.getc_tax2_id();
                importo = datex.getimportodue();
            }
            if (k == 3) {
                codtax = datex.getc_tax3_id();
                importo = datex.getimportotre();
            }
            if (k == 4) {
                codtax = datex.getc_tax4_id();
                importo = datex.getimportoquattro();
            }
            if (k == 5) {
                codtax = datex.getc_tax5_id();
                importo = datex.getimportocinque();
            }
            if (codtax > 0) {
                MInvoiceLine iline = new MInvoiceLine(realinvoice);
                iline.setC_Activity_ID(0);
                iline.setC_Project_ID(0);
                iline.setDescription("");
                BigDecimal tax = null;
                MTax ctax = new MTax(Env.getCtx(), datex.getc_tax1_id(), null);
                BigDecimal multiplier = ctax.getRate().divide(ONEHUNDRED, 12, 4);
                multiplier = multiplier.add(Env.ONE);
                BigDecimal base = importo.divide(multiplier, 2, 4);
                tax = importo.subtract(base);
                iline.setLineNetAmt(base);
                iline.setTaxAmt(tax);
                iline.setC_Tax_ID(codtax);
                iline.setQty(1);
                iline.setPriceEntered(base);
                iline.setPriceActual(base);
                iline.setLineTotalAmt(importo);
                iline.saveEx();
            }
            ++k;
        }
        return realinvoice;
    }

    protected ArrayList<KeyNamePair> loadDocType() {
        ArrayList<KeyNamePair> list;
        block13: {
            list = new ArrayList<KeyNamePair>();
            String sqlStmt = "SELECT c.C_DocType_ID, c.Name from C_DocType c WHERE  c.IsActive='Y' ORDER BY 2";
            CPreparedStatement pstmt = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sqlStmt, null);
                    ResultSet rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new KeyNamePair(rs.getInt(1), rs.getString(2)));
                    }
                    rs.close();
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sqlStmt.toString(), e);
                    if (pstmt == null) break block13;
                    try {
                        pstmt.close();
                    }
                    catch (Exception ex) {
                        log.severe("Could not close prepared statement");
                    }
                }
            }
            finally {
                if (pstmt != null) {
                    try {
                        pstmt.close();
                    }
                    catch (Exception ex) {
                        log.severe("Could not close prepared statement");
                    }
                }
            }
        }
        return list;
    }

    protected ArrayList<KeyNamePair> loadAccount() {
        ArrayList<KeyNamePair> list;
        block13: {
            list = new ArrayList<KeyNamePair>();
            String sqlStmt = "SELECT c.C_ELEMENTVALUE_ID, c.Name from C_ELEMENTVALUE c WHERE  c.IsActive='Y' ORDER BY c.Value";
            CPreparedStatement pstmt = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sqlStmt, null);
                    ResultSet rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new KeyNamePair(rs.getInt(1), rs.getString(2)));
                    }
                    rs.close();
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sqlStmt.toString(), e);
                    if (pstmt == null) break block13;
                    try {
                        pstmt.close();
                    }
                    catch (Exception ex) {
                        log.severe("Could not close prepared statement");
                    }
                }
            }
            finally {
                if (pstmt != null) {
                    try {
                        pstmt.close();
                    }
                    catch (Exception ex) {
                        log.severe("Could not close prepared statement");
                    }
                }
            }
        }
        return list;
    }

    protected ArrayList<KeyNamePair> loadTax() {
        ArrayList<KeyNamePair> list;
        block13: {
            list = new ArrayList<KeyNamePair>();
            String sqlStmt = "SELECT c.C_Tax_ID, c.Name from C_Tax c WHERE  c.IsActive='Y' ORDER BY c.Name";
            CPreparedStatement pstmt = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sqlStmt, null);
                    ResultSet rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new KeyNamePair(rs.getInt(1), rs.getString(2)));
                    }
                    rs.close();
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sqlStmt.toString(), e);
                    if (pstmt == null) break block13;
                    try {
                        pstmt.close();
                    }
                    catch (Exception ex) {
                        log.severe("Could not close prepared statement");
                    }
                }
            }
            finally {
                if (pstmt != null) {
                    try {
                        pstmt.close();
                    }
                    catch (Exception ex) {
                        log.severe("Could not close prepared statement");
                    }
                }
            }
        }
        return list;
    }
}

