/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;

public class Allocation {
    public DecimalFormat format = DisplayType.getNumberFormat(12);
    public static CLogger log = CLogger.getCLogger(Allocation.class);
    private boolean m_calculating = false;
    public int m_C_Currency_ID = 0;
    public int m_C_BPartner_ID = 0;
    private int m_noInvoices = 0;
    private int m_noPayments = 0;
    public BigDecimal totalInv = new BigDecimal(0.0);
    public BigDecimal totalPay = new BigDecimal(0.0);
    public BigDecimal totalDiff = new BigDecimal(0.0);
    public Timestamp allocDate = null;
    private int i_payment = 7;
    private int i_open = 6;
    private int i_discount = 7;
    private int i_writeOff = 8;
    private int i_applied = 9;
    private int i_overUnder = 10;
    public int m_AD_Org_ID = 0;
    private ArrayList<Integer> m_bpartnerCheck = new ArrayList();

    public void dynInit() throws Exception {
        this.m_C_Currency_ID = Env.getContextAsInt(Env.getCtx(), "$C_Currency_ID");
        log.info("Currency=" + this.m_C_Currency_ID);
        this.m_AD_Org_ID = Env.getAD_Org_ID(Env.getCtx());
    }

    public void checkBPartner() {
        log.config("BPartner=" + this.m_C_BPartner_ID + ", Cur=" + this.m_C_Currency_ID);
        if (this.m_C_BPartner_ID == 0 || this.m_C_Currency_ID == 0) {
            return;
        }
        Integer key = new Integer(this.m_C_BPartner_ID);
        if (!this.m_bpartnerCheck.contains(key)) {
            new Thread(){

                @Override
                public void run() {
                    MPayment.setIsAllocated(Env.getCtx(), Allocation.this.m_C_BPartner_ID, null);
                    MInvoice.setIsPaid(Env.getCtx(), Allocation.this.m_C_BPartner_ID, null);
                }
            }.start();
            this.m_bpartnerCheck.add(key);
        }
    }

    public Vector<Vector<Object>> getPaymentData(boolean isMultiCurrency, Object date, IMiniTable paymentTable) {
        Vector<Vector<Object>> data = new Vector<Vector<Object>>();
        StringBuffer sql = new StringBuffer("SELECT p.DateTrx,p.DocumentNo,p.C_Payment_ID,c.ISO_Code,p.PayAmt,currencyConvert(p.PayAmt,p.C_Currency_ID,?,?,p.C_ConversionType_ID,p.AD_Client_ID,p.AD_Org_ID),currencyConvert(paymentAvailable(C_Payment_ID),p.C_Currency_ID,?,?,p.C_ConversionType_ID,p.AD_Client_ID,p.AD_Org_ID),p.MultiplierAP FROM C_Payment_v p INNER JOIN C_Currency c ON (p.C_Currency_ID=c.C_Currency_ID) WHERE p.IsAllocated='N' AND p.Processed='Y' AND p.C_Charge_ID IS NULL AND p.C_BPartner_ID=?");
        if (!isMultiCurrency) {
            sql.append(" AND p.C_Currency_ID=?");
        }
        if (this.m_AD_Org_ID != 0) {
            sql.append(" AND p.AD_Org_ID=" + this.m_AD_Org_ID);
        }
        sql.append(" ORDER BY p.DateTrx,p.DocumentNo");
        sql = new StringBuffer(MRole.getDefault(Env.getCtx(), false).addAccessSQL(sql.toString(), "p", true, false));
        log.fine("PaySQL=" + sql.toString());
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setInt(1, this.m_C_Currency_ID);
            pstmt.setTimestamp(2, (Timestamp)date);
            pstmt.setInt(3, this.m_C_Currency_ID);
            pstmt.setTimestamp(4, (Timestamp)date);
            pstmt.setInt(5, this.m_C_BPartner_ID);
            if (!isMultiCurrency) {
                pstmt.setInt(6, this.m_C_Currency_ID);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Vector<Object> line = new Vector<Object>();
                line.add(new Boolean(false));
                line.add(rs.getTimestamp(1));
                KeyNamePair pp = new KeyNamePair(rs.getInt(3), rs.getString(2));
                line.add(pp);
                if (isMultiCurrency) {
                    line.add(rs.getString(4));
                    line.add(rs.getBigDecimal(5));
                }
                line.add(rs.getBigDecimal(6));
                BigDecimal available = rs.getBigDecimal(7);
                if (available == null || available.signum() == 0) continue;
                line.add(available);
                line.add(Env.ZERO);
                data.add(line);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), e);
        }
        return data;
    }

    public Vector<String> getPaymentColumnNames(boolean isMultiCurrency) {
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(Msg.getMsg(Env.getCtx(), "Select"));
        columnNames.add(Msg.translate(Env.getCtx(), "Date"));
        columnNames.add(Util.cleanAmp(Msg.translate(Env.getCtx(), "DocumentNo")));
        if (isMultiCurrency) {
            columnNames.add(Msg.getMsg(Env.getCtx(), "TrxCurrency"));
            columnNames.add(Msg.translate(Env.getCtx(), "Amount"));
        }
        columnNames.add(Msg.getMsg(Env.getCtx(), "ConvertedAmount"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "OpenAmt"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "AppliedAmt"));
        return columnNames;
    }

    public void setPaymentColumnClass(IMiniTable paymentTable, boolean isMultiCurrency) {
        int i = 0;
        paymentTable.setColumnClass(i++, Boolean.class, false);
        paymentTable.setColumnClass(i++, Timestamp.class, true);
        paymentTable.setColumnClass(i++, String.class, true);
        if (isMultiCurrency) {
            paymentTable.setColumnClass(i++, String.class, true);
            paymentTable.setColumnClass(i++, BigDecimal.class, true);
        }
        paymentTable.setColumnClass(i++, BigDecimal.class, true);
        paymentTable.setColumnClass(i++, BigDecimal.class, true);
        paymentTable.setColumnClass(i++, BigDecimal.class, false);
        this.i_payment = isMultiCurrency ? 7 : 5;
        paymentTable.autoSize();
    }

    public Vector<Vector<Object>> getInvoiceData(boolean isMultiCurrency, Object date, IMiniTable invoiceTable) {
        Vector<Vector<Object>> data = new Vector<Vector<Object>>();
        StringBuffer sql = new StringBuffer("SELECT i.DateInvoiced,i.DocumentNo,i.C_Invoice_ID,c.ISO_Code,i.GrandTotal*i.MultiplierAP, currencyConvert(i.GrandTotal*i.MultiplierAP,i.C_Currency_ID,?,?,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID), currencyConvert(invoiceOpen(C_Invoice_ID,C_InvoicePaySchedule_ID),i.C_Currency_ID,?,?,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID)*i.MultiplierAP, currencyConvert(invoiceDiscount(i.C_Invoice_ID,?,C_InvoicePaySchedule_ID),i.C_Currency_ID,?,i.DateInvoiced,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID)*i.Multiplier*i.MultiplierAP,i.MultiplierAP FROM C_Invoice_v i INNER JOIN C_Currency c ON (i.C_Currency_ID=c.C_Currency_ID) WHERE i.IsPaid='N' AND i.Processed='Y' AND i.C_BPartner_ID=?");
        if (!isMultiCurrency) {
            sql.append(" AND i.C_Currency_ID=?");
        }
        if (this.m_AD_Org_ID != 0) {
            sql.append(" AND i.AD_Org_ID=" + this.m_AD_Org_ID);
        }
        sql.append(" ORDER BY i.DateInvoiced, i.DocumentNo");
        log.fine("InvSQL=" + sql.toString());
        sql = new StringBuffer(MRole.getDefault(Env.getCtx(), false).addAccessSQL(sql.toString(), "i", true, false));
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setInt(1, this.m_C_Currency_ID);
            pstmt.setTimestamp(2, (Timestamp)date);
            pstmt.setInt(3, this.m_C_Currency_ID);
            pstmt.setTimestamp(4, (Timestamp)date);
            pstmt.setTimestamp(5, (Timestamp)date);
            pstmt.setInt(6, this.m_C_Currency_ID);
            pstmt.setInt(7, this.m_C_BPartner_ID);
            if (!isMultiCurrency) {
                pstmt.setInt(8, this.m_C_Currency_ID);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Vector<Object> line = new Vector<Object>();
                line.add(new Boolean(false));
                line.add(rs.getTimestamp(1));
                KeyNamePair pp = new KeyNamePair(rs.getInt(3), rs.getString(2));
                line.add(pp);
                if (isMultiCurrency) {
                    line.add(rs.getString(4));
                    line.add(rs.getBigDecimal(5));
                }
                line.add(rs.getBigDecimal(6));
                BigDecimal open = rs.getBigDecimal(7);
                if (open == null) {
                    open = Env.ZERO;
                }
                line.add(open);
                BigDecimal discount = rs.getBigDecimal(8);
                if (discount == null) {
                    discount = Env.ZERO;
                }
                line.add(discount);
                line.add(Env.ZERO);
                line.add(Env.ZERO);
                line.add(open);
                if (Env.ZERO.compareTo(open) == 0) continue;
                data.add(line);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), e);
        }
        return data;
    }

    public Vector<String> getInvoiceColumnNames(boolean isMultiCurrency) {
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(Msg.getMsg(Env.getCtx(), "Select"));
        columnNames.add(Msg.translate(Env.getCtx(), "Date"));
        columnNames.add(Util.cleanAmp(Msg.translate(Env.getCtx(), "DocumentNo")));
        if (isMultiCurrency) {
            columnNames.add(Msg.getMsg(Env.getCtx(), "TrxCurrency"));
            columnNames.add(Msg.translate(Env.getCtx(), "Amount"));
        }
        columnNames.add(Msg.getMsg(Env.getCtx(), "ConvertedAmount"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "OpenAmt"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Discount"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "WriteOff"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "AppliedAmt"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "OverUnderAmt"));
        return columnNames;
    }

    public void setInvoiceColumnClass(IMiniTable invoiceTable, boolean isMultiCurrency) {
        int i = 0;
        invoiceTable.setColumnClass(i++, Boolean.class, false);
        invoiceTable.setColumnClass(i++, Timestamp.class, true);
        invoiceTable.setColumnClass(i++, String.class, true);
        if (isMultiCurrency) {
            invoiceTable.setColumnClass(i++, String.class, true);
            invoiceTable.setColumnClass(i++, BigDecimal.class, true);
        }
        invoiceTable.setColumnClass(i++, BigDecimal.class, true);
        invoiceTable.setColumnClass(i++, BigDecimal.class, true);
        invoiceTable.setColumnClass(i++, BigDecimal.class, false);
        invoiceTable.setColumnClass(i++, BigDecimal.class, false);
        invoiceTable.setColumnClass(i++, BigDecimal.class, false);
        invoiceTable.setColumnClass(i++, BigDecimal.class, true);
        invoiceTable.autoSize();
    }

    public void calculate(boolean isMultiCurrency) {
        this.i_open = isMultiCurrency ? 6 : 4;
        this.i_discount = isMultiCurrency ? 7 : 5;
        this.i_writeOff = isMultiCurrency ? 8 : 6;
        this.i_applied = isMultiCurrency ? 9 : 7;
        this.i_overUnder = isMultiCurrency ? 10 : 8;
    }

    public String writeOff(int row, int col, boolean isInvoice, IMiniTable payment, IMiniTable invoice, boolean isAutoWriteOff) {
        String msg = "";
        if (this.m_calculating) {
            return msg;
        }
        this.m_calculating = true;
        log.config("Row=" + row + ", Col=" + col + ", InvoiceTable=" + isInvoice);
        if (!isInvoice) {
            BigDecimal open = (BigDecimal)payment.getValueAt(row, this.i_open);
            BigDecimal applied = (BigDecimal)payment.getValueAt(row, this.i_payment);
            if (col == 0) {
                if (((Boolean)payment.getValueAt(row, 0)).booleanValue()) {
                    applied = open;
                    if (this.totalDiff.abs().compareTo(applied.abs()) < 0 && this.totalDiff.signum() == -applied.signum()) {
                        applied = this.totalDiff.negate();
                    }
                } else {
                    applied = Env.ZERO;
                }
            }
            if (col == this.i_payment) {
                if (applied.signum() == -open.signum()) {
                    applied = applied.negate();
                }
                if (open.abs().compareTo(applied.abs()) < 0) {
                    applied = open;
                }
            }
            payment.setValueAt(applied, row, this.i_payment);
        } else {
            boolean selected = (Boolean)invoice.getValueAt(row, 0);
            BigDecimal open = (BigDecimal)invoice.getValueAt(row, this.i_open);
            BigDecimal discount = (BigDecimal)invoice.getValueAt(row, this.i_discount);
            BigDecimal applied = (BigDecimal)invoice.getValueAt(row, this.i_applied);
            BigDecimal writeOff = (BigDecimal)invoice.getValueAt(row, this.i_writeOff);
            BigDecimal overUnder = (BigDecimal)invoice.getValueAt(row, this.i_overUnder);
            int openSign = open.signum();
            if (col == 0) {
                if (selected) {
                    applied = open;
                    applied = applied.subtract(discount);
                    writeOff = Env.ZERO;
                    overUnder = Env.ZERO;
                    if (this.totalDiff.abs().compareTo(applied.abs()) < 0 && this.totalDiff.signum() == applied.signum()) {
                        applied = this.totalDiff;
                    }
                    if (isAutoWriteOff) {
                        writeOff = open.subtract(applied.add(discount));
                    } else {
                        overUnder = open.subtract(applied.add(discount));
                    }
                } else {
                    writeOff = Env.ZERO;
                    applied = Env.ZERO;
                    overUnder = Env.ZERO;
                }
            }
            if (selected && col != 0) {
                if (discount.signum() == -openSign) {
                    discount = discount.negate();
                }
                if (writeOff.signum() == -openSign) {
                    writeOff = writeOff.negate();
                }
                if (applied.signum() == -openSign) {
                    applied = applied.negate();
                }
                if (discount.abs().compareTo(open.abs()) > 0) {
                    discount = open;
                }
                if (writeOff.abs().compareTo(open.abs()) > 0) {
                    writeOff = open;
                }
                BigDecimal newTotal = discount.add(writeOff).add(applied).add(overUnder);
                BigDecimal difference = newTotal.subtract(open);
                BigDecimal diffWOD = writeOff.add(discount).subtract(open);
                if (diffWOD.signum() == open.signum()) {
                    if (col == this.i_discount) {
                        writeOff = writeOff.subtract(diffWOD);
                    } else {
                        discount = discount.subtract(diffWOD);
                    }
                    difference = difference.subtract(diffWOD);
                }
                if (col == this.i_applied) {
                    overUnder = overUnder.subtract(difference);
                } else {
                    applied = applied.subtract(difference);
                }
            }
            if (isAutoWriteOff && writeOff.doubleValue() / open.doubleValue() > 0.3) {
                msg = "AllocationWriteOffWarn";
            }
            invoice.setValueAt(discount, row, this.i_discount);
            invoice.setValueAt(applied, row, this.i_applied);
            invoice.setValueAt(writeOff, row, this.i_writeOff);
            invoice.setValueAt(overUnder, row, this.i_overUnder);
            invoice.repaint();
        }
        this.m_calculating = false;
        return msg;
    }

    public String calculatePayment(IMiniTable payment, boolean isMultiCurrency) {
        log.config("");
        this.totalPay = new BigDecimal(0.0);
        int rows = payment.getRowCount();
        this.m_noPayments = 0;
        int i = 0;
        while (i < rows) {
            if (((Boolean)payment.getValueAt(i, 0)).booleanValue()) {
                Timestamp ts = (Timestamp)payment.getValueAt(i, 1);
                if (!isMultiCurrency) {
                    this.allocDate = TimeUtil.max(this.allocDate, ts);
                }
                BigDecimal bd = (BigDecimal)payment.getValueAt(i, this.i_payment);
                this.totalPay = this.totalPay.add(bd);
                ++this.m_noPayments;
                log.fine("Payment_" + i + " = " + bd + " - Total=" + this.totalPay);
            }
            ++i;
        }
        return String.valueOf(String.valueOf(this.m_noPayments)) + " - " + Msg.getMsg(Env.getCtx(), "Sum") + "  " + this.format.format(this.totalPay) + " ";
    }

    public String calculateInvoice(IMiniTable invoice, boolean isMultiCurrency) {
        this.totalInv = new BigDecimal(0.0);
        int rows = invoice.getRowCount();
        this.m_noInvoices = 0;
        int i = 0;
        while (i < rows) {
            if (((Boolean)invoice.getValueAt(i, 0)).booleanValue()) {
                Timestamp ts = (Timestamp)invoice.getValueAt(i, 1);
                if (!isMultiCurrency) {
                    this.allocDate = TimeUtil.max(this.allocDate, ts);
                }
                BigDecimal bd = (BigDecimal)invoice.getValueAt(i, this.i_applied);
                this.totalInv = this.totalInv.add(bd);
                ++this.m_noInvoices;
                log.fine("Invoice_" + i + " = " + bd + " - Total=" + this.totalPay);
            }
            ++i;
        }
        return String.valueOf(String.valueOf(this.m_noInvoices)) + " - " + Msg.getMsg(Env.getCtx(), "Sum") + "  " + this.format.format(this.totalInv) + " ";
    }

    public String saveData(int m_WindowNo, Object date, IMiniTable payment, IMiniTable invoice, String trxName) {
        int C_Invoice_ID;
        KeyNamePair pp;
        if (this.m_noInvoices + this.m_noPayments == 0) {
            return "";
        }
        int AD_Client_ID = Env.getContextAsInt(Env.getCtx(), m_WindowNo, "AD_Client_ID");
        int AD_Org_ID = Env.getContextAsInt(Env.getCtx(), m_WindowNo, "AD_Org_ID");
        int C_BPartner_ID = this.m_C_BPartner_ID;
        int C_Order_ID = 0;
        int C_CashLine_ID = 0;
        Timestamp DateTrx = (Timestamp)date;
        int C_Currency_ID = this.m_C_Currency_ID;
        if (AD_Org_ID == 0) {
            throw new AdempiereException("@Org0NotAllowed@");
        }
        log.config("Client=" + AD_Client_ID + ", Org=" + AD_Org_ID + ", BPartner=" + C_BPartner_ID + ", Date=" + DateTrx);
        int pRows = payment.getRowCount();
        ArrayList<Integer> paymentList = new ArrayList<Integer>(pRows);
        ArrayList<BigDecimal> amountList = new ArrayList<BigDecimal>(pRows);
        BigDecimal paymentAppliedAmt = Env.ZERO;
        int i = 0;
        while (i < pRows) {
            if (((Boolean)payment.getValueAt(i, 0)).booleanValue()) {
                KeyNamePair pp2 = (KeyNamePair)payment.getValueAt(i, 2);
                int C_Payment_ID = pp2.getKey();
                paymentList.add(new Integer(C_Payment_ID));
                BigDecimal PaymentAmt = (BigDecimal)payment.getValueAt(i, this.i_payment);
                amountList.add(PaymentAmt);
                paymentAppliedAmt = paymentAppliedAmt.add(PaymentAmt);
                log.fine("C_Payment_ID=" + C_Payment_ID + " - PaymentAmt=" + PaymentAmt);
            }
            ++i;
        }
        log.config("Number of Payments=" + paymentList.size() + " - Total=" + paymentAppliedAmt);
        int iRows = invoice.getRowCount();
        MAllocationHdr alloc = new MAllocationHdr(Env.getCtx(), true, DateTrx, C_Currency_ID, Env.getContext(Env.getCtx(), "#AD_User_Name"), trxName);
        alloc.setAD_Org_ID(AD_Org_ID);
        alloc.saveEx();
        int invoiceLines = 0;
        BigDecimal unmatchedApplied = Env.ZERO;
        int i2 = 0;
        while (i2 < iRows) {
            if (((Boolean)invoice.getValueAt(i2, 0)).booleanValue()) {
                ++invoiceLines;
                pp = (KeyNamePair)invoice.getValueAt(i2, 2);
                C_Invoice_ID = pp.getKey();
                BigDecimal AppliedAmt = (BigDecimal)invoice.getValueAt(i2, this.i_applied);
                BigDecimal DiscountAmt = (BigDecimal)invoice.getValueAt(i2, this.i_discount);
                BigDecimal WriteOffAmt = (BigDecimal)invoice.getValueAt(i2, this.i_writeOff);
                BigDecimal OverUnderAmt = ((BigDecimal)invoice.getValueAt(i2, this.i_open)).subtract(AppliedAmt).subtract(DiscountAmt).subtract(WriteOffAmt);
                log.config("Invoice #" + i2 + " - AppliedAmt=" + AppliedAmt);
                int j = 0;
                while (j < paymentList.size() && AppliedAmt.signum() != 0) {
                    int C_Payment_ID = (Integer)paymentList.get(j);
                    BigDecimal PaymentAmt = (BigDecimal)amountList.get(j);
                    if (PaymentAmt.signum() == AppliedAmt.signum()) {
                        log.config(".. with payment #" + j + ", Amt=" + PaymentAmt);
                        BigDecimal amount = AppliedAmt;
                        if (amount.abs().compareTo(PaymentAmt.abs()) > 0) {
                            amount = PaymentAmt;
                        }
                        MAllocationLine aLine = new MAllocationLine(alloc, amount, DiscountAmt, WriteOffAmt, OverUnderAmt);
                        aLine.setDocInfo(C_BPartner_ID, C_Order_ID, C_Invoice_ID);
                        aLine.setPaymentInfo(C_Payment_ID, C_CashLine_ID);
                        aLine.saveEx();
                        DiscountAmt = Env.ZERO;
                        WriteOffAmt = Env.ZERO;
                        AppliedAmt = AppliedAmt.subtract(amount);
                        PaymentAmt = PaymentAmt.subtract(amount);
                        log.fine("Allocation Amount=" + amount + " - Remaining  Applied=" + AppliedAmt + ", Payment=" + PaymentAmt);
                        amountList.set(j, PaymentAmt);
                    }
                    ++j;
                }
                if (AppliedAmt.signum() != 0 || DiscountAmt.signum() != 0 || WriteOffAmt.signum() != 0) {
                    int C_Payment_ID = 0;
                    MAllocationLine aLine = new MAllocationLine(alloc, AppliedAmt, DiscountAmt, WriteOffAmt, OverUnderAmt);
                    aLine.setDocInfo(C_BPartner_ID, C_Order_ID, C_Invoice_ID);
                    aLine.setPaymentInfo(C_Payment_ID, C_CashLine_ID);
                    aLine.saveEx();
                    log.fine("Allocation Amount=" + AppliedAmt);
                    unmatchedApplied = unmatchedApplied.add(AppliedAmt);
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < paymentList.size()) {
            BigDecimal payAmt = (BigDecimal)amountList.get(i2);
            if (payAmt.signum() != 0) {
                int C_Payment_ID = (Integer)paymentList.get(i2);
                log.fine("Payment=" + C_Payment_ID + ", Amount=" + payAmt);
                MAllocationLine aLine = new MAllocationLine(alloc, payAmt, Env.ZERO, Env.ZERO, Env.ZERO);
                aLine.setDocInfo(C_BPartner_ID, 0, 0);
                aLine.setPaymentInfo(C_Payment_ID, 0);
                aLine.saveEx();
                unmatchedApplied = unmatchedApplied.subtract(payAmt);
            }
            ++i2;
        }
        if (unmatchedApplied.signum() != 0) {
            log.log(Level.SEVERE, "Allocation not balanced -- out by " + unmatchedApplied);
        }
        if (alloc.get_ID() != 0) {
            alloc.processIt("CO");
            alloc.saveEx();
        }
        i2 = 0;
        while (i2 < iRows) {
            if (((Boolean)invoice.getValueAt(i2, 0)).booleanValue()) {
                String sql = "SELECT invoiceOpen(C_Invoice_ID, 0) FROM C_Invoice WHERE C_Invoice_ID=?";
                pp = (KeyNamePair)invoice.getValueAt(i2, 2);
                C_Invoice_ID = pp.getKey();
                BigDecimal open = DB.getSQLValueBD(trxName, sql, C_Invoice_ID);
                if (open != null && open.signum() == 0) {
                    sql = "UPDATE C_Invoice SET IsPaid='Y' WHERE C_Invoice_ID=" + C_Invoice_ID;
                    int no = DB.executeUpdate(sql, trxName);
                    log.config("Invoice #" + i2 + " is paid - updated=" + no);
                } else {
                    log.config("Invoice #" + i2 + " is not paid - " + open);
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < paymentList.size()) {
            int C_Payment_ID = (Integer)paymentList.get(i2);
            MPayment pay = new MPayment(Env.getCtx(), C_Payment_ID, trxName);
            if (pay.testAllocation()) {
                pay.saveEx();
            }
            log.config("Payment #" + i2 + (pay.isAllocated() ? " not" : " is") + " fully allocated");
            ++i2;
        }
        paymentList.clear();
        amountList.clear();
        return alloc.getDocumentNo();
    }
}

