/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.Container;
import java.awt.Frame;
import java.io.InvalidClassException;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.ResultSet;
import java.util.logging.Level;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.adempiere.util.ProcessUtil;
import org.compiere.apps.AWindow;
import org.compiere.apps.IProcessParameter;
import org.compiere.apps.ProcessParameter;
import org.compiere.apps.Waiting;
import org.compiere.db.CConnection;
import org.compiere.interfaces.Server;
import org.compiere.model.MPInstance;
import org.compiere.print.ReportCtl;
import org.compiere.process.ClientProcess;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.util.ASyncProcess;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.wf.MWFProcess;

public class ProcessCtl
implements Runnable {
    int windowno;
    ASyncProcess m_parent;
    ProcessInfo m_pi;
    private Trx m_trx;
    private Waiting m_waiting;
    private boolean m_IsServerProcess = false;
    private static CLogger log = CLogger.getCLogger(ProcessCtl.class);

    public static ProcessCtl process(ASyncProcess parent, int WindowNo, ProcessInfo pi, Trx trx) {
        log.fine("WindowNo=" + WindowNo + " - " + pi);
        MPInstance instance = null;
        try {
            instance = new MPInstance(Env.getCtx(), pi.getAD_Process_ID(), pi.getRecord_ID());
        }
        catch (Exception e) {
            pi.setSummary(e.getLocalizedMessage());
            pi.setError(true);
            log.warning(pi.toString());
            return null;
        }
        catch (Error e) {
            pi.setSummary(e.getLocalizedMessage());
            pi.setError(true);
            log.warning(pi.toString());
            return null;
        }
        if (!instance.save()) {
            pi.setSummary(Msg.getMsg(Env.getCtx(), "ProcessNoInstance"));
            pi.setError(true);
            return null;
        }
        pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        ProcessParameter para = new ProcessParameter((Frame)Env.getFrame((Container)((Object)parent)), WindowNo, pi);
        if (para.initDialog()) {
            para.setVisible(true);
            if (!para.isOK()) {
                pi.setSummary(Msg.getMsg(Env.getCtx(), "ProcessCancelled"));
                pi.setError(true);
                return null;
            }
        }
        ProcessCtl worker = new ProcessCtl(parent, WindowNo, pi, trx);
        if (parent != null) {
            worker.start();
        } else {
            worker.run();
        }
        return worker;
    }

    public static ProcessCtl process(ASyncProcess parent, int WindowNo, IProcessParameter parameter, ProcessInfo pi, Trx trx) {
        log.fine("WindowNo=" + WindowNo + " - " + pi);
        MPInstance instance = null;
        try {
            instance = new MPInstance(Env.getCtx(), pi.getAD_Process_ID(), pi.getRecord_ID());
        }
        catch (Exception e) {
            pi.setSummary(e.getLocalizedMessage());
            pi.setError(true);
            log.warning(pi.toString());
            return null;
        }
        catch (Error e) {
            pi.setSummary(e.getLocalizedMessage());
            pi.setError(true);
            log.warning(pi.toString());
            return null;
        }
        if (!instance.save()) {
            pi.setSummary(Msg.getMsg(Env.getCtx(), "ProcessNoInstance"));
            pi.setError(true);
            return null;
        }
        pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        if (parameter != null && !parameter.saveParameters()) {
            pi.setSummary(Msg.getMsg(Env.getCtx(), "ProcessCancelled"));
            pi.setError(true);
            return null;
        }
        ProcessCtl worker = new ProcessCtl(parent, WindowNo, pi, trx);
        if (parent != null) {
            worker.start();
        } else {
            worker.run();
        }
        return worker;
    }

    public ProcessCtl(ASyncProcess parent, int WindowNo, ProcessInfo pi, Trx trx) {
        this.windowno = WindowNo;
        this.m_parent = parent;
        this.m_pi = pi;
        this.m_trx = trx;
    }

    public void start() {
        Thread thread = new Thread(this);
        if (this.m_pi != null) {
            thread.setName(this.m_pi.getTitle() + "-" + this.m_pi.getAD_PInstance_ID());
        }
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ResultSet rs;
        CPreparedStatement pstmt;
        boolean IsDirectPrint;
        boolean IsReport;
        int AD_Workflow_ID;
        int AD_ReportView_ID;
        String JasperReport2;
        String ProcedureName;
        block26: {
            log.fine("AD_PInstance_ID=" + this.m_pi.getAD_PInstance_ID() + ", Record_ID=" + this.m_pi.getRecord_ID());
            this.lock();
            ProcedureName = "";
            JasperReport2 = "";
            AD_ReportView_ID = 0;
            AD_Workflow_ID = 0;
            IsReport = false;
            IsDirectPrint = false;
            boolean isPrintPreview = this.m_pi.isPrintPreview();
            String sql = "SELECT p.Name, p.ProcedureName,p.ClassName, p.AD_Process_ID, p.isReport,p.IsDirectPrint,p.AD_ReportView_ID,p.AD_Workflow_ID, CASE WHEN COALESCE(p.Statistic_Count,0)=0 THEN 0 ELSE p.Statistic_Seconds/p.Statistic_Count END CASE, p.IsServerProcess, p.JasperReport FROM AD_Process p INNER JOIN AD_PInstance i ON (p.AD_Process_ID=i.AD_Process_ID) WHERE p.IsActive='Y' AND i.AD_PInstance_ID=?";
            if (!Env.isBaseLanguage(Env.getCtx(), "AD_Process")) {
                sql = "SELECT t.Name, p.ProcedureName,p.ClassName, p.AD_Process_ID, p.isReport, p.IsDirectPrint,p.AD_ReportView_ID,p.AD_Workflow_ID, CASE WHEN COALESCE(p.Statistic_Count,0)=0 THEN 0 ELSE p.Statistic_Seconds/p.Statistic_Count END CASE, p.IsServerProcess, p.JasperReport FROM AD_Process p INNER JOIN AD_PInstance i ON (p.AD_Process_ID=i.AD_Process_ID)  INNER JOIN AD_Process_Trl t ON (p.AD_Process_ID=t.AD_Process_ID AND t.AD_Language='" + Env.getAD_Language(Env.getCtx()) + "') " + "WHERE p.IsActive='Y'" + " AND i.AD_PInstance_ID=?";
            }
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(sql, 1003, 1007, null);
                pstmt.setInt(1, this.m_pi.getAD_PInstance_ID());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    this.m_pi.setTitle(rs.getString(1));
                    if (this.m_waiting != null) {
                        this.m_waiting.setTitle(this.m_pi.getTitle());
                    }
                    ProcedureName = rs.getString(2);
                    this.m_pi.setClassName(rs.getString(3));
                    this.m_pi.setAD_Process_ID(rs.getInt(4));
                    if ("Y".equals(rs.getString(5))) {
                        IsReport = true;
                        if ("Y".equals(rs.getString(6)) && !Ini.isPropertyBool("PrintPreview") && !isPrintPreview) {
                            IsDirectPrint = true;
                        }
                    }
                    AD_ReportView_ID = rs.getInt(7);
                    AD_Workflow_ID = rs.getInt(8);
                    int estimate = rs.getInt(9);
                    if (estimate != 0) {
                        this.m_pi.setEstSeconds(estimate + 1);
                        if (this.m_waiting != null) {
                            this.m_waiting.setTimerEstimate(this.m_pi.getEstSeconds());
                        }
                    }
                    this.m_IsServerProcess = "Y".equals(rs.getString(10));
                    JasperReport2 = rs.getString(11);
                    break block26;
                }
                log.log(Level.SEVERE, "No AD_PInstance_ID=" + this.m_pi.getAD_PInstance_ID());
            }
            catch (Throwable e) {
                try {
                    this.m_pi.setSummary(Msg.getMsg(Env.getCtx(), "ProcessNoProcedure") + " " + e.getLocalizedMessage(), true);
                    this.unlock();
                    log.log(Level.SEVERE, "run", e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (ProcedureName == null) {
            ProcedureName = "";
        }
        if (AD_Workflow_ID > 0) {
            this.startWorkflow(AD_Workflow_ID);
            this.unlock();
            return;
        }
        boolean isJasper = false;
        if (JasperReport2 != null && JasperReport2.trim().length() > 0) {
            isJasper = true;
            if ("org.compiere.report.ReportStarter".equals(this.m_pi.getClassName())) {
                this.m_pi.setClassName(null);
            }
        }
        if (this.m_pi.getClassName() != null) {
            if (isJasper) {
                this.m_pi.setReportingProcess(true);
            }
            if (!this.startProcess()) {
                this.unlock();
                return;
            }
            if (!IsReport && ProcedureName.length() == 0) {
                this.unlock();
                return;
            }
            if (IsReport && AD_ReportView_ID == 0 && !isJasper) {
                this.unlock();
                return;
            }
        }
        if (IsReport && ProcedureName.length() > 0) {
            this.m_pi.setReportingProcess(true);
            if (!this.startDBProcess(ProcedureName)) {
                this.unlock();
                return;
            }
        }
        if (isJasper) {
            this.m_pi.setReportingProcess(true);
            this.m_pi.setClassName("org.compiere.report.ReportStarter");
            this.startProcess();
            this.unlock();
            return;
        }
        if (IsReport) {
            this.m_pi.setReportingProcess(true);
            boolean ok = ReportCtl.start(this.m_parent, this.windowno, this.m_pi, IsDirectPrint);
            this.m_pi.setSummary("Report", !ok);
            this.unlock();
        } else {
            if (!this.startDBProcess(ProcedureName)) {
                this.unlock();
                return;
            }
            ProcessInfoUtil.setSummaryFromDB(this.m_pi);
            this.unlock();
        }
    }

    private void lock() {
        if (this.m_parent != null) {
            if (this.m_parent instanceof Container) {
                JFrame frame = Env.getFrame((Container)((Object)this.m_parent));
                if (frame instanceof AWindow) {
                    ((AWindow)frame).setBusyTimer(this.m_pi.getEstSeconds());
                } else {
                    this.m_waiting = new Waiting((Frame)frame, Msg.getMsg(Env.getCtx(), "Processing"), false, this.m_pi.getEstSeconds());
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        log.finer("lock");
                        ProcessCtl.this.m_parent.lockUI(ProcessCtl.this.m_pi);
                    }
                });
                if (this.m_waiting != null) {
                    this.m_waiting.toFront();
                    this.m_waiting.setVisible(true);
                }
            } else {
                log.finer("lock");
                this.m_parent.lockUI(this.m_pi);
            }
        }
    }

    private void unlock() {
        if (this.m_pi.isBatch()) {
            this.m_pi.setIsTimeout(true);
        }
        if (this.m_parent != null) {
            if (this.m_parent instanceof Container) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String summary = ProcessCtl.this.m_pi.getSummary();
                        log.finer("unlock - " + summary);
                        if (summary != null && summary.indexOf(64) != -1) {
                            ProcessCtl.this.m_pi.setSummary(Msg.parseTranslation(Env.getCtx(), summary));
                        }
                        ProcessCtl.this.m_parent.unlockUI(ProcessCtl.this.m_pi);
                    }
                });
                if (this.m_waiting != null) {
                    this.m_waiting.dispose();
                }
                this.m_waiting = null;
            } else {
                this.m_parent.unlockUI(this.m_pi);
            }
        }
    }

    private boolean startWorkflow(int AD_Workflow_ID) {
        log.fine(AD_Workflow_ID + " - " + this.m_pi);
        boolean started = false;
        if (this.m_IsServerProcess) {
            Server server = CConnection.get().getServer();
            try {
                if (server != null) {
                    this.m_pi = server.workflow(Env.getRemoteCallCtx(Env.getCtx()), this.m_pi, AD_Workflow_ID);
                    log.finest("server => " + this.m_pi);
                    started = true;
                }
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "AppsServer error", ex);
                started = false;
            }
        }
        if (!started && !this.m_IsServerProcess) {
            MWFProcess wfProcess;
            if (this.m_trx != null) {
                this.m_pi.setTransactionName(this.m_trx.getTrxName());
            }
            started = (wfProcess = ProcessUtil.startWorkFlow(Env.getCtx(), this.m_pi, AD_Workflow_ID)) != null;
        }
        return started;
    }

    private boolean startProcess() {
        log.fine(this.m_pi.toString());
        boolean started = false;
        boolean clientOnly = false;
        if (!this.m_pi.getClassName().toLowerCase().startsWith("@script:")) {
            try {
                Class<?> processClass = Class.forName(this.m_pi.getClassName());
                if (ClientProcess.class.isAssignableFrom(processClass)) {
                    clientOnly = true;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.m_IsServerProcess && !clientOnly) {
            Server server = CConnection.get().getServer();
            try {
                if (server != null) {
                    this.m_pi = server.process(Env.getRemoteCallCtx(Env.getCtx()), this.m_pi);
                    log.finest("server => " + this.m_pi);
                    started = true;
                }
            }
            catch (UndeclaredThrowableException ex) {
                Throwable cause = ex.getCause();
                if (cause != null) {
                    if (cause instanceof InvalidClassException) {
                        log.log(Level.SEVERE, "Version Server <> Client: " + cause.toString() + " - " + this.m_pi, ex);
                    } else {
                        log.log(Level.SEVERE, "AppsServer error(1b): " + cause.toString() + " - " + this.m_pi, ex);
                    }
                } else {
                    log.log(Level.SEVERE, " AppsServer error(1) - " + this.m_pi, ex);
                }
                started = false;
            }
            catch (Exception ex) {
                Throwable cause = ex.getCause();
                if (cause == null) {
                    cause = ex;
                }
                log.log(Level.SEVERE, "AppsServer error - " + this.m_pi, cause);
                started = false;
            }
        }
        if (!(started || this.m_IsServerProcess && !clientOnly)) {
            if (this.m_pi.getClassName().toLowerCase().startsWith("@script:")) {
                return ProcessUtil.startScriptProcess(Env.getCtx(), this.m_pi, this.m_trx);
            }
            return ProcessUtil.startJavaProcess(Env.getCtx(), this.m_pi, this.m_trx);
        }
        return !this.m_pi.isError();
    }

    private boolean startDBProcess(String ProcedureName) {
        String trxName;
        log.fine(ProcedureName + "(" + this.m_pi.getAD_PInstance_ID() + ")");
        boolean started = false;
        String string = trxName = this.m_trx != null ? this.m_trx.getTrxName() : null;
        if (this.m_IsServerProcess) {
            Server server = CConnection.get().getServer();
            try {
                if (server != null) {
                    this.m_pi = server.dbProcess(this.m_pi, ProcedureName);
                    log.finest("server => " + this.m_pi);
                    started = true;
                }
            }
            catch (UndeclaredThrowableException ex) {
                Throwable cause = ex.getCause();
                if (cause != null) {
                    if (cause instanceof InvalidClassException) {
                        log.log(Level.SEVERE, "Version Server <> Client: " + cause.toString() + " - " + this.m_pi, ex);
                    } else {
                        log.log(Level.SEVERE, "AppsServer error(1b): " + cause.toString() + " - " + this.m_pi, ex);
                    }
                } else {
                    log.log(Level.SEVERE, " AppsServer error(1) - " + this.m_pi, ex);
                    cause = ex;
                }
                this.m_pi.setSummary(Msg.getMsg(Env.getCtx(), "ProcessRunError") + " " + cause.getLocalizedMessage());
                this.m_pi.setError(true);
                return false;
            }
            catch (Exception ex) {
                Throwable cause = ex.getCause();
                if (cause == null) {
                    cause = ex;
                }
                log.log(Level.SEVERE, "AppsServer error - " + this.m_pi, cause);
                this.m_pi.setSummary(Msg.getMsg(Env.getCtx(), "ProcessRunError") + " " + cause.getLocalizedMessage());
                this.m_pi.setError(true);
                return false;
            }
        }
        if (!started) {
            return ProcessUtil.startDatabaseProcedure(this.m_pi, ProcedureName, this.m_trx);
        }
        return true;
    }
}

