/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.apps.AppsAction;
import org.compiere.apps.search.Find;
import org.compiere.grid.GridController;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MQuery;
import org.compiere.model.MUserQuery;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;

public class ASearch
implements ActionListener {
    private static final String FIELD_SEPARATOR = "<^>";
    private static final String SEGMENT_SEPARATOR = "<~>";
    private GridField[] m_findFields;
    private JPopupMenu m_popup = new JPopupMenu("SearchMenu");
    private ArrayList<KeyNamePair> m_list = new ArrayList();
    private static CLogger log = CLogger.getCLogger(ASearch.class);
    int m_onlycurrentdays;
    AppsAction m_appsaction;
    JComponent m_invoker;
    Frame m_owner;
    int m_targetWindowNo;
    GridTab m_gt;
    GridController m_gc;

    public ASearch(AppsAction appsAction, Frame owner, int targetWindowNo, GridController gc, GridTab gridTab, int m_onlyCurrentDays) {
        this.m_onlycurrentdays = m_onlyCurrentDays;
        this.m_appsaction = appsAction;
        this.m_invoker = appsAction.getButton();
        this.m_owner = owner;
        this.m_targetWindowNo = targetWindowNo;
        this.m_gt = gridTab;
        this.m_gc = gc;
        this.m_findFields = GridField.createFields(Env.getCtx(), this.m_targetWindowNo, 0, this.m_gt.getAD_Tab_ID());
        this.getSearchTargets();
    }

    private void getSearchTargets() {
        boolean baseLanguage = Env.isBaseLanguage(Env.getCtx(), "AD_Window");
        MUserQuery[] search = MUserQuery.get(Env.getCtx(), this.m_gt.getAD_Tab_ID());
        KeyNamePair pp = null;
        if (search.length == 0) {
            this.find();
            return;
        }
        pp = new KeyNamePair(0, Msg.translate(Env.getCtx(), "Find"));
        this.m_list.add(pp);
        this.m_popup.add(pp.toString()).addActionListener(this);
        MUserQuery[] mUserQueryArray = search;
        int n = search.length;
        int n2 = 0;
        while (n2 < n) {
            MUserQuery query = mUserQueryArray[n2];
            pp = new KeyNamePair(query.getAD_UserQuery_ID(), query.getName());
            this.m_list.add(pp);
            this.m_popup.add(pp.toString()).addActionListener(this);
            ++n2;
        }
        if (this.m_invoker.isShowing() && this.m_list.size() > 1) {
            this.m_popup.show(this.m_invoker, 0, this.m_invoker.getHeight());
        } else {
            this.launchSearch(pp);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.m_popup.setCursor(Cursor.getPredefinedCursor(3));
        String cmd = e.getActionCommand();
        int i = 0;
        while (i < this.m_list.size()) {
            KeyNamePair pp = this.m_list.get(i);
            if (cmd.equals(pp.getName())) {
                this.launchSearch(pp);
                return;
            }
            ++i;
        }
    }

    private void launchSearch(KeyNamePair pp) {
        if (pp.getName().equals(Msg.getMsg(Env.getCtx(), "Find"))) {
            this.find();
        } else {
            this.filter(pp.getKey());
        }
    }

    private void find() {
        GridField[] findFields = GridField.createFields(Env.getCtx(), this.m_targetWindowNo, 0, this.m_gt.getAD_Tab_ID());
        Find find = new Find(Env.getFrame(this.m_owner), this.m_targetWindowNo, this.m_gt.getName(), this.m_gt.getAD_Tab_ID(), this.m_gt.getAD_Table_ID(), this.m_gt.getTableName(), this.m_gt.getWhereExtended(), findFields, 1);
        MQuery query = find.getQuery();
        find.dispose();
        find = null;
        if (query != null) {
            this.m_gt.setQuery(query);
            this.m_gc.query(false, this.m_onlycurrentdays, 0);
        }
        this.m_appsaction.setPressed(this.m_gt.isQueryActive());
    }

    private void filter(int AD_UserQuery_ID) {
        MUserQuery userQuery = null;
        if (AD_UserQuery_ID > 0) {
            userQuery = new MUserQuery(Env.getCtx(), AD_UserQuery_ID, null);
            MQuery query = this.getQuery(userQuery);
            if (query != null) {
                this.m_gt.setQuery(query);
                this.m_gc.query(false, this.m_onlycurrentdays, 0);
            }
            this.m_appsaction.setPressed(this.m_gt.isQueryActive());
        }
    }

    private MQuery getQuery(MUserQuery userQuery) {
        int openBrackets = 0;
        MQuery m_query = new MQuery(userQuery.getAD_Table_ID());
        m_query.addRestriction(Env.parseContext(Env.getCtx(), this.m_targetWindowNo, "", false));
        String code = userQuery.getCode();
        log.fine("Parse user query: " + code);
        String[] segments = code.split(Pattern.quote(SEGMENT_SEPARATOR), -1);
        int i = 0;
        while (i < segments.length) {
            String columnName = null;
            String operator = null;
            Object value = null;
            Object value2 = null;
            String andor = null;
            String left_bracket = null;
            String right_bracket = null;
            String[] fields = segments[i].split(Pattern.quote(FIELD_SEPARATOR));
            int j = 0;
            while (j < fields.length) {
                GridField field;
                if (j == 0) {
                    columnName = fields[j];
                } else if (j == 1) {
                    ValueNamePair[] valueNamePairArray = MQuery.OPERATORS;
                    int n = MQuery.OPERATORS.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ValueNamePair vnp = valueNamePairArray[n2];
                        if (vnp.getValue().equals(fields[j])) {
                            operator = vnp.getValue();
                        }
                        ++n2;
                    }
                } else if (j == 2 && fields[j].length() > 0) {
                    field = this.getTargetMField(columnName);
                    value = this.parseString(field, fields[j]);
                } else if (j == 3 && fields[j].length() > 0) {
                    field = this.getTargetMField(columnName);
                    value2 = this.parseString(field, fields[j]);
                } else if (j == 4 && fields[j].length() > 0) {
                    if (i != 0) {
                        andor = fields[j];
                    }
                } else if (j == 5 && fields[j].length() > 0) {
                    left_bracket = fields[j];
                } else if (j == 6 && fields[j].length() > 0) {
                    right_bracket = fields[j];
                }
                ++j;
            }
            GridField field = this.getTargetMField(columnName);
            if (field != null) {
                String op;
                String rBrackets;
                String ColumnSQL = field.getColumnSQL(false);
                String lBrackets = left_bracket;
                if (lBrackets != null) {
                    openBrackets += lBrackets.length();
                }
                if ((rBrackets = right_bracket) != null) {
                    openBrackets -= rBrackets.length();
                }
                boolean and = true;
                if (i > 0) {
                    boolean bl = and = !"OR".equals(andor);
                }
                if ((op = operator) != null) {
                    if (value == null) {
                        if (MQuery.OPERATORS[0].equals(op) || MQuery.OPERATORS[1].equals(op)) {
                            m_query.addRestriction(ColumnSQL, operator, null, columnName, null, and, openBrackets);
                        }
                    } else {
                        Object parsedValue = this.parseValue(field, value);
                        if (parsedValue != null) {
                            String infoDisplay = value.toString();
                            if (field.isLookup()) {
                                infoDisplay = field.getLookup().getDisplay(value);
                            } else if (field.getDisplayType() == 20) {
                                infoDisplay = Msg.getMsg(Env.getCtx(), infoDisplay);
                            }
                            if (MQuery.OPERATORS[8].equals(op)) {
                                if (value2 != null) {
                                    Object parsedValue2 = this.parseValue(field, value2);
                                    String infoDisplay_to = value2.toString();
                                    if (parsedValue2 != null) {
                                        m_query.addRangeRestriction(ColumnSQL, parsedValue, parsedValue2, columnName, infoDisplay, infoDisplay_to, and, openBrackets);
                                    }
                                }
                            } else {
                                m_query.addRestriction(ColumnSQL, operator, parsedValue, columnName, infoDisplay, and, openBrackets);
                            }
                        }
                    }
                }
            }
            ++i;
        }
        return m_query;
    }

    public GridField getTargetMField(String columnName) {
        if (columnName == null) {
            return null;
        }
        int c = 0;
        while (c < this.m_findFields.length) {
            GridField field = this.m_findFields[c];
            if (columnName.equals(field.getColumnName())) {
                return field;
            }
            ++c;
        }
        return null;
    }

    private Object parseString(GridField field, String in) {
        log.log(Level.FINE, "Parse: " + field + ":" + in);
        if (in == null) {
            return null;
        }
        int dt = field.getDisplayType();
        try {
            if (dt == 11 || DisplayType.isID(dt) && field.getColumnName().endsWith("_ID")) {
                int i = Integer.parseInt(in);
                return new Integer(i);
            }
            if (DisplayType.isNumeric(dt)) {
                return DisplayType.getNumberFormat(dt).parse(in);
            }
            if (DisplayType.isDate(dt)) {
                long time = 0L;
                try {
                    time = DisplayType.getDateFormat_JDBC().parse(in).getTime();
                    return new Timestamp(time);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, String.valueOf(in) + "(" + in.getClass() + ")" + e);
                    time = DisplayType.getDateFormat(dt).parse(in).getTime();
                    return new Timestamp(time);
                }
            }
            if (dt == 20) {
                return Boolean.valueOf(in);
            }
            return in;
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Object=" + in, ex);
            return null;
        }
    }

    private Object parseValue(GridField field, Object in) {
        if (in == null) {
            return null;
        }
        int dt = field.getDisplayType();
        try {
            if (dt == 11 || DisplayType.isID(dt) && field.getColumnName().endsWith("_ID")) {
                if (in instanceof Integer) {
                    return in;
                }
                int i = Integer.parseInt(in.toString());
                return new Integer(i);
            }
            if (DisplayType.isNumeric(dt)) {
                if (in instanceof BigDecimal) {
                    return in;
                }
                return DisplayType.getNumberFormat(dt).parse(in.toString());
            }
            if (DisplayType.isDate(dt)) {
                if (in instanceof Timestamp) {
                    return in;
                }
                long time = 0L;
                try {
                    time = DisplayType.getDateFormat_JDBC().parse(in.toString()).getTime();
                    return new Timestamp(time);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, in + "(" + in.getClass() + ")" + e);
                    time = DisplayType.getDateFormat(dt).parse(in.toString()).getTime();
                    return new Timestamp(time);
                }
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? "Y" : "N";
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Object=" + in, ex);
            String error = ex.getLocalizedMessage();
            if (error == null || error.length() == 0) {
                error = ex.toString();
            }
            StringBuffer errMsg = new StringBuffer();
            errMsg.append(field.getColumnName()).append(" = ").append(in).append(" - ").append(error);
            throw new AdempiereException(errMsg.toString());
        }
        return in;
    }
}

