/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import it.nectosoft.model.LIT_MInvoice;
import it.nectosoft.model.LIT_MOrder;
import it.nectosoft.model.LIT_TaxAcct;
import it.nectosoft.util.FiscalCheck;
import it.nectosoft.util.Helper;
import it.nectosoft.util.POUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.DocLine_Allocation;
import org.compiere.acct.DocTax;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.grid.VCreateFromBatchUI;
import org.compiere.grid.VCreateFromFactory;
import org.compiere.model.FactsValidator;
import org.compiere.model.I_C_PaymentBatch;
import org.compiere.model.I_M_InventoryLine;
import org.compiere.model.LITMDocType;
import org.compiere.model.LIT_Sequence;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MInvoiceTax;
import org.compiere.model.MLITInvoiceAuto;
import org.compiere.model.MLITInvoiceWithholding;
import org.compiere.model.MLocation;
import org.compiere.model.MOrder;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentAllocate;
import org.compiere.model.MProduct;
import org.compiere.model.MProjectTask;
import org.compiere.model.MSysConfig;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_C_DocType;
import org.compiere.model.X_C_Invoice;
import org.compiere.model.X_LIT_DocTypeExt;
import org.compiere.model.X_LIT_Invoice_Auto;
import org.compiere.model.X_LIT_TaxIdType;
import org.compiere.model.X_LIT_VATLedgerDef;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.model.X_PP_Cost_Collector;

public class LIT_Validator
implements ModelValidator,
FactsValidator {
    private static final String LIT_ALLOW_DIFFERENT_DATES = "LIT_INVOICE_ALLOW_DIFFERENT_POST_LEDGER_DATE";
    private static final String DOCTYPE_OF_ALLOCATIONLINE = "SELECT C_Payment.C_DocType_ID FROM C_AllocationLine inner join C_Payment on (C_AllocationLine.C_Payment_ID = C_Payment.C_Payment_ID) WHERE C_AllocationLine_ID = ?";
    private static CLogger log = CLogger.getCLogger(LIT_Validator.class);
    private int m_AD_Client_ID = -1;
    private static String version = "Italian localization version: 2.4";

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(String.valueOf(this.toString()) + " for " + client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        VCreateFromFactory.registerClass(I_C_PaymentBatch.Table_ID, VCreateFromBatchUI.class);
        engine.addModelChange("C_Invoice", this);
        engine.addModelChange("C_InvoiceLine", this);
        engine.addModelChange("LIT_Invoice_Auto", this);
        engine.addModelChange("C_Order", this);
        engine.addModelChange("C_BPartner", this);
        engine.addModelChange("LIT_TaxIdType", this);
        engine.addModelChange("C_AllocationLine", this);
        engine.addModelChange("C_Payment", this);
        engine.addModelChange("C_ProjectTask", this);
        engine.addDocValidate("C_Invoice", this);
        engine.addDocValidate("C_Payment", this);
        engine.addDocValidate("C_AllocationHdr", this);
        engine.addDocValidate("M_InOut", this);
        engine.addDocValidate("M_MatchInv", this);
        engine.addDocValidate("C_ProjectIssue", this);
        engine.addFactsValidate("C_Order", this);
        engine.addFactsValidate("M_InOut", this);
        engine.addFactsValidate("M_MatchInv", this);
        engine.addFactsValidate("C_Invoice", this);
        engine.addFactsValidate("PP_Cost_Collector", this);
        engine.addFactsValidate("M_Inventory", this);
        engine.addFactsValidate("M_Movement", this);
        engine.addFactsValidate("M_Production", this);
        engine.addFactsValidate("C_Payment", this);
        engine.addFactsValidate("C_AllocationHdr", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        MPayment pay;
        X_LIT_TaxIdType taxidtype;
        X_C_Invoice mInvoice;
        String msg;
        MProjectTask pt;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if (po.get_TableName().equals("C_ProjectTask") && type == 1 && (pt = (MProjectTask)po).getM_Product_ID() > 0 && pt.getQty().signum() != 0) {
            pt.setProjInvoiceRule("P");
        }
        if (po.get_TableName().equals("C_Invoice") && (type == 1 || type == 2)) {
            msg = this.setInvoiceCustomFields((MInvoice)po);
            if (msg != null) {
                return msg;
            }
            msg = this.clearInvoiceWithholdingAmtFromInvoice((MInvoice)po);
            if (msg != null) {
                return msg;
            }
            msg = this.validateVATLedgerDate((MInvoice)po);
            if (msg != null) {
                return msg;
            }
            msg = this.manageAcctPostDateChanges((MInvoice)po);
            if (msg != null) {
                return msg;
            }
        }
        if (po.get_TableName().equals("C_Invoice") && type == 5 && (mInvoice = (X_C_Invoice)po).is_ValueChanged("Processed") && mInvoice.isProcessed() && !mInvoice.isPaid() && mInvoice.getReversal_ID() <= 0) {
            this.doInvoiceAutoPayment(mInvoice);
        }
        if (po.get_TableName().equals("LIT_Invoice_Auto") && (type == 1 || type == 2)) {
            X_LIT_Invoice_Auto autoi = (X_LIT_Invoice_Auto)po;
            String value = autoi.getDocumentNo();
            if (value != null && value.startsWith("<") && value.endsWith(">")) {
                value = null;
            }
            if (value == null || value.length() == 0) {
                value = DB.getDocumentNo(autoi.getC_DocTypeAutoInvoice_ID(), autoi.get_TrxName(), false, (PO)autoi);
                autoi.setDocumentNo(value);
            }
        }
        if (po.get_TableName().equals("C_InvoiceLine") && (type == 1 || type == 2 || type == 3) && (msg = this.clearInvoiceWithholdingAmtFromInvoiceLine((MInvoiceLine)po, type)) != null) {
            return msg;
        }
        if (po.get_TableName().equals("C_Order") && type == 2 && (msg = this.setOrderCustomFields((MOrder)po)) != null) {
            return msg;
        }
        if (po.get_TableName().equals("C_BPartner") && (type == 1 || type == 2) && (msg = this.mfillName((MBPartner)po)) != null) {
            return msg;
        }
        if (po.get_TableName().equals("LIT_TaxIdType") && (type == 1 || type == 2) && !(taxidtype = (X_LIT_TaxIdType)po).isUseTaxIdDigit() && taxidtype.isDigitChecked()) {
            taxidtype.setIsDigitChecked(false);
        }
        if (po.get_TableName().equals("C_AllocationLine") && type == 3 && (msg = this.reversePaymentWithholdingsLines((MAllocationLine)po)) != null) {
            return msg;
        }
        if (po.get_TableName().equals("C_Payment") && type == 5 && (pay = (MPayment)po).getDescription() != null && pay.getDescription().endsWith("^<-)") && pay.getDocStatus().equals("RE")) {
            Doc doc = pay.getDoc();
            if (doc == null) {
                MAcctSchema[] m_ass = MAcctSchema.getClientAcctSchema(pay.getCtx(), pay.getAD_Client_ID());
                msg = Doc.postImmediate(m_ass, pay.get_Table_ID(), pay.get_ID(), true, pay.get_TrxName());
            } else {
                msg = doc.post(true, true);
            }
            if (msg != null) {
                return msg;
            }
        }
        return null;
    }

    public static String FiscalCheck(MBPartner po) {
        String str_controllo = null;
        String taxID = po.getTaxID();
        if (taxID == null || taxID.isEmpty()) {
            return null;
        }
        int no = DB.getSQLValue(po.get_TrxName(), "SELECT COUNT(TAXID) FROM C_BPARTNER WHERE TAXID=? AND C_BPARTNER_ID<>? AND AD_CLIENT_ID=?", po.getTaxID(), po.getC_BPartner_ID(), po.getAD_Client_ID());
        if (no > 0) {
            str_controllo = "Un BPartner con questa P.IVA esiste gia' in anagrafica, verificare la presenza di duplicati";
            log.saveError("Error", str_controllo);
            return str_controllo;
        }
        boolean check_piva = false;
        if (taxID.startsWith("IT")) {
            taxID = taxID.substring(2);
            check_piva = true;
        } else {
            MBPartnerLocation bploc = po.getLocation(0);
            if (bploc != null) {
                MLocation loc = MLocation.get(po.getCtx(), bploc.getC_Location_ID(), null);
                if (loc.getCountry(false).equalsIgnoreCase("Italy")) {
                    check_piva = true;
                }
            } else if (taxID.length() > 2 && !taxID.substring(0, 2).matches("[A-Z]{2}")) {
                check_piva = true;
            }
        }
        if (check_piva && (str_controllo = FiscalCheck.controllaPIVA(po.getTaxID())).trim().length() != 0) {
            log.saveError("Error", str_controllo);
            return str_controllo;
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        MPayment pay;
        MDocType dt;
        String genwh;
        MInvoice inv;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        String msg = null;
        if (!(!po.get_TableName().equals("C_Invoice") || timing != 1 || (inv = (MInvoice)po).getDescription() != null && inv.getDescription().contains("{->") && inv.getDescription().endsWith(")") || inv.get_Value("WithholdingAmt") != null || (genwh = (dt = new MDocType(inv.getCtx(), inv.getC_DocTypeTarget_ID(), inv.get_TrxName())).get_ValueAsString("GenerateWithholding")) == null)) {
            if (genwh.equals("Y")) {
                return Msg.getMsg(inv.getCtx(), "LIT_WithholdingNotGenerated");
            }
            if (genwh.equals("A")) {
                LIT_MInvoice lcoinv = new LIT_MInvoice(inv.getCtx(), inv.getC_Invoice_ID(), inv.get_TrxName());
                lcoinv.recalcWithholdings();
            }
        }
        if (po.get_TableName().equals("C_Invoice") && timing == 7) {
            msg = this.assignVATLedgerNo((MInvoice)po);
            if (msg != null) {
                return msg;
            }
            if ((POUtils.GetValueAsBoolean(po, "IsIntraVAT") || POUtils.GetValueAsBoolean(po, "IsReverseCharge")) && (msg = this.assignVATLedgerNoAuto((MInvoice)po)) != null) {
                return msg;
            }
            msg = this.translateWithholdingToTaxes((MInvoice)po);
            if (msg != null) {
                return msg;
            }
        }
        if (po.get_TableName().equals("C_Invoice") && timing == 9 && (msg = this.completeInvoiceWithholding((MInvoice)po)) != null) {
            return msg;
        }
        if (po.get_TableName().equals("C_Invoice") && timing == 15 && (msg = this.accountingForInvoiceTaxes((MInvoice)po)) != null) {
            return msg;
        }
        if (!(!po.get_TableName().equals("C_Payment") || timing != 1 || (pay = (MPayment)po).getDescription() != null && pay.getDescription().contains("{->") && pay.getDescription().endsWith(")") || pay.getPayAmt().signum() != 0 || pay.getC_Invoice_ID() != 0 || pay.getC_Order_ID() != 0 || pay.getC_Charge_ID() != 0)) {
            MPaymentAllocate[] pAllocs = MPaymentAllocate.get(pay);
            BigDecimal sumPaymentAllocates = Env.ZERO;
            if (pAllocs.length > 0) {
                MPaymentAllocate[] mPaymentAllocateArray = pAllocs;
                int n = pAllocs.length;
                int n2 = 0;
                while (n2 < n) {
                    MPaymentAllocate pAlloc = mPaymentAllocateArray[n2];
                    sumPaymentAllocates = sumPaymentAllocates.add(pAlloc.getAmount());
                    ++n2;
                }
                pay.setPayAmt(sumPaymentAllocates);
                pay.save();
            }
        }
        if (po.get_TableName().equals("C_Payment") && timing == 1 && ((pay = (MPayment)po).getDescription() == null || !pay.getDescription().contains("{->") || !pay.getDescription().endsWith(")")) && pay.isPrepayment() && pay.getWriteOffAmt().signum() == 0) {
            LIT_MOrder ord = new LIT_MOrder(pay.getCtx(), pay.getC_Order_ID(), pay.get_TrxName());
            MDocType dt2 = new MDocType(pay.getCtx(), ord.getC_DocTypeTarget_ID(), pay.get_TrxName());
            String genwh2 = dt2.get_ValueAsString("GenerateWithholding");
            if (genwh2 != null) {
                if (genwh2.equals("Y")) {
                    return Msg.getMsg(pay.getCtx(), "LIT_WithholdingNotGenerated");
                }
                if (genwh2.equals("A")) {
                    ord.recalcWithholdings(pay);
                }
            }
        }
        if (po.get_TableName().equals("C_Payment") && timing == 7 && (msg = this.validateWriteOffVsPaymentWithholdings((MPayment)po)) != null) {
            return msg;
        }
        if (po.get_TableName().equals("C_Payment") && timing == 9 && (msg = this.completePrePaymentWithholdings((MPayment)po)) != null) {
            return msg;
        }
        if (po.get_TableName().equals("C_Payment") && timing == 15 && (msg = this.accountingForPrePaymentWithholdings((MPayment)po)) != null) {
            return msg;
        }
        if (po.get_TableName().equals("C_AllocationHdr") && timing == 9 && (msg = this.completePaymentWithholdings((MAllocationHdr)po)) != null) {
            return msg;
        }
        if (po.get_TableName().equals("C_AllocationHdr") && timing == 15) {
            msg = this.accountingForInvoiceWithholdingOnPayment((MAllocationHdr)po);
            if (msg != null) {
                return msg;
            }
            msg = this.accountingForSuspendedVAT((MAllocationHdr)po);
            if (msg != null) {
                return msg;
            }
        }
        if (po.get_TableName().equals("C_AllocationHdr") && (timing == 10 || timing == 13 || timing == 14) && (msg = this.reversePaymentWithholdings((MAllocationHdr)po)) != null) {
            return msg;
        }
        if (po.get_TableName().equals("M_InOut") && timing == 15 && (msg = this.accountingForNOEInOut((MInOut)po)) != null) {
            return msg;
        }
        return null;
    }

    private String accountingForServiceShipment(MAcctSchema schema, List<Fact> facts, MInOut inout) {
        String msg = null;
        Doc doc = inout.getDoc();
        Fact fact = new Fact(doc, schema, "A");
        FactLine dr = null;
        FactLine cr = null;
        MAccount revenue = doc.getAccount(72, schema);
        MAccount receivable = doc.getAccount(71, schema);
        DocLine[] docLineArray = doc.p_lines;
        int n = doc.p_lines.length;
        int n2 = 0;
        while (n2 < n) {
            DocLine line = docLineArray[n2];
            MProduct product = line.getProduct();
            if (product.isService()) {
                if (line.getC_OrderLine_ID() == 0) {
                    msg = "InOut Line not linked to OrderLine: " + line;
                    log.log(Level.WARNING, msg);
                    return null;
                }
                BigDecimal price = LIT_Validator.getSOPrice(inout.get_TrxName(), line.getC_OrderLine_ID(), schema.getC_Currency_ID());
                if (price == null || price.signum() == 0) {
                    msg = "No Price for " + line.getProduct().getName();
                    log.log(Level.WARNING, msg);
                    return null;
                }
                BigDecimal amount = price.multiply(line.getQty().negate());
                dr = fact.createLine(line, receivable, schema.getC_Currency_ID(), amount, null);
                if (dr == null) {
                    msg = "FactLine DR not created: " + line;
                    log.log(Level.WARNING, msg);
                    return null;
                }
                dr.setM_Locator_ID(line.getM_Locator_ID());
                dr.setLocationFromLocator(line.getM_Locator_ID(), true);
                dr.setLocationFromBPartner(doc.getC_BPartner_Location_ID(), false);
                dr.setAD_Org_ID(line.getOrder_Org_ID());
                dr.setQty(line.getQty().negate());
                cr = fact.createLine(line, revenue, schema.getC_Currency_ID(), null, amount);
                if (cr == null) {
                    msg = "FactLine CR not created: " + line;
                    log.log(Level.WARNING, msg);
                    return null;
                }
                cr.setM_Locator_ID(line.getM_Locator_ID());
                cr.setLocationFromLocator(line.getM_Locator_ID(), true);
                cr.setLocationFromBPartner(doc.getC_BPartner_Location_ID(), false);
            }
            ++n2;
        }
        if (fact.getLines().length > 0) {
            facts.add(fact);
        }
        return msg;
    }

    private String accountingForServiceOrder(MAcctSchema schema, List<Fact> facts, MOrder ord) {
        String msg = null;
        Doc doc = ord.getDoc();
        Fact fact = new Fact(doc, schema, "A");
        MAccount revenue = doc.getAccount(72, schema);
        MAccount receivable = doc.getAccount(71, schema);
        BigDecimal total = Env.ZERO;
        FactLine fl = null;
        DocLine[] docLineArray = doc.p_lines;
        int n = doc.p_lines.length;
        int n2 = 0;
        while (n2 < n) {
            DocLine dline = docLineArray[n2];
            MProduct product = dline.getProduct();
            if (product.isService()) {
                BigDecimal cost = dline.getAmtSource();
                total = total.add(cost);
                fl = fact.createLine(dline, revenue, doc.getC_Currency_ID(), null, cost);
            }
            ++n2;
        }
        if (total.signum() != 0) {
            fl = fact.createLine(null, receivable, doc.getC_Currency_ID(), total, null);
            facts.add(fact);
        }
        return msg;
    }

    private String accountingForServiceInvoicedOrder(MAcctSchema schema, List<Fact> facts, MInvoice inv) {
        String msg = null;
        Doc doc = inv.getDoc();
        Fact fact = new Fact(doc, schema, "A");
        MAccount revenue = doc.getAccount(72, schema);
        MAccount receivable = doc.getAccount(71, schema);
        BigDecimal total = Env.ZERO;
        FactLine fl = null;
        DocLine[] docLineArray = doc.p_lines;
        int n = doc.p_lines.length;
        int n2 = 0;
        while (n2 < n) {
            int C_OrderLine_ID;
            DocLine dline = docLineArray[n2];
            MProduct product = dline.getProduct();
            if (product.isService() && (C_OrderLine_ID = dline.getC_OrderLine_ID()) != 0 && this.checkOrderFact(null, C_OrderLine_ID, schema.getC_AcctSchema_ID())) {
                BigDecimal amount = dline.getAmtSource();
                total = total.add(amount);
                fl = fact.createLine(dline, revenue, doc.getC_Currency_ID(), amount, null);
            }
            ++n2;
        }
        if (total.signum() != 0) {
            fl = fact.createLine(null, receivable, doc.getC_Currency_ID(), null, total);
            facts.add(fact);
        }
        return msg;
    }

    private String accountingForServiceInvoicedShipment(MAcctSchema schema, List<Fact> facts, MInvoice inv) {
        String msg = null;
        Doc doc = inv.getDoc();
        Fact fact = new Fact(doc, schema, "A");
        MAccount revenue = doc.getAccount(72, schema);
        MAccount receivable = doc.getAccount(71, schema);
        BigDecimal total = Env.ZERO;
        FactLine fl = null;
        DocLine[] docLineArray = doc.p_lines;
        int n = doc.p_lines.length;
        int n2 = 0;
        while (n2 < n) {
            int M_InOutLine_ID;
            DocLine dline = docLineArray[n2];
            MProduct product = dline.getProduct();
            if (product.isService() && (M_InOutLine_ID = dline.getValue("M_InOutLine_ID")) != 0 && this.checkInOutFact(null, M_InOutLine_ID, schema.getC_AcctSchema_ID())) {
                BigDecimal amount = dline.getAmtSource();
                total = total.add(amount);
                fl = fact.createLine(dline, revenue, doc.getC_Currency_ID(), amount, null);
            }
            ++n2;
        }
        if (total.signum() != 0) {
            fl = fact.createLine(null, receivable, doc.getC_Currency_ID(), null, total);
            facts.add(fact);
        }
        return msg;
    }

    private String accountingForWarehouse(MAcctSchema schema, List<Fact> facts, PO mDoc) {
        boolean useNOEMethod = POUtils.GetValueAsBoolean((PO)schema, "UseNOEMethod");
        if (useNOEMethod) {
            boolean bClean = true;
            if (mDoc.get_TableName().equals("M_Inventory")) {
                block0: for (Fact fact : facts) {
                    FactLine[] factLineArray = fact.getLines();
                    int n = factLineArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        FactLine factLine = factLineArray[n2];
                        I_M_InventoryLine mInvLine = (I_M_InventoryLine)((Object)factLine.getDocLine().p_po);
                        if (mInvLine.getQtyInternalUse() != null && mInvLine.getQtyInternalUse().signum() != 0) {
                            bClean = false;
                            continue block0;
                        }
                        ++n2;
                    }
                }
            }
            if (bClean) {
                facts.clear();
            }
        }
        return null;
    }

    private String accountingForCostCollector(MAcctSchema schema, List<Fact> facts, X_PP_Cost_Collector mCostCollector) {
        String msg = null;
        String sPostingType = (String)schema.get_Value("LIT_ManufPostType");
        if (sPostingType != null && facts != null) {
            if (sPostingType.equals("N")) {
                facts.clear();
            } else if (sPostingType.equals("S")) {
                for (Fact fact : facts) {
                    if (fact.getLines() == null) continue;
                    FactLine[] factLineArray = fact.getLines();
                    int n = factLineArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        FactLine line = factLineArray[n2];
                        line.setPostingType("S");
                        ++n2;
                    }
                }
            }
        }
        return msg;
    }

    private String accountingForPayment(MAcctSchema schema, List<Fact> facts, PO po) {
        String msg = null;
        if (po.get_TableName().equals("C_Payment")) {
            MPayment mPayment = (MPayment)po;
            int C_DocType_ID = mPayment.getC_DocType_ID();
            MDocType mDocType = MDocType.get(po.getCtx(), C_DocType_ID);
            if (LITMDocType.isPayNotPosted(mDocType)) {
                facts.clear();
            }
        } else if (po.get_TableName().equals("C_AllocationHdr")) {
            for (Fact fact : facts) {
                ArrayList<FactLine> lstFactsToRemove = new ArrayList<FactLine>();
                FactLine[] factLineArray = fact.getLines();
                int n = factLineArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MDocType mDocType;
                    FactLine line = factLineArray[n2];
                    int C_AllocationLine_ID = line.getDocLine().get_ID();
                    int C_DocType_ID = DB.getSQLValue(po.get_TrxName(), DOCTYPE_OF_ALLOCATIONLINE, C_AllocationLine_ID);
                    if (C_DocType_ID > 0 && LITMDocType.isPayNotPosted(mDocType = MDocType.get(po.getCtx(), C_DocType_ID))) {
                        lstFactsToRemove.add(line);
                    }
                    ++n2;
                }
                for (FactLine flRemoved : lstFactsToRemove) {
                    fact.remove(flRemoved);
                }
            }
        }
        return msg;
    }

    private boolean checkInOutFact(String trx, int M_InOutLine_ID, int C_AcctSchema_ID) {
        String sql = "SELECT COUNT(*)  FROM M_INOUTLINE ML  INNER JOIN FACT_ACCT FA ON (FA.RECORD_ID = ML.M_INOUT_ID AND FA.LINE_ID = ML.M_INOUTLINE_ID)  WHERE FA.AD_TABLE_ID = " + MInOut.Table_ID + " AND FA.POSTINGTYPE = 'A' " + " AND ML.M_INOUTLINE_ID = ? " + " AND FA.C_ACCTSCHEMA_ID = ? ";
        int no = DB.getSQLValue(trx, sql, M_InOutLine_ID, C_AcctSchema_ID);
        return no > 0;
    }

    private boolean checkOrderFact(String trx, int C_OrderLine_ID, int C_AcctSchema_ID) {
        String sql = "SELECT COUNT(*)  FROM C_ORDERLINE OL  INNER JOIN FACT_ACCT FA ON (FA.RECORD_ID = OL.C_ORDER_ID AND FA.LINE_ID = OL.C_ORDERLINE_ID)  WHERE FA.AD_TABLE_ID = " + MOrder.Table_ID + " AND FA.POSTINGTYPE = 'A' " + " AND OL.C_ORDERLINE_ID = ? " + " AND FA.C_ACCTSCHEMA_ID = ? ";
        int no = DB.getSQLValue(trx, sql, C_OrderLine_ID, C_AcctSchema_ID);
        return no > 0;
    }

    public static BigDecimal getSOPrice(String trx, int C_OrderLine_ID, int C_Currency_ID) {
        BigDecimal retValue;
        block6: {
            retValue = null;
            String sql = "SELECT currencyConvert(ol.PriceCost, o.C_Currency_ID, ?, o.DateAcct, o.C_ConversionType_ID, ol.AD_Client_ID, ol.AD_Org_ID), currencyConvert(ol.PriceActual, o.C_Currency_ID, ?, o.DateAcct, o.C_ConversionType_ID, ol.AD_Client_ID, ol.AD_Org_ID) FROM C_OrderLine ol INNER JOIN C_Order o ON (ol.C_Order_ID=o.C_Order_ID) WHERE ol.C_OrderLine_ID=? AND o.IsSOTrx='Y'";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, trx);
                    pstmt.setInt(1, C_Currency_ID);
                    pstmt.setInt(2, C_Currency_ID);
                    pstmt.setInt(3, C_OrderLine_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next() && ((retValue = rs.getBigDecimal(2)) == null || retValue.signum() == 0)) {
                        retValue = rs.getBigDecimal(1);
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return retValue;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("LIT_Validator, ").append(version);
        return sb.toString();
    }

    private String setInvoiceCustomFields(MInvoice inv) {
        X_LIT_DocTypeExt xdte;
        if (!inv.getDocStatus().equals("DR")) {
            return null;
        }
        inv.set_CustomColumn("IsIntraVAT", "N");
        inv.set_CustomColumn("IsReverseCharge", "N");
        inv.set_CustomColumn("IsSuspendedVAT", "N");
        X_C_DocType doct = new X_C_DocType(inv.getCtx(), inv.getC_DocTypeTarget_ID(), inv.get_TrxName());
        int deid = POUtils.GetValueAsInt((PO)doct, "LIT_DocTypeExt_ID");
        if (deid > 0 && (xdte = new X_LIT_DocTypeExt(inv.getCtx(), deid, inv.get_TrxName())) != null) {
            inv.set_CustomColumn("IsIntraVAT", xdte.isIntraVAT());
            inv.set_CustomColumn("IsReverseCharge", xdte.isReverseCharge());
            if (xdte.getLIT_VATLedgerDef_ID() > 0 && inv.get_Value("VATLedgerDate") == null) {
                inv.set_CustomColumn("VATLedgerDate", inv.getDateAcct());
            }
        }
        MBPartner bp = new MBPartner(inv.getCtx(), inv.getC_BPartner_ID(), inv.get_TrxName());
        if (inv.isSOTrx()) {
            inv.set_CustomColumn("IsSuspendedVAT", bp.get_Value("IsSuspendedVAT"));
        }
        return null;
    }

    private String setOrderCustomFields(MOrder ord) {
        X_LIT_DocTypeExt xdte;
        if (ord.getDocStatus() != "DR") {
            return null;
        }
        ord.set_CustomColumn("IsIntraVAT", "N");
        ord.set_CustomColumn("IsReverseCharge", "N");
        ord.set_CustomColumn("IsSuspendedVAT", "N");
        X_C_DocType doct = new X_C_DocType(ord.getCtx(), ord.getC_DocType_ID(), null);
        int deid = POUtils.GetValueAsInt((PO)doct, "LIT_DocTypeExt_ID");
        if (deid > 0 && (xdte = new X_LIT_DocTypeExt(ord.getCtx(), deid, null)) != null) {
            ord.set_CustomColumn("IsIntraVAT", xdte.isIntraVAT());
            ord.set_CustomColumn("IsReverseCharge", xdte.isReverseCharge());
        }
        MBPartner bp = new MBPartner(ord.getCtx(), ord.getC_BPartner_ID(), null);
        if (ord.isSOTrx()) {
            ord.set_CustomColumn("IsSuspendedVAT", bp.get_Value("IsSuspendedVAT"));
        }
        return null;
    }

    private String assignVATLedgerNo(MInvoice inv) {
        X_LIT_VATLedgerDef vdef;
        int seqid;
        X_LIT_DocTypeExt dte;
        int vldid;
        MDocType dt = MDocType.get(inv.getCtx(), inv.getC_DocType_ID());
        String vatno = inv.get_ValueAsString("VATLedgerNo");
        int LIT_DocTypeExt_ID = POUtils.GetValueAsInt((PO)dt, "LIT_DocTypeExt_ID");
        if (LIT_DocTypeExt_ID > 0 && (vatno == null || vatno.trim().length() == 0 || vatno.startsWith("<") && vatno.endsWith(">")) && (vldid = POUtils.GetValueAsInt((PO)(dte = new X_LIT_DocTypeExt(inv.getCtx(), LIT_DocTypeExt_ID, inv.get_TrxName())), "LIT_VatLedgerDef_ID")) > 0 && (seqid = POUtils.GetValueAsInt((PO)(vdef = new X_LIT_VATLedgerDef(inv.getCtx(), vldid, inv.get_TrxName())), "DocNoSequence_ID")) > 0) {
            vatno = LIT_Sequence.getDocumentNo(inv.getAD_Client_ID(), seqid, inv.get_TrxName(), (PO)inv);
            if (vatno != null && vatno.length() > 0) {
                inv.set_CustomColumn("VATLedgerNo", vatno);
            } else {
                return String.valueOf(Msg.getMsg(inv.getCtx(), "SequenceDocNotFound")) + " (VATLedgerNo)";
            }
        }
        return null;
    }

    private String assignVATLedgerNoAuto(MInvoice inv) {
        X_LIT_VATLedgerDef vdef;
        int seqid;
        X_LIT_DocTypeExt dte;
        int vldid;
        MLITInvoiceAuto autoinv = MLITInvoiceAuto.get(inv, inv.get_TrxName());
        MDocType dt = MDocType.get(inv.getCtx(), autoinv.getC_DocTypeAutoInvoice_ID());
        String vatno = autoinv.get_ValueAsString("VATLedgerNo");
        int LIT_DocTypeExt_ID = POUtils.GetValueAsInt((PO)dt, "LIT_DocTypeExt_ID");
        if (LIT_DocTypeExt_ID > 0 && (vatno == null || vatno.trim().length() == 0 || vatno.startsWith("<") && vatno.endsWith(">")) && (vldid = POUtils.GetValueAsInt((PO)(dte = new X_LIT_DocTypeExt(inv.getCtx(), LIT_DocTypeExt_ID, inv.get_TrxName())), "LIT_VatLedgerDef_ID")) > 0 && (seqid = POUtils.GetValueAsInt((PO)(vdef = new X_LIT_VATLedgerDef(inv.getCtx(), vldid, inv.get_TrxName())), "DocNoSequence_ID")) > 0) {
            vatno = LIT_Sequence.getDocumentNo(inv.getAD_Client_ID(), seqid, inv.get_TrxName(), (PO)autoinv);
            if (vatno != null && vatno.length() > 0) {
                autoinv.set_CustomColumn("VATLedgerNo", vatno);
            } else {
                return String.valueOf(Msg.getMsg(inv.getCtx(), "SequenceDocNotFound")) + " (VATLedgerNoAuto)";
            }
        }
        autoinv.save();
        return null;
    }

    private String accountingForNOEInOut(MInOut inout) {
        Doc doc = inout.getDoc();
        ArrayList<Fact> facts = doc.getFacts();
        ListIterator<Fact> itFacts = facts.listIterator();
        while (itFacts.hasNext()) {
            Fact fact = itFacts.next();
            MAcctSchema as = fact.getAcctSchema();
            boolean useNOEMethod = POUtils.GetValueAsBoolean((PO)as, "UseNOEMethod");
            if (!useNOEMethod || !fact.isPostingType("A") || !doc.isSOTrx() || !doc.getDocumentType().equals("MMS") && !doc.getDocumentType().equals("MMR")) continue;
            FactLine[] factLineArray = fact.getLines();
            int n = factLineArray.length;
            int n2 = 0;
            while (n2 < n) {
                FactLine fl = factLineArray[n2];
                MProduct product = fl.getDocLine().getProduct();
                if (!product.isService()) {
                    fact.remove(fl);
                }
                ++n2;
            }
            if (fact.getLines().length != 0) continue;
            itFacts.remove();
        }
        return null;
    }

    private String accountingForSuspendedVAT(MAllocationHdr ah) {
        Doc doc = ah.getDoc();
        ArrayList<Fact> facts = doc.getFacts();
        PO invoice = null;
        DocLine[] docLineArray = doc.p_lines;
        int n = doc.p_lines.length;
        int n2 = 0;
        while (n2 < n) {
            DocLine dline = docLineArray[n2];
            DocLine_Allocation aline = (DocLine_Allocation)dline;
            int iID = aline.getC_Invoice_ID();
            if (iID != 0) {
                DocTax[] m_itaxes;
                if (invoice == null || iID != invoice.get_ID()) {
                    invoice = new MInvoice(ah.getCtx(), iID, ah.get_TrxName());
                }
                if (invoice != null && POUtils.GetValueAsBoolean(invoice, "IsSuspendedVAT") && (m_itaxes = this.loadInvoiceTaxes(invoice.get_ID(), ah.get_TrxName())).length > 0) {
                    BigDecimal allocationSource = aline.getAmtSource().add(aline.getDiscountAmt()).add(aline.getWriteOffAmt());
                    double percent = allocationSource.doubleValue() / ((X_C_Invoice)invoice).getGrandTotal().doubleValue();
                    if (percent > 0.99 && percent < 1.01) {
                        percent = 1.0;
                    }
                    for (Fact fact : facts) {
                        MAcctSchema as = fact.getAcctSchema();
                        if (!as.isAccrual()) continue;
                        int t = 0;
                        while (t < m_itaxes.length) {
                            BigDecimal vatamt = m_itaxes[t].getAmount();
                            if ((vatamt = vatamt.multiply(new BigDecimal(percent))).signum() != 0) {
                                FactLine fl = fact.createLine(dline, LIT_TaxAcct.getAccount(m_itaxes[t].getC_Tax_ID(), 5, as), doc.getC_Currency_ID(), vatamt, null);
                                fl.setC_Tax_ID(m_itaxes[t].getC_Tax_ID());
                                fl = fact.createLine(dline, m_itaxes[t].getAccount(0, as), doc.getC_Currency_ID(), null, vatamt);
                                fl.setC_Tax_ID(m_itaxes[t].getC_Tax_ID());
                            }
                            ++t;
                        }
                    }
                }
            }
            ++n2;
        }
        return null;
    }

    private DocTax[] loadInvoiceTaxes(int C_Invoice_ID, String trx) {
        ArrayList<DocTax> list = new ArrayList<DocTax>();
        String sql = "SELECT it.C_Tax_ID, t.Name, t.Rate, it.TaxBaseAmt, it.TaxAmt, t.IsSalesTax FROM C_Tax t, C_InvoiceTax it WHERE t.C_Tax_ID=it.C_Tax_ID AND it.C_Invoice_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, trx);
            pstmt.setInt(1, C_Invoice_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int C_Tax_ID = rs.getInt(1);
                String name = rs.getString(2);
                BigDecimal rate = rs.getBigDecimal(3);
                BigDecimal taxBaseAmt = rs.getBigDecimal(4);
                BigDecimal amount = rs.getBigDecimal(5);
                boolean salesTax = "Y".equals(rs.getString(6));
                DocTax taxLine = new DocTax(C_Tax_ID, name, rate, taxBaseAmt, amount, salesTax);
                log.fine(taxLine.toString());
                list.add(taxLine);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
            return null;
        }
        DocTax[] tl = new DocTax[list.size()];
        list.toArray(tl);
        return tl;
    }

    private String accountingForInvoiceWithholdingOnPayment(MAllocationHdr ah) {
        Doc doc = ah.getDoc();
        ArrayList<Fact> facts = doc.getFacts();
        int i = 0;
        while (i < facts.size()) {
            Fact fact = facts.get(i);
            MAcctSchema as = fact.getAcctSchema();
            MAccount ppwithholding = MLITInvoiceWithholding.getPrepaymentAcct(as);
            MAllocationLine[] alloc_lines = ah.getLines(false);
            int j = 0;
            while (j < alloc_lines.length) {
                BigDecimal tottax = new BigDecimal(0);
                MAllocationLine alloc_line = alloc_lines[j];
                doc.setC_BPartner_ID(alloc_line.getC_BPartner_ID());
                DocLine line = new DocLine(alloc_line, doc);
                int inv_id = alloc_line.getC_Invoice_ID();
                int pay_id = alloc_line.getC_Payment_ID();
                if (inv_id > 0 && pay_id > 0) {
                    MInvoice invoice = null;
                    invoice = new MInvoice(ah.getCtx(), alloc_line.getC_Invoice_ID(), ah.get_TrxName());
                    if (invoice != null) {
                        MPayment payment = new MPayment(ah.getCtx(), pay_id, ah.get_TrxName());
                        boolean prepayment = payment != null ? payment.isPrepayment() : false;
                        String sql = "SELECT i.C_Tax_ID, NVL(SUM(i.TaxBaseAmt),0) AS TaxBaseAmt, NVL(SUM(i.TaxAmt),0) AS TaxAmt, t.Name, t.Rate, t.IsSalesTax  FROM LIT_InvoiceWithholding i, C_Tax t  WHERE i.C_Invoice_ID = ? AND i.IsCalcOnPayment = 'Y' AND i.IsActive = 'Y' AND i.Processed = 'Y' AND i.C_AllocationLine_ID = ? AND i.C_Tax_ID = t.C_Tax_ID GROUP BY i.C_Tax_ID, t.Name, t.Rate, t.IsSalesTax";
                        CPreparedStatement pstmt = null;
                        ResultSet rs = null;
                        try {
                            try {
                                pstmt = DB.prepareStatement(sql, ah.get_TrxName());
                                pstmt.setInt(1, invoice.getC_Invoice_ID());
                                pstmt.setInt(2, alloc_line.getC_AllocationLine_ID());
                                rs = pstmt.executeQuery();
                                while (rs.next()) {
                                    int tax_ID = rs.getInt(1);
                                    BigDecimal taxBaseAmt = rs.getBigDecimal(2);
                                    BigDecimal amount = rs.getBigDecimal(3);
                                    String name = rs.getString(4);
                                    BigDecimal rate = rs.getBigDecimal(5);
                                    boolean salesTax = rs.getString(6).equals("Y");
                                    DocTax taxLine = new DocTax(tax_ID, name, rate, taxBaseAmt, amount, salesTax);
                                    if (amount == null || amount.signum() == 0) continue;
                                    FactLine tl = null;
                                    MAccount taxacct = prepayment ? ppwithholding : (invoice.isSOTrx() ? taxLine.getAccount(0, as) : taxLine.getAccount(taxLine.getAPTaxType(), as));
                                    tl = invoice.isSOTrx() ? fact.createLine(line, taxacct, as.getC_Currency_ID(), amount, null) : fact.createLine(line, taxacct, as.getC_Currency_ID(), null, amount);
                                    if (tl != null) {
                                        tl.setC_Tax_ID(taxLine.getC_Tax_ID());
                                    }
                                    tottax = tottax.add(amount);
                                }
                            }
                            catch (Exception e) {
                                log.log(Level.SEVERE, sql, e);
                                DB.close(rs, pstmt);
                                return "Error posting C_InvoiceTax from LIT_InvoiceWithholding";
                            }
                        }
                        catch (Throwable throwable) {
                            DB.close(rs, pstmt);
                            throw throwable;
                        }
                        DB.close(rs, pstmt);
                        if (Env.ZERO.compareTo(tottax) != 0) {
                            FactLine[] factlines = fact.getLines();
                            boolean foundflwriteoff = false;
                            int ifl = 0;
                            while (ifl < factlines.length) {
                                FactLine fl = factlines[ifl];
                                if (fl.getAccount().equals(doc.getAccount(32, as))) {
                                    foundflwriteoff = true;
                                    BigDecimal balamt = fl.getAmtSourceDr().subtract(fl.getAmtSourceCr());
                                    BigDecimal newbalamt = Env.ZERO;
                                    newbalamt = invoice.isSOTrx() ? balamt.subtract(tottax) : balamt.add(tottax);
                                    if (Env.ZERO.compareTo(newbalamt) == 0) {
                                        fact.remove(fl);
                                        break;
                                    }
                                    if (Env.ZERO.compareTo(newbalamt) > 0) {
                                        fl.setAmtAcct(fl.getC_Currency_ID(), Env.ZERO, newbalamt);
                                        fl.setAmtSource(fl.getC_Currency_ID(), Env.ZERO, newbalamt);
                                        break;
                                    }
                                    fl.setAmtAcct(fl.getC_Currency_ID(), newbalamt, Env.ZERO);
                                    fl.setAmtSource(fl.getC_Currency_ID(), newbalamt, Env.ZERO);
                                    break;
                                }
                                ++ifl;
                            }
                            if (!foundflwriteoff) {
                                FactLine fl = null;
                                fl = invoice.isSOTrx() ? fact.createLine(line, doc.getAccount(32, as), as.getC_Currency_ID(), null, tottax) : fact.createLine(line, doc.getAccount(32, as), as.getC_Currency_ID(), tottax, null);
                                if (fl != null) {
                                    fl.setAD_Org_ID(ah.getAD_Org_ID());
                                }
                            }
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private String accountingForPrePaymentWithholdings(MPayment pay) {
        if (!pay.isPrepayment()) {
            return null;
        }
        Doc doc = pay.getDoc();
        ArrayList<Fact> facts = doc.getFacts();
        int i = 0;
        while (i < facts.size()) {
            Fact fact = facts.get(i);
            MAcctSchema as = fact.getAcctSchema();
            MAccount ppwithholding = MLITInvoiceWithholding.getPrepaymentAcct(as);
            String sql = "SELECT i.C_Tax_ID, NVL(SUM(i.TaxBaseAmt),0) AS TaxBaseAmt, NVL(SUM(i.TaxAmt),0) AS TaxAmt, t.Name, t.Rate, t.IsSalesTax  FROM LIT_InvoiceWithholding i, C_Tax t  WHERE i.C_Invoice_ID IS NULL AND i.IsCalcOnPayment = 'Y' AND i.IsActive = 'Y' AND i.Processed = 'Y' AND i.C_Payment_ID = ? AND i.C_Tax_ID = t.C_Tax_ID GROUP BY i.C_Tax_ID, t.Name, t.Rate, t.IsSalesTax";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, pay.get_TrxName());
                    pstmt.setInt(1, pay.get_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int tax_ID = rs.getInt(1);
                        BigDecimal taxBaseAmt = rs.getBigDecimal(2);
                        BigDecimal amount = rs.getBigDecimal(3);
                        String name = rs.getString(4);
                        BigDecimal rate = rs.getBigDecimal(5);
                        boolean salesTax = rs.getString(6).equals("Y");
                        DocTax taxLine = new DocTax(tax_ID, name, rate, taxBaseAmt, amount, salesTax);
                        if (amount == null || amount.signum() == 0) continue;
                        FactLine tl = null;
                        if (pay.getC_DocType().getDocBaseType().equals("ARR")) {
                            tl = fact.createLine(null, taxLine.getAccount(0, as), as.getC_Currency_ID(), amount, null);
                            if (tl != null) {
                                tl.setC_Tax_ID(taxLine.getC_Tax_ID());
                            }
                            if ((tl = fact.createLine(null, ppwithholding, as.getC_Currency_ID(), null, amount)) == null) continue;
                            tl.setC_Tax_ID(taxLine.getC_Tax_ID());
                            continue;
                        }
                        tl = fact.createLine(null, taxLine.getAccount(taxLine.getAPTaxType(), as), as.getC_Currency_ID(), null, amount);
                        if (tl != null) {
                            tl.setC_Tax_ID(taxLine.getC_Tax_ID());
                        }
                        if ((tl = fact.createLine(null, ppwithholding, as.getC_Currency_ID(), amount, null)) == null) continue;
                        tl.setC_Tax_ID(taxLine.getC_Tax_ID());
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    return "Error posting Withholding on prepayment in LOC_Validator";
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
            DB.close(rs, pstmt);
            ++i;
        }
        return null;
    }

    private String accountingForInvoiceTaxes(MInvoice inv) {
        Doc doc = inv.getDoc();
        ArrayList<Fact> facts = doc.getFacts();
        boolean isSuspendedVAT = POUtils.GetValueAsBoolean((PO)inv, "IsSuspendedVAT");
        if (isSuspendedVAT) {
            for (Fact fact : facts) {
                MAcctSchema as = fact.getAcctSchema();
                if (!as.isAccrual()) continue;
                FactLine[] factLineArray = fact.getLines();
                int n = factLineArray.length;
                int n2 = 0;
                while (n2 < n) {
                    FactLine fl = factLineArray[n2];
                    if (fl.getC_Tax_ID() > 0 && fl.getAccount().equals(LIT_TaxAcct.getAccount(fl.getC_Tax_ID(), 0, as))) {
                        fl.setAccount(as, LIT_TaxAcct.getAccount(fl.getC_Tax_ID(), 5, as));
                    }
                    ++n2;
                }
            }
        }
        return null;
    }

    private boolean checkWriteOffAmt(Properties ctx, int C_Invoice_ID, BigDecimal totPayed, BigDecimal writeOff) {
        BigDecimal WhFullAmt = MLITInvoiceWithholding.getOpenWithholdingAmt(null, C_Invoice_ID, "Y", "N");
        if (WhFullAmt.signum() != 0 && writeOff.compareTo(WhFullAmt) < 0) {
            return false;
        }
        BigDecimal[] WhProRataAmt = MLITInvoiceWithholding.getProRataWithholdingAmt(null, C_Invoice_ID, 0, 0, 0);
        if (WhProRataAmt[1].signum() != 0) {
            double percent;
            MInvoice invoice = new MInvoice(ctx, C_Invoice_ID, null);
            double d = percent = invoice.getGrandTotal().signum() != 0 ? totPayed.doubleValue() / invoice.getGrandTotal().doubleValue() : 1.0;
            if (percent > 0.99 && percent < 1.01) {
                percent = 1.0;
            }
            BigDecimal creditWhAmt = MLITInvoiceWithholding.getCreditNoteWithholdingAmt(null, C_Invoice_ID);
            BigDecimal totwriteoff = WhProRataAmt[1].multiply(new BigDecimal(percent)).add(WhFullAmt).setScale(invoice.getPrecision(), 4);
            if (writeOff.compareTo(totwriteoff = totwriteoff.subtract(creditWhAmt)) < 0) {
                return false;
            }
        }
        return true;
    }

    private boolean checkWriteOffAmtPP(Properties ctx, int C_Order_ID, BigDecimal totPayed, BigDecimal writeOff) {
        BigDecimal WhFullAmt = MLITInvoiceWithholding.getOpenWithholdingAmt(null, C_Order_ID, 0, "Y", "N");
        if (WhFullAmt.signum() != 0 && writeOff.compareTo(WhFullAmt) < 0) {
            return false;
        }
        BigDecimal[] WhProRataAmt = MLITInvoiceWithholding.getProRataWithholdingAmt(null, C_Order_ID, 0, 0, 0, 0);
        if (WhProRataAmt[1].signum() != 0) {
            BigDecimal totwriteoff;
            double percent;
            MOrder order = new MOrder(ctx, C_Order_ID, null);
            double d = percent = order.getGrandTotal().signum() != 0 ? totPayed.doubleValue() / order.getGrandTotal().doubleValue() : 1.0;
            if (percent > 0.99 && percent < 1.01) {
                percent = 1.0;
            }
            if (writeOff.compareTo(totwriteoff = WhProRataAmt[1].multiply(new BigDecimal(percent)).add(WhFullAmt).setScale(order.getPrecision(), 4)) < 0) {
                return false;
            }
        }
        return true;
    }

    public String mfillName(MBPartner bpartner) {
        log.info("");
        Object bp = bpartner.get_Value("IsDetailedNames");
        if (bp == null || !((Boolean)bp).booleanValue()) {
            bpartner.set_ValueOfColumn("FirstName1", null);
            bpartner.set_ValueOfColumn("FirstName2", null);
            bpartner.set_ValueOfColumn("LastName1", null);
            bpartner.set_ValueOfColumn("LastName2", null);
            return null;
        }
        String filledName = null;
        if (bpartner.get_Value("FirstName1") == null || ((String)bpartner.get_Value("FirstName1")).length() == 0) {
            return Msg.getMsg(bpartner.getCtx(), "LIT_FirstName1Required");
        }
        if (bpartner.get_Value("LastName1") == null || ((String)bpartner.get_Value("LastName1")).length() == 0) {
            return Msg.getMsg(bpartner.getCtx(), "LIT_LastName1Required");
        }
        filledName = bpartner.get_ValueAsString("LastName1").trim();
        if (bpartner.get_Value("LastName2") != null) {
            filledName = String.valueOf(filledName) + " " + bpartner.get_ValueAsString("LastName2").trim();
        }
        if (filledName != null) {
            filledName = String.valueOf(filledName) + " ";
        }
        filledName = String.valueOf(filledName) + bpartner.get_ValueAsString("FirstName1").trim();
        if (bpartner.get_Value("FirstName2") != null) {
            filledName = String.valueOf(filledName) + " " + bpartner.get_ValueAsString("FirstName2").trim();
        }
        bpartner.setName(filledName);
        return null;
    }

    private String clearInvoiceWithholdingAmtFromInvoice(MInvoice inv) {
        if (inv.is_ValueChanged("AD_Org_ID") || inv.is_ValueChanged("C_BPartner_ID") || inv.is_ValueChanged("C_DocTypeTarget_ID")) {
            boolean thereAreCalc;
            try {
                thereAreCalc = this.thereAreCalc(inv);
            }
            catch (SQLException e) {
                log.log(Level.SEVERE, "Error looking for calc on invoice rules", e);
                return "Error looking for calc on invoice rules";
            }
            BigDecimal curWithholdingAmt = (BigDecimal)inv.get_Value("WithholdingAmt");
            if (thereAreCalc) {
                if (curWithholdingAmt != null) {
                    inv.set_CustomColumn("WithholdingAmt", null);
                }
            } else if (curWithholdingAmt == null) {
                inv.set_CustomColumn("WithholdingAmt", Env.ZERO);
            }
        }
        return null;
    }

    private String clearInvoiceWithholdingAmtFromInvoiceLine(MInvoiceLine invline, int type) {
        if (type == 1 || type == 3 || type == 2 && (invline.is_ValueChanged("LineNetAmt") || invline.is_ValueChanged("M_Product_ID") || invline.is_ValueChanged("C_Charge_ID") || invline.is_ValueChanged("IsActive") || invline.is_ValueChanged("C_Tax_ID"))) {
            boolean thereAreCalc;
            MInvoice inv = invline.getParent();
            try {
                thereAreCalc = this.thereAreCalc(inv);
            }
            catch (SQLException e) {
                log.log(Level.SEVERE, "Error looking for calc on invoice rules", e);
                return "Error looking for calc on invoice rules";
            }
            BigDecimal curWithholdingAmt = (BigDecimal)inv.get_Value("WithholdingAmt");
            if (thereAreCalc) {
                if (curWithholdingAmt != null) {
                    inv.set_CustomColumn("WithholdingAmt", null);
                    if (!inv.save()) {
                        return "Error saving C_Invoice clearInvoiceWithholdingAmtFromInvoiceLine";
                    }
                }
            } else if (curWithholdingAmt == null) {
                inv.set_CustomColumn("WithholdingAmt", Env.ZERO);
                if (!inv.save()) {
                    return "Error saving C_Invoice clearInvoiceWithholdingAmtFromInvoiceLine";
                }
            }
        }
        return null;
    }

    private String completeInvoiceWithholding(MInvoice inv) {
        String upd_dates = "UPDATE LIT_InvoiceWithholding    SET DateAcct =           (SELECT DateAcct              FROM C_Invoice             WHERE C_Invoice.C_Invoice_ID = LIT_InvoiceWithholding.C_Invoice_ID),        DateTrx =           (SELECT DateInvoiced              FROM C_Invoice             WHERE C_Invoice.C_Invoice_ID = LIT_InvoiceWithholding.C_Invoice_ID)  WHERE C_Invoice_ID = ? ";
        int noupddates = DB.executeUpdate(upd_dates, inv.getC_Invoice_ID(), inv.get_TrxName());
        if (noupddates == -1) {
            return "Error updating dates on invoice withholding";
        }
        String upd_proc = "UPDATE LIT_InvoiceWithholding    SET Processed = 'Y'  WHERE C_Invoice_ID = ? AND IsCalcOnPayment = 'N'";
        int noupdproc = DB.executeUpdate(upd_proc, inv.getC_Invoice_ID(), inv.get_TrxName());
        if (noupdproc == -1) {
            return "Error updating processed on invoice withholding";
        }
        return null;
    }

    private String doInvoiceAutoPayment(X_C_Invoice mInvoice) {
        String sMsg = null;
        MDocType mDocType = MDocType.get(mInvoice.getCtx(), mInvoice.getC_DocType_ID());
        int C_BankAccount_ID = LITMDocType.getC_BankAccount_ID(mDocType);
        if (C_BankAccount_ID > 0) {
            MPayment mPayment = new MPayment(mInvoice.getCtx(), 0, mInvoice.get_TrxName());
            mPayment.setC_DocType_ID(LITMDocType.getC_DocPay_ID(mDocType));
            mPayment.setC_BankAccount_ID(LITMDocType.getC_BankAccount_ID(mDocType));
            mPayment.setC_Invoice_ID(mInvoice.getC_Invoice_ID());
            mPayment.setC_BPartner_ID(mInvoice.getC_BPartner_ID());
            mPayment.setAmount(mInvoice.getC_Currency_ID(), mInvoice.getGrandTotal());
            mPayment.setDateAcct(mInvoice.getDateAcct());
            mPayment.setDateTrx(mInvoice.getDateInvoiced());
            mPayment.setTenderType("T");
            mPayment.setTrxType("A");
            mPayment.saveEx();
            mPayment.processIt("CO");
            mPayment.saveEx();
        }
        return sMsg;
    }

    /*
     * Exception decompiling
     */
    private String completePaymentWithholdings(MAllocationHdr ah) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 20[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String completePrePaymentWithholdings(MPayment pay) {
        if (!pay.isPrepayment()) {
            return null;
        }
        String upd_dates = "UPDATE LIT_InvoiceWithholding    SET DateAcct = " + DB.TO_DATE(pay.getDateAcct()) + "       ,DateTrx = " + DB.TO_DATE(pay.getDateTrx()) + "       ,Processed = 'Y'" + " WHERE C_Payment_ID = ? AND Processed = 'N' AND IsCalcOnPayment = 'Y'";
        int noupddates = DB.executeUpdate(upd_dates, pay.get_ID(), pay.get_TrxName());
        if (noupddates == -1) {
            return "Error updating dates on prepayment withholding";
        }
        return null;
    }

    private String reversePaymentWithholdings(MAllocationHdr ah) {
        MAllocationLine[] als = ah.getLines(true);
        String msg = null;
        int i = 0;
        while (i < als.length) {
            MAllocationLine al = als[i];
            msg = this.reversePaymentWithholdingsLines(al);
            if (msg != null) {
                return msg;
            }
            ++i;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String reversePaymentWithholdingsLines(MAllocationLine al) {
        if (al.getC_Invoice_ID() <= 0) return null;
        String sql = "SELECT LIT_InvoiceWithholding_ID FROM LIT_InvoiceWithholding WHERE C_Invoice_ID = ? AND IsActive = 'Y' AND IsCalcOnPayment = 'Y' AND Processed = 'Y' AND C_AllocationLine_ID = ?";
        CPreparedStatement pstmt = DB.prepareStatement(sql, al.get_TrxName());
        try {
            MLITInvoiceWithholding iwh;
            pstmt.setInt(1, al.getC_Invoice_ID());
            pstmt.setInt(2, al.getC_AllocationLine_ID());
            ResultSet rs = pstmt.executeQuery();
            do {
                if (!rs.next()) {
                    rs.close();
                    pstmt.close();
                    return null;
                }
                int iwhid = rs.getInt(1);
                iwh = new MLITInvoiceWithholding(al.getCtx(), iwhid, al.get_TrxName());
                iwh.setC_AllocationLine_ID(0);
                iwh.setProcessed(false);
            } while (iwh.save());
            return "Error saving LIT_InvoiceWithholding reversePaymentWithholdings";
        }
        catch (SQLException e) {
            e.printStackTrace();
            return e.getLocalizedMessage();
        }
    }

    private boolean thereAreCalc(MInvoice inv) throws SQLException {
        boolean thereAreCalc = false;
        String sqlwccoi = "SELECT 1   FROM LIT_WithholdingType wt, LIT_WithholdingCalc wc  WHERE wt.LIT_WithholdingType_ID = wc.LIT_WithholdingType_ID";
        CPreparedStatement pstmtwccoi = DB.prepareStatement(sqlwccoi, inv.get_TrxName());
        ResultSet rswccoi = pstmtwccoi.executeQuery();
        if (rswccoi.next()) {
            thereAreCalc = true;
        }
        rswccoi.close();
        pstmtwccoi.close();
        return thereAreCalc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String translateWithholdingToTaxes(MInvoice inv) {
        BigDecimal sumit = new BigDecimal(0);
        MDocType dt = new MDocType(inv.getCtx(), inv.getC_DocTypeTarget_ID(), inv.get_TrxName());
        String genwh = dt.get_ValueAsString("GenerateWithholding");
        if (genwh == null || genwh.equals("N")) {
            String sqldel = "DELETE FROM LIT_InvoiceWithholding  WHERE C_Invoice_ID = ?";
            try {
                CPreparedStatement pstmtdel = DB.prepareStatement(sqldel, 1003, 1008, inv.get_TrxName());
                pstmtdel.setInt(1, inv.getC_Invoice_ID());
                int nodel = pstmtdel.executeUpdate();
                log.config("LIT_InvoiceWithholding deleted=" + nodel);
                pstmtdel.close();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, sqldel, e);
                return "Error creating C_InvoiceTax from LIT_InvoiceWithholding -delete";
            }
            inv.set_CustomColumn("WithholdingAmt", Env.ZERO);
            return null;
        }
        String sql = "SELECT C_Tax_ID, NVL(SUM(TaxBaseAmt),0) AS TaxBaseAmt, NVL(SUM(TaxAmt),0) AS TaxAmt  FROM LIT_InvoiceWithholding  WHERE C_Invoice_ID = ? AND IsCalcOnPayment = 'N' AND IsActive = 'Y' GROUP BY C_Tax_ID";
        CPreparedStatement pstmt = null;
        try {
            ResultSet rs;
            block8: {
                MInvoiceTax it;
                pstmt = DB.prepareStatement(sql, inv.get_TrxName());
                pstmt.setInt(1, inv.getC_Invoice_ID());
                rs = pstmt.executeQuery();
                do {
                    if (!rs.next()) break block8;
                    it = new MInvoiceTax(inv.getCtx(), 0, inv.get_TrxName());
                    it.setAD_Org_ID(inv.getAD_Org_ID());
                    it.setC_Invoice_ID(inv.getC_Invoice_ID());
                    it.setC_Tax_ID(rs.getInt(1));
                    it.setTaxBaseAmt(rs.getBigDecimal(2));
                    it.setTaxAmt(rs.getBigDecimal(3).negate());
                    sumit = sumit.add(rs.getBigDecimal(3));
                } while (it.save());
                rs.close();
                pstmt.close();
                return "Error creating C_InvoiceTax from LIT_InvoiceWithholding - save InvoiceTax";
            }
            inv.set_CustomColumn("WithholdingAmt", sumit);
            BigDecimal gt = inv.getGrandTotal();
            inv.setGrandTotal(gt.subtract(sumit));
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
            return "Error creating C_InvoiceTax from LIT_InvoiceWithholding - select InvoiceTax";
        }
        try {
            if (pstmt == null) return null;
            pstmt.close();
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String validateWriteOffVsPaymentWithholdings(MPayment pay) {
        if (pay.isPrepayment()) {
            BigDecimal wo = pay.getWriteOffAmt();
            BigDecimal totPayed = pay.getPayAmt().add(pay.getDiscountAmt().add(wo).abs());
            if (!this.checkWriteOffAmtPP(pay.getCtx(), pay.getC_Order_ID(), totPayed, wo)) {
                return Msg.getMsg(pay.getCtx(), "LIT_WriteOffLowerThanWithholdings");
            }
        } else if (pay.getC_Invoice_ID() > 0) {
            BigDecimal wo = pay.getWriteOffAmt();
            BigDecimal totPayed = pay.getPayAmt().add(pay.getDiscountAmt().add(wo).abs());
            if (!this.checkWriteOffAmt(pay.getCtx(), pay.getC_Invoice_ID(), totPayed, wo)) {
                return Msg.getMsg(pay.getCtx(), "LIT_WriteOffLowerThanWithholdings");
            }
        } else {
            String sql = "SELECT C_PaymentAllocate_ID FROM C_PaymentAllocate WHERE C_Payment_ID = ?";
            CPreparedStatement pstmt = DB.prepareStatement(sql, pay.get_TrxName());
            try {
                pstmt.setInt(1, pay.getC_Payment_ID());
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    int palid = rs.getInt(1);
                    MPaymentAllocate pal = new MPaymentAllocate(pay.getCtx(), palid, pay.get_TrxName());
                    BigDecimal wo = pal.getWriteOffAmt();
                    BigDecimal totPayed = pal.getAmount().add(pal.getDiscountAmt().add(wo).abs());
                    if (this.checkWriteOffAmt(pal.getCtx(), pal.getC_Invoice_ID(), totPayed, wo)) continue;
                    return Msg.getMsg(pal.getCtx(), "LIT_WriteOffLowerThanWithholdings");
                }
                rs.close();
                pstmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
                return e.getLocalizedMessage();
            }
        }
        return null;
    }

    private String validateVATLedgerDate(MInvoice inv) {
        if (inv.get_Value("VATLedgerDate") != null && ((Date)inv.get_Value("DateInvoiced")).compareTo((Date)inv.get_Value("VATLedgerDate")) > 0) {
            return String.valueOf(Msg.getMsg(inv.getCtx(), "LIT_VATLedgerDateBeforeDateInvoiced")) + " (VATLedgerDate)";
        }
        return null;
    }

    private String manageAcctPostDateChanges(MInvoice inv) {
        boolean bChangedVATLedgerDate = inv.is_ValueChanged("VATLedgerDate");
        boolean bChangedDateAcct = inv.is_ValueChanged("DateAcct");
        if ((bChangedVATLedgerDate || bChangedDateAcct) && !MSysConfig.getBooleanValue(LIT_ALLOW_DIFFERENT_DATES, false, inv.getAD_Client_ID(), inv.getAD_Client_ID())) {
            if (bChangedVATLedgerDate) {
                Timestamp tsLedgerDate = (Timestamp)inv.get_Value("VATLedgerDate");
                inv.setDateAcct(tsLedgerDate);
            } else if (bChangedDateAcct) {
                inv.set_CustomColumn("VATLedgerDate", inv.getDateAcct());
            }
        }
        return null;
    }

    @Override
    public String factsValidate(MAcctSchema schema, List<Fact> facts, PO po) {
        String msg = null;
        boolean IsSOBookRevenue = POUtils.GetValueAsBoolean((PO)schema, "IsSOBookRevenue");
        boolean IsShipmentBookRevenue = POUtils.GetValueAsBoolean((PO)schema, "IsShipmentBookRevenue");
        boolean IsAllowReturnsPosting = POUtils.GetValueAsBoolean((PO)schema, "IsAllowReturnsPosting");
        if (po.get_TableName().equals("M_InOut") && IsShipmentBookRevenue && (msg = this.accountingForServiceShipment(schema, facts, (MInOut)po)) != null) {
            return msg;
        }
        if (po.get_TableName().equals("C_Order") && IsSOBookRevenue && (msg = this.accountingForServiceOrder(schema, facts, (MOrder)po)) != null) {
            return msg;
        }
        if (po.get_TableName().equals("C_Invoice") && IsShipmentBookRevenue && (msg = this.accountingForServiceInvoicedShipment(schema, facts, (MInvoice)po)) != null) {
            return msg;
        }
        if (po.get_TableName().equals("C_Invoice") && IsSOBookRevenue && (msg = this.accountingForServiceInvoicedOrder(schema, facts, (MInvoice)po)) != null) {
            return msg;
        }
        if (po.get_TableName().equals("PP_Cost_Collector") && (msg = this.accountingForCostCollector(schema, facts, (X_PP_Cost_Collector)po)) != null) {
            return msg;
        }
        if ((po.get_TableName().equals("M_Inventory") || po.get_TableName().equals("M_Movement") || po.get_TableName().equals("M_Production")) && (msg = this.accountingForWarehouse(schema, facts, po)) != null) {
            return msg;
        }
        if ((po.get_TableName().equals("C_Payment") || po.get_TableName().equals("C_AllocationHdr")) && (msg = this.accountingForPayment(schema, facts, po)) != null) {
            return msg;
        }
        if (!IsAllowReturnsPosting && Helper.isReturnsRelated(po)) {
            facts.clear();
        }
        return msg;
    }
}

