/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaElement;
import org.compiere.model.MDistribution;
import org.compiere.model.MDistributionLine;
import org.compiere.model.MElementValue;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public final class Fact {
    private CLogger log = CLogger.getCLogger(this.getClass());
    private Doc m_doc = null;
    private MAcctSchema m_acctSchema = null;
    private String m_trxName;
    private String m_postingType = null;
    public static final String POST_Actual = "A";
    public static final String POST_Budget = "B";
    public static final String POST_Commitment = "E";
    public static final String POST_Reservation = "R";
    private boolean m_converted = false;
    private ArrayList<FactLine> m_lines = new ArrayList();

    public Fact(Doc document, MAcctSchema acctSchema, String defaultPostingType) {
        this.m_doc = document;
        this.m_acctSchema = acctSchema;
        this.m_postingType = defaultPostingType;
        this.m_trxName = document.getTrxName();
        this.log.config(this.toString());
    }

    public void dispose() {
        this.m_lines.clear();
        this.m_lines = null;
    }

    public FactLine createLine(DocLine docLine, MAccount account, int C_Currency_ID, BigDecimal debitAmt, BigDecimal creditAmt) {
        if (account == null) {
            this.log.info("No account for " + docLine + ": Amt=" + debitAmt + "/" + creditAmt + " - " + this.toString());
            return null;
        }
        FactLine line = new FactLine(this.m_doc.getCtx(), this.m_doc.get_Table_ID(), this.m_doc.get_ID(), docLine == null ? 0 : docLine.get_ID(), this.m_trxName);
        line.setDocumentInfo(this.m_doc, docLine);
        line.setPostingType(this.m_postingType);
        line.setAccount(this.m_acctSchema, account);
        if (!line.setAmtSource(C_Currency_ID, debitAmt, creditAmt)) {
            if (docLine == null || docLine.getQty() == null || docLine.getQty().signum() == 0) {
                this.log.fine("Both amounts & qty = 0/Null - " + docLine + " - " + this.toString());
                return null;
            }
            this.log.fine("Both amounts = 0/Null, Qty=" + docLine.getQty() + " - " + docLine + " - " + this.toString());
        }
        line.convert();
        if (docLine != null && (docLine.getAmtAcctDr() != null || docLine.getAmtAcctCr() != null)) {
            line.setAmtAcct(docLine.getAmtAcctDr(), docLine.getAmtAcctCr());
        }
        this.log.fine(line.toString());
        this.add(line);
        return line;
    }

    public void add(FactLine line) {
        this.m_lines.add(line);
    }

    public void remove(FactLine line) {
        this.m_lines.remove(line);
    }

    public FactLine createLine(DocLine docLine, MAccount accountDr, MAccount accountCr, int C_Currency_ID, BigDecimal Amt) {
        if (Amt.signum() < 0) {
            return this.createLine(docLine, accountCr, C_Currency_ID, null, Amt.abs());
        }
        return this.createLine(docLine, accountDr, C_Currency_ID, Amt, null);
    }

    public FactLine createLine(DocLine docLine, MAccount account, int C_Currency_ID, BigDecimal Amt) {
        if (Amt.signum() < 0) {
            return this.createLine(docLine, account, C_Currency_ID, null, Amt.abs());
        }
        return this.createLine(docLine, account, C_Currency_ID, Amt, null);
    }

    public boolean isPostingType(String PostingType) {
        return this.m_postingType.equals(PostingType);
    }

    public boolean isConverted() {
        return this.m_converted;
    }

    public MAcctSchema getAcctSchema() {
        return this.m_acctSchema;
    }

    public boolean isSourceBalanced() {
        boolean retValue;
        if (this.m_lines.size() == 0 || this.m_doc.isMultiCurrency()) {
            return true;
        }
        BigDecimal balance = this.getSourceBalance();
        boolean bl = retValue = balance.signum() == 0;
        if (retValue) {
            this.log.finer(this.toString());
        } else {
            this.log.warning("NO - Diff=" + balance + " - " + this.toString());
        }
        return retValue;
    }

    protected BigDecimal getSourceBalance() {
        BigDecimal result = Env.ZERO;
        int i = 0;
        while (i < this.m_lines.size()) {
            FactLine line = this.m_lines.get(i);
            result = result.add(line.getSourceBalance());
            ++i;
        }
        return result;
    }

    public FactLine balanceSource() {
        if (!this.m_acctSchema.isSuspenseBalancing() || this.m_doc.isMultiCurrency()) {
            return null;
        }
        BigDecimal diff = this.getSourceBalance();
        this.log.finer("Diff=" + diff);
        FactLine line = new FactLine(this.m_doc.getCtx(), this.m_doc.get_Table_ID(), this.m_doc.get_ID(), 0, this.m_trxName);
        line.setDocumentInfo(this.m_doc, null);
        line.setPostingType(this.m_postingType);
        line.setAccount(this.m_acctSchema, this.m_acctSchema.getSuspenseBalancing_Acct());
        if (diff.signum() < 0) {
            line.setAmtSource(this.m_doc.getC_Currency_ID(), diff.abs(), Env.ZERO);
        } else {
            line.setAmtSource(this.m_doc.getC_Currency_ID(), Env.ZERO, diff);
        }
        line.convert();
        this.log.fine(line.toString());
        this.m_lines.add(line);
        return line;
    }

    public boolean isSegmentBalanced() {
        if (this.m_lines.size() == 0 || this.m_doc.isMultiCurrency()) {
            return true;
        }
        MAcctSchemaElement[] elements = this.m_acctSchema.getAcctSchemaElements();
        int i = 0;
        while (i < elements.length) {
            MAcctSchemaElement ase = elements[i];
            if (ase.isBalanced() && !this.isSegmentBalanced(ase.getElementType())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isSegmentBalanced(String segmentType) {
        if (segmentType.equals("OO")) {
            HashMap<Integer, BigDecimal> map = new HashMap<Integer, BigDecimal>();
            int i = 0;
            while (i < this.m_lines.size()) {
                FactLine line = this.m_lines.get(i);
                Integer key = new Integer(line.getAD_Org_ID());
                BigDecimal bal = line.getSourceBalance();
                BigDecimal oldBal = (BigDecimal)map.get(key);
                if (oldBal != null) {
                    bal = bal.add(oldBal);
                }
                map.put(key, bal);
                ++i;
            }
            for (BigDecimal bal : map.values()) {
                if (bal.signum() == 0) continue;
                map.clear();
                this.log.warning("(" + segmentType + ") NO - " + this.toString() + ", Balance=" + bal);
                return false;
            }
            map.clear();
            this.log.finer("(" + segmentType + ") - " + this.toString());
            return true;
        }
        this.log.finer("(" + segmentType + ") (not checked) - " + this.toString());
        return true;
    }

    public void balanceSegments() {
        MAcctSchemaElement[] elements = this.m_acctSchema.getAcctSchemaElements();
        int i = 0;
        while (i < elements.length) {
            MAcctSchemaElement ase = elements[i];
            if (ase.isBalanced()) {
                this.balanceSegment(ase.getElementType());
            }
            ++i;
        }
    }

    private void balanceSegment(String elementType) {
        if (this.m_lines.size() == 0) {
            return;
        }
        this.log.fine("(" + elementType + ") - " + this.toString());
        if (elementType.equals("OO")) {
            HashMap<Integer, Balance> map = new HashMap<Integer, Balance>();
            int i = 0;
            while (i < this.m_lines.size()) {
                FactLine line = this.m_lines.get(i);
                Integer key = new Integer(line.getAD_Org_ID());
                Balance oldBalance = (Balance)map.get(key);
                if (oldBalance == null) {
                    oldBalance = new Balance(line.getAmtSourceDr(), line.getAmtSourceCr());
                    map.put(key, oldBalance);
                } else {
                    oldBalance.add(line.getAmtSourceDr(), line.getAmtSourceCr());
                }
                ++i;
            }
            for (Integer key : map.keySet()) {
                Balance difference = (Balance)map.get(key);
                this.log.info(String.valueOf(elementType) + "=" + key + ", " + difference);
                if (difference.isZeroBalance()) continue;
                FactLine line = new FactLine(this.m_doc.getCtx(), this.m_doc.get_Table_ID(), this.m_doc.get_ID(), 0, this.m_trxName);
                line.setDocumentInfo(this.m_doc, null);
                line.setPostingType(this.m_postingType);
                if (difference.getBalance().signum() < 0) {
                    if (difference.isReversal()) {
                        line.setAccount(this.m_acctSchema, this.m_acctSchema.getDueTo_Acct(elementType));
                        line.setAmtSource(this.m_doc.getC_Currency_ID(), Env.ZERO, difference.getPostBalance());
                    } else {
                        line.setAccount(this.m_acctSchema, this.m_acctSchema.getDueFrom_Acct(elementType));
                        line.setAmtSource(this.m_doc.getC_Currency_ID(), difference.getPostBalance(), Env.ZERO);
                    }
                } else if (difference.isReversal()) {
                    line.setAccount(this.m_acctSchema, this.m_acctSchema.getDueFrom_Acct(elementType));
                    line.setAmtSource(this.m_doc.getC_Currency_ID(), difference.getPostBalance(), Env.ZERO);
                } else {
                    line.setAccount(this.m_acctSchema, this.m_acctSchema.getDueTo_Acct(elementType));
                    line.setAmtSource(this.m_doc.getC_Currency_ID(), Env.ZERO, difference.getPostBalance());
                }
                line.convert();
                line.setAD_Org_ID(key);
                this.m_lines.add(line);
                this.log.fine("(" + elementType + ") - " + line);
            }
            map.clear();
        }
    }

    public boolean isAcctBalanced() {
        boolean retValue;
        if (this.m_lines.size() == 0) {
            return true;
        }
        BigDecimal balance = this.getAcctBalance();
        boolean bl = retValue = balance.signum() == 0;
        if (retValue) {
            this.log.finer(this.toString());
        } else {
            this.log.warning("NO - Diff=" + balance + " - " + this.toString());
        }
        return retValue;
    }

    protected BigDecimal getAcctBalance() {
        BigDecimal result = Env.ZERO;
        int i = 0;
        while (i < this.m_lines.size()) {
            FactLine line = this.m_lines.get(i);
            result = result.add(line.getAcctBalance());
            ++i;
        }
        return result;
    }

    public FactLine balanceAccounting() {
        BigDecimal diff = this.getAcctBalance();
        this.log.fine("Balance=" + diff + ", CurrBal=" + this.m_acctSchema.isCurrencyBalancing() + " - " + this.toString());
        FactLine line = null;
        BigDecimal BSamount = Env.ZERO;
        FactLine BSline = null;
        BigDecimal PLamount = Env.ZERO;
        FactLine PLline = null;
        int i = 0;
        while (i < this.m_lines.size()) {
            FactLine l = this.m_lines.get(i);
            BigDecimal amt = l.getAcctBalance().abs();
            if (l.isBalanceSheet() && amt.compareTo(BSamount) > 0) {
                BSamount = amt;
                BSline = l;
            } else if (!l.isBalanceSheet() && amt.compareTo(PLamount) > 0) {
                PLamount = amt;
                PLline = l;
            }
            ++i;
        }
        if (this.m_acctSchema.isCurrencyBalancing()) {
            boolean switchIt;
            line = new FactLine(this.m_doc.getCtx(), this.m_doc.get_Table_ID(), this.m_doc.get_ID(), 0, this.m_trxName);
            line.setDocumentInfo(this.m_doc, null);
            line.setPostingType(this.m_postingType);
            line.setAccount(this.m_acctSchema, this.m_acctSchema.getCurrencyBalancing_Acct());
            line.setAmtSource(this.m_doc.getC_Currency_ID(), Env.ZERO, Env.ZERO);
            line.convert();
            BigDecimal drAmt = Env.ZERO;
            BigDecimal crAmt = Env.ZERO;
            boolean isDR = diff.signum() < 0;
            BigDecimal difference = diff.abs();
            if (isDR) {
                drAmt = difference;
            } else {
                crAmt = difference;
            }
            boolean bl = switchIt = BSline != null && (BSline.isDrSourceBalance() && isDR || !BSline.isDrSourceBalance() && !isDR);
            if (switchIt) {
                drAmt = Env.ZERO;
                crAmt = Env.ZERO;
                if (isDR) {
                    crAmt = difference.negate();
                } else {
                    drAmt = difference.negate();
                }
            }
            line.setAmtAcct(drAmt, crAmt);
            this.log.fine(line.toString());
            this.m_lines.add(line);
        } else {
            line = BSline != null ? BSline : PLline;
            if (line == null) {
                this.log.severe("No Line found");
            } else {
                this.log.fine("Adjusting Amt=" + diff + "; Line=" + line);
                line.currencyCorrect(diff);
                this.log.fine(line.toString());
            }
        }
        return line;
    }

    public boolean checkAccounts() {
        if (this.m_lines.size() == 0) {
            return true;
        }
        int i = 0;
        while (i < this.m_lines.size()) {
            FactLine line = this.m_lines.get(i);
            MAccount account = line.getAccount();
            if (account == null) {
                this.log.warning("No Account for " + line);
                return false;
            }
            MElementValue ev = account.getAccount();
            if (ev == null) {
                this.log.warning("No Element Value for " + account + ": " + line);
                return false;
            }
            if (ev.isSummary()) {
                this.log.warning("Cannot post to Summary Account " + ev + ": " + line);
                return false;
            }
            if (!ev.isActive()) {
                this.log.warning("Cannot post to Inactive Account " + ev + ": " + line);
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean distribute() {
        if (this.m_lines.size() == 0) {
            return true;
        }
        ArrayList<FactLine> newLines = new ArrayList<FactLine>();
        int i = 0;
        while (i < this.m_lines.size()) {
            FactLine dLine = this.m_lines.get(i);
            MDistribution[] distributions = MDistribution.get(dLine.getAccount(), this.m_postingType, this.m_doc.getC_DocType_ID());
            if (distributions != null && distributions.length != 0 || (distributions = MDistribution.get(dLine.getCtx(), dLine.getC_AcctSchema_ID(), this.m_postingType, this.m_doc.getC_DocType_ID(), dLine.getAD_Org_ID(), dLine.getAccount_ID(), dLine.getM_Product_ID(), dLine.getC_BPartner_ID(), dLine.getC_Project_ID(), dLine.getC_Campaign_ID(), dLine.getC_Activity_ID(), dLine.getAD_OrgTrx_ID(), dLine.getC_SalesRegion_ID(), dLine.getC_LocTo_ID(), dLine.getC_LocFrom_ID(), dLine.getUser1_ID(), dLine.getUser2_ID())) != null && distributions.length != 0) {
                MDistribution distribution;
                if (distributions.length > 1) {
                    this.log.warning("More then one Distributiion for " + dLine.getAccount());
                }
                if ((distribution = distributions[0]).isCreateReversal()) {
                    FactLine reversal = dLine.reverse(distribution.getName(), this.m_postingType);
                    this.log.info("Reversal=" + reversal);
                    newLines.add(reversal);
                } else {
                    this.m_lines.remove(i);
                    --i;
                }
                distribution.distribute(dLine.getAccount(), dLine.getSourceBalance(), dLine.getQty(), dLine.getC_Currency_ID());
                MDistributionLine[] lines = distribution.getLines(false);
                int j = 0;
                while (j < lines.length) {
                    MDistributionLine dl = lines[j];
                    if (dl.isActive() && dl.getAmt().signum() != 0) {
                        FactLine factLine = new FactLine(this.m_doc.getCtx(), this.m_doc.get_Table_ID(), this.m_doc.get_ID(), 0, this.m_trxName);
                        factLine.setDocumentInfo(this.m_doc, dLine.getDocLine());
                        factLine.setAccount(this.m_acctSchema, dl.getAccount());
                        if (this.m_postingType.equals(POST_Actual)) {
                            factLine.setPostingType("S");
                        } else {
                            factLine.setPostingType(this.m_postingType);
                        }
                        if (dl.isOverwriteOrg()) {
                            factLine.setAD_Org_ID(dl.getOrg_ID());
                        }
                        if (dl.isOverwriteAcct()) {
                            factLine.setAccount_ID(dl.getAccount_ID());
                        }
                        if (dl.isOverwriteActivity()) {
                            factLine.setC_Activity_ID(dl.getC_Activity_ID());
                        }
                        if (dl.isOverwriteBPartner()) {
                            factLine.setC_BPartner_ID(dl.getC_BPartner_ID());
                        }
                        if (dl.isOverwriteCampaign()) {
                            factLine.setC_Campaign_ID(dl.getC_Campaign_ID());
                        }
                        if (dl.isOverwriteLocFrom()) {
                            factLine.setC_LocFrom_ID(dl.getC_LocFrom_ID());
                        }
                        if (dl.isOverwriteLocTo()) {
                            factLine.setC_LocTo_ID(dl.getC_LocTo_ID());
                        }
                        if (dl.isOverwriteOrgTrx()) {
                            factLine.setAD_OrgTrx_ID(dl.getAD_OrgTrx_ID());
                        }
                        if (dl.isOverwriteProduct()) {
                            factLine.setM_Product_ID(dl.getM_Product_ID());
                        }
                        if (dl.isOverwriteProject()) {
                            factLine.setC_Project_ID(dl.getC_Project_ID());
                        }
                        if (dl.isOverwriteSalesRegion()) {
                            factLine.setC_SalesRegion_ID(dl.getC_SalesRegion_ID());
                        }
                        if (dl.isOverwriteUser1()) {
                            factLine.setUser1_ID(dl.getUser1_ID());
                        }
                        if (dl.isOverwriteUser2()) {
                            factLine.setUser2_ID(dl.getUser2_ID());
                        }
                        if (dl.getAmt().signum() < 0) {
                            factLine.setAmtSource(dLine.getC_Currency_ID(), null, dl.getAmt().abs());
                        } else {
                            factLine.setAmtSource(dLine.getC_Currency_ID(), dl.getAmt(), null);
                        }
                        factLine.setQty(dl.getQty());
                        factLine.convert();
                        String description = String.valueOf(distribution.getName()) + " #" + dl.getLine();
                        if (dl.getDescription() != null) {
                            description = String.valueOf(description) + " - " + dl.getDescription();
                        }
                        factLine.addDescription(description);
                        this.log.info(factLine.toString());
                        newLines.add(factLine);
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < newLines.size()) {
            this.m_lines.add((FactLine)newLines.get(i));
            ++i;
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Fact[");
        sb.append(this.m_doc.toString());
        sb.append(",").append(this.m_acctSchema.toString());
        sb.append(",PostType=").append(this.m_postingType);
        sb.append("]");
        return sb.toString();
    }

    public FactLine[] getLines() {
        FactLine[] temp = new FactLine[this.m_lines.size()];
        this.m_lines.toArray(temp);
        return temp;
    }

    public boolean save(String trxName) {
        this.m_trxName = trxName;
        int i = 0;
        while (i < this.m_lines.size()) {
            FactLine fl = this.m_lines.get(i);
            if (!fl.save(trxName)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String get_TrxName() {
        return this.m_trxName;
    }

    private void set_TrxName(String trxName) {
        this.m_trxName = trxName;
    }

    public class Balance {
        public BigDecimal DR = Env.ZERO;
        public BigDecimal CR = Env.ZERO;

        public Balance(BigDecimal dr, BigDecimal cr) {
            this.DR = dr;
            this.CR = cr;
        }

        public void add(BigDecimal dr, BigDecimal cr) {
            this.DR = this.DR.add(dr);
            this.CR = this.CR.add(cr);
        }

        public BigDecimal getBalance() {
            return this.DR.subtract(this.CR);
        }

        public BigDecimal getPostBalance() {
            BigDecimal bd = this.getBalance().abs();
            if (this.isReversal()) {
                return bd.negate();
            }
            return bd;
        }

        public boolean isZeroBalance() {
            return this.getBalance().signum() == 0;
        }

        public boolean isReversal() {
            return this.DR.signum() <= 0 && this.CR.signum() <= 0;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("Balance[");
            sb.append("DR=").append(this.DR).append("-CR=").append(this.CR).append(" = ").append(this.getBalance()).append("]");
            return sb.toString();
        }
    }
}

