/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.Fact;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MTimeExpense;
import org.compiere.model.MTimeExpenseLine;
import org.compiere.model.MUOMConversion;
import org.compiere.model.Query;
import org.compiere.util.Env;

public class Doc_TimeExpense
extends Doc {
    protected String m_sErrorLoadingLines = null;

    public Doc_TimeExpense(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, MTimeExpense.class, rs, "GLD", trxName);
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        if (this.m_sErrorLoadingLines != null) {
            this.p_Error = this.m_sErrorLoadingLines;
            this.log.log(Level.WARNING, this.p_Error);
            return null;
        }
        ArrayList<Fact> facts = new ArrayList<Fact>();
        Fact fact = new Fact(this, as, "S");
        this.setC_Currency_ID(as.getC_Currency_ID());
        BigDecimal bdTotal = Env.ZERO;
        DocLine[] docLineArray = this.p_lines;
        int n = this.p_lines.length;
        int n2 = 0;
        while (n2 < n) {
            DocLine docLine = docLineArray[n2];
            BigDecimal bdAmount = docLine.getAmtSourceCr();
            if (bdAmount.signum() == 0) {
                bdAmount = docLine.getProductCosts(as, docLine.getAD_Org_ID(), false);
            }
            if (bdAmount == null || bdAmount.signum() == 0) {
                this.p_Error = "No Costs for " + docLine.getProduct().getName();
                this.log.log(Level.WARNING, this.p_Error);
                return null;
            }
            fact.createLine(docLine, docLine.getAccount(2, as), as.getC_Currency_ID(), bdAmount, null);
            bdTotal = bdTotal.add(bdAmount);
            ++n2;
        }
        fact.createLine(null, this.getAccount(2, as), this.getC_Currency_ID(), null, bdTotal);
        facts.add(fact);
        return facts;
    }

    @Override
    public BigDecimal getBalance() {
        return Env.ZERO;
    }

    @Override
    protected String loadDocumentDetails() {
        MTimeExpense timeExpense = (MTimeExpense)this.getPO();
        this.setC_Currency_ID(-2);
        this.setDateDoc(timeExpense.getDateReport());
        this.setDateAcct(timeExpense.getDateReport());
        this.p_lines = this.loadLines(timeExpense);
        this.log.fine("Lines=" + this.p_lines.length);
        return null;
    }

    private DocLine[] loadLines(MTimeExpense te) {
        ArrayList<DocLine> lstLines = new ArrayList<DocLine>();
        Query qTimeExpenseLines = new Query(this.getCtx(), "S_TimeExpenseLine", "S_TimeExpense_ID = ?", this.getTrxName());
        qTimeExpenseLines.setOnlyActiveRecords(true);
        qTimeExpenseLines.setParameters(te.getS_TimeExpense_ID());
        List lstTimeExpenseLines = qTimeExpenseLines.list();
        for (MTimeExpenseLine line : lstTimeExpenseLines) {
            BigDecimal bdRate;
            BigDecimal qty;
            DocLine docLine = new DocLine(line, this);
            if (line.getM_Product_ID() < 1) {
                this.m_sErrorLoadingLines = "@F3P_Error_MissingProduct@: " + te.getDocumentNo() + "(" + docLine.getLine() + ")";
                continue;
            }
            docLine.setDateAcct(line.getDateExpense());
            docLine.setDateDoc(line.getDateExpense());
            BigDecimal bdAmount = line.getConvertedAmt();
            if (line.isTimeReport() || bdAmount == null) {
                bdAmount = Env.ZERO;
            }
            if ((qty = line.getQty()).signum() == 0) {
                qty = BigDecimal.ONE;
            }
            if ((bdRate = MUOMConversion.getProductRateFrom(this.getCtx(), line.getM_Product_ID(), line.getC_UOM_ID())) == null) {
                MProduct mProduct = MProduct.get(this.getCtx(), line.getM_Product_ID());
                bdRate = MUOMConversion.getRate(line.getC_UOM_ID(), mProduct.getC_UOM_ID());
                if (bdRate == null) {
                    this.m_sErrorLoadingLines = "@NoUOMConversion@ " + docLine.getProduct().getName();
                    break;
                }
            }
            if (bdAmount.signum() != 0) {
                bdAmount = qty.multiply(line.getConvertedAmt());
            } else {
                qty = qty.multiply(bdRate);
            }
            docLine.setQty(qty, false);
            docLine.setAmount(Env.ZERO, bdAmount);
            MPeriod period = MPeriod.get(this.getCtx(), docLine.getDateAcct(), line.getAD_Org_ID());
            if (period != null && period.isOpen("CMB", docLine.getDateAcct())) {
                docLine.setC_Period_ID(period.getC_Period_ID());
            }
            lstLines.add(docLine);
        }
        DocLine[] dls = new DocLine[lstLines.size()];
        lstLines.toArray(dls);
        return dls;
    }
}

