/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCostDetail;
import org.compiere.model.X_M_Production;
import org.compiere.model.X_M_ProductionLine;
import org.compiere.model.X_M_ProductionPlan;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class Doc_Production
extends Doc {
    public Doc_Production(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, X_M_Production.class, rs, "MMP", trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        this.setC_Currency_ID(-2);
        X_M_Production prod = (X_M_Production)this.getPO();
        this.setDateDoc(prod.getMovementDate());
        this.setDateAcct(prod.getMovementDate());
        this.p_lines = this.loadLines(prod);
        this.log.fine("Lines=" + this.p_lines.length);
        return null;
    }

    private DocLine[] loadLines(X_M_Production prod) {
        ArrayList<DocLine> list = new ArrayList<DocLine>();
        String sqlPP = "SELECT * FROM M_ProductionPlan pp WHERE pp.M_Production_ID=? ORDER BY pp.Line";
        String sqlPL = "SELECT * FROM M_ProductionLine pl WHERE pl.M_ProductionPlan_ID=? ORDER BY pl.Line";
        try {
            CPreparedStatement pstmtPP = DB.prepareStatement(sqlPP, this.getTrxName());
            pstmtPP.setInt(1, this.get_ID());
            ResultSet rsPP = pstmtPP.executeQuery();
            while (rsPP.next()) {
                int M_Product_ID = rsPP.getInt("M_Product_ID");
                int M_ProductionPlan_ID = rsPP.getInt("M_ProductionPlan_ID");
                try {
                    CPreparedStatement pstmtPL = DB.prepareStatement(sqlPL, this.getTrxName());
                    pstmtPL.setInt(1, M_ProductionPlan_ID);
                    ResultSet rsPL = pstmtPL.executeQuery();
                    while (rsPL.next()) {
                        X_M_ProductionLine line = new X_M_ProductionLine(this.getCtx(), rsPL, this.getTrxName());
                        if (line.getMovementQty().signum() == 0) {
                            this.log.info("LineQty=0 - " + line);
                            continue;
                        }
                        DocLine docLine = new DocLine(line, this);
                        docLine.setQty(line.getMovementQty(), false);
                        docLine.setProductionBOM(line.getM_Product_ID() == M_Product_ID);
                        this.log.fine(docLine.toString());
                        list.add(docLine);
                    }
                    rsPL.close();
                    pstmtPL.close();
                }
                catch (Exception ee) {
                    this.log.log(Level.SEVERE, sqlPL, ee);
                }
            }
            rsPP.close();
            pstmtPP.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sqlPP, e);
        }
        DocLine[] dl = new DocLine[list.size()];
        list.toArray(dl);
        return dl;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        return retValue;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        Fact fact = new Fact(this, as, "A");
        this.setC_Currency_ID(as.getC_Currency_ID());
        FactLine fl = null;
        for (int i = 0; i < this.p_lines.length; ++i) {
            DocLine line = this.p_lines[i];
            BigDecimal costs = null;
            MCostDetail cd = MCostDetail.get(as.getCtx(), "M_ProductionLine_ID=?", line.get_ID(), line.getM_AttributeSetInstance_ID(), as.getC_AcctSchema_ID(), this.getTrxName());
            if (cd != null) {
                costs = cd.getAmt();
            } else if (line.isProductionBOM()) {
                BigDecimal bomCost = Env.ZERO;
                for (int ii = 0; ii < this.p_lines.length; ++ii) {
                    DocLine line0 = this.p_lines[ii];
                    if (line0.getM_ProductionPlan_ID() != line.getM_ProductionPlan_ID() || line0.isProductionBOM()) continue;
                    bomCost = bomCost.add(line0.getProductCosts(as, line.getAD_Org_ID(), false));
                }
                costs = bomCost.negate();
                X_M_ProductionPlan mpp = new X_M_ProductionPlan(this.getCtx(), line.getM_ProductionPlan_ID(), this.getTrxName());
                if (line.getQty() != mpp.getProductionQty()) {
                    costs = costs.multiply(line.getQty());
                    costs = costs.divide(mpp.getProductionQty(), as.getCostingPrecision(), 4);
                }
            } else {
                costs = line.getProductCosts(as, line.getAD_Org_ID(), false);
            }
            fl = fact.createLine(line, line.getAccount(3, as), as.getC_Currency_ID(), costs);
            if (fl == null) {
                this.p_Error = "No Costs for Line " + line.getLine() + " - " + line;
                return null;
            }
            fl.setM_Locator_ID(line.getM_Locator_ID());
            fl.setQty(line.getQty());
            String description = line.getDescription();
            if (description == null) {
                description = "";
            }
            if (line.isProductionBOM()) {
                description = description + "(*)";
            }
            MCostDetail.createProduction(as, line.getAD_Org_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.get_ID(), 0, costs, line.getQty(), description, this.getTrxName());
        }
        ArrayList<Fact> facts = new ArrayList<Fact>();
        facts.add(fact);
        return facts;
    }
}

