/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.DocLine_CostCollector;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCostElement;
import org.compiere.model.MProduct;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.eevolution.model.MPPCostCollector;
import org.eevolution.model.RoutingService;
import org.eevolution.model.RoutingServiceFactory;

public class Doc_PPCostCollector
extends Doc {
    protected DocLine_CostCollector m_line = null;
    protected MPPCostCollector m_cc = null;
    protected RoutingService m_routingService = null;
    private List<MCostDetail> m_costDetails = null;

    public Doc_PPCostCollector(MAcctSchema[] mAcctSchemaArray, ResultSet resultSet, String string) {
        super(mAcctSchemaArray, MPPCostCollector.class, resultSet, "MCC", string);
    }

    @Override
    protected String loadDocumentDetails() {
        this.setC_Currency_ID(-2);
        this.m_cc = (MPPCostCollector)this.getPO();
        this.setDateDoc(this.m_cc.getMovementDate());
        this.setDateAcct(this.m_cc.getMovementDate());
        this.m_line = new DocLine_CostCollector(this.m_cc, this);
        this.m_line.setQty(this.m_cc.getMovementQty(), false);
        if (this.m_line.getM_Product_ID() == 0) {
            this.log.warning(this.m_line.toString() + " - No Product");
        }
        this.log.fine(this.m_line.toString());
        this.m_routingService = RoutingServiceFactory.get().getRoutingService(this.m_cc.getAD_Client_ID());
        return null;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal bigDecimal = Env.ZERO;
        return bigDecimal;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema mAcctSchema) {
        this.setC_Currency_ID(mAcctSchema.getC_Currency_ID());
        ArrayList<Fact> arrayList = new ArrayList<Fact>();
        if ("100".equals(this.m_cc.getCostCollectorType())) {
            arrayList.add(this.createMaterialReceipt(mAcctSchema));
        } else if ("110".equals(this.m_cc.getCostCollectorType())) {
            arrayList.add(this.createComponentIssue(mAcctSchema));
        } else if ("130".equals(this.m_cc.getCostCollectorType())) {
            arrayList.add(this.createVariance(mAcctSchema, 12));
        } else if ("120".equals(this.m_cc.getCostCollectorType())) {
            arrayList.add(this.createVariance(mAcctSchema, 13));
        } else if ("120".equals(this.m_cc.getCostCollectorType())) {
            arrayList.add(this.createVariance(mAcctSchema, 13));
        } else if ("140".equals(this.m_cc.getCostCollectorType())) {
            arrayList.add(this.createVariance(mAcctSchema, 14));
        } else if ("150".equals(this.m_cc.getCostCollectorType())) {
            arrayList.add(this.createVariance(mAcctSchema, 15));
        } else if ("160".equals(this.m_cc.getCostCollectorType())) {
            arrayList.addAll(this.createActivityControl(mAcctSchema));
        }
        return arrayList;
    }

    protected void createLines(MCostElement mCostElement, MAcctSchema mAcctSchema, Fact fact, MProduct mProduct, MAccount mAccount, MAccount mAccount2, BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        if (bigDecimal == null || mAccount == null || mAccount2 == null) {
            return;
        }
        this.log.info("CostElement: " + mCostElement + "Product: " + mProduct.getName() + " Debit: " + mAccount.getDescription() + " Credit: " + mAccount2.getDescription() + " Cost: " + bigDecimal + " Qty: " + bigDecimal2);
        FactLine factLine = null;
        FactLine factLine2 = null;
        if (bigDecimal.signum() != 0) {
            factLine = fact.createLine((DocLine)this.m_line, mAccount, mAcctSchema.getC_Currency_ID(), bigDecimal, null);
            factLine.setQty(bigDecimal2);
            String string = mCostElement.getName();
            factLine.addDescription(string);
            factLine.setC_Project_ID(this.m_cc.getC_Project_ID());
            factLine.setC_Activity_ID(this.m_cc.getC_Activity_ID());
            factLine.setC_Campaign_ID(this.m_cc.getC_Campaign_ID());
            factLine.setM_Locator_ID(this.m_cc.getM_Locator_ID());
            factLine2 = fact.createLine((DocLine)this.m_line, mAccount2, mAcctSchema.getC_Currency_ID(), null, bigDecimal);
            factLine2.setQty(bigDecimal2);
            factLine2.addDescription(string);
            factLine2.setC_Project_ID(this.m_cc.getC_Project_ID());
            factLine2.setC_Activity_ID(this.m_cc.getC_Activity_ID());
            factLine2.setC_Campaign_ID(this.m_cc.getC_Campaign_ID());
            factLine2.setM_Locator_ID(this.m_cc.getM_Locator_ID());
        }
    }

    protected Fact createMaterialReceipt(MAcctSchema mAcctSchema) {
        Fact fact = new Fact(this, mAcctSchema, "A");
        MProduct mProduct = this.m_cc.getM_Product();
        MAccount mAccount = this.m_line.getAccount(11, mAcctSchema);
        for (MCostDetail mCostDetail : this.getCostDetails()) {
            BigDecimal bigDecimal;
            MAccount mAccount2;
            MCostElement mCostElement = MCostElement.get(this.getCtx(), mCostDetail.getM_CostElement_ID());
            if (this.m_cc.getMovementQty().signum() != 0) {
                mAccount2 = this.m_line.getAccount(3, mAcctSchema);
                bigDecimal = mCostDetail.getAmt();
                if (bigDecimal.scale() > mAcctSchema.getStdPrecision()) {
                    bigDecimal = bigDecimal.setScale(mAcctSchema.getStdPrecision(), RoundingMode.HALF_UP);
                }
                this.createLines(mCostElement, mAcctSchema, fact, mProduct, mAccount2, mAccount, bigDecimal, this.m_cc.getMovementQty());
            }
            if (this.m_cc.getScrappedQty().signum() == 0) continue;
            mAccount2 = this.m_line.getAccount(22, mAcctSchema);
            bigDecimal = mCostDetail.getPrice().multiply(this.m_cc.getScrappedQty());
            if (bigDecimal.scale() > mAcctSchema.getStdPrecision()) {
                bigDecimal = bigDecimal.setScale(mAcctSchema.getStdPrecision(), RoundingMode.HALF_UP);
            }
            this.createLines(mCostElement, mAcctSchema, fact, mProduct, mAccount2, mAccount, bigDecimal, this.m_cc.getScrappedQty());
        }
        return fact;
    }

    protected Fact createComponentIssue(MAcctSchema mAcctSchema) {
        Fact fact = new Fact(this, mAcctSchema, "A");
        MProduct mProduct = this.m_cc.getM_Product();
        MAccount mAccount = this.m_line.getAccount(11, mAcctSchema);
        MAccount mAccount2 = this.m_line.getAccount(3, mAcctSchema);
        if (this.m_cc.isFloorStock()) {
            mAccount2 = this.m_line.getAccount(16, mAcctSchema);
        }
        for (MCostDetail mCostDetail : this.getCostDetails()) {
            MCostElement mCostElement = MCostElement.get(this.getCtx(), mCostDetail.getM_CostElement_ID());
            BigDecimal bigDecimal = mCostDetail.getAmt().negate();
            if (bigDecimal.scale() > mAcctSchema.getStdPrecision()) {
                bigDecimal = bigDecimal.setScale(mAcctSchema.getStdPrecision(), RoundingMode.HALF_UP);
            }
            this.createLines(mCostElement, mAcctSchema, fact, mProduct, mAccount, mAccount2, bigDecimal, this.m_cc.getMovementQty());
        }
        return fact;
    }

    protected List<Fact> createActivityControl(MAcctSchema mAcctSchema) {
        ArrayList<Fact> arrayList = new ArrayList<Fact>();
        Fact fact = new Fact(this, mAcctSchema, "A");
        arrayList.add(fact);
        MProduct mProduct = this.m_cc.getM_Product();
        MAccount mAccount = this.m_line.getAccount(11, mAcctSchema);
        for (MCostDetail mCostDetail : this.getCostDetails()) {
            BigDecimal bigDecimal = mCostDetail.getAmt();
            if (bigDecimal.signum() == 0) continue;
            MCostElement mCostElement = MCostElement.get(this.getCtx(), mCostDetail.getM_CostElement_ID());
            MAccount mAccount2 = this.m_line.getAccount(mAcctSchema, mCostElement);
            this.createLines(mCostElement, mAcctSchema, fact, mProduct, mAccount, mAccount2, bigDecimal, this.m_cc.getMovementQty());
        }
        return arrayList;
    }

    protected Fact createVariance(MAcctSchema mAcctSchema, int n) {
        Fact fact = new Fact(this, mAcctSchema, "A");
        MProduct mProduct = this.m_cc.getM_Product();
        MAccount mAccount = this.m_line.getAccount(n, mAcctSchema);
        MAccount mAccount2 = this.m_line.getAccount(11, mAcctSchema);
        for (MCostDetail mCostDetail : this.getCostDetails()) {
            MCostElement mCostElement = MCostElement.get(this.getCtx(), mCostDetail.getM_CostElement_ID());
            BigDecimal bigDecimal = mCostDetail.getAmt().negate();
            if (bigDecimal.scale() > mAcctSchema.getStdPrecision()) {
                bigDecimal = bigDecimal.setScale(mAcctSchema.getStdPrecision(), RoundingMode.HALF_UP);
            }
            BigDecimal bigDecimal2 = mCostDetail.getQty().negate();
            this.createLines(mCostElement, mAcctSchema, fact, mProduct, mAccount, mAccount2, bigDecimal, bigDecimal2);
        }
        return fact;
    }

    public Collection<MCostElement> getCostElements() {
        List<MCostElement> list = MCostElement.getByCostingMethod(this.getCtx(), "S");
        return list;
    }

    protected static final MProduct getProductForResource(Properties properties, int n, String string) {
        int n2 = new Query(properties, "M_Product", "S_Resource_ID=?", string).setParameters(n).firstIdOnly();
        return MProduct.get(properties, n2);
    }

    private List<MCostDetail> getCostDetails() {
        if (this.m_costDetails == null) {
            String string = "PP_Cost_Collector_ID=?";
            this.m_costDetails = new Query(this.getCtx(), "M_CostDetail", string, this.getTrxName()).setParameters(this.m_cc.getPP_Cost_Collector_ID()).setOrderBy("M_CostDetail_ID").list();
        }
        return this.m_costDetails;
    }
}

