/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import org.compiere.acct.AssetFactUtil;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.acct.FactUtil;
import org.compiere.model.I_A_Asset;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MDepreciationEntry;
import org.compiere.model.MDepreciationExp;
import org.compiere.util.Env;

public class Doc_DepreciationEntry
extends Doc {
    private String m_PostingType = null;
    private int m_C_AcctSchema_ID = 0;

    public Doc_DepreciationEntry(MAcctSchema[] as, ResultSet rs, String trxName) {
        super(as, MDepreciationEntry.class, rs, null, trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        MDepreciationEntry entry = (MDepreciationEntry)this.getPO();
        this.m_PostingType = entry.getPostingType();
        this.m_C_AcctSchema_ID = entry.getC_AcctSchema_ID();
        return null;
    }

    private DocLine createLine(MDepreciationExp depexp) {
        if (!depexp.isProcessed()) {
            return null;
        }
        DocLine docLine = new DocLine(depexp, this);
        return docLine;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        return retValue;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        ArrayList<Fact> facts = new ArrayList<Fact>();
        if (as.getC_AcctSchema_ID() != this.m_C_AcctSchema_ID) {
            return facts;
        }
        Fact fact = new Fact(this, as, this.m_PostingType);
        this.setC_Currency_ID(as.getC_Currency_ID());
        MDepreciationEntry entry = (MDepreciationEntry)this.getPO();
        Iterator<MDepreciationExp> it = entry.getLinesIterator(false);
        while (it.hasNext()) {
            MDepreciationExp depexp = it.next();
            DocLine line = this.createLine(depexp);
            BigDecimal expenseAmt = depexp.getExpense();
            MAccount dr_acct = MAccount.get(this.getCtx(), depexp.getDR_Account_ID());
            MAccount cr_acct = MAccount.get(this.getCtx(), depexp.getCR_Account_ID());
            I_A_Asset asset = depexp.getA_Asset();
            FactLine[] factLine = FactUtil.createSimpleOperation(fact, line, dr_acct, cr_acct, as.getC_Currency_ID(), expenseAmt, false);
            AssetFactUtil.setFactLineDimensions(factLine[0], asset);
            AssetFactUtil.setFactLineDimensions(factLine[1], asset);
        }
        facts.add(fact);
        return facts;
    }
}

