/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import org.compiere.acct.AssetFactUtil;
import org.compiere.acct.Doc;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.acct.FactUtil;
import org.compiere.model.I_A_Asset;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAssetTransfer;
import org.compiere.model.MDepreciationWorkfile;
import org.compiere.util.Env;

public class Doc_AssetTransfer
extends Doc {
    public Doc_AssetTransfer(MAcctSchema[] as, ResultSet rs, String trxName) {
        super(as, MAssetTransfer.class, rs, "GLJ", trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        return null;
    }

    @Override
    public BigDecimal getBalance() {
        return Env.ZERO;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        FactLine[] lines;
        MAssetTransfer assetTr = this.getAssetTransfer();
        MDepreciationWorkfile wk = this.getAssetWorkfile();
        I_A_Asset asset = assetTr.getA_Asset();
        ArrayList<Fact> facts = new ArrayList<Fact>();
        Fact fact = new Fact(this, as, assetTr.getPostingType());
        facts.add(fact);
        this.setC_Currency_ID(as.getC_Currency_ID());
        if (assetTr.getA_Asset_New_Acct() != assetTr.getA_Asset_Acct()) {
            MAccount dr = MAccount.get(this.getCtx(), assetTr.getA_Asset_New_Acct());
            MAccount cr = MAccount.get(this.getCtx(), assetTr.getA_Asset_Acct());
            lines = FactUtil.createSimpleOperation(fact, null, dr, cr, as.getC_Currency_ID(), wk.getA_Asset_Cost(), false);
            AssetFactUtil.setFactLineDimensions(lines[0], asset);
            AssetFactUtil.setFactLineDimensions(lines[1], asset);
        }
        if (assetTr.getA_Accumdepreciation_New_Acct() != assetTr.getA_Accumdepreciation_Acct()) {
            MAccount cr = MAccount.get(this.getCtx(), assetTr.getA_Accumdepreciation_New_Acct());
            MAccount dr = MAccount.get(this.getCtx(), assetTr.getA_Accumdepreciation_Acct());
            lines = FactUtil.createSimpleOperation(fact, null, dr, cr, as.getC_Currency_ID(), wk.getA_Accumulated_Depr(), false);
            AssetFactUtil.setFactLineDimensions(lines[0], asset);
            AssetFactUtil.setFactLineDimensions(lines[1], asset);
        }
        return facts;
    }

    private MAssetTransfer getAssetTransfer() {
        return (MAssetTransfer)this.getPO();
    }

    private MDepreciationWorkfile getAssetWorkfile() {
        MAssetTransfer assetTr = this.getAssetTransfer();
        return MDepreciationWorkfile.get(this.getCtx(), assetTr.getA_Asset_ID(), assetTr.getPostingType(), this.getTrxName());
    }
}

