/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.compiere.acct.AssetFactUtil;
import org.compiere.acct.Doc;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.I_A_Asset;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAsset;
import org.compiere.model.MAssetMovement;
import org.compiere.model.MAssetType;
import org.compiere.model.MDepreciationWorkfile;
import org.compiere.model.MLocation;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class Doc_AssetMovement
extends Doc {
    private MAsset m_asset = null;
    private MAssetMovement m_aMovement = null;
    private MAssetType m_aType = null;
    private MAccount m_assetAcct = null;

    public Doc_AssetMovement(MAcctSchema[] as, ResultSet rs, String trxName) {
        super(as, MAssetMovement.class, rs, "GLD", trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        this.m_aMovement = (MAssetMovement)this.getPO();
        this.m_asset = MAsset.get(this.getCtx(), this.m_aMovement.getA_Asset_ID(), this.getTrxName());
        this.m_aType = MAssetType.get(this.getCtx(), this.m_asset.getA_Asset_Type_ID());
        return null;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        ArrayList<Fact> facts = new ArrayList<Fact>();
        Fact fact = new Fact(this, as, "A");
        this.setC_Currency_ID(as.getC_Currency_ID());
        if (this.m_aType.isFixedAsset()) {
            facts.add(fact);
            return facts;
        }
        if (!this.m_aMovement.isLocationChanged()) {
            facts.add(fact);
            return facts;
        }
        BigDecimal amt = this.getAssetValue();
        MAccount assetAcct = this.getAssetAcct();
        FactLine dr = fact.createLine(null, assetAcct, as.getC_Currency_ID(), amt, null);
        dr.setA_Asset_ID(this.getA_Asset_ID());
        dr.setC_Activity_ID(this.m_aMovement.getC_Activity_ID());
        if (this.m_aMovement.isInPosession()) {
            dr.setM_Locator_ID(this.m_aMovement.getM_LocatorTo_ID());
            dr.setC_BPartner_ID(this.m_aMovement.getC_BPartnerSR_ID());
        } else {
            dr.setC_BPartner_ID(this.m_aMovement.getC_BPartner_ID());
            MLocation loc = MLocation.getBPLocation(this.getCtx(), this.m_aMovement.getC_BPartner_Location_ID(), null);
            if (loc != null) {
                dr.setC_LocTo_ID(loc.getC_Location_ID());
            }
        }
        FactLine cr = fact.createLine(null, assetAcct, as.getC_Currency_ID(), null, amt);
        cr.setA_Asset_ID(this.getA_Asset_ID());
        cr.setC_Activity_ID(this.m_aMovement.getC_Activity2_ID());
        if (this.m_aMovement.isInPosession2()) {
            cr.setM_Locator_ID(this.m_aMovement.getM_Locator_ID());
            cr.setC_BPartner_ID(this.m_aMovement.getC_BPartnerSR2_ID());
        } else {
            cr.setC_BPartner_ID(this.m_aMovement.getC_BPartner2_ID());
            MLocation loc = MLocation.getBPLocation(this.getCtx(), this.m_aMovement.getC_BPartner_Location2_ID(), null);
            if (loc != null) {
                cr.setC_LocFrom_ID(loc.getC_Location_ID());
            }
        }
        I_A_Asset asset = this.m_aMovement.getA_Asset();
        AssetFactUtil.setFactLineDimensions(dr, asset);
        AssetFactUtil.setFactLineDimensions(cr, asset);
        facts.add(fact);
        return facts;
    }

    @Override
    public BigDecimal getBalance() {
        return Env.ZERO;
    }

    public MAccount getAssetAcct() {
        if (this.m_assetAcct != null) {
            return this.m_assetAcct;
        }
        String sql = "select A_Asset_Acct from A_Asset_Acct where A_Asset_ID=? and PostingType=" + DB.TO_STRING("A");
        int acctID = DB.getSQLValueEx(null, sql, this.m_aMovement.getA_Asset_ID());
        if (acctID <= 0) {
            return null;
        }
        this.m_assetAcct = MAccount.get(this.getCtx(), acctID);
        return this.m_assetAcct;
    }

    @Override
    public int getM_Product_ID() {
        return this.m_asset.getM_Product_ID();
    }

    @Override
    public BigDecimal getQty() {
        return this.m_asset.getQty();
    }

    @Override
    public String getDocumentNo() {
        if (this.m_aMovement != null) {
            return "" + this.m_aMovement.get_ID();
        }
        return "";
    }

    @Override
    public Timestamp getDateAcct() {
        return this.m_aMovement.getDateDoc();
    }

    public int getA_Asset_ID() {
        return this.m_aMovement.getA_Asset_ID();
    }

    public BigDecimal getAssetValue() {
        MDepreciationWorkfile wk = MDepreciationWorkfile.get(this.getCtx(), this.getA_Asset_ID(), "A");
        BigDecimal costs = wk.getA_Asset_Cost();
        return costs;
    }
}

