/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import org.compiere.acct.AssetFactUtil;
import org.compiere.acct.Doc;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.I_A_Asset;
import org.compiere.model.I_C_Invoice;
import org.compiere.model.I_C_InvoiceLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAssetAcct;
import org.compiere.model.MAssetDisposed;
import org.compiere.util.Env;

public class Doc_AssetDisposed
extends Doc {
    public Doc_AssetDisposed(MAcctSchema[] as, ResultSet rs, String trxName) {
        super(as, MAssetDisposed.class, rs, "GLD", trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        return null;
    }

    @Override
    public BigDecimal getBalance() {
        return Env.ZERO;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        MAssetDisposed assetDisp = (MAssetDisposed)this.getPO();
        ArrayList<Fact> facts = new ArrayList<Fact>();
        Fact fact = new Fact(this, as, assetDisp.getPostingType());
        facts.add(fact);
        this.setC_Currency_ID(as.getC_Currency_ID());
        I_A_Asset asset = assetDisp.getA_Asset();
        FactLine line1 = fact.createLine(null, this.getAccount("A_Asset_Acct"), as.getC_Currency_ID(), Env.ZERO, assetDisp.getA_Disposal_Amt());
        FactLine line2 = fact.createLine(null, this.getAccount("A_Accumdepreciation_Acct"), as.getC_Currency_ID(), assetDisp.getA_Accumulated_Depr_Delta(), Env.ZERO);
        I_C_InvoiceLine invoiceLine = null;
        I_C_Invoice invoice = null;
        if (assetDisp.getC_InvoiceLine_ID() > 0) {
            invoiceLine = assetDisp.getC_InvoiceLine();
            invoice = invoiceLine.getC_Invoice();
        }
        FactLine line3 = null;
        line3 = assetDisp.getExpense().signum() >= 0 ? fact.createLine(null, this.getAccount("A_Disposal_Loss_Acct"), as.getC_Currency_ID(), assetDisp.getExpense(), Env.ZERO) : fact.createLine(null, this.getAccount("A_Disposal_Revenue_Acct"), as.getC_Currency_ID(), Env.ZERO, assetDisp.getExpense().abs());
        if (asset.getM_Product_ID() > 0) {
            BigDecimal bdProdRev = assetDisp.getA_Disposal_Amt().subtract(assetDisp.getExpense()).subtract(assetDisp.getA_Accumulated_Depr_Delta());
            MAccount mProdRevenueAcct = MAssetAcct.forA_Asset_ID(this.getCtx(), assetDisp.getA_Asset_ID(), assetDisp.getPostingType(), assetDisp.getDateAcct(), null).getP_Revenue_Acct(asset.getM_Product_ID());
            FactLine line4 = fact.createLine(null, mProdRevenueAcct, as.getC_Currency_ID(), bdProdRev, Env.ZERO);
            if (invoice != null) {
                AssetFactUtil.setFactLineDimensions(line4, invoice, invoiceLine);
            } else {
                AssetFactUtil.setFactLineDimensions(line4, asset);
            }
        }
        AssetFactUtil.setFactLineDimensions(line1, asset);
        AssetFactUtil.setFactLineDimensions(line2, asset);
        if (invoice != null) {
            AssetFactUtil.setFactLineDimensions(line3, invoice, invoiceLine);
        } else {
            AssetFactUtil.setFactLineDimensions(line3, asset);
        }
        return facts;
    }

    private MAccount getAccount(String accountName) {
        MAssetDisposed assetDisp = (MAssetDisposed)this.getPO();
        MAssetAcct assetAcct = MAssetAcct.forA_Asset_ID(this.getCtx(), assetDisp.getA_Asset_ID(), assetDisp.getPostingType(), assetDisp.getDateAcct(), null);
        int account_id = (Integer)assetAcct.get_Value(accountName);
        return MAccount.get(this.getCtx(), account_id);
    }
}

