/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.compiere.acct.AssetFactUtil;
import org.compiere.acct.Doc;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.acct.FactUtil;
import org.compiere.model.I_C_InvoiceLine;
import org.compiere.model.I_C_Project;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAssetAcct;
import org.compiere.model.MAssetAddition;
import org.compiere.model.MCharge;
import org.compiere.model.MCurrency;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class Doc_AssetAddition
extends Doc {
    protected static final String F3P_TAX_INFO = "select C_Tax.issalestax, C_Tax.rate, C_Tax_Acct.T_EXPENSE_ACCT  from C_Tax, C_Tax_Acct  where C_Tax.C_Tax_ID = ?  and C_Tax.issummary = 'N'  and C_Tax.issalestax = 'Y'  and C_Tax_Acct.C_Tax_ID = C_Tax.C_Tax_ID  and C_Tax_Acct.C_AcctSchema_ID = ?  union all  select C_Tax.issalestax, C_Tax.rate as rate, C_Tax_Acct.T_EXPENSE_ACCT  from C_Tax, C_Tax_Acct  where C_Tax.Parent_Tax_ID = ?  and C_Tax.isactive = 'Y'  and C_Tax.issalestax = 'Y'  and C_Tax_Acct.C_Tax_ID = C_Tax.C_Tax_ID  and C_Tax_Acct.C_AcctSchema_ID = ? ";

    public Doc_AssetAddition(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, MAssetAddition.class, rs, "GLD", trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        return null;
    }

    @Override
    public BigDecimal getBalance() {
        return Env.ZERO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        MAssetAddition assetAdd = this.getAssetAddition();
        ArrayList<Fact> facts = new ArrayList<Fact>();
        Fact fact = new Fact(this, as, assetAdd.getPostingType());
        facts.add(fact);
        this.setC_Currency_ID(as.getC_Currency_ID());
        if ("IMP".equals(assetAdd.getA_SourceType())) {
            return facts;
        }
        int iPrecision = MCurrency.getStdPrecision(as.getCtx(), as.getC_Currency_ID());
        BigDecimal bdConvRate = assetAdd.getCurrencyRate();
        BigDecimal bdEnteredAmt = assetAdd.getAssetAmtEntered().multiply(bdConvRate);
        FactLine[] fls = FactUtil.createSimpleOperation(fact, null, this.getA_Asset_Acct(), this.getP_Asset_Acct(as), as.getC_Currency_ID(), bdEnteredAmt.setScale(iPrecision, 4), false);
        AssetFactUtil.setFactLinesDimensions(fls, assetAdd, true);
        if ("INV".equals(assetAdd.getA_SourceType()) && assetAdd.getC_Invoice_ID() > 0 && assetAdd.getC_InvoiceLine_ID() > 0) {
            I_C_InvoiceLine invoiceLine = assetAdd.getC_InvoiceLine();
            CPreparedStatement pstmtTax = DB.prepareStatement(F3P_TAX_INFO, this.getTrxName());
            ResultSet rs = null;
            try {
                pstmtTax.setInt(1, invoiceLine.getC_Tax_ID());
                pstmtTax.setInt(2, as.getC_AcctSchema_ID());
                pstmtTax.setInt(3, invoiceLine.getC_Tax_ID());
                pstmtTax.setInt(4, as.getC_AcctSchema_ID());
                rs = pstmtTax.executeQuery();
                while (rs.next()) {
                    int C_ValidCombination_ID = rs.getInt("T_EXPENSE_ACCT");
                    BigDecimal bdRate = rs.getBigDecimal("rate");
                    BigDecimal bdValue = bdEnteredAmt.multiply(bdRate).divide(Env.ONEHUNDRED);
                    MAccount accountTax = MAccount.get(this.getCtx(), C_ValidCombination_ID);
                    FactLine[] taxFls = FactUtil.createSimpleOperation(fact, null, this.getA_Asset_Acct(), accountTax, as.getC_Currency_ID(), bdValue.setScale(iPrecision, 4), false);
                    AssetFactUtil.setFactLinesDimensions(taxFls, assetAdd, false);
                    taxFls[1].setM_Product_ID(0);
                }
            }
            catch (SQLException e) {
            }
            finally {
                if (pstmtTax != null) {
                    try {
                        pstmtTax.close();
                    }
                    catch (SQLException e) {}
                }
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {}
                }
            }
        }
        return facts;
    }

    private MAssetAddition getAssetAddition() {
        return (MAssetAddition)this.getPO();
    }

    private MAccount getP_Asset_Acct(MAcctSchema as) {
        MAssetAddition assetAdd = this.getAssetAddition();
        MAccount pAssetAcct = null;
        if ("PRJ".equals(assetAdd.getA_SourceType())) {
            I_C_Project prj = assetAdd.getC_Project();
            return this.getProjectAcct(prj, as);
        }
        if ("MAN".equals(assetAdd.getA_SourceType()) && this.getC_Charge_ID() > 0) {
            pAssetAcct = MCharge.getAccount(this.getC_Charge_ID(), as, null);
            return pAssetAcct;
        }
        if ("INV".equals(assetAdd.getA_SourceType()) && assetAdd.getC_InvoiceLine().getC_Project_ID() > 0 && this.isAssetInProjectIssues()) {
            I_C_Project prj = assetAdd.getC_InvoiceLine().getC_Project();
            return this.getProjectAcct(prj, as);
        }
        pAssetAcct = MAssetAcct.forA_Asset_ID(this.getCtx(), assetAdd.getA_Asset_ID(), assetAdd.getPostingType(), assetAdd.getDateAcct(), null).getP_Asset_Acct(assetAdd.getM_Product_ID());
        return pAssetAcct;
    }

    private MAccount getProjectAcct(I_C_Project prj, MAcctSchema as) {
        String projectCategory = prj.getProjectCategory();
        String acctName = "PJ_WIP_Acct";
        if ("A".equals(projectCategory)) {
            acctName = "PJ_Asset_Acct";
        }
        String sql = "SELECT " + acctName + " FROM " + "C_Project_Acct" + " WHERE " + "C_Project_ID" + "=?" + " AND " + "C_AcctSchema_ID" + "=?";
        int acct_id = DB.getSQLValueEx(this.getTrxName(), sql, prj.getC_Project_ID(), as.get_ID());
        return MAccount.get(this.getCtx(), acct_id);
    }

    private MAccount getA_Asset_Acct() {
        MAssetAddition assetAdd = this.getAssetAddition();
        int acct_id = MAssetAcct.forA_Asset_ID(this.getCtx(), assetAdd.getA_Asset_ID(), assetAdd.getPostingType(), assetAdd.getDateAcct(), null).getA_Asset_Acct();
        return MAccount.get(this.getCtx(), acct_id);
    }

    private boolean isAssetInProjectIssues() {
        MAssetAddition assetAdd = this.getAssetAddition();
        int C_PROJECTISSUE_ID = DB.getSQLValue(this.getTrxName(), "SELECT C_PROJECTISSUE_ID FROM C_PROJECTISSUE  WHERE C_PROJECTISSUE.M_INOUTLINE_ID = ? AND ISACTIVE = 'Y'", assetAdd.getM_InOutLine_ID());
        return C_PROJECTISSUE_ID > 0;
    }
}

