/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.util.HashMap;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCostElement;
import org.compiere.model.PO;
import org.compiere.util.DB;

public class DocLine_CostCollector
extends DocLine {
    private static final HashMap<Integer, String> s_acctName = new HashMap();

    public DocLine_CostCollector(PO pO, Doc doc) {
        super(pO, doc);
    }

    public MAccount getAccount(MAcctSchema mAcctSchema, MCostElement mCostElement) {
        int n;
        String string = mCostElement.getCostElementType();
        if ("M".equals(string)) {
            n = 3;
        } else if ("R".equals(string)) {
            n = 18;
        } else if ("B".equals(string)) {
            n = 19;
        } else if ("O".equals(string)) {
            n = 21;
        } else if ("X".equals(string)) {
            n = 20;
        } else {
            throw new AdempiereException("@NotSupported@ " + mCostElement);
        }
        return this.getAccount(n, mAcctSchema);
    }

    @Override
    public MAccount getAccount(int n, MAcctSchema mAcctSchema) {
        String string = s_acctName.get(n);
        if (this.getM_Product_ID() == 0 || string == null) {
            return super.getAccount(n, mAcctSchema);
        }
        return this.getAccount(string, mAcctSchema);
    }

    public MAccount getAccount(String string, MAcctSchema mAcctSchema) {
        String string2 = " SELECT  COALESCE(pa." + string + ",pca." + string + ",asd." + string + ")" + " FROM M_Product p" + " INNER JOIN M_Product_Acct pa ON (pa.M_Product_ID=p.M_Product_ID)" + " INNER JOIN M_Product_Category_Acct pca ON (pca.M_Product_Category_ID=p.M_Product_Category_ID AND pca.C_AcctSchema_ID=pa.C_AcctSchema_ID)" + " INNER JOIN C_AcctSchema_Default asd ON (asd.C_AcctSchema_ID=pa.C_AcctSchema_ID)" + " WHERE pa.M_Product_ID=? AND pa.C_AcctSchema_ID=?";
        int n = DB.getSQLValueEx(null, string2, this.getM_Product_ID(), mAcctSchema.get_ID());
        if (n <= 0) {
            return null;
        }
        return MAccount.get(mAcctSchema.getCtx(), n);
    }

    static {
        s_acctName.put(11, "P_WIP_Acct");
        s_acctName.put(12, "P_MethodChangeVariance_Acct");
        s_acctName.put(13, "P_UsageVariance_Acct");
        s_acctName.put(14, "P_RateVariance_Acct");
        s_acctName.put(15, "P_MixVariance_Acct");
        s_acctName.put(16, "P_FloorStock_Acct");
        s_acctName.put(17, "P_CostOfProduction_Acct");
        s_acctName.put(18, "P_Labor_Acct");
        s_acctName.put(19, "P_Burden_Acct");
        s_acctName.put(20, "P_OutsideProcessing_Acct");
        s_acctName.put(21, "P_Overhead_Acct");
        s_acctName.put(22, "P_Scrap_Acct");
    }
}

