/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import org.compiere.acct.FactLine;
import org.compiere.model.I_A_Asset;
import org.compiere.model.I_C_Invoice;
import org.compiere.model.I_C_InvoiceLine;
import org.compiere.model.MAsset;
import org.compiere.model.MAssetAddition;
import org.compiere.model.PO;

public class AssetFactUtil {
    public static void setFactLineDimensions(FactLine factLine, I_A_Asset asset) {
        if (asset.getC_BPartner_ID() > 0) {
            factLine.setC_BPartner_ID(asset.getC_BPartner_ID());
        }
        if (asset.getC_Project_ID() > 0) {
            factLine.setC_Project_ID(asset.getC_Project_ID());
        }
        if (asset.getC_Activity_ID() > 0) {
            factLine.setC_Activity_ID(asset.getC_Activity_ID());
        }
        if (asset.getM_Product_ID() > 0) {
            factLine.setM_Product_ID(asset.getM_Product_ID());
        }
    }

    public static void setFactLineDimensions(FactLine factLine, I_C_Invoice invoice, I_C_InvoiceLine invoiceLine) {
        if (invoice == null && invoiceLine != null) {
            invoice = invoiceLine.getC_Invoice();
        }
        int C_BPartner_ID = invoice.getC_BPartner_ID();
        int C_Project_ID = AssetFactUtil.fromLineOrInvoice((PO)((Object)invoice), (PO)((Object)invoiceLine), "C_Project_ID");
        int C_Campaign_ID = AssetFactUtil.fromLineOrInvoice((PO)((Object)invoice), (PO)((Object)invoiceLine), "C_Campaign_ID");
        int C_Activity_ID = AssetFactUtil.fromLineOrInvoice((PO)((Object)invoice), (PO)((Object)invoiceLine), "C_Activity_ID");
        int AD_OrgTrx_ID = AssetFactUtil.fromLineOrInvoice((PO)((Object)invoice), (PO)((Object)invoiceLine), "AD_OrgTrx_ID");
        int User1_ID = AssetFactUtil.fromLineOrInvoice((PO)((Object)invoice), (PO)((Object)invoiceLine), "User1_ID");
        int User2_ID = AssetFactUtil.fromLineOrInvoice((PO)((Object)invoice), (PO)((Object)invoiceLine), "User2_ID");
        int M_Product_ID = 0;
        if (invoiceLine != null) {
            M_Product_ID = invoiceLine.getM_Product_ID();
        }
        if (C_BPartner_ID > 0) {
            factLine.setC_BPartner_ID(C_BPartner_ID);
        }
        if (C_Project_ID > 0) {
            factLine.setC_Project_ID(C_Project_ID);
        }
        if (C_Campaign_ID > 0) {
            factLine.setC_Campaign_ID(C_Campaign_ID);
        }
        if (C_Activity_ID > 0) {
            factLine.setC_Activity_ID(C_Activity_ID);
        }
        if (AD_OrgTrx_ID > 0) {
            factLine.setAD_OrgTrx_ID(AD_OrgTrx_ID);
        }
        if (User1_ID > 0) {
            factLine.setUser1_ID(User1_ID);
        }
        if (User2_ID > 0) {
            factLine.setUser2_ID(User2_ID);
        }
        if (M_Product_ID > 0) {
            factLine.setM_Product_ID(M_Product_ID);
        }
    }

    public static void setFactLinesDimensions(FactLine[] factLines, MAssetAddition addition, boolean bIncludeInvoiceLine) {
        MAsset asset = addition.getA_Asset(false);
        AssetFactUtil.setFactLineDimensions(factLines[0], asset);
        if (addition.getA_SourceType().equals("INV") && addition.getC_Invoice_ID() > 0) {
            I_C_Invoice invoice = addition.getC_Invoice();
            I_C_InvoiceLine invoiceLine = bIncludeInvoiceLine ? addition.getC_InvoiceLine() : null;
            AssetFactUtil.setFactLineDimensions(factLines[1], invoice, invoiceLine);
        }
    }

    protected static int fromLineOrInvoice(PO invoice, PO line, String sFieldName) {
        int iRet = 0;
        if (line != null) {
            iRet = line.get_ValueAsInt(sFieldName);
        }
        if (iRet <= 0 && invoice != null) {
            iRet = invoice.get_ValueAsInt(sFieldName);
        }
        return iRet;
    }
}

