/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.FA;

import java.math.BigDecimal;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.model.GridTabWrapper;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.I_A_Asset;
import org.compiere.model.I_A_Asset_Addition;
import org.compiere.model.MAsset;
import org.compiere.model.MAssetAcct;
import org.compiere.model.MAssetAddition;
import org.compiere.model.MConversionRateUtil;
import org.compiere.model.MDepreciation;
import org.compiere.model.MDepreciationWorkfile;
import org.compiere.model.MProject;
import org.compiere.model.MSysConfig;
import org.compiere.model.SetGetUtil;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class CalloutA_Asset_Addition
extends CalloutEngine {
    public String matchInv(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        int M_MatchInv_ID = ((Number)value).intValue();
        if (M_MatchInv_ID > 0) {
            MAssetAddition.setM_MatchInv(SetGetUtil.wrap(mTab), M_MatchInv_ID);
        }
        return this.amt(ctx, WindowNo, mTab, mField, value);
    }

    public String project(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive()) {
            return "";
        }
        int project_id = 0;
        if (value == null || !(value instanceof Number)) {
            return "";
        }
        project_id = ((Number)value).intValue();
        BigDecimal amt = Env.ZERO;
        if (project_id > 0) {
            MProject prj = new MProject(ctx, project_id, null);
            amt = prj.getProjectBalanceAmt();
            mTab.setValue("C_Currency_ID", (Object)prj.getC_Currency_ID());
        }
        mTab.setValue("AssetSourceAmt", (Object)amt);
        return this.amt(ctx, WindowNo, mTab, mField, value);
    }

    public String amt(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive()) {
            return "";
        }
        String columnName = mField.getColumnName();
        if ("A_Accumulated_Depr".equals(columnName)) {
            mTab.setValue("A_Accumulated_Depr_F", value);
        } else {
            BigDecimal amtEntered = (BigDecimal)mTab.getValue("AssetAmtEntered");
            BigDecimal amtTax = (BigDecimal)mTab.getValue("AssetSourceTaxAmt");
            mTab.setValue("AssetSourceAmt", (Object)amtEntered.add(amtTax));
            MConversionRateUtil.convertBase(SetGetUtil.wrap(mTab), "DateAcct", "AssetSourceAmt", "AssetValueAmt", mField.getColumnName());
        }
        return "";
    }

    public String dateDoc(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        mTab.setValue("DateAcct", value);
        return "";
    }

    public String uselife(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if ("DeltaUseLifeYears".equals(mField.getColumnName())) {
            mTab.setValue("DeltaUseLifeYears_F", value);
        }
        return "";
    }

    public String periodOffset(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        MAsset mWkAsset;
        I_A_Asset_Addition aa = GridTabWrapper.create(mTab, I_A_Asset_Addition.class);
        if (!aa.isA_Accumulated_Depr_Adjust()) {
            return "";
        }
        int periods = TimeUtil.getMonthsBetween(aa.getDateDoc(), aa.getDateAcct());
        if (periods <= 0) {
            return "";
        }
        int uselifeMonths = aa.getDeltaUseLifeYears() * 12;
        if (uselifeMonths == 0) {
            return "";
        }
        double monthlyExpenseSL = aa.getAssetValueAmt().doubleValue() / (double)uselifeMonths * (double)periods;
        aa.setA_Period_Start(periods + 1);
        I_A_Asset asset = aa.getA_Asset();
        boolean bAllowAccumulateDeprAlways = MSysConfig.getBooleanValue("FA_ADDITION_ALLOW_ACCDEPR_ALWAYS", false);
        if (!bAllowAccumulateDeprAlways && asset.getA_Asset_Status() != null && !asset.getA_Asset_Status().equals("NW")) {
            return "";
        }
        MDepreciationWorkfile mWorkFile = MDepreciationWorkfile.get(ctx, aa.getA_Asset_ID(), aa.getPostingType());
        if (mWorkFile == null) {
            throw new AdempiereException("@Invalid@ @A_Depreciation_Workfile_ID@");
        }
        mWorkFile.load((String)null);
        boolean bDateAcctWasNull = false;
        boolean bAssetServiceDateWasNull = false;
        if (mWorkFile.getDateAcct() == null) {
            bDateAcctWasNull = true;
            mWorkFile.setDateAcct(aa.getDateDoc());
        }
        if ((mWkAsset = mWorkFile.getAsset(true)).getAssetServiceDate() == null) {
            bAssetServiceDateWasNull = true;
            mWkAsset.setAssetServiceDate(aa.getDateDoc());
        }
        if (mWorkFile != null) {
            MAssetAcct mAssectAcct = mWorkFile.getA_AssetAcct(aa.getDateAcct(), null);
            if (mAssectAcct == null) {
                throw new AdempiereException("@Invalid@ @PostingType@");
            }
            MDepreciation depreciation_C = MDepreciation.get(ctx, mAssectAcct.getA_Depreciation_ID());
            MDepreciation depreciation_F = MDepreciation.get(ctx, mAssectAcct.getA_Depreciation_F_ID());
            BigDecimal accumDep_C = mWorkFile.getA_Accumulated_Depr();
            BigDecimal accumDep_F = mWorkFile.getA_Accumulated_Depr_F();
            BigDecimal bdAssetCost = mWorkFile.getA_Asset_Cost();
            BigDecimal bdAssetValueAmt = aa.getAssetValueAmt();
            if (bdAssetCost == null) {
                bdAssetCost = BigDecimal.ZERO;
            }
            if (bdAssetValueAmt == null) {
                bdAssetValueAmt = BigDecimal.ZERO;
            }
            mWorkFile.setA_Asset_Cost(bdAssetCost.add(bdAssetValueAmt));
            for (int i = 0; i <= periods; ++i) {
                mWorkFile.setFiscal(false);
                BigDecimal bdAdd_C = depreciation_C.invoke(mWorkFile, mAssectAcct, i, accumDep_C);
                mWorkFile.setFiscal(true);
                BigDecimal bdAdd_F = depreciation_F.invoke(mWorkFile, mAssectAcct, i, accumDep_F);
                if (bdAdd_C != null) {
                    accumDep_C = accumDep_C.add(bdAdd_C);
                }
                if (bdAdd_F == null) continue;
                accumDep_F = accumDep_F.add(bdAdd_F);
            }
            mWorkFile.setA_Asset_Cost(bdAssetCost);
            aa.setA_Accumulated_Depr(accumDep_C);
            aa.setA_Accumulated_Depr_F(accumDep_F);
        }
        if (bDateAcctWasNull) {
            mWorkFile.setDateAcct(null);
        }
        if (bAssetServiceDateWasNull) {
            mWkAsset.setAssetServiceDate(null);
        }
        return "";
    }
}

