/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.form;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Vector;
import java.util.logging.Level;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListModelTable;
import org.adempiere.webui.component.ListboxFactory;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.WListbox;
import org.adempiere.webui.editor.WDateEditor;
import org.adempiere.webui.editor.WSearchEditor;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.event.WTableModelEvent;
import org.adempiere.webui.event.WTableModelListener;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.panel.CustomForm;
import org.adempiere.webui.panel.IFormController;
import org.adempiere.webui.panel.StatusBarPanel;
import org.compiere.model.Lookup;
import org.compiere.model.MColumn;
import org.compiere.model.MDocType;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.X_MP_JobStandar;
import org.compiere.model.X_MP_OT;
import org.compiere.model.X_MP_OT_Resource;
import org.compiere.model.X_MP_OT_Task;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zkex.zul.Borderlayout;
import org.zkoss.zkex.zul.Center;
import org.zkoss.zkex.zul.North;
import org.zkoss.zkex.zul.South;
import org.zkoss.zul.Separator;

public class WMPRequestOT
implements IFormController,
EventListener,
WTableModelListener,
ValueChangeListener {
    private static final long serialVersionUID = -5322824600164192235L;
    private CustomForm form = new CustomForm();
    private int m_WindowNo = 0;
    private static CLogger log = CLogger.getCLogger(WMPRequestOT.class);
    private boolean m_calculating = false;
    private int m_C_Currency_ID = 0;
    private Panel parameterPanel = new Panel();
    private Grid parameterLayout = GridFactory.newGridLayout();
    private Borderlayout mainLayout = new Borderlayout();
    private Panel allocationPanel = new Panel();
    private WListbox requestTable = ListboxFactory.newDataTable();
    private Panel infoPanel = new Panel();
    private int m_A_Asset_ID = 0;
    private int m_Job_ID = 0;
    private Panel requestPanel = new Panel();
    private Label requestLabel = new Label();
    private Borderlayout requestLayout = new Borderlayout();
    private Label requestInfo = new Label();
    private Grid allocationLayout = GridFactory.newGridLayout();
    private Button ProcessButton = new Button();
    private Button searchButton = new Button();
    private Button VoidButton = new Button();
    private Button addButton = new Button();
    private Button EnableButton = new Button();
    private Button ChangeButton = new Button();
    private Label assetLabel = new Label();
    private Checkbox selectall = new Checkbox();
    private Label allocCurrencyLabel = new Label();
    private StatusBarPanel statusBar = new StatusBarPanel();
    private Label dateLabel = new Label();
    private WDateEditor dateField = new WDateEditor();
    private WSearchEditor assetSearch = null;
    private Label jobLabel = new Label();
    private WSearchEditor jobSearch = null;
    private Button jobButton = new Button();
    private Panel southPanel = new Panel();

    public WMPRequestOT() {
        log.info("Currency=" + this.m_C_Currency_ID);
        try {
            this.dynInit();
            this.zkInit();
            this.southPanel.appendChild((Component)new Separator());
            this.southPanel.appendChild((Component)this.statusBar);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    private void zkInit() throws Exception {
        this.form.appendChild((Component)this.mainLayout);
        this.mainLayout.setWidth("99%");
        this.mainLayout.setHeight("100%");
        this.dateLabel.setText(Msg.getMsg(Env.getCtx(), "Date"));
        this.parameterPanel.appendChild((Component)this.parameterLayout);
        this.allocationPanel.appendChild((Component)this.allocationLayout);
        this.requestLabel.setText(Msg.getMsg(Env.getCtx(), "Request List"));
        this.requestPanel.appendChild((Component)this.requestLayout);
        this.requestInfo.setText(".");
        this.ProcessButton.setLabel(Msg.getMsg(Env.getCtx(), "Generate OT"));
        this.ProcessButton.addActionListener((EventListener)this);
        this.VoidButton.setLabel(Msg.getMsg(Env.getCtx(), "Chiudi Richiesta"));
        this.VoidButton.addActionListener((EventListener)this);
        this.searchButton.setLabel(Msg.getMsg(Env.getCtx(), "Search"));
        this.searchButton.addActionListener((EventListener)this);
        this.addButton.setLabel(Msg.getMsg(Env.getCtx(), "Select"));
        this.addButton.addActionListener((EventListener)this);
        this.EnableButton.setLabel(Msg.getMsg(Env.getCtx(), "Enable Editing"));
        this.EnableButton.addActionListener((EventListener)this);
        this.ChangeButton.setLabel(Msg.getMsg(Env.getCtx(), "Apply Date"));
        this.ChangeButton.addActionListener((EventListener)this);
        this.jobButton.setLabel("Assegnazione JobStandard");
        this.jobButton.addActionListener((EventListener)this);
        this.jobLabel.setText("JobStandard");
        this.assetLabel.setText(Msg.translate(Env.getCtx(), "A_Asset_ID"));
        this.selectall.setText(Msg.getMsg(Env.getCtx(), "Sellect all"));
        this.selectall.addActionListener((EventListener)this);
        this.allocCurrencyLabel.setText(".");
        North north = new North();
        north.setStyle("border: none");
        this.mainLayout.appendChild((Component)north);
        north.appendChild((Component)this.parameterPanel);
        Rows rows = null;
        Row row = null;
        this.parameterLayout.setWidth("800px");
        rows = this.parameterLayout.newRows();
        row = rows.newRow();
        row.appendChild(this.dateLabel.rightAlign());
        row.appendChild((Component)this.dateField.getComponent());
        row.appendChild((Component)this.ChangeButton);
        row.appendChild(this.assetLabel.rightAlign());
        row.appendChild((Component)this.assetSearch.getComponent());
        row.appendChild((Component)this.selectall);
        row.appendChild(this.jobLabel.rightAlign());
        row.appendChild((Component)this.jobSearch.getComponent());
        row.appendChild((Component)this.jobButton);
        South south = new South();
        south.setStyle("border: none");
        this.mainLayout.appendChild((Component)south);
        south.appendChild((Component)this.southPanel);
        this.southPanel.appendChild((Component)this.allocationPanel);
        this.allocationPanel.appendChild((Component)this.allocationLayout);
        this.allocationLayout.setWidth("400px");
        rows = this.allocationLayout.newRows();
        row = rows.newRow();
        row.appendChild((Component)this.VoidButton);
        row.appendChild((Component)this.ProcessButton);
        this.requestPanel.appendChild((Component)this.requestLayout);
        this.requestPanel.setWidth("100%");
        this.requestPanel.setHeight("100%");
        this.requestLayout.setWidth("100%");
        this.requestLayout.setHeight("100%");
        this.requestLayout.setStyle("border: none");
        north = new North();
        north.setStyle("border: none");
        this.requestLayout.appendChild((Component)north);
        north.appendChild((Component)this.requestLabel);
        south = new South();
        south.setStyle("border: none");
        this.requestLayout.appendChild((Component)south);
        south.appendChild(this.requestInfo.rightAlign());
        Center center = new Center();
        this.requestLayout.appendChild((Component)center);
        center.appendChild((Component)this.requestTable);
        this.requestTable.setWidth("99%");
        this.requestTable.setHeight("99%");
        center.setStyle("border: none");
        center = new Center();
        center.setFlex(true);
        this.mainLayout.appendChild((Component)center);
        center.appendChild((Component)this.requestPanel);
    }

    private void dynInit() throws Exception {
        int AD_Column_ID = MColumn.getColumn_ID("MP_Maintain", "A_Asset_ID");
        MLookup lookupBP = MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, AD_Column_ID, 30);
        this.assetSearch = new WSearchEditor("A_Asset_ID", true, false, true, (Lookup)lookupBP);
        this.assetSearch.addValueChangeListener((ValueChangeListener)this);
        AD_Column_ID = MColumn.getColumn_ID("MP_Maintain", "MP_JobStandar_ID");
        MLookup lookupjob = MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, AD_Column_ID, 30);
        this.jobSearch = new WSearchEditor("MP_JobStandar_ID", true, false, true, (Lookup)lookupjob);
        this.jobSearch.addValueChangeListener((ValueChangeListener)this);
        this.dateField.setValue((Object)Env.getContextAsDate(Env.getCtx(), "#Date"));
        this.statusBar.setStatusLine("Selezionare Documenti, Variare la data o Generare Ordini Direttamente");
        this.statusBar.setStatusDB("");
        this.loadMPs();
    }

    private void loadMPs() {
        Vector data = new Vector();
        StringBuffer sql = new StringBuffer("select rt.DATEDOC,rt.DATEREQUIRED,rt.DOCUMENTNO,rt.MP_OT_REQUEST_ID, rt.AD_Org_ID, rt.AD_User_ID, rt.A_Asset_ID, rt.MP_JOBSTANDAR_ID, rt.Description, u.name, a.name as AssetName, jo.name as jobName,rl.name as PriorityRule, rt.OT_Request_Type from MP_OT_REQUEST rt inner join AD_User u on (rt.AD_User_ID=u.AD_User_ID) inner join A_Asset a on (rt.A_Asset_ID=a.A_Asset_ID) left outer join MP_JOBSTANDAR jo on (rt.MP_JOBSTANDAR_ID=jo.MP_JOBSTANDAR_ID) inner join AD_Ref_List rl on (rt.PriorityRule=rl.value and rl. AD_Reference_ID=154) where rt.DocStatus='WC' and rt.processed='Y'");
        log.config("request=" + sql.toString());
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            String tipo = new String();
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Vector<Object> line = new Vector<Object>();
                line.add(new Boolean(false));
                if (rs.getString(14).equals("RV")) {
                    tipo = "Revision";
                }
                if (rs.getString(14).equals("RP")) {
                    tipo = "Reparacion";
                }
                if (rs.getString(14).equals("CN")) {
                    tipo = "Completar Niveles";
                }
                line.add(tipo);
                line.add(rs.getTimestamp(2));
                KeyNamePair pp = new KeyNamePair(rs.getInt(4), rs.getString(3));
                line.add(pp);
                line.add(rs.getTimestamp(1));
                KeyNamePair pp2 = new KeyNamePair(rs.getInt(6), rs.getString(10));
                line.add(pp2);
                KeyNamePair pp3 = new KeyNamePair(rs.getInt(7), rs.getString(11));
                line.add(pp3);
                line.add(rs.getString(9));
                line.add(rs.getString(13));
                KeyNamePair pp4 = new KeyNamePair(rs.getInt(8), rs.getString(12));
                line.add(pp4);
                data.add(line);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), e);
        }
        this.requestTable.clear();
        this.requestTable.getModel().removeTableModelListener((WTableModelListener)this);
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(Msg.getMsg(Env.getCtx(), "Selected"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Type"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Date Programed"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Request No"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Date Request"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "AD_User_ID"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Asset"));
        columnNames.add("Descripcion");
        columnNames.add(Msg.getMsg(Env.getCtx(), "Priority"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Standard Job"));
        ListModelTable modelP = new ListModelTable(data);
        modelP.addTableModelListener((WTableModelListener)this);
        this.requestTable.setData(modelP, columnNames);
        int i = 0;
        this.requestTable.setColumnClass(i++, Boolean.class, false);
        this.requestTable.setColumnClass(i++, String.class, true);
        this.requestTable.setColumnClass(i++, Timestamp.class, false);
        this.requestTable.setColumnClass(i++, String.class, true);
        this.requestTable.setColumnClass(i++, Timestamp.class, true);
        this.requestTable.setColumnClass(i++, String.class, true);
        this.requestTable.setColumnClass(i++, String.class, true);
        this.requestTable.setColumnClass(i++, String.class, true);
        this.requestTable.setColumnClass(i++, String.class, true);
        this.requestTable.setColumnClass(i++, String.class, true);
        this.requestTable.autoSize();
        this.requestTable.setColumnReadOnly(1, false);
        this.calculate();
    }

    public void onEvent(Event e) {
        block9: {
            block12: {
                block11: {
                    block10: {
                        block8: {
                            log.config("");
                            if (!e.getTarget().equals(this.ProcessButton)) break block8;
                            this.saveData();
                            break block9;
                        }
                        if (!e.getTarget().equals(this.jobButton)) break block10;
                        ListModelTable request = this.requestTable.getModel();
                        int rows = request.getRowCount();
                        X_MP_JobStandar job = new X_MP_JobStandar(Env.getCtx(), this.m_Job_ID, null);
                        int i = 0;
                        while (i < rows) {
                            if (((Boolean)request.getValueAt(i, 0)).booleanValue()) {
                                KeyNamePair pp = new KeyNamePair(job.getMP_JobStandar_ID(), job.getName());
                                request.setValueAt((Object)pp, i, 9);
                            }
                            ++i;
                        }
                        break block9;
                    }
                    if (!e.getTarget().equals(this.VoidButton)) break block11;
                    this.voidData();
                    break block9;
                }
                if (!e.getTarget().equals(this.ChangeButton)) break block12;
                this.ProcessButton.setEnabled(true);
                ListModelTable request = this.requestTable.getModel();
                int rows = request.getRowCount();
                Timestamp DateTrx = (Timestamp)this.dateField.getValue();
                int i = 0;
                while (i < rows) {
                    if (((Boolean)request.getValueAt(i, 0)).booleanValue()) {
                        request.setValueAt((Object)DateTrx, i, 2);
                    }
                    ++i;
                }
                break block9;
            }
            if (!e.getTarget().equals(this.selectall)) break block9;
            ListModelTable request = this.requestTable.getModel();
            int rows = request.getRowCount();
            int i = 0;
            while (i < rows) {
                if (this.m_A_Asset_ID == 0) {
                    request.setValueAt((Object)this.selectall.isSelected(), i, 0);
                } else {
                    KeyNamePair pp = (KeyNamePair)request.getValueAt(i, 6);
                    int Asset_ID = pp.getKey();
                    if (Asset_ID == this.m_A_Asset_ID) {
                        request.setValueAt((Object)this.selectall.isSelected(), i, 0);
                    }
                }
                ++i;
            }
        }
    }

    public void tableChanged(WTableModelEvent e) {
        boolean isUpdate;
        boolean bl = isUpdate = e.getType() == 0;
        if (!isUpdate) {
            this.calculate();
            return;
        }
        if (this.m_calculating) {
            return;
        }
        this.m_calculating = true;
        this.m_calculating = false;
        this.calculate();
    }

    private void calculate() {
        log.config("");
        DecimalFormat format = DisplayType.getNumberFormat(12);
        Object allocDate = null;
    }

    public void valueChange(ValueChangeEvent e) {
        String name = e.getPropertyName();
        Object value = e.getNewValue();
        log.config(String.valueOf(name) + "=" + value);
        if (name.equals("A_Asset_ID")) {
            this.assetSearch.setValue(value);
            if (value != null) {
                this.m_A_Asset_ID = (Integer)value;
            }
        } else if (name.equals("MP_JobStandar_ID")) {
            this.jobSearch.setValue(value);
            if (value != null) {
                this.m_Job_ID = (Integer)value;
            }
        }
    }

    private void saveData() {
        ListModelTable request = this.requestTable.getModel();
        int rows = request.getRowCount();
        Timestamp DateTrx = (Timestamp)this.dateField.getValue();
        Trx trx = Trx.get(Trx.createTrxName("AL"), true);
        int i = 0;
        while (i < rows) {
            if (((Boolean)request.getValueAt(i, 0)).booleanValue()) {
                KeyNamePair pp = (KeyNamePair)request.getValueAt(i, 3);
                int Req_ID = pp.getKey();
                pp = (KeyNamePair)request.getValueAt(i, 6);
                int Asset_ID = pp.getKey();
                Timestamp Datetrx = (Timestamp)request.getValueAt(i, 2);
                String description = (String)request.getValueAt(i, 7);
                int job_id = 0;
                if (request.getValueAt(i, 9) != null) {
                    pp = (KeyNamePair)request.getValueAt(i, 9);
                    job_id = pp.getKey();
                }
                if (!this.createOT(job_id, Datetrx, description, Asset_ID, Req_ID)) {
                    log.log(Level.SEVERE, "OT not created #" + i);
                } else {
                    String sql = "Update MP_OT_REQUEST set DocStatus='AP',MP_JobStandar_ID=" + job_id + " where MP_OT_REQUEST_ID=" + Req_ID;
                    DB.executeUpdate(sql);
                }
            }
            ++i;
        }
        this.loadMPs();
    }

    private void voidData() {
        ListModelTable request = this.requestTable.getModel();
        int rows = request.getRowCount();
        Trx trx = Trx.get(Trx.createTrxName("AL"), true);
        int i = 0;
        while (i < rows) {
            if (((Boolean)request.getValueAt(i, 0)).booleanValue()) {
                KeyNamePair pp = (KeyNamePair)request.getValueAt(i, 3);
                int Req_ID = pp.getKey();
                String sql = "Update MP_OT_REQUEST set DocStatus='VO' where MP_OT_REQUEST_ID=" + Req_ID;
                DB.executeUpdate(sql);
            }
            ++i;
        }
        this.loadMPs();
    }

    public boolean createOT(int Job_ID, Timestamp Datetrx, String description, int Asset_ID, int Req_ID) {
        X_MP_OT newOT = new X_MP_OT(Env.getCtx(), 0, null);
        newOT.setDateTrx(Datetrx);
        newOT.setDescription(description);
        newOT.setA_Asset_ID(Asset_ID);
        newOT.setMP_JobStandar_ID(Job_ID);
        newOT.setDocStatus("DR");
        newOT.setDocAction("CO");
        newOT.setMP_OT_Request_ID(Req_ID);
        newOT.setC_DocType_ID(MDocType.getOfDocBaseType(Env.getCtx(), "OTC")[0].getC_DocType_ID());
        if (!newOT.save()) {
            return false;
        }
        return this.createOTTaskDetail(Job_ID, newOT);
    }

    public void lookChilds(int MP_ID, X_MP_OT OT) {
        String sql = "select mp_maintain_id from mp_maintain where ischild='Y' and MP_MAINTAINPARENT_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, MP_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                this.createOTTaskDetail(rs.getInt(1), OT);
                this.lookChilds(rs.getInt(1), OT);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
        }
    }

    public boolean createOTTaskDetail(int Job_ID, X_MP_OT OT) {
        String sql = "select * from MP_JOBSTANDAR_TASK where MP_JOBSTANDAR_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, Job_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                X_MP_OT_Task ta = new X_MP_OT_Task(Env.getCtx(), 0, null);
                ta.setAD_Org_ID(rs.getInt("AD_Org_ID"));
                ta.setMP_OT_ID(OT.getMP_OT_ID());
                ta.setDescription(rs.getString("Description"));
                ta.setDuration(rs.getBigDecimal("Duration"));
                ta.setC_UOM_ID(rs.getInt("C_UOM_ID"));
                ta.setStatus("NS");
                ta.saveEx();
                this.createOTResourceDetail(rs.getInt("MP_JOBSTANDAR_TASK_ID"), ta.getMP_OT_Task_ID());
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
        }
        return true;
    }

    public boolean createOTResourceDetail(int oldTask_ID, int newTask_ID) {
        String sql = "select * from MP_JOBSTANDAR_RESOURCE where MP_JOBSTANDAR_TASK_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, oldTask_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                X_MP_OT_Resource re = new X_MP_OT_Resource(Env.getCtx(), 0, null);
                re.setAD_Org_ID(rs.getInt("AD_Org_ID"));
                re.setMP_OT_Task_ID(newTask_ID);
                re.setCostAmt(rs.getBigDecimal("CostAmt"));
                re.setS_Resource_ID(rs.getInt("S_Resource_ID"));
                re.setM_BOM_ID(rs.getInt("M_BOM_ID"));
                re.setResourceQty(rs.getBigDecimal("RESOURCEQTY"));
                re.setResourceType(rs.getString("RESOURCETYPE"));
                re.set_ValueOfColumn("M_Product_ID", (Object)rs.getInt("M_Product_ID"));
                re.saveEx();
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
        }
        return true;
    }

    public ADForm getForm() {
        return this.form;
    }
}

