/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.form;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Vector;
import java.util.logging.Level;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListModelTable;
import org.adempiere.webui.component.ListboxFactory;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.WListbox;
import org.adempiere.webui.editor.WDateEditor;
import org.adempiere.webui.editor.WSearchEditor;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.event.WTableModelEvent;
import org.adempiere.webui.event.WTableModelListener;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.panel.CustomForm;
import org.adempiere.webui.panel.IFormController;
import org.adempiere.webui.panel.StatusBarPanel;
import org.adempiere.webui.window.FDialog;
import org.compiere.model.Lookup;
import org.compiere.model.MColumn;
import org.compiere.model.MDocType;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MQuery;
import org.compiere.model.PrintInfo;
import org.compiere.model.X_MP_OT;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportCtl;
import org.compiere.print.ReportEngine;
import org.compiere.print.ReportViewerProvider;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zkex.zul.Borderlayout;
import org.zkoss.zkex.zul.Center;
import org.zkoss.zkex.zul.North;
import org.zkoss.zkex.zul.South;
import org.zkoss.zul.Separator;

public class WMPProgrammingOT
implements IFormController,
EventListener,
WTableModelListener,
ValueChangeListener {
    private static final long serialVersionUID = -5322824600164192235L;
    private CustomForm form = new CustomForm();
    private int m_WindowNo = 0;
    private static CLogger log = CLogger.getCLogger(WMPProgrammingOT.class);
    private boolean m_calculating = false;
    private int m_C_Currency_ID = 0;
    private Panel parameterPanel = new Panel();
    private Grid parameterLayout = GridFactory.newGridLayout();
    private Borderlayout mainLayout = new Borderlayout();
    private Panel allocationPanel = new Panel();
    private WListbox otTable = ListboxFactory.newDataTable();
    private Panel infoPanel = new Panel();
    private int m_A_Asset_ID = 0;
    private int m_AD_User_ID = 0;
    private Panel otPanel = new Panel();
    private Label otLabel = new Label();
    private Borderlayout otLayout = new Borderlayout();
    private Label otInfo = new Label();
    private Grid allocationLayout = GridFactory.newGridLayout();
    private Button ProcessButton = new Button();
    private Button searchButton = new Button();
    private Button setButton = new Button();
    private Button EnableButton = new Button();
    private Button ChangeButton = new Button();
    private Label assetLabel = new Label();
    private Checkbox selectall = new Checkbox();
    private Label allocCurrencyLabel = new Label();
    private StatusBarPanel statusBar = new StatusBarPanel();
    private Label dateLabel = new Label();
    private WDateEditor dateField = new WDateEditor();
    private WSearchEditor assetSearch = null;
    private WSearchEditor userSearch = null;
    private Panel southPanel = new Panel();

    public WMPProgrammingOT() {
        Env.setContext(Env.getCtx(), this.m_WindowNo, "IsSOTrx", "Y");
        this.m_C_Currency_ID = Env.getContextAsInt(Env.getCtx(), "$C_Currency_ID");
        log.info("Currency=" + this.m_C_Currency_ID);
        try {
            this.dynInit();
            this.zkInit();
            this.calculate();
            this.southPanel.appendChild((Component)new Separator());
            this.southPanel.appendChild((Component)this.statusBar);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    private void zkInit() throws Exception {
        this.form.appendChild((Component)this.mainLayout);
        this.mainLayout.setWidth("99%");
        this.mainLayout.setHeight("100%");
        this.dateLabel.setText(Msg.getMsg(Env.getCtx(), "Date"));
        this.parameterPanel.appendChild((Component)this.parameterLayout);
        this.allocationPanel.appendChild((Component)this.allocationLayout);
        this.otLabel.setText(Msg.getMsg(Env.getCtx(), "OT List"));
        this.otPanel.appendChild((Component)this.otLayout);
        this.otInfo.setText(".");
        this.ProcessButton.setLabel(Msg.getMsg(Env.getCtx(), "Print"));
        this.ProcessButton.addActionListener((EventListener)this);
        this.searchButton.setLabel(Msg.getMsg(Env.getCtx(), "Search"));
        this.searchButton.addActionListener((EventListener)this);
        this.setButton.setLabel(Msg.getMsg(Env.getCtx(), "set User"));
        this.setButton.addActionListener((EventListener)this);
        this.EnableButton.setLabel(Msg.getMsg(Env.getCtx(), "Enable Editing"));
        this.EnableButton.addActionListener((EventListener)this);
        this.ChangeButton.setLabel(Msg.getMsg(Env.getCtx(), "Apply Date"));
        this.ChangeButton.addActionListener((EventListener)this);
        this.assetLabel.setText(Msg.getMsg(Env.getCtx(), "User"));
        this.selectall.setText(Msg.getMsg(Env.getCtx(), "Select All"));
        this.selectall.addActionListener((EventListener)this);
        this.allocCurrencyLabel.setText(".");
        North north = new North();
        north.setStyle("border: none");
        this.mainLayout.appendChild((Component)north);
        north.appendChild((Component)this.parameterPanel);
        Rows rows = null;
        Row row = null;
        this.parameterLayout.setWidth("800px");
        rows = this.parameterLayout.newRows();
        row = rows.newRow();
        row.appendChild(this.dateLabel.rightAlign());
        row.appendChild((Component)this.dateField.getComponent());
        row.appendChild((Component)this.ChangeButton);
        row.appendChild((Component)this.selectall);
        row.appendChild((Component)this.assetLabel);
        row.appendChild((Component)this.userSearch.getComponent());
        row.appendChild((Component)this.setButton);
        South south = new South();
        south.setStyle("border: none");
        this.mainLayout.appendChild((Component)south);
        south.appendChild((Component)this.southPanel);
        this.southPanel.appendChild((Component)this.allocationPanel);
        this.allocationPanel.appendChild((Component)this.allocationLayout);
        this.allocationLayout.setWidth("400px");
        rows = this.allocationLayout.newRows();
        row = rows.newRow();
        row.appendChild((Component)this.selectall);
        row.appendChild((Component)this.ProcessButton);
        this.otPanel.appendChild((Component)this.otLayout);
        this.otPanel.setWidth("100%");
        this.otPanel.setHeight("100%");
        this.otLayout.setWidth("100%");
        this.otLayout.setHeight("100%");
        this.otLayout.setStyle("border: none");
        north = new North();
        north.setStyle("border: none");
        this.otLayout.appendChild((Component)north);
        north.appendChild((Component)this.otLabel);
        south = new South();
        south.setStyle("border: none");
        this.otLayout.appendChild((Component)south);
        south.appendChild(this.otInfo.rightAlign());
        Center center = new Center();
        this.otLayout.appendChild((Component)center);
        center.appendChild((Component)this.otTable);
        this.otTable.setWidth("99%");
        this.otTable.setHeight("99%");
        center.setStyle("border: none");
        center = new Center();
        center.setFlex(true);
        this.mainLayout.appendChild((Component)center);
        center.appendChild((Component)this.otPanel);
    }

    private void dynInit() throws Exception {
        int AD_Column_ID = MColumn.getColumn_ID("MP_OT", "AD_User_ID");
        MLookup lookupUs = MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, AD_Column_ID, 30);
        this.userSearch = new WSearchEditor("AD_User_ID", true, false, true, (Lookup)lookupUs);
        this.userSearch.addValueChangeListener((ValueChangeListener)this);
        this.dateField.setValue((Object)Env.getContextAsDate(Env.getCtx(), "#Date"));
        this.statusBar.setStatusLine("Selezionare Documenti, Variare la data e o Utente e Generare Stampa");
        this.statusBar.setStatusDB("");
        this.loadMPs();
    }

    private void loadMPs() {
        Vector data = new Vector();
        StringBuffer sql = new StringBuffer("select o.DATETRX,doc.name,o.DOCUMENTNO,o.AD_USER_ID,o.DESCRIPTION, o.MP_OT_ID, u.name, o.A_Asset_ID, a.name as AssetName From MP_OT o  inner join A_Asset a on (o.A_Asset_ID=a.A_Asset_ID) inner join C_DocType doc on (o.C_DocType_ID=doc.C_DocType_ID) Left Outer Join AD_User u on(o.AD_User_ID=u.AD_User_ID) where o.DOCSTATUS='DR' and not exists  (select * from MP_OT_TASK t where t.STATUS<>'NS' and t.MP_OT_ID=o.MP_OT_ID)");
        log.config("ot=" + sql.toString());
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Vector<Object> line = new Vector<Object>();
                line.add(new Boolean(false));
                line.add(rs.getTimestamp(1));
                line.add(rs.getString(2));
                KeyNamePair pp = new KeyNamePair(rs.getInt(6), rs.getString(3));
                line.add(pp);
                KeyNamePair pp3 = new KeyNamePair(rs.getInt(8), rs.getString(9));
                line.add(pp3);
                KeyNamePair pp2 = new KeyNamePair(rs.getInt(4), rs.getString(7));
                line.add(pp2);
                line.add(rs.getString(5));
                data.add(line);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), e);
        }
        this.otTable.clear();
        this.otTable.getModel().removeTableModelListener((WTableModelListener)this);
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(Msg.getMsg(Env.getCtx(), "Selected"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Date Programed"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Type"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "DocumentNo"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Asset"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "AD_User_ID"));
        columnNames.add("Description");
        ListModelTable modelP = new ListModelTable(data);
        modelP.addTableModelListener((WTableModelListener)this);
        this.otTable.setData(modelP, columnNames);
        int i = 0;
        this.otTable.setColumnClass(i++, Boolean.class, false);
        this.otTable.setColumnClass(i++, Timestamp.class, false);
        this.otTable.setColumnClass(i++, String.class, true);
        this.otTable.setColumnClass(i++, String.class, true);
        this.otTable.setColumnClass(i++, String.class, true);
        this.otTable.setColumnClass(i++, String.class, true);
        this.otTable.setColumnClass(i++, String.class, true);
        this.otTable.autoSize();
        this.otTable.setColumnReadOnly(1, false);
        this.calculate();
    }

    public void onEvent(Event e) {
        log.config("");
        if (e.getTarget().equals(this.ProcessButton)) {
            this.saveData();
        } else if (e.getTarget().equals(this.ChangeButton)) {
            this.ProcessButton.setEnabled(true);
            ListModelTable ot = this.otTable.getModel();
            int rows = ot.getRowCount();
            Timestamp DateTrx = (Timestamp)this.dateField.getValue();
            int i = 0;
            while (i < rows) {
                if (((Boolean)ot.getValueAt(i, 0)).booleanValue()) {
                    KeyNamePair pp = (KeyNamePair)ot.getValueAt(i, 3);
                    int OT_ID = pp.getKey();
                    X_MP_OT currentOT = new X_MP_OT(Env.getCtx(), OT_ID, null);
                    currentOT.setDateTrx(DateTrx);
                    currentOT.save();
                }
                ++i;
            }
            this.loadMPs();
        } else if (e.getTarget().equals(this.setButton)) {
            ListModelTable ot = this.otTable.getModel();
            int rows = ot.getRowCount();
            if (this.m_AD_User_ID != 0) {
                int i = 0;
                while (i < rows) {
                    if (((Boolean)ot.getValueAt(i, 0)).booleanValue()) {
                        KeyNamePair pp = (KeyNamePair)ot.getValueAt(i, 3);
                        int OT_ID = pp.getKey();
                        X_MP_OT currentOT = new X_MP_OT(Env.getCtx(), OT_ID, null);
                        currentOT.setAD_User_ID(this.m_AD_User_ID);
                        currentOT.save();
                    }
                    ++i;
                }
                this.loadMPs();
            }
        } else if (e.getTarget().equals(this.selectall)) {
            ListModelTable ot = this.otTable.getModel();
            int rows = ot.getRowCount();
            int i = 0;
            while (i < rows) {
                if (this.m_A_Asset_ID == 0) {
                    ot.setValueAt((Object)this.selectall.isSelected(), i, 0);
                } else {
                    KeyNamePair pp = (KeyNamePair)ot.getValueAt(i, 6);
                    int Asset_ID = pp.getKey();
                    if (Asset_ID == this.m_A_Asset_ID) {
                        ot.setValueAt((Object)this.selectall.isSelected(), i, 0);
                    }
                }
                ++i;
            }
        }
    }

    public void tableChanged(WTableModelEvent e) {
        boolean isUpdate;
        boolean bl = isUpdate = e.getType() == 0;
        if (!isUpdate) {
            this.calculate();
            return;
        }
        if (this.m_calculating) {
            return;
        }
        this.m_calculating = true;
        this.m_calculating = false;
        this.calculate();
    }

    private void calculate() {
        log.config("");
    }

    public void valueChange(ValueChangeEvent e) {
        String name = e.getPropertyName();
        Object value = e.getNewValue();
        log.config(String.valueOf(name) + "=" + value);
        if (name.equals("A_Asset_ID")) {
            this.assetSearch.setValue(value);
            this.m_A_Asset_ID = (Integer)value;
        } else if (name.equals("AD_User_ID")) {
            this.userSearch.setValue(value);
            this.m_AD_User_ID = (Integer)value;
        }
    }

    private void saveData() {
        ListModelTable ot = this.otTable.getModel();
        int rows = ot.getRowCount();
        int i = 0;
        while (i < rows) {
            if (((Boolean)ot.getValueAt(i, 0)).booleanValue()) {
                KeyNamePair pp = (KeyNamePair)ot.getValueAt(i, 3);
                int OT_ID = pp.getKey();
                try {
                    X_MP_OT currentOT = new X_MP_OT(Env.getCtx(), OT_ID, null);
                    MDocType doc = new MDocType(Env.getCtx(), currentOT.getC_DocType_ID(), null);
                    int AD_PrintFormat_ID = doc.getAD_PrintFormat_ID();
                    int C_BPartner_ID = 0;
                    String DocumentNo = currentOT.getDocumentNo();
                    int copies = 1;
                    MPrintFormat format = MPrintFormat.get(Env.getCtx(), AD_PrintFormat_ID, false);
                    MQuery query = new MQuery("MP_OT");
                    query.addRestriction("MP_OT_ID", "=", new Integer(OT_ID));
                    PrintInfo info = new PrintInfo(DocumentNo, X_MP_OT.Table_ID, OT_ID, C_BPartner_ID);
                    info.setCopies(copies);
                    info.setDocumentCopy(false);
                    info.setPrinterName(format.getPrinterName());
                    ReportEngine re = new ReportEngine(Env.getCtx(), format, query, info, null);
                    ReportViewerProvider provider = ReportCtl.getReportViewerProvider();
                    provider.openViewer(re);
                }
                catch (Exception e) {
                    FDialog.warn((int)this.form.getWindowNo(), (String)"No se Encuetra bien definido el formato de impresion");
                }
            }
            ++i;
        }
        this.loadMPs();
    }

    public ADForm getForm() {
        return this.form;
    }
}

