/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.form;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Vector;
import java.util.logging.Level;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListModelTable;
import org.adempiere.webui.component.ListboxFactory;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.WListbox;
import org.adempiere.webui.editor.WDateEditor;
import org.adempiere.webui.editor.WSearchEditor;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.event.WTableModelEvent;
import org.adempiere.webui.event.WTableModelListener;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.panel.CustomForm;
import org.adempiere.webui.panel.IFormController;
import org.adempiere.webui.panel.StatusBarPanel;
import org.compiere.model.Lookup;
import org.compiere.model.MColumn;
import org.compiere.model.MDocType;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.X_MP_Maintain;
import org.compiere.model.X_MP_OT;
import org.compiere.model.X_MP_OT_Resource;
import org.compiere.model.X_MP_OT_Task;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zkex.zul.Borderlayout;
import org.zkoss.zkex.zul.Center;
import org.zkoss.zkex.zul.North;
import org.zkoss.zkex.zul.South;
import org.zkoss.zul.Separator;

public class WMPGenerateOT
implements IFormController,
EventListener,
WTableModelListener,
ValueChangeListener {
    private static final long serialVersionUID = -5322824600164192235L;
    private CustomForm form = new CustomForm();
    private int m_WindowNo = 0;
    private static CLogger log = CLogger.getCLogger(WMPGenerateOT.class);
    private boolean m_calculating = false;
    private int m_C_Currency_ID = 0;
    private Panel parameterPanel = new Panel();
    private Grid parameterLayout = GridFactory.newGridLayout();
    private Borderlayout mainLayout = new Borderlayout();
    private Panel allocationPanel = new Panel();
    private WListbox selectedTable = ListboxFactory.newDataTable();
    private WListbox prognosisTable = ListboxFactory.newDataTable();
    private Panel infoPanel = new Panel();
    private int m_A_Asset_ID = 0;
    private Panel prognosisPanel = new Panel();
    private Panel selectedPanel = new Panel();
    private Label prognosisLabel = new Label();
    private Label selectedLabel = new Label();
    private Borderlayout prognosisLayout = new Borderlayout();
    private Borderlayout selectedLayout = new Borderlayout();
    private Label prognosisInfo = new Label();
    private Label invoiceInfo = new Label();
    private Grid allocationLayout = GridFactory.newGridLayout();
    private Button ProcessButton = new Button();
    private Button searchButton = new Button();
    private Button addButton = new Button();
    private Button EnableButton = new Button();
    private Button ChangeButton = new Button();
    private Label assetLabel = new Label();
    private Checkbox selectall = new Checkbox();
    private Label allocCurrencyLabel = new Label();
    private StatusBarPanel statusBar = new StatusBarPanel();
    private Label dateLabel = new Label();
    private WDateEditor dateField = new WDateEditor();
    private WSearchEditor assetSearch = null;
    private Panel southPanel = new Panel();

    public WMPGenerateOT() {
        Env.setContext(Env.getCtx(), this.m_WindowNo, "IsSOTrx", "Y");
        this.m_C_Currency_ID = Env.getContextAsInt(Env.getCtx(), "$C_Currency_ID");
        log.info("Currency=" + this.m_C_Currency_ID);
        try {
            this.dynInit();
            this.zkInit();
            this.southPanel.appendChild((Component)new Separator());
            this.southPanel.appendChild((Component)this.statusBar);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    private void zkInit() throws Exception {
        this.form.appendChild((Component)this.mainLayout);
        this.mainLayout.setWidth("99%");
        this.mainLayout.setHeight("100%");
        this.dateLabel.setText(Msg.getMsg(Env.getCtx(), "Date"));
        this.parameterPanel.appendChild((Component)this.parameterLayout);
        this.allocationPanel.appendChild((Component)this.allocationLayout);
        this.prognosisLabel.setText(Msg.translate(Env.getCtx(), "List of Mps"));
        this.prognosisPanel.appendChild((Component)this.prognosisLayout);
        this.selectedPanel.appendChild((Component)this.selectedLayout);
        this.invoiceInfo.setText(".");
        this.prognosisInfo.setText(".");
        this.ProcessButton.setLabel(Msg.getMsg(Env.getCtx(), "Generate OT"));
        this.ProcessButton.addActionListener((EventListener)this);
        this.searchButton.setLabel(Msg.getMsg(Env.getCtx(), "Search"));
        this.searchButton.addActionListener((EventListener)this);
        this.addButton.setLabel(Msg.getMsg(Env.getCtx(), "Add Selected"));
        this.addButton.addActionListener((EventListener)this);
        this.EnableButton.setLabel(Msg.getMsg(Env.getCtx(), "Enable Editing"));
        this.EnableButton.addActionListener((EventListener)this);
        this.ChangeButton.setLabel(Msg.getMsg(Env.getCtx(), "Apply Date"));
        this.ChangeButton.addActionListener((EventListener)this);
        this.assetLabel.setText(Msg.translate(Env.getCtx(), "A_Asset_ID"));
        this.selectall.setText(Msg.getMsg(Env.getCtx(), "Select All"));
        this.selectall.addActionListener((EventListener)this);
        this.allocCurrencyLabel.setText(".");
        North north = new North();
        north.setStyle("border: none");
        this.mainLayout.appendChild((Component)north);
        north.appendChild((Component)this.parameterPanel);
        Rows rows = null;
        Row row = null;
        this.parameterLayout.setWidth("800px");
        rows = this.parameterLayout.newRows();
        row = rows.newRow();
        row.appendChild(this.dateLabel.rightAlign());
        row.appendChild((Component)this.dateField.getComponent());
        row.appendChild((Component)this.ChangeButton);
        row.appendChild((Component)this.selectall);
        row.appendChild(this.assetLabel.rightAlign());
        row.appendChild((Component)this.assetSearch.getComponent());
        South south = new South();
        south.setStyle("border: none");
        this.mainLayout.appendChild((Component)south);
        south.appendChild((Component)this.southPanel);
        this.southPanel.appendChild((Component)this.allocationPanel);
        this.allocationPanel.appendChild((Component)this.allocationLayout);
        this.allocationLayout.setWidth("400px");
        rows = this.allocationLayout.newRows();
        row = rows.newRow();
        row.appendChild((Component)this.ProcessButton);
        this.prognosisPanel.appendChild((Component)this.prognosisLayout);
        this.prognosisPanel.setWidth("100%");
        this.prognosisPanel.setHeight("100%");
        this.prognosisLayout.setWidth("100%");
        this.prognosisLayout.setHeight("100%");
        this.prognosisLayout.setStyle("border: none");
        north = new North();
        north.setStyle("border: none");
        this.prognosisLayout.appendChild((Component)north);
        north.appendChild((Component)this.prognosisLabel);
        south = new South();
        south.setStyle("border: none");
        this.prognosisLayout.appendChild((Component)south);
        south.appendChild(this.prognosisInfo.rightAlign());
        Center center = new Center();
        this.prognosisLayout.appendChild((Component)center);
        center.appendChild((Component)this.prognosisTable);
        this.prognosisTable.setWidth("99%");
        this.prognosisTable.setHeight("99%");
        center.setStyle("border: none");
        center = new Center();
        center.setFlex(true);
        this.mainLayout.appendChild((Component)center);
        center.appendChild((Component)this.prognosisPanel);
    }

    private void dynInit() throws Exception {
        int AD_Column_ID = MColumn.getColumn_ID("MP_Maintain", "A_Asset_ID");
        MLookup lookupBP = MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, AD_Column_ID, 30);
        this.assetSearch = new WSearchEditor("A_Asset_ID", true, false, true, (Lookup)lookupBP);
        this.assetSearch.addValueChangeListener((ValueChangeListener)this);
        this.dateField.setValue((Object)Env.getContextAsDate(Env.getCtx(), "#Date"));
        this.statusBar.setStatusLine("Selezionare Documenti, Variare la data o Generare Ordini Direttamente");
        this.statusBar.setStatusDB("");
        this.loadMPs();
    }

    private void loadMPs() {
        Vector data = new Vector();
        StringBuffer sql = new StringBuffer("select p.AD_PINSTANCE_ID,p.AD_CLIENT_ID,p.AD_ORG_ID,p.A_ASSET_ID,p.MP_MAINTAIN_ID,p.DESCRIPTION,p.PROGRAMMINGTYPE,p.CICLO,p.DATETRX,mp.DOCUMENTNO||'-'||mp.Description as MP_name,a.name as assetname   from MP_Prognosis p Inner Join MP_MainTain mp on (p.MP_MAINTAIN_ID=mp.MP_MAINTAIN_ID) Inner Join A_Asset a on (p.A_ASSET_ID=a.A_ASSET_ID) where p.Processed='N' and p.Selected='N'  order by p.DATETRX asc");
        log.config("Prognosis=" + sql.toString());
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Vector<Object> line = new Vector<Object>();
                line.add(new Boolean(false));
                line.add(rs.getInt(8));
                line.add(rs.getTimestamp(9));
                KeyNamePair pp = new KeyNamePair(rs.getInt(4), rs.getString(11));
                line.add(pp);
                KeyNamePair pp2 = new KeyNamePair(rs.getInt(5), rs.getString(10));
                line.add(pp2);
                line.add(rs.getString(7));
                line.add(rs.getString(6));
                data.add(line);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), e);
        }
        this.prognosisTable.clear();
        this.prognosisTable.getModel().removeTableModelListener((WTableModelListener)this);
        Vector<String> columnNames = new Vector<String>();
        columnNames.add("Selezione");
        columnNames.add(Msg.getMsg(Env.getCtx(), "Ciclo"));
        columnNames.add(Msg.translate(Env.getCtx(), "Date"));
        columnNames.add(Util.cleanAmp(Msg.translate(Env.getCtx(), "Asset")));
        columnNames.add(Msg.getMsg(Env.getCtx(), "MP"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Programing Type"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Description"));
        ListModelTable modelP = new ListModelTable(data);
        modelP.addTableModelListener((WTableModelListener)this);
        this.prognosisTable.setData(modelP, columnNames);
        int i = 0;
        this.prognosisTable.setColumnClass(i++, Boolean.class, false);
        this.prognosisTable.setColumnClass(i++, Integer.class, true);
        this.prognosisTable.setColumnClass(i++, Timestamp.class, true);
        this.prognosisTable.setColumnClass(i++, String.class, true);
        this.prognosisTable.setColumnClass(i++, String.class, true);
        this.prognosisTable.setColumnClass(i++, String.class, true);
        this.prognosisTable.setColumnClass(i++, String.class, true);
        this.prognosisTable.autoSize();
        this.prognosisTable.setColumnReadOnly(1, false);
        this.calculate();
    }

    public void onEvent(Event e) {
        block7: {
            block9: {
                block8: {
                    block6: {
                        log.config("");
                        if (!e.getTarget().equals(this.ProcessButton)) break block6;
                        this.saveData();
                        break block7;
                    }
                    if (!e.getTarget().equals(this.EnableButton)) break block8;
                    this.prognosisTable.setColumnReadOnly(1, false);
                    this.prognosisTable.setColumnReadOnly(2, false);
                    this.prognosisTable.setColumnReadOnly(3, false);
                    break block7;
                }
                if (!e.getTarget().equals(this.ChangeButton)) break block9;
                this.ProcessButton.setEnabled(true);
                int rows = this.prognosisTable.getRowCount();
                Timestamp DateTrx = (Timestamp)this.dateField.getValue();
                int i = 0;
                while (i < rows) {
                    if (((Boolean)this.prognosisTable.getValueAt(i, 0)).booleanValue()) {
                        this.prognosisTable.setValueAt((Object)DateTrx, i, 2);
                    }
                    ++i;
                }
                break block7;
            }
            if (!e.getTarget().equals(this.selectall)) break block7;
            int rows = this.prognosisTable.getRowCount();
            int i = 0;
            while (i < rows) {
                if (this.m_A_Asset_ID == 0) {
                    this.prognosisTable.setValueAt((Object)this.selectall.isSelected(), i, 0);
                } else {
                    KeyNamePair pp = (KeyNamePair)this.prognosisTable.getValueAt(i, 3);
                    int Asset_ID = pp.getKey();
                    if (Asset_ID == this.m_A_Asset_ID) {
                        this.prognosisTable.setValueAt((Object)this.selectall.isSelected(), i, 0);
                    }
                }
                ++i;
            }
        }
    }

    public void tableChanged(WTableModelEvent e) {
        boolean isUpdate;
        boolean bl = isUpdate = e.getType() == 0;
        if (!isUpdate) {
            this.calculate();
            return;
        }
        if (this.m_calculating) {
            return;
        }
        this.m_calculating = true;
        this.m_calculating = false;
        this.calculate();
    }

    private void calculate() {
        log.config("");
    }

    public void valueChange(ValueChangeEvent e) {
        String name = e.getPropertyName();
        Object value = e.getNewValue();
        log.config(String.valueOf(name) + "=" + value);
        if (name.equals("A_Asset_ID")) {
            this.assetSearch.setValue(value);
            if (value != null) {
                this.m_A_Asset_ID = (Integer)value;
            }
        }
    }

    private void saveData() {
        ListModelTable prognosis = this.prognosisTable.getModel();
        int rows = prognosis.getRowCount();
        int i = 0;
        while (i < rows) {
            if (((Boolean)prognosis.getValueAt(i, 0)).booleanValue()) {
                KeyNamePair pp = (KeyNamePair)prognosis.getValueAt(i, 4);
                int MP_ID = pp.getKey();
                pp = (KeyNamePair)prognosis.getValueAt(i, 3);
                int Asset_ID = pp.getKey();
                Timestamp Datetrx = (Timestamp)prognosis.getValueAt(i, 2);
                String description = (String)prognosis.getValueAt(i, 6);
                int ciclo = (Integer)prognosis.getValueAt(i, 1);
                String ProgramingType = (String)prognosis.getValueAt(i, 5);
                if (!this.createOT(MP_ID, Datetrx, description, Asset_ID)) {
                    log.log(Level.SEVERE, "OT not created #" + i);
                } else {
                    this.updateMP(MP_ID, Datetrx, description);
                    String sql = "Update MP_Prognosis set Processed='Y' where ciclo=" + ciclo + " and MP_MAINTAIN_ID=" + MP_ID + " and A_Asset_ID=" + Asset_ID + " and PROGRAMMINGTYPE='" + ProgramingType + "'";
                    DB.executeUpdate(sql);
                }
            }
            ++i;
        }
        this.loadMPs();
    }

    public boolean createOT(int MP_ID, Timestamp Datetrx, String description, int Asset_ID) {
        X_MP_OT newOT = new X_MP_OT(Env.getCtx(), 0, null);
        newOT.setDateTrx(Datetrx);
        newOT.setDescription(description);
        newOT.setA_Asset_ID(Asset_ID);
        newOT.setMP_Maintain_ID(MP_ID);
        newOT.setDocStatus("DR");
        newOT.setDocAction("CO");
        newOT.setC_DocType_ID(MDocType.getOfDocBaseType(Env.getCtx(), "MOF")[0].getC_DocType_ID());
        if (!newOT.save()) {
            return false;
        }
        if (!this.createOTTaskDetail(MP_ID, newOT)) {
            return false;
        }
        String sql = "select mp_maintain_id from mp_maintain where ischild='Y' and MP_MAINTAINPARENT_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, MP_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                this.createOTTaskDetail(rs.getInt(1), newOT);
                this.lookChilds(rs.getInt(1), newOT);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
        }
        return true;
    }

    public void lookChilds(int MP_ID, X_MP_OT OT) {
        String sql = "select mp_maintain_id from mp_maintain where ischild='Y' and MP_MAINTAINPARENT_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, MP_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                this.createOTTaskDetail(rs.getInt(1), OT);
                this.lookChilds(rs.getInt(1), OT);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
        }
    }

    public boolean createOTTaskDetail(int MP_ID, X_MP_OT OT) {
        String sql = "select * from MP_MAINTAIN_TASK where MP_MAINTAIN_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, MP_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                X_MP_OT_Task ta = new X_MP_OT_Task(Env.getCtx(), 0, null);
                ta.setMP_Maintain_ID(MP_ID);
                ta.setAD_Org_ID(rs.getInt("AD_Org_ID"));
                ta.setMP_OT_ID(OT.getMP_OT_ID());
                ta.setDescription(rs.getString("Description"));
                ta.setDuration(rs.getBigDecimal("Duration"));
                ta.setC_UOM_ID(rs.getInt("C_UOM_ID"));
                ta.setStatus("NS");
                ta.saveEx();
                this.createOTResourceDetail(rs.getInt("MP_MAINTAIN_TASK_ID"), ta.getMP_OT_Task_ID());
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
        }
        this.updateMP(MP_ID, OT.getDateTrx(), OT.getDescription());
        return true;
    }

    public boolean createOTResourceDetail(int oldTask_ID, int newTask_ID) {
        String sql = "select * from MP_MAINTAIN_RESOURCE where MP_MAINTAIN_TASK_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, oldTask_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                X_MP_OT_Resource re = new X_MP_OT_Resource(Env.getCtx(), 0, null);
                re.setAD_Org_ID(rs.getInt("AD_Org_ID"));
                re.setMP_OT_Task_ID(newTask_ID);
                re.setCostAmt(rs.getBigDecimal("CostAmt"));
                re.setS_Resource_ID(rs.getInt("S_Resource_ID"));
                re.setM_BOM_ID(rs.getInt("M_BOM_ID"));
                re.setResourceQty(rs.getBigDecimal("RESOURCEQTY"));
                re.setResourceType(rs.getString("RESOURCETYPE"));
                re.set_ValueOfColumn("M_Product_ID", (Object)rs.getInt("M_Product_ID"));
                re.saveEx();
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
        }
        return true;
    }

    public void updateMP(int MP_ID, Timestamp Datetrx, String description) {
        X_MP_Maintain mp = new X_MP_Maintain(Env.getCtx(), MP_ID, null);
        mp.setdatelastrunmp(Datetrx);
        mp.setDateLastRun(Datetrx);
        if (mp.getProgrammingType().equals("C")) {
            mp.setDateNextRun(new Timestamp(Datetrx.getTime() + mp.getInterval().longValue() * 86400000L));
        } else {
            mp.setnextmp(mp.getInterval().add(mp.getlastmp()).setScale(2, 6));
            mp.setlastmp(new BigDecimal(Float.parseFloat(description.split(":")[description.split(":").length - 1].replace(',', '.'))).setScale(2, 6));
        }
        mp.save();
    }

    public ADForm getForm() {
        return this.form;
    }
}

