/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process.rpl.imp;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.xml.xpath.XPathExpressionException;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.process.rpl.XMLHelper;
import org.adempiere.process.rpl.exp.ExportHelper;
import org.compiere.model.MClient;
import org.compiere.model.MColumn;
import org.compiere.model.MEXPFormat;
import org.compiere.model.MEXPFormatLine;
import org.compiere.model.MReplicationStrategy;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.DocAction;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ImportHelper {
    private CLogger log = CLogger.getCLogger(ImportHelper.class);
    private static CLogger s_log = CLogger.getCLogger(ImportHelper.class);
    private SimpleDateFormat m_customDateFormat = null;
    boolean isChanged = false;
    private Properties ctx = null;

    public ImportHelper(Properties ctx) {
        this.ctx = ctx;
    }

    public void importXMLDocument(StringBuffer result, Document documentToBeImported, String trxName) throws Exception, SQLException, XPathExpressionException {
        Element rootElement = documentToBeImported.getDocumentElement();
        String AD_Client_Value = null;
        AD_Client_Value = rootElement.getAttribute("AD_Client_Value");
        this.log.info("AD_Client_Value = " + AD_Client_Value);
        if (AD_Client_Value == null || Util.isEmpty(AD_Client_Value)) {
            throw new Exception(Msg.getMsg(this.ctx, "XMLClientValueMandatory"));
        }
        String version = null;
        version = rootElement.getAttribute("Version");
        this.log.info("Version = " + version);
        if (version == null || Util.isEmpty(version)) {
            throw new Exception(Msg.getMsg(this.ctx, "XMLVersionAttributeMandatory"));
        }
        int ReplicationMode2 = new Integer(rootElement.getAttribute("ReplicationMode"));
        String ReplicationType = rootElement.getAttribute("ReplicationType");
        int ReplicationEvent = new Integer(rootElement.getAttribute("ReplicationEvent"));
        MClient client = null;
        client = ImportHelper.getAD_ClientByValue(this.ctx, AD_Client_Value, trxName);
        if (client == null) {
            throw new Exception(Msg.getMsg(this.ctx, "XMLClientNotFound"));
        }
        this.log.info(client.toString());
        String EXP_Format_Value = null;
        EXP_Format_Value = rootElement.getNodeName();
        this.log.info("EXP_Format_Value = " + EXP_Format_Value);
        MEXPFormat expFormat = null;
        expFormat = MEXPFormat.getFormatByValueAD_Client_IDAndVersion(this.ctx, EXP_Format_Value, client.getAD_Client_ID(), version, trxName);
        if (expFormat == null || expFormat.getEXP_Format_ID() == 0) {
            MClient systemClient = null;
            systemClient = MClient.get(this.ctx, 0);
            if (systemClient == null) {
                throw new Exception(Msg.getMsg(this.ctx, "XMLClientNotFound"));
            }
            this.log.info(systemClient.toString());
            expFormat = MEXPFormat.getFormatByValueAD_Client_IDAndVersion(this.ctx, EXP_Format_Value, systemClient.getAD_Client_ID(), version, trxName);
        }
        if (expFormat == null || expFormat.getEXP_Format_ID() == 0) {
            throw new Exception(Msg.getMsg(this.ctx, "EXPFormatNotFound"));
        }
        this.log.info("expFormat = " + expFormat.toString());
        this.isChanged = false;
        PO po = this.importElement(this.ctx, result, rootElement, expFormat, ReplicationType, trxName);
        if (!po.is_Changed() && !this.isChanged) {
            this.log.info("Object not changed = " + po.toString());
            return;
        }
        if (po != null) {
            Env.setContext(po.getCtx(), "#AD_Client_ID", po.getAD_Client_ID());
            if (0 == ReplicationMode2) {
                if (3 == ReplicationEvent || 9 == ReplicationEvent || 3 == ReplicationEvent) {
                    po.deleteEx(true);
                } else if ("B".equals(ReplicationType)) {
                    MReplicationStrategy rplStrategy = new MReplicationStrategy(client.getCtx(), client.getAD_ReplicationStrategy_ID(), po.get_TrxName());
                    ExportHelper expHelper = new ExportHelper(client, rplStrategy);
                    expHelper.exportRecord(po, 0, "M", 5);
                    po.saveReplica(true);
                } else if ("M".equals(ReplicationType) || "R".equals(ReplicationType)) {
                    po.saveReplica(true);
                } else if (!"L".equals(ReplicationType)) {
                    throw new Exception(Msg.getMsg(this.ctx, "EXPReplicationTypeNonValidType"));
                }
            } else if (1 == ReplicationMode2 && "M".equals(ReplicationType) && po instanceof DocAction) {
                DocAction document = (DocAction)((Object)po);
                String action = document.getDocAction();
                String status = document.getDocStatus();
                this.log.info("Document:" + document.toString() + " DocStauts:" + status + " DocAction:" + action);
                if (13 == ReplicationEvent && status.equals("RE") && action.equals("--")) {
                    po.saveEx();
                    return;
                }
                if (action.equals("CO") && status.equals("IP") || action.equals("CL") && status.equals("CO")) {
                    if (!document.processIt(action)) {
                        this.log.info("PO.toString() = can not " + po.get_Value("DocAction"));
                    }
                    po.saveEx();
                } else {
                    po.saveEx();
                    return;
                }
            }
        }
        result.append("Save Successful ;");
    }

    private PO importElement(Properties ctx, StringBuffer result, Element rootElement, MEXPFormat expFormat, String ReplicationType, String trxName) throws Exception, XPathExpressionException {
        PO po = this.getObjectFromFormat(ctx, expFormat, rootElement, rootElement.getNodeName(), trxName);
        if (po == null) {
            throw new Exception(Msg.getMsg(ctx, "Can't Load PO Object"));
        }
        if ("R".equals(ReplicationType) && po.get_ID() == 0) {
            return null;
        }
        this.log.info("PO.toString() = " + po.toString());
        if (po.get_KeyColumns().length < 1) {
            throw new Exception(Msg.getMsg(ctx, "EDIMultiColumnNotSupported"));
        }
        List<MEXPFormatLine> formatLines = expFormat.getFormatLinesOrderedBy("IsMandatory , Position");
        if (formatLines == null || formatLines.size() < 1) {
            throw new Exception(Msg.getMsg(ctx, "EXPFormatNoLines"));
        }
        for (MEXPFormatLine formatLine : formatLines) {
            this.log.info("=================== Beginnig of Format Line ===============================");
            this.log.info("formatLine: [" + formatLine.toString() + "]");
            Object value = this.getValueFromFormat(formatLine, po, rootElement, result, ReplicationType);
            if (value == null || value.toString().equals("")) continue;
            this.setReplicaValues(value, formatLine, po, result);
        }
        return po;
    }

    private Object getValueFromFormat(MEXPFormatLine line, PO po, Element rootElement, StringBuffer result, String ReplicationType) throws Exception {
        Object value = null;
        if ("E".equals(line.getType())) {
            value = XMLHelper.getString(line.getValue(), rootElement);
            this.log.info("value=[" + value + "]");
        } else if ("R".equals(line.getType())) {
            MEXPFormat referencedExpFormat = MEXPFormat.get(this.ctx, line.getEXP_EmbeddedFormat_ID(), po.get_TrxName());
            this.log.info("referencedExpFormat = " + referencedExpFormat);
            int refRecord_ID = 0;
            String xPath = null;
            xPath = "" + line.getValue() + "";
            this.log.info("Seach for XML Element = " + xPath);
            Element referencedNode = XMLHelper.getElement(xPath, rootElement);
            this.log.info("referencedNode = " + referencedNode);
            if (referencedNode != null) {
                refRecord_ID = this.getID(this.ctx, referencedExpFormat, referencedNode, line.getValue(), po.get_TrxName());
                this.log.info("refRecord_ID = " + refRecord_ID);
                value = new Integer(refRecord_ID);
            } else {
                this.log.info("NULL VALUE FOR " + xPath.toString());
                value = null;
            }
            this.log.info("value=[" + value + "]");
        } else if ("M".equals(line.getType())) {
            if (!po.is_Changed()) {
                return value;
            }
            this.isChanged = true;
            po.saveReplica(true);
            MEXPFormat referencedExpFormat = MEXPFormat.get(this.ctx, line.getEXP_EmbeddedFormat_ID(), po.get_TrxName());
            this.log.info("embeddedExpFormat = " + referencedExpFormat);
            NodeList nodeList = XMLHelper.getNodeList("/" + rootElement.getNodeName() + "/" + line.getValue(), rootElement);
            for (int j = 0; j < nodeList.getLength(); ++j) {
                Element referencedElement = (Element)nodeList.item(j);
                this.log.info("EmbeddedEXPFormat - referencedElement.getNodeName = " + referencedElement.getNodeName());
                PO embeddedPo = null;
                this.log.info("=== BEGIN RECURSION CALL ===");
                embeddedPo = this.importElement(this.ctx, result, referencedElement, referencedExpFormat, ReplicationType, po.get_TrxName());
                this.log.info("embeddedPo = " + embeddedPo);
                if (!embeddedPo.is_Changed()) {
                    this.log.info("Object not changed = " + po.toString());
                    continue;
                }
                embeddedPo.saveReplica(true);
                this.isChanged = true;
                result.append(" Embedded Save Successful ; ");
            }
        } else if ("A".equals(line.getType())) {
            value = XMLHelper.getString("@" + line.getValue(), rootElement);
            this.log.info("value=[" + value + "]");
        } else {
            throw new Exception(Msg.getMsg(this.ctx, "EXPFormatLineNonValidType"));
        }
        return value;
    }

    private void setReplicaValues(Object value, MEXPFormatLine line, PO po, StringBuffer result) throws Exception {
        MColumn column = MColumn.get(this.ctx, line.getAD_Column_ID());
        this.log.info("column=[" + column + "]");
        if (value != null && !"M".equals(line.getType())) {
            Class clazz = DisplayType.getClass(column.getAD_Reference_ID(), true);
            if (column.getColumnName().equalsIgnoreCase("Posted") || column.getColumnName().equalsIgnoreCase("Processed") || column.getColumnName().equalsIgnoreCase("Processing")) {
                clazz = Boolean.class;
            } else if (column.getColumnName().equalsIgnoreCase("Record_ID")) {
                clazz = Integer.class;
            } else if (column.getColumnName().equalsIgnoreCase("AD_Language") || column.getColumnName().equalsIgnoreCase("EntityType")) {
                clazz = String.class;
            }
            this.log.info("clazz = " + clazz.getName());
            value = this.handleDateTime(value, column, line);
            this.log.info("formatLinesType = " + line.getType());
            if ("M".equals(line.getType())) {
                throw new Exception("We can't be here!!!");
            }
            if (16 == column.getAD_Reference_ID() || 15 == column.getAD_Reference_ID()) {
                po.set_ValueOfColumn(line.getAD_Column_ID(), value);
                this.log.info("Set value of column [" + column.getColumnName() + "]=[" + value + "]");
            } else if (DisplayType.isID(column.getAD_Reference_ID()) || 11 == column.getAD_Reference_ID()) {
                if (!Util.isEmpty(value.toString())) {
                    int intValue = Integer.parseInt(value.toString());
                    value = new Integer(intValue);
                } else {
                    value = null;
                }
                this.log.info("About to set int value of column [" + column.getColumnName() + "]=[" + value + "]");
                po.set_ValueOfColumn(line.getAD_Column_ID(), value);
                this.log.info("Set int value of column [" + column.getColumnName() + "]=[" + value + "]");
            } else if (DisplayType.isNumeric(column.getAD_Reference_ID()) && column.getAD_Reference_ID() != 11) {
                value = !Util.isEmpty(value.toString()) ? new BigDecimal(value.toString()) : null;
                this.log.info("About to set BigDecimal value of column [" + column.getColumnName() + "]=[" + value + "]");
                po.set_ValueOfColumn(line.getAD_Column_ID(), value);
                this.log.info("Set BigDecimal value of column [" + column.getColumnName() + "]=[" + value + "]");
            } else if (20 == column.getAD_Reference_ID()) {
                if (clazz == Boolean.class) {
                    String v = value.toString().equals("true") ? "Y" : "N";
                    po.set_ValueOfColumn(line.getAD_Column_ID(), (Object)v);
                }
            } else {
                try {
                    this.log.info("About to set value of column [" + column.getColumnName() + "]=[" + value + "]");
                    if (clazz == Boolean.class) {
                        String v = value.toString().equals("true") ? "Y" : "N";
                        po.set_ValueOfColumn(line.getAD_Column_ID(), (Object)v);
                    } else {
                        po.set_ValueOfColumn(line.getAD_Column_ID(), clazz.cast(value));
                    }
                    this.log.info("Set value of column [" + column.getColumnName() + "]=[" + value + "]");
                }
                catch (ClassCastException ex) {
                    ex.printStackTrace();
                    throw new Exception(ex);
                }
            }
            result.append(column.getColumnName()).append("=").append(value).append("; ");
        }
    }

    public static MClient getAD_ClientByValue(Properties ctx, String value, String trxName) throws SQLException {
        String whereClause = "Value= ? ";
        MClient result = (MClient)new Query(ctx, "AD_Client", "Value= ? ", trxName).setParameters(value).firstOnly();
        s_log.info("Client_Value =[" + value + "]");
        if (result != null) {
            s_log.info("AD_Client_ID = " + result.getAD_Client_ID());
        }
        return result;
    }

    private PO getObjectFromFormat(Properties ctx, MEXPFormat expFormat, Element rootElement, String rootNodeName, String trxName) throws Exception {
        Collection<MEXPFormatLine> uniqueFormatLines;
        List values = null;
        if (expFormat == null || rootElement == null || rootNodeName == null) {
            throw new IllegalArgumentException("expFormat, rootNode and RootnodeName can't be null!");
        }
        this.log.info("expFormat = " + expFormat);
        this.log.info("rootNode.getNodeName() = " + rootElement.getNodeName());
        this.log.info("rootNodeName = " + rootNodeName);
        if (rootElement.getParentNode() != null) {
            this.log.info("rootNode.ParentName = " + rootElement.getParentNode().getNodeName());
        }
        if ((uniqueFormatLines = expFormat.getUniqueColumns()) == null || uniqueFormatLines.size() < 1) {
            throw new AdempiereException(Msg.getMsg(ctx, "EXPFormatLineNoUniqueColumns"));
        }
        int replication_id = 0;
        Object[] cols = new Object[uniqueFormatLines.size()];
        Object[] params = new Object[uniqueFormatLines.size()];
        StringBuffer whereClause = new StringBuffer("");
        int col = 0;
        String formatLines = "";
        for (MEXPFormatLine uniqueFormatLine : uniqueFormatLines) {
            Object value;
            MColumn column = MColumn.get(ctx, uniqueFormatLine.getAD_Column_ID());
            this.log.info("column = [" + column + "]");
            String valuecol = column.getColumnName();
            formatLines = formatLines + "|" + valuecol;
            if ("E".equals(uniqueFormatLine.getType())) {
                String xPath = null;
                xPath = "" + uniqueFormatLine.getValue();
                cols[col] = XMLHelper.getString(xPath, rootElement);
                this.log.info("values[" + col + "]=" + cols[col]);
            } else if ("R".equals(uniqueFormatLine.getType())) {
                this.log.info("referencedExpFormat.EXP_EmbeddedFormat_ID = " + uniqueFormatLine.getEXP_EmbeddedFormat_ID());
                MEXPFormat referencedExpFormat = MEXPFormat.get(ctx, uniqueFormatLine.getEXP_EmbeddedFormat_ID(), trxName);
                this.log.info("referencedExpFormat = " + referencedExpFormat);
                int record_ID = 0;
                Element referencedNode = (Element)rootElement.getElementsByTagName(uniqueFormatLine.getValue()).item(0);
                this.log.info("referencedNode = " + referencedNode);
                if (referencedNode == null) {
                    throw new IllegalArgumentException("referencedNode can't be found!");
                }
                record_ID = this.getID(ctx, referencedExpFormat, referencedNode, uniqueFormatLine.getValue(), trxName);
                this.log.info("record_ID = " + record_ID);
                cols[col] = new Integer(record_ID);
            } else {
                throw new Exception(Msg.getMsg(ctx, "EXPFormatLineNonValidType"));
            }
            if (16 == column.getAD_Reference_ID() || 15 == column.getAD_Reference_ID()) {
                params[col] = value = (Timestamp)this.handleDateTime(cols[col], column, uniqueFormatLine);
            } else if (column.getAD_Reference_ID() == 10) {
                params[col] = (String)cols[col];
            } else if (DisplayType.isID(column.getAD_Reference_ID()) || 11 == column.getAD_Reference_ID()) {
                value = cols[col];
                if (!Util.isEmpty(value.toString())) {
                    value = new Integer(value.toString());
                    if (13 == column.getAD_Reference_ID()) {
                        replication_id = (Integer)value;
                    }
                } else {
                    value = null;
                }
                params[col] = value;
            } else if (DisplayType.isNumeric(column.getAD_Reference_ID())) {
                valuecol = "Round(" + valuecol + ",2)";
                params[col] = new BigDecimal((String)cols[col]).setScale(2, 4);
            } else {
                params[col] = cols[col];
            }
            if (col == 0) {
                whereClause.append(" ").append(valuecol).append(" = ? ");
            } else {
                whereClause.append(" AND ").append(valuecol).append(" = ? ");
            }
            ++col;
        }
        Query query = new Query(ctx, MTable.get(ctx, expFormat.getAD_Table_ID()), whereClause.toString(), trxName).setParameters(params);
        values = query.list();
        if (values.size() > 1) {
            throw new AdempiereException(Msg.getMsg(ctx, "EXPFormatLineNoUniqueColumns") + " : " + expFormat.getName() + "(" + formatLines + ")");
        }
        if (values.size() <= 0) {
            PO po = MTable.get(ctx, expFormat.getAD_Table_ID()).getPO(0, trxName);
            if (replication_id > 0) {
                po.set_CustomColumn(po.get_KeyColumns()[0], replication_id);
            }
            return po;
        }
        return (PO)values.get(0);
    }

    private int getID(Properties ctx, MEXPFormat expFormat, Element rootElement, String rootNodeName, String trxName) throws Exception {
        int record_id = 0;
        PO po = this.getObjectFromFormat(ctx, expFormat, rootElement, rootNodeName, trxName);
        if (po != null) {
            record_id = po.get_ID();
        }
        this.log.info("record_id = " + record_id);
        return record_id;
    }

    private Object handleDateTime(Object value, MColumn column, MEXPFormatLine formatLine) throws ParseException {
        String valueString = null;
        valueString = value.toString();
        Object result = value;
        if (15 == column.getAD_Reference_ID()) {
            if (valueString != null) {
                if (formatLine.getDateFormat() != null && !Util.isEmpty(formatLine.getDateFormat())) {
                    this.m_customDateFormat = new SimpleDateFormat(formatLine.getDateFormat());
                    result = new Timestamp(this.m_customDateFormat.parse(valueString).getTime());
                    this.log.info("Custom Date Format; Parsed value = " + result.toString());
                } else {
                    result = valueString == null || valueString.length() <= 0 ? null : Timestamp.valueOf(valueString);
                }
            }
        } else if (16 == column.getAD_Reference_ID() && valueString != null) {
            if (formatLine.getDateFormat() != null && !Util.isEmpty(formatLine.getDateFormat())) {
                this.m_customDateFormat = new SimpleDateFormat(formatLine.getDateFormat());
                result = new Timestamp(this.m_customDateFormat.parse(valueString).getTime());
                this.log.info("Custom Date Format; Parsed value = " + result.toString());
            } else {
                result = Timestamp.valueOf(valueString);
            }
        }
        return result;
    }
}

