/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MRMA;
import org.compiere.model.MRMALine;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class InOutGenerateRMA
extends SvrProcess {
    private boolean p_Selection = false;
    private int p_M_Warehouse_ID = 0;
    private String p_docAction = "CO";
    private int m_created = 0;
    private Timestamp m_movementDate = null;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("M_Warehouse_ID")) {
                this.p_M_Warehouse_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("Selection")) {
                this.p_Selection = "Y".equals(para[i].getParameter());
                continue;
            }
            if (name.equals("DocAction")) {
                this.p_docAction = (String)para[i].getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.m_movementDate = Env.getContextAsDate(this.getCtx(), "#Date");
        if (this.m_movementDate == null) {
            this.m_movementDate = new Timestamp(System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doIt() throws Exception {
        if (!this.p_Selection) {
            throw new IllegalStateException("Shipments can only be generated from selection");
        }
        String sql = "SELECT rma.M_RMA_ID FROM M_RMA rma, T_Selection WHERE rma.DocStatus='CO' AND rma.IsSOTrx='N' AND rma.AD_Client_ID=? AND rma.M_RMA_ID = T_Selection.T_Selection_ID AND T_Selection.AD_PInstance_ID=? ";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, Env.getAD_Client_ID(this.getCtx()));
            pstmt.setInt(2, this.getAD_PInstance_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                this.generateShipment(rs.getInt(1));
            }
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, sql, ex);
        }
        finally {
            try {
                pstmt.close();
            }
            catch (Exception ex) {
                this.log.log(Level.SEVERE, "Could not close prepared statement");
            }
        }
        return "@Created@ = " + this.m_created;
    }

    private int getShipmentDocTypeId(int M_RMA_ID) {
        String docTypeSQl = "SELECT dt.C_DocTypeShipment_ID FROM C_DocType dt INNER JOIN M_RMA rma ON dt.C_DocType_ID=rma.C_DocType_ID WHERE rma.M_RMA_ID=?";
        int docTypeId = DB.getSQLValue(null, docTypeSQl, M_RMA_ID);
        return docTypeId;
    }

    private MInOut createShipment(MRMA rma) {
        int docTypeId = this.getShipmentDocTypeId(rma.get_ID());
        if (docTypeId == -1) {
            throw new IllegalStateException("Could not get invoice document type for Vendor RMA");
        }
        MInOut originalReceipt = rma.getShipment();
        MInOut shipment = new MInOut(this.getCtx(), 0, this.get_TrxName());
        shipment.setM_RMA_ID(rma.get_ID());
        shipment.setAD_Org_ID(rma.getAD_Org_ID());
        shipment.setAD_OrgTrx_ID(originalReceipt.getAD_OrgTrx_ID());
        shipment.setDescription(rma.getDescription());
        shipment.setC_BPartner_ID(rma.getC_BPartner_ID());
        shipment.setC_BPartner_Location_ID(originalReceipt.getC_BPartner_Location_ID());
        shipment.setIsSOTrx(rma.isSOTrx());
        shipment.setC_DocType_ID(docTypeId);
        shipment.setM_Warehouse_ID(originalReceipt.getM_Warehouse_ID());
        shipment.setMovementType("V-");
        shipment.setC_Project_ID(originalReceipt.getC_Project_ID());
        shipment.setC_Campaign_ID(originalReceipt.getC_Campaign_ID());
        shipment.setC_Activity_ID(originalReceipt.getC_Activity_ID());
        shipment.setUser1_ID(originalReceipt.getUser1_ID());
        shipment.setUser2_ID(originalReceipt.getUser2_ID());
        if (!shipment.save()) {
            throw new IllegalStateException("Could not create Shipment");
        }
        return shipment;
    }

    private MInOutLine[] createShipmentLines(MRMA rma, MInOut shipment) {
        MRMALine[] rmaLines;
        ArrayList<MInOutLine> shipLineList = new ArrayList<MInOutLine>();
        for (MRMALine rmaLine : rmaLines = rma.getLines(true)) {
            if (rmaLine.getM_InOutLine_ID() == 0) continue;
            MInOutLine shipLine = new MInOutLine(shipment);
            shipLine.setM_RMALine_ID(rmaLine.get_ID());
            shipLine.setLine(rmaLine.getLine());
            shipLine.setDescription(rmaLine.getDescription());
            shipLine.setM_Product_ID(rmaLine.getM_Product_ID());
            shipLine.setM_AttributeSetInstance_ID(rmaLine.getM_AttributeSetInstance_ID());
            shipLine.setC_UOM_ID(rmaLine.getC_UOM_ID());
            shipLine.setQty(rmaLine.getQty());
            shipLine.setM_Locator_ID(rmaLine.getM_Locator_ID());
            shipLine.setC_Project_ID(rmaLine.getC_Project_ID());
            shipLine.setC_Campaign_ID(rmaLine.getC_Campaign_ID());
            shipLine.setC_Activity_ID(rmaLine.getC_Activity_ID());
            shipLine.setC_ProjectPhase_ID(rmaLine.getC_ProjectPhase_ID());
            shipLine.setC_ProjectTask_ID(rmaLine.getC_ProjectTask_ID());
            shipLine.setUser1_ID(rmaLine.getUser1_ID());
            shipLine.setUser2_ID(rmaLine.getUser2_ID());
            shipLine.saveEx();
            shipLineList.add(shipLine);
            MInvoiceLine invoiceLine = (MInvoiceLine)new Query(shipment.getCtx(), "C_InvoiceLine", "M_RMALine_ID=?", shipment.get_TrxName()).setParameters(rmaLine.getM_RMALine_ID()).firstOnly();
            if (invoiceLine == null) continue;
            invoiceLine.setM_InOutLine_ID(shipLine.getM_InOutLine_ID());
            invoiceLine.saveEx();
        }
        MInOutLine[] shipLines = new MInOutLine[shipLineList.size()];
        shipLineList.toArray(shipLines);
        return shipLines;
    }

    private void generateShipment(int M_RMA_ID) {
        MInOut shipment;
        MRMA rma = new MRMA(this.getCtx(), M_RMA_ID, this.get_TrxName());
        MInOutLine[] shipmentLines = this.createShipmentLines(rma, shipment = this.createShipment(rma));
        if (shipmentLines.length == 0) {
            this.log.log(Level.WARNING, "No shipment lines created: M_RMA_ID=" + M_RMA_ID + ", M_InOut_ID=" + shipment.get_ID());
        }
        StringBuffer processMsg = new StringBuffer(shipment.getDocumentNo());
        if (!shipment.processIt(this.p_docAction)) {
            processMsg.append(" (NOT Processed)");
            this.log.warning("Shipment Processing failed: " + shipment + " - " + shipment.getProcessMsg());
        }
        if (!shipment.save()) {
            throw new IllegalStateException("Could not update shipment");
        }
        this.addLog(shipment.getM_InOut_ID(), shipment.getMovementDate(), null, processMsg.toString());
        ++this.m_created;
    }
}

