/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo.handler;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.AbstractElementHandler;
import org.adempiere.pipo.Element;
import org.adempiere.pipo.ElementFilter;
import org.adempiere.pipo.PackIn;
import org.adempiere.pipo.PackOut;
import org.adempiere.pipo.exception.POSaveFailedException;
import org.adempiere.pipo.handler.ColumnElementHandler;
import org.compiere.model.MTable;
import org.compiere.model.X_AD_Table;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class TableElementHandler
extends AbstractElementHandler {
    private ColumnElementHandler columnHandler = new ColumnElementHandler();
    private List<Integer> tables = new ArrayList<Integer>();
    protected static final String[] FILTER_TABLE_CHAIN = new String[]{"AD_Table", "AD_Column"};
    protected static final String[] FILTER_TABLEONLY_CHAIN = new String[]{"AD_Table"};

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void startElement(Properties ctx, Element element) throws SAXException {
        String valRuleName;
        String poWindowName;
        PackIn packIn = (PackIn)ctx.get("PackInProcess");
        String elementValue = element.getElementValue();
        Attributes atts = element.attributes;
        this.log.info(String.valueOf(elementValue) + " " + atts.getValue("ADTableNameID"));
        String entitytype = atts.getValue("EntityType");
        if (!this.isProcessElement(ctx, entitytype)) {
            element.skip = true;
            return;
        }
        String tableName = atts.getValue("ADTableNameID");
        int id = packIn.getTableId(tableName);
        if (id <= 0 && (id = this.get_IDWithColumn(ctx, "AD_Table", "TableName", tableName)) > 0) {
            packIn.addTable(tableName, id);
        }
        if (id > 0 && this.isTableProcess(ctx, id) && element.pass == 1) {
            return;
        }
        MTable m_Table = new MTable(ctx, id, this.getTrxName(ctx));
        if (id <= 0 && atts.getValue("AD_Table_ID") != null && Integer.parseInt(atts.getValue("AD_Table_ID")) <= 999999) {
            m_Table.setAD_Table_ID(Integer.parseInt(atts.getValue("AD_Table_ID")));
        }
        int AD_Backup_ID = -1;
        String Object_Status = null;
        if (id > 0) {
            AD_Backup_ID = this.copyRecord(ctx, "AD_Table", m_Table);
            Object_Status = "Update";
        } else {
            Object_Status = "New";
            AD_Backup_ID = 0;
        }
        m_Table.setTableName(tableName);
        String windowName = atts.getValue("ADWindowNameID");
        if (!Util.isEmpty(windowName, true)) {
            id = this.get_IDWithColumn(ctx, "AD_Window", "Name", windowName);
            if (id > 0) {
                m_Table.setAD_Window_ID(id);
            } else if (!element.defer) {
                element.defer = true;
                element.unresolved = "Window:" + windowName;
            } else {
                this.log.warning("@NotFound@ @AD_Window_ID@:" + windowName);
            }
        }
        if (!Util.isEmpty(poWindowName = this.getStringValue(atts, "POWindowNameID"), true)) {
            id = this.get_IDWithColumn(ctx, "AD_Window", "Name", poWindowName);
            if (id > 0) {
                m_Table.setPO_Window_ID(id);
            } else if (!element.defer) {
                element.defer = true;
                element.unresolved = "POWindow:" + poWindowName;
            } else {
                this.log.warning("@NotFound@ @PO_Window_ID@:" + poWindowName);
            }
        }
        if (!Util.isEmpty(valRuleName = this.getStringValue(atts, "ADValRuleNameID"), true)) {
            id = this.get_IDWithColumn(ctx, "AD_Val_Rule", "Name", valRuleName);
            if (id > 0) {
                m_Table.setAD_Val_Rule_ID(id);
            } else {
                element.defer = true;
                element.unresolved = "ValRule:" + valRuleName;
            }
        }
        m_Table.setAccessLevel(atts.getValue("AccessLevel"));
        m_Table.setDescription(this.getStringValue(atts, "Description"));
        m_Table.setEntityType(atts.getValue("EntityType"));
        m_Table.setHelp(this.getStringValue(atts, "Help"));
        m_Table.setIsActive(atts.getValue("isActive") != null ? Boolean.valueOf(atts.getValue("isActive")) : true);
        m_Table.setImportTable(this.getStringValue(atts, "ImportTable"));
        m_Table.setIsChangeLog(Boolean.valueOf(atts.getValue("isChangeLog")));
        m_Table.setIsDeleteable(Boolean.valueOf(atts.getValue("isDeleteable")));
        m_Table.setIsHighVolume(Boolean.valueOf(atts.getValue("isHighVolume")));
        m_Table.setIsSecurityEnabled(Boolean.valueOf(atts.getValue("isSecurityEnabled")));
        m_Table.setIsView(Boolean.valueOf(atts.getValue("isView")));
        m_Table.setName(atts.getValue("Name"));
        m_Table.setReplicationType(this.getStringValue(atts, "ReplicationType"));
        m_Table.setTableName(atts.getValue("TableName"));
        if (m_Table.save(this.getTrxName(ctx))) {
            this.record_log(ctx, 1, m_Table.getName(), "Table", m_Table.get_ID(), AD_Backup_ID, Object_Status, "AD_Table", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Table"));
            this.tables.add(m_Table.getAD_Table_ID());
            packIn.addTable(tableName, m_Table.getAD_Table_ID());
            element.recordId = m_Table.getAD_Table_ID();
            return;
        }
        this.record_log(ctx, 0, m_Table.getName(), "Table", m_Table.get_ID(), AD_Backup_ID, Object_Status, "AD_Table", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Table"));
        throw new POSaveFailedException("Table");
    }

    @Override
    public void endElement(Properties ctx, Element element) throws SAXException {
    }

    @Override
    public void create(Properties ctx, TransformerHandler document, ElementFilter filter) throws SAXException {
        int AD_Table_ID = Env.getContextAsInt(ctx, "AD_Table_ID");
        PackOut packOut = (PackOut)ctx.get("PackOutProcess");
        boolean exported = this.isTableProcess(ctx, AD_Table_ID);
        AttributesImpl atts = new AttributesImpl();
        if (!exported) {
            Set<Integer>[] cColumns = filter.getFilteredIds(ctx, AD_Table_ID, FILTER_TABLE_CHAIN, this.getTrxName(ctx));
            if (cColumns[0].size() > 0 || cColumns[1].size() > 0) {
                cColumns = filter.getFilteredIds(ctx, AD_Table_ID, FILTER_TABLE_CHAIN, true, this.getTrxName(ctx));
                String sql = "SELECT Name FROM AD_Table WHERE AD_Table_ID= " + AD_Table_ID;
                CPreparedStatement pstmt = null;
                pstmt = DB.prepareStatement(sql, this.getTrxName(ctx));
                try {
                    try {
                        ResultSet rs = pstmt.executeQuery();
                        while (rs.next()) {
                            block36: {
                                X_AD_Table m_Table = new X_AD_Table(ctx, AD_Table_ID, null);
                                this.createTableBinding(atts, m_Table);
                                document.startElement("", "", "table", atts);
                                String sql1 = "SELECT * FROM AD_Column WHERE AD_Table_ID = " + AD_Table_ID + " ORDER BY IsKey DESC, AD_Column_ID";
                                CPreparedStatement pstmt1 = null;
                                pstmt1 = DB.prepareStatement(sql1, this.getTrxName(ctx));
                                try {
                                    try {
                                        ResultSet rs1 = pstmt1.executeQuery();
                                        while (rs1.next()) {
                                            int AD_Column_ID = rs1.getInt("AD_Column_ID");
                                            if (!cColumns[1].contains(AD_Column_ID)) continue;
                                            packOut.createAdElement(rs1.getInt("AD_Element_ID"), document);
                                            if (rs1.getInt("AD_Reference_ID") > 0) {
                                                packOut.createReference(rs1.getInt("AD_Reference_ID"), document);
                                            }
                                            if (rs1.getInt("AD_Reference_Value_ID") > 0) {
                                                packOut.createReference(rs1.getInt("AD_Reference_Value_ID"), document);
                                            }
                                            if (rs1.getInt("AD_Process_ID") > 0) {
                                                packOut.createProcess(rs1.getInt("AD_Process_ID"), document);
                                            }
                                            if (rs1.getInt("AD_Val_Rule_ID") > 0) {
                                                packOut.createDynamicRuleValidation(rs1.getInt("AD_Val_Rule_ID"), document);
                                            }
                                            this.createColumn(ctx, document, AD_Column_ID);
                                        }
                                        rs1.close();
                                        pstmt1.close();
                                        pstmt1 = null;
                                    }
                                    catch (Exception e) {
                                        this.log.log(Level.SEVERE, "getProcess", e);
                                        try {
                                            if (pstmt1 != null) {
                                                pstmt1.close();
                                            }
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        pstmt1 = null;
                                        break block36;
                                    }
                                }
                                catch (Throwable throwable) {
                                    try {
                                        if (pstmt1 != null) {
                                            pstmt1.close();
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    pstmt1 = null;
                                    throw throwable;
                                }
                                try {
                                    if (pstmt1 != null) {
                                        pstmt1.close();
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                pstmt1 = null;
                            }
                            document.endElement("", "", "table");
                        }
                        rs.close();
                        pstmt.close();
                        pstmt = null;
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, "getProcess", e);
                        try {
                            if (pstmt != null) {
                                pstmt.close();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        pstmt = null;
                    }
                }
                finally {
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                        }
                    }
                    catch (Exception exception) {}
                    pstmt = null;
                }
            } else {
                filter.logElementFiltered(ctx, "AD_Table", AD_Table_ID);
            }
        }
    }

    private void createColumn(Properties ctx, TransformerHandler document, int AD_Column_ID) throws SAXException {
        Env.setContext(ctx, "AD_Column_ID", AD_Column_ID);
        this.columnHandler.create(ctx, document);
        ctx.remove("AD_Column_ID");
    }

    private boolean isTableProcess(Properties ctx, int AD_Table_ID) {
        if (this.tables.contains(AD_Table_ID)) {
            return true;
        }
        this.tables.add(AD_Table_ID);
        return false;
    }

    private AttributesImpl createTableBinding(AttributesImpl atts, X_AD_Table m_Table) {
        String sql = null;
        String name = null;
        atts.clear();
        if (m_Table.getAD_Table_ID() <= 999999) {
            atts.addAttribute("", "", "AD_Table_ID", "CDATA", Integer.toString(m_Table.getAD_Table_ID()));
        }
        atts.addAttribute("", "", "Name", "CDATA", m_Table.getName() != null ? m_Table.getName() : "");
        if (m_Table.getAD_Table_ID() > 0) {
            sql = "SELECT TableName FROM AD_Table WHERE AD_Table_ID=?";
            name = DB.getSQLValueString(null, sql, m_Table.getAD_Table_ID());
            atts.addAttribute("", "", "ADTableNameID", "CDATA", name);
        } else {
            atts.addAttribute("", "", "ADTableNameID", "CDATA", "");
        }
        if (m_Table.getAD_Window_ID() > 0) {
            sql = "SELECT Name FROM AD_Window WHERE AD_Window_ID=?";
            name = DB.getSQLValueString(null, sql, m_Table.getAD_Window_ID());
            atts.addAttribute("", "", "ADWindowNameID", "CDATA", name);
        } else {
            atts.addAttribute("", "", "ADWindowNameID", "CDATA", "");
        }
        if (m_Table.getPO_Window_ID() > 0) {
            sql = "SELECT Name FROM AD_Window WHERE AD_Window_ID=?";
            name = DB.getSQLValueString(null, sql, m_Table.getPO_Window_ID());
            atts.addAttribute("", "", "POWindowNameID", "CDATA", name);
        } else {
            atts.addAttribute("", "", "POWindowNameID", "CDATA", "");
        }
        if (m_Table.getAD_Val_Rule_ID() > 0) {
            sql = "SELECT Name FROM AD_Val_Rule WHERE AD_Val_Rule_ID=?";
            name = DB.getSQLValueString(null, sql, m_Table.getAD_Val_Rule_ID());
            atts.addAttribute("", "", "ADValRuleNameID", "CDATA", name);
        } else {
            atts.addAttribute("", "", "ADValRuleNameID", "CDATA", "");
        }
        atts.addAttribute("", "", "AccessLevel", "CDATA", m_Table.getAccessLevel() != null ? m_Table.getAccessLevel() : "");
        atts.addAttribute("", "", "Description", "CDATA", m_Table.getDescription() != null ? m_Table.getDescription() : "");
        atts.addAttribute("", "", "EntityType", "CDATA", m_Table.getEntityType() != null ? m_Table.getEntityType() : "");
        atts.addAttribute("", "", "Help", "CDATA", m_Table.getHelp() != null ? m_Table.getHelp() : "");
        atts.addAttribute("", "", "ImportTable", "CDATA", m_Table.getImportTable() != null ? m_Table.getImportTable() : "");
        atts.addAttribute("", "", "isChangeLog", "CDATA", m_Table.isChangeLog() ? "true" : "false");
        atts.addAttribute("", "", "isActive", "CDATA", m_Table.isActive() ? "true" : "false");
        atts.addAttribute("", "", "isDeleteable", "CDATA", m_Table.isDeleteable() ? "true" : "false");
        atts.addAttribute("", "", "isHighVolume", "CDATA", m_Table.isHighVolume() ? "true" : "false");
        atts.addAttribute("", "", "isSecurityEnabled", "CDATA", m_Table.isSecurityEnabled() ? "true" : "false");
        atts.addAttribute("", "", "isView", "CDATA", m_Table.isView() ? "true" : "false");
        atts.addAttribute("", "", "LoadSeq", "CDATA", m_Table.getLoadSeq() > 0 ? "" + m_Table.getLoadSeq() : "");
        atts.addAttribute("", "", "ReplicationType", "CDATA", m_Table.getReplicationType() != null ? m_Table.getReplicationType() : "");
        atts.addAttribute("", "", "TableName", "CDATA", m_Table.getTableName() != null ? m_Table.getTableName() : "");
        return atts;
    }
}

