/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo.handler;

import com.f3p.commons.Utils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.AbstractElementHandler;
import org.adempiere.pipo.Element;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SQLStatementElementHandler
extends AbstractElementHandler {
    public static final String SCRIPT_SEPARATOR = "--@@";
    public static final String DIR_SQL_FILE = "doc";

    @Override
    public void startElement(Properties ctx, Element element) throws SAXException {
        block32: {
            Object br;
            String[] sql;
            String DBType;
            Attributes atts;
            block31: {
                String elementValue = element.getElementValue();
                int AD_Backup_ID = -1;
                Object Object_Status = null;
                this.log.info(elementValue);
                atts = element.attributes;
                DBType = atts.getValue("DBType");
                sql = new String[]{atts.getValue("statement").trim()};
                if (sql[0].startsWith("@")) {
                    String sFile = sql[0].substring(1);
                    String sFileLoc = (ctx.get("PackageDirectory") + DIR_SQL_FILE + "/" + sFile).replace("\\", "/");
                    InputStreamReader inStream = null;
                    br = null;
                    try {
                        try {
                            String sSQL;
                            FileInputStream fileInputSql = new FileInputStream(sFileLoc);
                            inStream = new InputStreamReader(fileInputSql);
                            br = new BufferedReader(inStream);
                            LinkedList<String> lstSql = new LinkedList<String>();
                            StringBuffer sbSql = new StringBuffer();
                            String sLine = null;
                            while ((sLine = ((BufferedReader)br).readLine()) != null) {
                                if (sLine.startsWith(SCRIPT_SEPARATOR)) {
                                    if (sbSql.length() > 0) {
                                        sbSql.setLength(sbSql.length() - 1);
                                    }
                                    if ((sSQL = sbSql.toString().trim()).endsWith(";") || sSQL.endsWith("/")) {
                                        sSQL = sSQL.substring(0, sSQL.length() - 1);
                                    }
                                    if (!Utils.isEmptyString(sSQL)) {
                                        lstSql.add(sSQL);
                                    }
                                    sbSql = new StringBuffer();
                                    continue;
                                }
                                sbSql.append(sLine).append('\n');
                            }
                            if (sbSql.length() > 0) {
                                sbSql.setLength(sbSql.length() - 1);
                                sSQL = sbSql.toString().trim();
                                if (sSQL.endsWith(";") || sSQL.endsWith("/")) {
                                    sSQL = sSQL.substring(0, sSQL.length() - 1);
                                }
                                if (!Utils.isEmptyString(sSQL)) {
                                    lstSql.add(sSQL);
                                }
                            }
                            sql = lstSql.toArray(sql);
                        }
                        catch (Exception e) {
                            this.log.log(Level.SEVERE, "File " + sFileLoc + " non trovato", e);
                            sql = new String[]{""};
                            try {
                                ((BufferedReader)br).close();
                                inStream.close();
                            }
                            catch (Exception e2) {
                                this.log.log(Level.SEVERE, "File " + sFileLoc + " non trovato", e2);
                            }
                            break block31;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            ((BufferedReader)br).close();
                            inStream.close();
                        }
                        catch (Exception e) {
                            this.log.log(Level.SEVERE, "File " + sFileLoc + " non trovato", e);
                        }
                        throw throwable;
                    }
                    try {
                        ((BufferedReader)br).close();
                        inStream.close();
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, "File " + sFileLoc + " non trovato", e);
                    }
                }
            }
            try {
                CPreparedStatement pstmt;
                String sSQL;
                if (DBType.equals("ALL")) {
                    br = sql;
                    int inStream = sql.length;
                    int sFileLoc = 0;
                    while (sFileLoc < inStream) {
                        sSQL = br[sFileLoc];
                        pstmt = DB.prepareStatement(sSQL, this.getTrxName(ctx));
                        int n = pstmt.executeUpdate();
                        pstmt.close();
                        this.log.info("Executed SQL Statement: " + atts.getValue("statement"));
                        ++sFileLoc;
                    }
                    break block32;
                }
                if (DB.isOracle() && DBType.equals("Oracle")) {
                    br = sql;
                    int inStream = sql.length;
                    int sFileLoc = 0;
                    while (sFileLoc < inStream) {
                        sSQL = br[sFileLoc];
                        pstmt = DB.prepareStatement(sSQL, this.getTrxName(ctx));
                        pstmt.executeUpdate();
                        pstmt.close();
                        this.log.info("Executed SQL Statement: " + atts.getValue("statement"));
                        ++sFileLoc;
                    }
                    break block32;
                }
                if (!DB.isPostgreSQL() || !DBType.equals("Postgres") && !DBType.equals("PostgreSQL")) break block32;
                Trx trx = Trx.get(this.getTrxName(ctx), true);
                trx.commit();
                Connection m_con = DB.getConnectionRW(true);
                Statement stmt = null;
                try {
                    stmt = m_con.createStatement();
                    String[] stringArray = sql;
                    int n = sql.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String sSQL2 = stringArray[n2];
                        stmt.addBatch(sSQL2);
                        ++n2;
                    }
                    stmt.executeBatch();
                    this.log.info("Executed SQL Statement for PostgreSQL: " + atts.getValue("statement"));
                    if (m_con != null && !m_con.getAutoCommit()) {
                        m_con.commit();
                    }
                }
                finally {
                    stmt.close();
                    m_con.close();
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "SQLSatement", e);
            }
        }
    }

    @Override
    public void endElement(Properties ctx, Element element) throws SAXException {
    }

    @Override
    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        String SQLStatement = Env.getContext(ctx, "SQLStatement");
        String DBType = Env.getContext(ctx, "DBType");
        AttributesImpl atts = new AttributesImpl();
        this.createSQLStatmentBinding(atts, SQLStatement, DBType);
        document.startElement("", "", "SQLStatement", atts);
        document.endElement("", "", "SQLStatement");
    }

    private AttributesImpl createSQLStatmentBinding(AttributesImpl atts, String SqlStatement, String DBType) {
        atts.clear();
        atts.addAttribute("", "", "DBType", "CDATA", DBType);
        atts.addAttribute("", "", "statement", "CDATA", SqlStatement);
        return atts;
    }
}

