/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo.handler;

import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.AbstractElementHandler;
import org.adempiere.pipo.Element;
import org.adempiere.pipo.exception.DatabaseAccessException;
import org.adempiere.pipo.exception.POSaveFailedException;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.model.M_Element;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ReferenceTableElementHandler
extends AbstractElementHandler {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void startElement(Properties ctx, Element element) throws SAXException {
        int keyId;
        int DisplayId;
        StringBuffer sqlB;
        String elementValue = element.getElementValue();
        int AD_Backup_ID = -1;
        Object Object_Status = null;
        this.log.info(elementValue);
        Attributes atts = element.attributes;
        String entitytype = atts.getValue("EntityType");
        String name = atts.getValue("ADRefenceNameID");
        if (!this.isProcessElement(ctx, entitytype)) {
            element.skip = true;
            return;
        }
        if (element.parent != null && element.parent.skip) {
            element.skip = true;
            return;
        }
        int AD_Reference_ID = 0;
        if (element.parent != null && element.parent.getElementValue().equals("reference") && element.parent.recordId > 0) {
            AD_Reference_ID = element.parent.recordId;
        } else {
            sqlB = new StringBuffer("SELECT AD_Reference_ID FROM AD_Reference WHERE Name= ?");
            AD_Reference_ID = DB.getSQLValue(this.getTrxName(ctx), sqlB.toString(), name);
        }
        if (AD_Reference_ID <= 0 && atts.getValue("AD_Reference_ID") != null && Integer.parseInt(atts.getValue("AD_Reference_ID")) <= 999999) {
            AD_Reference_ID = Integer.parseInt(atts.getValue("AD_Reference_ID"));
        }
        sqlB = new StringBuffer("SELECT Count(*) FROM AD_Ref_Table WHERE AD_Reference_ID= ?");
        int count = DB.getSQLValue(this.getTrxName(ctx), sqlB.toString(), AD_Reference_ID);
        int tableId = this.get_IDWithColumn(ctx, "AD_Table", "TableName", atts.getValue("ADTableNameID"));
        if (tableId == 0) {
            MTable m_Table = new MTable(ctx, 0, this.getTrxName(ctx));
            m_Table.setAccessLevel("3");
            m_Table.setName(atts.getValue("ADTableNameID"));
            m_Table.setTableName(atts.getValue("ADTableNameID"));
            if (m_Table.save(this.getTrxName(ctx))) {
                this.record_log(ctx, 1, m_Table.getName(), "Table", m_Table.get_ID(), 0, "New", "AD_Table", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Table"));
            } else {
                this.record_log(ctx, 0, m_Table.getName(), "Table", m_Table.get_ID(), 0, "New", "AD_Table", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Table"));
            }
            tableId = this.get_IDWithColumn(ctx, "AD_Table", "TableName", atts.getValue("ADTableNameID"));
        }
        if ((DisplayId = this.get_IDWithMasterAndColumn(ctx, "AD_Column", "ColumnName", name = atts.getValue("ADDisplay"), "AD_Table", tableId)) == 0) {
            MColumn m_Column = new MColumn(ctx, 0, this.getTrxName(ctx));
            m_Column.setAD_Table_ID(tableId);
            m_Column.setColumnName(name);
            m_Column.setName(name);
            m_Column.setAD_Reference_ID(30);
            m_Column.setEntityType(entitytype);
            this.setElement(m_Column);
            if (m_Column.save(this.getTrxName(ctx))) {
                this.record_log(ctx, 1, m_Column.getName(), "Column", m_Column.get_ID(), 0, "New", "AD_Column", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Column"));
            } else {
                this.record_log(ctx, 0, m_Column.getName(), "Column", m_Column.get_ID(), 0, "New", "AD_Column", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Column"));
            }
        }
        if ((keyId = this.get_IDWithMasterAndColumn(ctx, "AD_Column", "ColumnName", name = atts.getValue("Key"), "AD_Table", tableId)) == 0) {
            MColumn m_Column = new MColumn(ctx, 0, this.getTrxName(ctx));
            m_Column.setAD_Table_ID(tableId);
            m_Column.setColumnName(name);
            m_Column.setName(name);
            m_Column.setAD_Reference_ID(30);
            m_Column.setEntityType(entitytype);
            this.setElement(m_Column);
            if (m_Column.save(this.getTrxName(ctx))) {
                this.record_log(ctx, 1, m_Column.getName(), "Column", m_Column.get_ID(), 0, "New", "AD_Column", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Column"));
            } else {
                this.record_log(ctx, 0, m_Column.getName(), "Column", m_Column.get_ID(), 0, "New", "AD_Column", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Column"));
            }
        }
        name = atts.getValue("ADDisplay");
        DisplayId = this.get_IDWithMasterAndColumn(ctx, "AD_Column", "ColumnName", name, "AD_Table", tableId);
        name = atts.getValue("Key");
        keyId = this.get_IDWithMasterAndColumn(ctx, "AD_Column", "ColumnName", name, "AD_Table", tableId);
        String entityType = atts.getValue("EntityType");
        String isValueDisplayed = atts.getValue("IsValueDisplayed");
        String OrderByClause = atts.getValue("OrderByClause").replaceAll("'", "''");
        String WhereClause = atts.getValue("WhereClause").replaceAll("'", "''");
        if (count > 0) {
            sqlB = new StringBuffer("UPDATE AD_Ref_Table ").append("SET AD_Table_ID = " + tableId).append(", AD_Display = " + DisplayId).append(", AD_Key = " + keyId).append(", isValueDisplayed = '" + isValueDisplayed).append("', OrderByClause = '" + OrderByClause).append("', EntityType ='" + entityType).append("', WhereClause = '" + WhereClause).append("' WHERE AD_Reference_ID = " + AD_Reference_ID);
            int no = DB.executeUpdate(sqlB.toString(), this.getTrxName(ctx));
            if (no > 0) {
                this.record_log(ctx, 1, atts.getValue("ADRefenceNameID"), "Reference Table", AD_Reference_ID, 0, "Update", "AD_Ref_Table", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Ref_Table"));
                return;
            }
            this.record_log(ctx, 0, atts.getValue("ADRefenceNameID"), "Reference Table", AD_Reference_ID, 0, "Update", "AD_Ref_Table", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Ref_Table"));
            throw new POSaveFailedException("ReferenceTable");
        }
        sqlB = new StringBuffer("INSERT INTO AD_Ref_Table").append("(AD_Client_ID, AD_Org_ID, CreatedBy, UpdatedBy, ").append("AD_Reference_ID, AD_Table_ID, AD_Display, AD_Key ").append(",entityType, isValueDisplayed, OrderByClause, ").append(" WhereClause )").append("VALUES(0, 0, 0, 0, " + AD_Reference_ID).append(", " + tableId).append(", " + DisplayId).append(", " + keyId).append(", '" + entityType).append("', '" + isValueDisplayed).append("', '" + OrderByClause).append("', '" + WhereClause + "')");
        int no = DB.executeUpdate(sqlB.toString(), this.getTrxName(ctx));
        if (no > 0) {
            this.record_log(ctx, 1, atts.getValue("ADRefenceNameID"), "Reference Table", AD_Reference_ID, 0, "New", "AD_Ref_Table", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Ref_Table"));
            return;
        }
        this.record_log(ctx, 0, atts.getValue("ADRefenceNameID"), "Reference Table", AD_Reference_ID, 0, "New", "AD_Ref_Table", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Ref_Table"));
        throw new POSaveFailedException("ReferenceTable");
    }

    @Override
    public void endElement(Properties ctx, Element element) throws SAXException {
    }

    @Override
    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        int Reference_id = Env.getContextAsInt(ctx, "AD_Reference_ID");
        AttributesImpl atts = new AttributesImpl();
        this.createReferenceTableBinding(ctx, atts, Reference_id);
        document.startElement("", "", "referencetable", atts);
        document.endElement("", "", "referencetable");
    }

    private AttributesImpl createReferenceTableBinding(Properties ctx, AttributesImpl atts, int reference_ID) {
        atts.clear();
        if (reference_ID <= 999999) {
            atts.addAttribute("", "", "AD_Reference_ID", "CDATA", Integer.toString(reference_ID));
        }
        String name = null;
        String sql = null;
        String sql1 = "SELECT * FROM AD_Ref_Table WHERE AD_Reference_ID= " + reference_ID;
        CPreparedStatement pstmt = null;
        pstmt = DB.prepareStatement(sql1, this.getTrxName(ctx));
        try {
            try {
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    sql = "SELECT Name FROM AD_Reference WHERE AD_Reference_ID=?";
                    name = DB.getSQLValueString(null, sql, reference_ID);
                    atts.addAttribute("", "", "ADRefenceNameID", "CDATA", name);
                    if (rs.getInt("AD_Table_ID") > 0) {
                        sql = "SELECT TableName FROM AD_Table WHERE AD_Table_ID=?";
                        name = DB.getSQLValueString(null, sql, rs.getInt("AD_Table_ID"));
                        atts.addAttribute("", "", "ADTableNameID", "CDATA", name);
                    } else {
                        atts.addAttribute("", "", "ADTableNameID", "CDATA", "");
                    }
                    if (rs.getInt("AD_Display") > 0) {
                        sql = "SELECT ColumnName FROM AD_Column WHERE AD_Column_ID=?";
                        name = DB.getSQLValueString(null, sql, rs.getInt("AD_Display"));
                        atts.addAttribute("", "", "ADDisplay", "CDATA", name);
                    } else {
                        atts.addAttribute("", "", "ADDisplay", "CDATA", "");
                    }
                    if (rs.getInt("AD_Key") > 0) {
                        sql = "SELECT ColumnName FROM AD_Column WHERE AD_Column_ID=?";
                        name = DB.getSQLValueString(null, sql, rs.getInt("AD_Key"));
                        atts.addAttribute("", "", "Key", "CDATA", name);
                    } else {
                        atts.addAttribute("", "", "Key", "CDATA", "");
                    }
                    atts.addAttribute("", "", "EntityType", "CDATA", rs.getString("EntityType") != null ? rs.getString("EntityType") : "");
                    atts.addAttribute("", "", "IsValueDisplayed", "CDATA", rs.getString("IsValueDisplayed").compareTo("Y") == 0 ? "Y" : "N");
                    atts.addAttribute("", "", "OrderByClause", "CDATA", rs.getString("OrderByClause") != null ? rs.getString("OrderByClause") : "");
                    atts.addAttribute("", "", "isActive", "CDATA", rs.getString("isActive").compareTo("Y") == 0 ? "Y" : "N");
                    atts.addAttribute("", "", "WhereClause", "CDATA", rs.getString("WhereClause") != null ? rs.getString("WhereClause") : "");
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, e.getLocalizedMessage(), e);
                throw new DatabaseAccessException("Failed to export Reference Table", e);
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
            pstmt = null;
        }
        return atts;
    }

    protected void setElement(MColumn column) throws SAXException {
        Properties ctx = column.getCtx();
        String sName = column.getColumnName();
        System.out.println("Sname:" + sName);
        M_Element adElement = M_Element.get(ctx, sName, this.getTrxName(ctx));
        System.out.println("adElement:" + adElement);
        if (adElement.getAD_Element_ID() == 0) {
            adElement.setColumnName(column.getColumnName());
            adElement.setEntityType(column.getEntityType());
            adElement.setPrintName(sName);
            adElement.setName(sName);
            if (adElement.save(this.getTrxName(ctx))) {
                this.record_log(ctx, 1, sName, "Element", adElement.getAD_Element_ID(), 0, "New", "AD_Element", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Element"));
            } else {
                this.record_log(ctx, 0, sName, "Element", adElement.getAD_Element_ID(), 0, "New", "AD_Element", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Element"));
            }
        }
        column.setAD_Element_ID(adElement.getAD_Element_ID());
    }
}

