/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo.handler;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pipo.AbstractElementHandler;
import org.adempiere.pipo.Element;
import org.adempiere.pipo.exception.POSaveFailedException;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.POInfo;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class PrintPaperElementHandler
extends AbstractElementHandler {
    public static final String TAG_Name = "printpaper";
    private final List<Integer> list = new ArrayList<Integer>();

    protected String getTagName() {
        return TAG_Name;
    }

    protected String getTableName() {
        return "AD_PrintPaper";
    }

    protected final int getTable_ID() {
        return MTable.getTable_ID(this.getTableName());
    }

    protected String getKeyColumnName() {
        return "AD_PrintPaper_ID";
    }

    protected String getIdentifierColumnName() {
        return "Name";
    }

    protected String[] getAttributeNames() {
        String[] attributeNames = new String[]{"Name", "Description", "IsActive", "IsDefault", "IsLandscape", "Code", "MarginTop", "MarginLeft", "MarginRight", "MarginBottom", "SizeX", "SizeY", "DimensionUnits"};
        return attributeNames;
    }

    protected int getExportItem_ID(Properties ctx) {
        int id = Env.getContextAsInt(ctx, this.getKeyColumnName());
        return id;
    }

    protected PO getCreatePO(Properties ctx, int id, String trxName) {
        return MTable.get(ctx, this.getTableName()).getPO(id, trxName);
    }

    @Override
    public void startElement(Properties ctx, Element element) throws SAXException {
        String Object_Status;
        int AD_Backup_ID;
        String elementValue = element.getElementValue();
        Attributes atts = element.attributes;
        String strIdentifier = atts.getValue(this.getIdentifierColumnName());
        int id = this.get_IDWithColumn(ctx, this.getTableName(), this.getIdentifierColumnName(), strIdentifier);
        PO po = this.getCreatePO(ctx, id, this.getTrxName(ctx));
        String keyColumnName = this.getKeyColumnName();
        this.log.info(elementValue + " " + strIdentifier + "[" + id + "]");
        if (id <= 0 && keyColumnName != null && this.getIntValue(atts, keyColumnName, 0) <= 999999) {
            po.set_ValueOfColumn(keyColumnName, (Object)this.getIntValue(atts, keyColumnName, 0));
        }
        if (id > 0) {
            AD_Backup_ID = this.copyRecord(ctx, this.getTableName(), po);
            Object_Status = "Update";
        } else {
            Object_Status = "New";
            AD_Backup_ID = 0;
        }
        for (String attributeName : this.getAttributeNames()) {
            this.loadAttribute(atts, attributeName, po);
        }
        if (!po.save(this.getTrxName(ctx))) {
            this.record_log(ctx, 0, strIdentifier, this.getTagName(), po.get_ID(), AD_Backup_ID, Object_Status, this.getTableName(), this.getTable_ID());
            throw new POSaveFailedException("Failed to save message.");
        }
        this.record_log(ctx, 1, strIdentifier, this.getTagName(), po.get_ID(), AD_Backup_ID, Object_Status, this.getTableName(), this.getTable_ID());
    }

    @Override
    public void endElement(Properties ctx, Element element) throws SAXException {
    }

    @Override
    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        int id = this.getExportItem_ID(ctx);
        if (this.list.contains(id)) {
            return;
        }
        this.list.add(id);
        PO po = this.getCreatePO(ctx, id, null);
        AttributesImpl atts = new AttributesImpl();
        this.createMessageBinding(atts, po);
        document.startElement("", "", this.getTagName(), atts);
        document.endElement("", "", this.getTagName());
    }

    private AttributesImpl createMessageBinding(AttributesImpl atts, PO po) {
        atts.clear();
        String keyColumnName = this.getKeyColumnName();
        if (keyColumnName != null && po.get_ID() <= 999999) {
            this.addAttribute(atts, keyColumnName, po);
        }
        for (String name : this.getAttributeNames()) {
            this.addAttribute(atts, name, po);
        }
        return atts;
    }

    protected void loadAttribute(Attributes atts, String name, PO po) {
        String strValueExact = atts.getValue(name);
        String strValue = strValueExact;
        strValue = Util.isEmpty(strValue, true) ? null : strValue.trim();
        POInfo poInfo = POInfo.getPOInfo(po.getCtx(), this.getTable_ID());
        Class<?> clazz = poInfo.getColumnClass(poInfo.getColumnIndex(name));
        if (strValue == null) {
            po.set_ValueOfColumn(name, null);
        } else if (clazz == BigDecimal.class) {
            po.set_ValueOfColumn(name, (Object)new BigDecimal(strValue));
        } else if (clazz == Integer.class) {
            po.set_ValueOfColumn(name, (Object)new BigDecimal(strValue).intValueExact());
        } else if (clazz == String.class) {
            po.set_ValueOfColumn(name, (Object)strValueExact);
        } else if (clazz == Boolean.class) {
            po.set_ValueOfColumn(name, (Object)Boolean.valueOf(strValue));
        } else if (clazz == Timestamp.class) {
            Timestamp ts = Timestamp.valueOf(strValue);
            po.set_ValueOfColumn(name, (Object)ts);
        } else {
            throw new AdempiereException("Class not supported - " + clazz);
        }
    }

    protected boolean getBooleanValue(Attributes atts, String qName, boolean defaultValue) {
        String s = atts.getValue(qName);
        return s != null ? Boolean.valueOf(s) : defaultValue;
    }

    protected int getIntValue(Attributes atts, String qName, int defaultValue) {
        String o = atts.getValue(qName);
        if (o == null) {
            return defaultValue;
        }
        if (o instanceof Number) {
            return ((Number)((Object)o)).intValue();
        }
        return Integer.parseInt(o.toString());
    }

    private final void addAttribute(AttributesImpl atts, String name, PO po) {
        Object value = po.get_Value(name);
        atts.addAttribute("", "", name, "CDATA", this.toStringAttribute(value));
    }

    private final String toStringAttribute(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Boolean) {
            return (Boolean)value == true ? "true" : "false";
        }
        return value.toString();
    }
}

