/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.AbstractElementHandler;
import org.adempiere.pipo.Element;
import org.adempiere.pipo.exception.POSaveFailedException;
import org.compiere.model.I_AD_ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_AD_ModelValidator;
import org.compiere.util.Env;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ModelValidatorElementHandler
extends AbstractElementHandler {
    public static final String TAG_Name = "modelvalidator";
    private final List<Integer> validators = new ArrayList<Integer>();

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void startElement(Properties ctx, Element element) throws SAXException {
        String Object_Status;
        int AD_Backup_ID;
        String elementValue = element.getElementValue();
        Attributes atts = element.attributes;
        this.log.info(elementValue + " " + atts.getValue("Name"));
        String entitytype = atts.getValue("EntityType");
        if (!this.isProcessElement(ctx, entitytype)) {
            element.skip = true;
            return;
        }
        String name = atts.getValue("Name");
        int id = this.get_IDWithColumn(ctx, "AD_ModelValidator", "Name", name);
        X_AD_ModelValidator validator = new X_AD_ModelValidator(ctx, id, this.getTrxName(ctx));
        if (id <= 0 && this.getIntValue(atts, "AD_ModelValidator_ID", 0) <= 999999) {
            validator.setAD_ModelValidator_ID(this.getIntValue(atts, "AD_ModelValidator_ID", 0));
        }
        if (id > 0) {
            AD_Backup_ID = this.copyRecord(ctx, "AD_ModelValidator", validator);
            Object_Status = "Update";
        } else {
            Object_Status = "New";
            AD_Backup_ID = 0;
        }
        validator.setName(name);
        validator.setDescription(this.getStringValue(atts, "Description"));
        validator.setHelp(this.getStringValue(atts, "Help"));
        validator.setEntityType(atts.getValue("EntityType"));
        validator.setModelValidationClass(atts.getValue("ModelValidationClass"));
        validator.setIsActive(this.getBooleanValue(atts, "IsActive", true));
        validator.setSeqNo(this.getIntValue(atts, "SeqNo", 0));
        if (validator.save(this.getTrxName(ctx))) {
            this.record_log(ctx, 1, validator.getName(), TAG_Name, validator.get_ID(), AD_Backup_ID, Object_Status, "AD_ModelValidator", I_AD_ModelValidator.Table_ID);
            return;
        }
        this.record_log(ctx, 0, validator.getName(), TAG_Name, validator.get_ID(), AD_Backup_ID, Object_Status, "AD_ModelValidator", I_AD_ModelValidator.Table_ID);
        throw new POSaveFailedException("Failed to save message.");
    }

    @Override
    public void endElement(Properties ctx, Element element) throws SAXException {
    }

    @Override
    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        int AD_ModelValidator_ID = Env.getContextAsInt(ctx, "AD_ModelValidator_ID");
        if (this.validators.contains(AD_ModelValidator_ID)) {
            return;
        }
        this.validators.add(AD_ModelValidator_ID);
        X_AD_ModelValidator validator = new X_AD_ModelValidator(ctx, AD_ModelValidator_ID, null);
        AttributesImpl atts = new AttributesImpl();
        this.createMessageBinding(atts, validator);
        document.startElement("", "", TAG_Name, atts);
        document.endElement("", "", TAG_Name);
    }

    private AttributesImpl createMessageBinding(AttributesImpl atts, X_AD_ModelValidator validator) {
        atts.clear();
        if (validator.getAD_ModelValidator_ID() <= 999999) {
            this.addAttribute(atts, "AD_ModelValidator_ID", validator);
        }
        this.addAttribute(atts, "Name", validator);
        this.addAttribute(atts, "Description", validator);
        this.addAttribute(atts, "Help", validator);
        this.addAttribute(atts, "ModelValidationClass", validator);
        this.addAttribute(atts, "EntityType", validator);
        this.addAttribute(atts, "IsActive", validator);
        this.addAttribute(atts, "SeqNo", validator);
        return atts;
    }

    protected boolean getBooleanValue(Attributes atts, String qName, boolean defaultValue) {
        String s = atts.getValue(qName);
        return s != null ? Boolean.valueOf(s) : defaultValue;
    }

    protected int getIntValue(Attributes atts, String qName, int defaultValue) {
        String o = atts.getValue(qName);
        if (o == null) {
            return defaultValue;
        }
        if (o instanceof Number) {
            return ((Number)((Object)o)).intValue();
        }
        return Integer.parseInt(o.toString());
    }

    private final void addAttribute(AttributesImpl atts, String name, PO po) {
        Object value = po.get_Value(name);
        atts.addAttribute("", "", name, "CDATA", this.toStringAttribute(value));
    }

    private final String toStringAttribute(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Boolean) {
            return (Boolean)value == true ? "true" : "false";
        }
        return value.toString();
    }
}

