/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo.handler;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.AbstractElementHandler;
import org.adempiere.pipo.Element;
import org.adempiere.pipo.ElementFilter;
import org.adempiere.pipo.exception.POSaveFailedException;
import org.compiere.model.X_AD_Val_Rule;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class DynValRuleElementHandler
extends AbstractElementHandler {
    protected static final String[] FILTER_CHAIN = new String[]{"AD_Val_Rule"};
    private List<Integer> rules = new ArrayList<Integer>();

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void startElement(Properties ctx, Element element) throws SAXException {
        String elementValue = element.getElementValue();
        Attributes atts = element.attributes;
        this.log.info(String.valueOf(elementValue) + " " + atts.getValue("Name"));
        String entitytype = atts.getValue("EntityType");
        if (!this.isProcessElement(ctx, entitytype)) {
            element.skip = true;
            return;
        }
        String name = atts.getValue("Name");
        int id = this.get_IDWithColumn(ctx, "AD_Val_Rule", "name", name);
        X_AD_Val_Rule m_ValRule = new X_AD_Val_Rule(ctx, id, this.getTrxName(ctx));
        if (id <= 0 && atts.getValue("AD_Val_Rule_ID") != null && Integer.parseInt(atts.getValue("AD_Val_Rule_ID")) <= 999999) {
            m_ValRule.setAD_Val_Rule_ID(Integer.parseInt(atts.getValue("AD_Val_Rule_ID")));
        }
        int AD_Backup_ID = -1;
        String Object_Status = null;
        if (id > 0) {
            AD_Backup_ID = this.copyRecord(ctx, "AD_Val_Rule", m_ValRule);
            Object_Status = "Update";
        } else {
            Object_Status = "New";
            AD_Backup_ID = 0;
        }
        m_ValRule.setDescription(this.getStringValue(atts, "Description"));
        m_ValRule.setEntityType(atts.getValue("EntityType"));
        m_ValRule.setIsActive(atts.getValue("isActive") != null ? Boolean.valueOf(atts.getValue("isActive")) : true);
        m_ValRule.setName(name);
        m_ValRule.setType(atts.getValue("Type"));
        m_ValRule.setCode(atts.getValue("Code"));
        if (m_ValRule.save(this.getTrxName(ctx))) {
            this.record_log(ctx, 1, m_ValRule.getName(), "ValRule", m_ValRule.get_ID(), AD_Backup_ID, Object_Status, "AD_Val_Rule", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Val_Rule"));
            return;
        }
        this.record_log(ctx, 0, m_ValRule.getName(), "ValRule", m_ValRule.get_ID(), AD_Backup_ID, Object_Status, "AD_Val_Rule", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Val_Rule"));
        throw new POSaveFailedException("Failed to save dynamic validation rule.");
    }

    @Override
    public void endElement(Properties ctx, Element element) throws SAXException {
    }

    @Override
    public void create(Properties ctx, TransformerHandler document, ElementFilter filter) throws SAXException {
        int AD_Val_Rule_ID = Env.getContextAsInt(ctx, "AD_Val_Rule_ID");
        if (this.rules.contains(AD_Val_Rule_ID)) {
            return;
        }
        Set<Integer>[] cVals = filter.getFilteredIds(ctx, AD_Val_Rule_ID, FILTER_CHAIN, this.getTrxName(ctx));
        if (cVals[0].size() == 0) {
            filter.logElementFiltered(ctx, "AD_Val_Rule", AD_Val_Rule_ID);
            return;
        }
        this.rules.add(AD_Val_Rule_ID);
        String sql = "SELECT Name FROM AD_Val_Rule WHERE  AD_Val_Rule_ID= " + AD_Val_Rule_ID;
        AttributesImpl atts = new AttributesImpl();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        pstmt = DB.prepareStatement(sql, this.getTrxName(ctx));
        try {
            try {
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    X_AD_Val_Rule m_ValRule = new X_AD_Val_Rule(ctx, AD_Val_Rule_ID, null);
                    this.createDynamicValidationRuleBinding(atts, m_ValRule);
                    document.startElement("", "", "dynvalrule", atts);
                    document.endElement("", "", "dynvalrule");
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "getProcess", e);
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
    }

    private AttributesImpl createDynamicValidationRuleBinding(AttributesImpl atts, X_AD_Val_Rule m_ValRule) {
        atts.clear();
        if (m_ValRule.getAD_Val_Rule_ID() <= 999999) {
            atts.addAttribute("", "", "AD_Val_Rule_ID", "CDATA", Integer.toString(m_ValRule.getAD_Val_Rule_ID()));
        }
        atts.addAttribute("", "", "Name", "CDATA", m_ValRule.getName() != null ? m_ValRule.getName() : "");
        atts.addAttribute("", "", "Code", "CDATA", m_ValRule.getCode() != null ? m_ValRule.getCode() : "");
        atts.addAttribute("", "", "Description", "CDATA", m_ValRule.getDescription() != null ? m_ValRule.getDescription() : "");
        atts.addAttribute("", "", "EntityType", "CDATA", m_ValRule.getEntityType() != null ? m_ValRule.getEntityType() : "");
        atts.addAttribute("", "", "Type", "CDATA", m_ValRule.getType() != null ? m_ValRule.getType() : "");
        atts.addAttribute("", "", "isActive", "CDATA", m_ValRule.isActive() ? "true" : "false");
        return atts;
    }
}

