/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo;

import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.compiere.model.MTable;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class ElementFilter {
    protected HashMap<String, ArrayList<Integer>> m_mapTableToTopLevelIds = new HashMap();
    protected String m_sEntityType = null;
    protected Timestamp m_tsChangedFrom = null;

    public String getEntityTypeAsINClause() {
        return this.m_sEntityType;
    }

    public void setEntityType(String sEntityType) {
        if (sEntityType == null) {
            this.m_sEntityType = null;
            return;
        }
        StringTokenizer tk = new StringTokenizer(sEntityType, ",");
        StringBuilder sBuilder = new StringBuilder();
        boolean bFirst = true;
        while (tk.hasMoreTokens()) {
            String sVal = tk.nextToken();
            if (bFirst) {
                bFirst = false;
            } else {
                sBuilder.append(',');
            }
            if (sVal.startsWith("'")) {
                sBuilder.append(sVal);
                continue;
            }
            sBuilder.append(DB.TO_STRING(sVal));
        }
        this.m_sEntityType = sBuilder.toString();
    }

    public Timestamp getChangedFrom() {
        return this.m_tsChangedFrom;
    }

    public void setChangedFrom(Timestamp tsChangedFrom) {
        this.m_tsChangedFrom = tsChangedFrom;
    }

    public Set<Integer>[] getFilteredIds(Properties ctx, int iMainTableID, String[] sTableChain, String sTrx) {
        return this.getFilteredIds(ctx, iMainTableID, sTableChain, false, sTrx);
    }

    public Set<Integer>[] getFilteredIds(Properties ctx, int iMainTableID, String[] sTableChain, boolean bFilterOnlyLastTable, String sTrx) {
        String sParentTable = null;
        StringBuilder sbFromClause = new StringBuilder("FROM ");
        StringBuilder sbWhereClause = new StringBuilder("WHERE ");
        StringBuilder sbSelectClause = new StringBuilder("SELECT ");
        int iParmsCouples = 0;
        int i = 0;
        while (i < sTableChain.length) {
            String sTable = sTableChain[i];
            if (i == 0) {
                sbSelectClause.append(this.getIDColumn(ctx, sTable));
            } else {
                sbSelectClause.append(',').append(this.getIDColumn(ctx, sTable));
            }
            if (i != 0) {
                if (i == 1) {
                    sbFromClause.append(sParentTable).append(" LEFT OUTER JOIN ").append(sTable).append(" ON ").append(this.getJoinCondition(ctx, sParentTable, sTable)).append(" AND ").append(sTable).append(".IsActive = 'Y' ");
                } else {
                    sbFromClause.append("LEFT OUTER JOIN ").append(sTable).append(" ON ").append(this.getJoinCondition(ctx, sParentTable, sTable)).append(" AND ").append(sTable).append(".IsActive = 'Y' ");
                }
            }
            if (i == 0) {
                sbWhereClause.append(this.getIDColumn(ctx, sTable)).append("=? ");
            }
            if ((this.getEntityTypeAsINClause() != null || this.getChangedFrom() != null) && (!bFilterOnlyLastTable || bFilterOnlyLastTable && i == sTableChain.length - 1)) {
                if (i == 0) {
                    sbWhereClause.append("AND ").append(sTable).append(".IsActive = 'Y' AND (");
                    sbWhereClause.append("(");
                } else if (bFilterOnlyLastTable) {
                    sbWhereClause.append(" AND (");
                } else {
                    sbWhereClause.append(" OR (");
                }
                if (this.getEntityTypeAsINClause() != null) {
                    sbWhereClause.append(sTable).append('.').append("EntityType IN (").append(this.getEntityTypeAsINClause()).append(") ");
                    if (this.m_tsChangedFrom != null) {
                        sbWhereClause.append("OR ");
                    }
                }
                if (this.m_tsChangedFrom != null) {
                    sbWhereClause.append('(');
                    if (this.getEntityTypeAsINClause() != null) {
                        sbWhereClause.append(sTable).append(".EntityType IN ('A','D','EE01') AND ");
                    }
                    sbWhereClause.append(sTable).append(".Updated >= ? )");
                }
                sbWhereClause.append(") ");
                ++iParmsCouples;
            }
            sParentTable = sTableChain[i];
            ++i;
        }
        if (!(this.getEntityTypeAsINClause() == null && this.getChangedFrom() == null || bFilterOnlyLastTable)) {
            sbWhereClause.append(')');
        }
        if (sTableChain.length == 1) {
            sbFromClause.append(sTableChain[0]);
        }
        StringBuilder sbQuery = new StringBuilder(sbSelectClause);
        sbQuery.append(' ');
        sbQuery.append((CharSequence)sbFromClause).append(' ').append((CharSequence)sbWhereClause);
        CPreparedStatement pstmt = DB.prepareStatement(sbQuery.toString(), sTrx);
        ResultSet rs = null;
        HashSet[] vRes = new HashSet[sTableChain.length];
        int i2 = 0;
        while (i2 < sTableChain.length) {
            vRes[i2] = new HashSet();
            ++i2;
        }
        try {
            try {
                int iParm = 1;
                pstmt.setInt(iParm++, iMainTableID);
                int i3 = 0;
                while (i3 < iParmsCouples) {
                    if (this.getChangedFrom() != null) {
                        pstmt.setTimestamp(iParm++, this.getChangedFrom());
                    }
                    ++i3;
                }
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    i3 = 0;
                    while (i3 < sTableChain.length) {
                        int iID = rs.getInt(i3 + 1);
                        if (!rs.wasNull()) {
                            vRes[i3].add(iID);
                        }
                        ++i3;
                    }
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            throw throwable;
        }
        DB.close(rs, pstmt);
        return vRes;
    }

    public String getJoinCondition(Properties ctx, String sTable1, String sTable2) {
        MTable table = MTable.get(ctx, sTable1);
        String[] sKeys = table.getKeyColumns();
        if (sKeys.length == 1) {
            StringBuilder sbClause = new StringBuilder();
            sbClause.append(sTable1).append('.').append(sKeys[0]).append('=').append(sTable2).append('.').append(sKeys[0]);
            return sbClause.toString();
        }
        throw new RuntimeException("Unsupported number of key columns for " + sTable1);
    }

    public String getIDColumn(Properties ctx, String sTable) {
        MTable table = MTable.get(ctx, sTable);
        String[] sKeys = table.getKeyColumns();
        if (sKeys.length == 1) {
            return String.valueOf(sTable) + "." + sKeys[0];
        }
        throw new RuntimeException("Unsupported number of key columns for " + sTable);
    }

    public void markTopLevelElement(Properties ctx, String sTableName, int ID2) {
        if (this.m_mapTableToTopLevelIds.containsKey(sTableName)) {
            ArrayList<Integer> list = this.m_mapTableToTopLevelIds.get(sTableName);
            list.add(ID2);
            Collections.sort(list);
        } else {
            ArrayList<Integer> list = new ArrayList<Integer>();
            list.add(ID2);
            this.m_mapTableToTopLevelIds.put(sTableName, list);
        }
    }

    public void logElementFiltered(Properties ctx, String sTableName, int ID2) {
        ArrayList<Integer> list;
        if (this.m_mapTableToTopLevelIds.containsKey(sTableName) && Collections.binarySearch(list = this.m_mapTableToTopLevelIds.get(sTableName), ID2) >= 0) {
            StringBuilder sbLog = new StringBuilder("Skipped: ");
            sbLog.append(sTableName).append(" ID: ").append(ID2);
            PrintWriter warningsWriter = (PrintWriter)ctx.get("f3p_warningsWriter");
            warningsWriter.println(sbLog);
        }
    }
}

