/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.model.engines;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.model.engines.CostEngineFactory;
import org.adempiere.model.engines.IDocumentLine;
import org.adempiere.model.engines.IInventoryAllocation;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MProduct;
import org.compiere.model.MStorage;
import org.compiere.model.MTable;
import org.compiere.model.MTransaction;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_M_AttributeSetInstance;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class StorageEngine {
    protected static transient CLogger log = CLogger.getCLogger(StorageEngine.class);

    public static void createTrasaction(IDocumentLine iDocumentLine, String string, Timestamp timestamp, BigDecimal bigDecimal, boolean bl, int n, int n2, int n3, boolean bl2) {
        boolean bl3;
        MProduct mProduct = MProduct.get(iDocumentLine.getCtx(), iDocumentLine.getM_Product_ID());
        boolean bl4 = bl3 = string.charAt(1) == '+';
        if (mProduct != null && mProduct.isStocked()) {
            if (!bl) {
                StorageEngine.checkMaterialPolicy(iDocumentLine, string, timestamp, n);
            }
            int n4 = n2;
            if (iDocumentLine.getM_AttributeSetInstance_ID() == 0) {
                IInventoryAllocation[] iInventoryAllocationArray = StorageEngine.getMA(iDocumentLine);
                for (int i = 0; i < iInventoryAllocationArray.length; ++i) {
                    IInventoryAllocation iInventoryAllocation = iInventoryAllocationArray[i];
                    BigDecimal bigDecimal2 = iInventoryAllocation.getMovementQty();
                    if (!bl3) {
                        bigDecimal2 = bigDecimal2.negate();
                    }
                    if (!MStorage.add(iDocumentLine.getCtx(), n, iDocumentLine.getM_Locator_ID(), iDocumentLine.getM_Product_ID(), iInventoryAllocation.getM_AttributeSetInstance_ID(), n4, bigDecimal2, Env.ZERO, Env.ZERO, iDocumentLine.get_TrxName())) {
                        throw new AdempiereException();
                    }
                    StorageEngine.create(iDocumentLine, string, timestamp, iInventoryAllocation.getM_AttributeSetInstance_ID(), bigDecimal2);
                }
            } else {
                if (!bl3) {
                    bigDecimal = bigDecimal.negate();
                }
                if (!MStorage.add(iDocumentLine.getCtx(), n, iDocumentLine.getM_Locator_ID(), iDocumentLine.getM_Product_ID(), iDocumentLine.getM_AttributeSetInstance_ID(), n4, bigDecimal, Env.ZERO, Env.ZERO, iDocumentLine.get_TrxName())) {
                    throw new AdempiereException();
                }
                StorageEngine.create(iDocumentLine, string, timestamp, iDocumentLine.getM_AttributeSetInstance_ID(), bigDecimal);
            }
        }
    }

    private static void checkMaterialPolicy(IDocumentLine iDocumentLine, String string, Timestamp timestamp, int n) {
        StorageEngine.deleteMA(iDocumentLine);
        boolean bl = string.charAt(1) == '+';
        MProduct mProduct = MProduct.get(iDocumentLine.getCtx(), iDocumentLine.getM_Product_ID());
        if (iDocumentLine.getM_Locator_ID() == 0) {
            // empty if block
        }
        if (iDocumentLine.getM_AttributeSetInstance_ID() == 0) {
            if (bl) {
                MStorage[] mStorageArray;
                X_M_AttributeSetInstance x_M_AttributeSetInstance = null;
                for (MStorage mStorage : mStorageArray = MStorage.getWarehouse(iDocumentLine.getCtx(), n, iDocumentLine.getM_Product_ID(), 0, null, "F".equals(mProduct.getMMPolicy()), false, iDocumentLine.getM_Locator_ID(), iDocumentLine.get_TrxName())) {
                    if (mStorage.getQtyOnHand().signum() >= 0) continue;
                    x_M_AttributeSetInstance = new MAttributeSetInstance(iDocumentLine.getCtx(), mStorage.getM_AttributeSetInstance_ID(), iDocumentLine.get_TrxName());
                    break;
                }
                if (x_M_AttributeSetInstance == null) {
                    x_M_AttributeSetInstance = MAttributeSetInstance.create(iDocumentLine.getCtx(), mProduct, iDocumentLine.get_TrxName());
                }
                iDocumentLine.setM_AttributeSetInstance_ID(x_M_AttributeSetInstance.getM_AttributeSetInstance_ID());
                log.config("New ASI=" + iDocumentLine);
                StorageEngine.createMA(iDocumentLine, iDocumentLine.getM_AttributeSetInstance_ID(), iDocumentLine.getMovementQty());
            } else {
                String string2 = mProduct.getMMPolicy();
                Timestamp timestamp2 = timestamp;
                MStorage[] mStorageArray = MStorage.getWarehouse(iDocumentLine.getCtx(), n, iDocumentLine.getM_Product_ID(), iDocumentLine.getM_AttributeSetInstance_ID(), timestamp2, "F".equals(string2), true, iDocumentLine.getM_Locator_ID(), iDocumentLine.get_TrxName());
                BigDecimal bigDecimal = iDocumentLine.getMovementQty();
                for (MStorage mStorage : mStorageArray) {
                    if (mStorage.getQtyOnHand().compareTo(bigDecimal) >= 0) {
                        StorageEngine.createMA(iDocumentLine, mStorage.getM_AttributeSetInstance_ID(), bigDecimal);
                        bigDecimal = Env.ZERO;
                    } else {
                        StorageEngine.createMA(iDocumentLine, mStorage.getM_AttributeSetInstance_ID(), mStorage.getQtyOnHand());
                        bigDecimal = bigDecimal.subtract(mStorage.getQtyOnHand());
                        log.fine("QtyToDeliver=" + bigDecimal);
                    }
                    if (bigDecimal.signum() == 0) break;
                }
                if (bigDecimal.signum() != 0) {
                    MAttributeSetInstance mAttributeSetInstance = MAttributeSetInstance.create(iDocumentLine.getCtx(), mProduct, iDocumentLine.get_TrxName());
                    StorageEngine.createMA(iDocumentLine, mAttributeSetInstance.getM_AttributeSetInstance_ID(), bigDecimal);
                }
            }
        } else if (!bl) {
            StorageEngine.createMA(iDocumentLine, iDocumentLine.getM_AttributeSetInstance_ID(), iDocumentLine.getMovementQty());
        }
        StorageEngine.save(iDocumentLine);
    }

    private static String getTableNameMA(IDocumentLine iDocumentLine) {
        return iDocumentLine.get_TableName() + "MA";
    }

    private static int deleteMA(IDocumentLine iDocumentLine) {
        String string = "DELETE FROM " + StorageEngine.getTableNameMA(iDocumentLine) + " WHERE " + iDocumentLine.get_TableName() + "_ID=?";
        int n = DB.executeUpdateEx(string, new Object[]{iDocumentLine.get_ID()}, iDocumentLine.get_TrxName());
        if (n > 0) {
            log.config("Delete old #" + n);
        }
        return n;
    }

    private static void saveMA(IInventoryAllocation iInventoryAllocation) {
        ((PO)((Object)iInventoryAllocation)).saveEx();
    }

    private static void save(IDocumentLine iDocumentLine) {
        ((PO)((Object)iDocumentLine)).saveEx();
    }

    private static void create(IDocumentLine iDocumentLine, String string, Timestamp timestamp, int n, BigDecimal bigDecimal) {
        MTransaction mTransaction = new MTransaction(iDocumentLine.getCtx(), iDocumentLine.getAD_Org_ID(), string, iDocumentLine.getM_Locator_ID(), iDocumentLine.getM_Product_ID(), n, bigDecimal, timestamp, iDocumentLine.get_TrxName());
        StorageEngine.setReferenceLine_ID(mTransaction, iDocumentLine);
        mTransaction.saveEx();
        CostEngineFactory.getCostEngine(iDocumentLine.getAD_Client_ID()).createCostDetail(iDocumentLine, mTransaction);
    }

    private static IInventoryAllocation createMA(IDocumentLine iDocumentLine, int n, BigDecimal bigDecimal) {
        Properties properties = iDocumentLine.getCtx();
        String string = StorageEngine.getTableNameMA(iDocumentLine);
        String string2 = iDocumentLine.get_TrxName();
        IInventoryAllocation iInventoryAllocation = (IInventoryAllocation)((Object)MTable.get(properties, string).getPO(0, string2));
        iInventoryAllocation.setAD_Org_ID(iDocumentLine.getAD_Org_ID());
        StorageEngine.setReferenceLine_ID((PO)((Object)iInventoryAllocation), iDocumentLine);
        iInventoryAllocation.setM_AttributeSetInstance_ID(n);
        iInventoryAllocation.setMovementQty(bigDecimal);
        StorageEngine.saveMA(iInventoryAllocation);
        log.fine("##: " + iInventoryAllocation);
        return iInventoryAllocation;
    }

    private static IInventoryAllocation[] getMA(IDocumentLine iDocumentLine) {
        Properties properties = iDocumentLine.getCtx();
        String string = iDocumentLine.get_TableName() + "_ID";
        String string2 = StorageEngine.getTableNameMA(iDocumentLine);
        String string3 = iDocumentLine.get_TrxName();
        String string4 = string + "=?";
        List<IInventoryAllocation> list = new Query(properties, string2, string4, string3).setParameters(iDocumentLine.get_ID()).setOrderBy(string).list();
        IInventoryAllocation[] iInventoryAllocationArray = new IInventoryAllocation[list.size()];
        return list.toArray(iInventoryAllocationArray);
    }

    private static void setReferenceLine_ID(PO pO, IDocumentLine iDocumentLine) {
        String string = iDocumentLine.get_TableName() + "_ID";
        if (pO.get_ColumnIndex(string) < 0) {
            throw new AdempiereException("Invalid inventory document line " + iDocumentLine);
        }
        pO.set_ValueOfColumn(string, (Object)iDocumentLine.get_ID());
    }

    public static int getM_Locator_ID(Properties properties, int n, int n2, int n3, BigDecimal bigDecimal, String string) {
        int n4 = MStorage.getM_Locator_ID(n, n2, n3, bigDecimal, string);
        if (n4 == 0) {
            MWarehouse mWarehouse = MWarehouse.get(properties, n);
            n4 = mWarehouse.getDefaultLocator().getM_Locator_ID();
        }
        return n4;
    }
}

