/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.model.engines;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.model.engines.CostDimension;
import org.adempiere.model.engines.IDocumentLine;
import org.compiere.model.I_M_CostElement;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCost;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCostElement;
import org.compiere.model.MProduct;
import org.compiere.model.MTransaction;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.model.MPPCostCollector;
import org.eevolution.model.MPPOrderCost;
import org.eevolution.model.RoutingService;
import org.eevolution.model.RoutingServiceFactory;

public class CostEngine {
    protected transient CLogger log = CLogger.getCLogger(this.getClass());

    public String getCostingMethod() {
        return "S";
    }

    public BigDecimal getResourceStandardCostRate(MPPCostCollector mPPCostCollector, int n, CostDimension costDimension, String string) {
        MProduct mProduct = MProduct.forS_Resource_ID(Env.getCtx(), n, null);
        return this.getProductStandardCostPrice(mPPCostCollector, mProduct, MAcctSchema.get(Env.getCtx(), costDimension.getC_AcctSchema_ID()), MCostElement.get(Env.getCtx(), costDimension.getM_CostElement_ID()));
    }

    public BigDecimal getResourceActualCostRate(MPPCostCollector mPPCostCollector, int n, CostDimension costDimension, String string) {
        if (n <= 0) {
            return Env.ZERO;
        }
        MProduct mProduct = MProduct.forS_Resource_ID(Env.getCtx(), n, null);
        return this.getProductActualCostPrice(mPPCostCollector, mProduct, MAcctSchema.get(Env.getCtx(), costDimension.getC_AcctSchema_ID()), MCostElement.get(Env.getCtx(), costDimension.getM_CostElement_ID()), string);
    }

    public BigDecimal getProductActualCostPrice(MPPCostCollector mPPCostCollector, MProduct mProduct, MAcctSchema mAcctSchema, MCostElement mCostElement, String string) {
        CostDimension costDimension = new CostDimension(mProduct, mAcctSchema, mAcctSchema.getM_CostType_ID(), 0, 0, mCostElement.getM_CostElement_ID());
        MCost mCost = (MCost)costDimension.toQuery(MCost.class, string).firstOnly();
        if (mCost == null) {
            throw new AdempiereException("@NotFound@ @M_Cost_ID@ - " + mAcctSchema + ", " + mCostElement);
        }
        BigDecimal bigDecimal = mCost.getCurrentCostPrice().add(mCost.getCurrentCostPriceLL());
        return this.roundCost(bigDecimal, mAcctSchema.getC_AcctSchema_ID());
    }

    public BigDecimal getProductStandardCostPrice(MPPCostCollector mPPCostCollector, MProduct mProduct, MAcctSchema mAcctSchema, MCostElement mCostElement) {
        CostDimension costDimension = new CostDimension(mProduct, mAcctSchema, mAcctSchema.getM_CostType_ID(), 0, 0, mCostElement.getM_CostElement_ID());
        MPPOrderCost mPPOrderCost = (MPPOrderCost)costDimension.toQuery(MPPOrderCost.class, "PP_Order_ID=?", new Object[]{mPPCostCollector.getPP_Order_ID()}, mPPCostCollector.get_TrxName()).firstOnly();
        if (mPPOrderCost == null) {
            return Env.ZERO;
        }
        BigDecimal bigDecimal = mPPOrderCost.getCurrentCostPrice().add(mPPOrderCost.getCurrentCostPriceLL());
        return this.roundCost(bigDecimal, mAcctSchema.getC_AcctSchema_ID());
    }

    protected BigDecimal roundCost(BigDecimal bigDecimal, int n) {
        int n2 = MAcctSchema.get(Env.getCtx(), n).getCostingPrecision();
        BigDecimal bigDecimal2 = bigDecimal;
        if (bigDecimal2.scale() > n2) {
            bigDecimal2 = bigDecimal2.setScale(n2, RoundingMode.HALF_UP);
        }
        return bigDecimal2;
    }

    public Collection<MCost> getByElement(MProduct mProduct, MAcctSchema mAcctSchema, int n, int n2, int n3, int n4) {
        CostDimension costDimension = new CostDimension(mProduct, mAcctSchema, n, n2, n3, n4);
        return costDimension.toQuery(MCost.class, mProduct.get_TrxName()).setOnlyActiveRecords(true).list();
    }

    private MCostDetail getCostDetail(IDocumentLine iDocumentLine, MTransaction mTransaction, MAcctSchema mAcctSchema, int n) {
        String string = "AD_Client_ID=? AND AD_Org_ID=? AND " + iDocumentLine.get_TableName() + "_ID=?" + " AND " + "M_Product_ID" + "=?" + " AND " + "M_AttributeSetInstance_ID" + "=?" + " AND " + "C_AcctSchema_ID" + "=?" + " AND " + "M_CostElement_ID" + "=?";
        Object[] objectArray = new Object[]{mTransaction.getAD_Client_ID(), mTransaction.getAD_Org_ID(), iDocumentLine.get_ID(), mTransaction.getM_Product_ID(), mTransaction.getM_AttributeSetInstance_ID(), mAcctSchema.getC_AcctSchema_ID(), n};
        return (MCostDetail)new Query(mTransaction.getCtx(), "M_CostDetail", string, mTransaction.get_TrxName()).setParameters(objectArray).firstOnly();
    }

    public void createCostDetail(IDocumentLine iDocumentLine, MTransaction mTransaction) {
        MPPCostCollector mPPCostCollector = iDocumentLine instanceof MPPCostCollector ? (MPPCostCollector)iDocumentLine : null;
        for (MAcctSchema mAcctSchema : this.getAcctSchema(mTransaction)) {
            MProduct mProduct = MProduct.get(mTransaction.getCtx(), mTransaction.getM_Product_ID());
            String string = mProduct.getCostingMethod(mAcctSchema);
            if (!this.getCostingMethod().equals(string)) {
                throw new AdempiereException("Costing method not supported - " + string);
            }
            for (MCostElement mCostElement : this.getCostElements(mTransaction.getCtx())) {
                this.deleteCostDetail(iDocumentLine, mAcctSchema, mCostElement.get_ID(), mTransaction.getM_AttributeSetInstance_ID());
                BigDecimal bigDecimal = mTransaction.getMovementQty();
                BigDecimal bigDecimal2 = this.getProductActualCostPrice(mPPCostCollector, mProduct, mAcctSchema, mCostElement, mTransaction.get_TrxName());
                BigDecimal bigDecimal3 = this.roundCost(bigDecimal2.multiply(bigDecimal), mAcctSchema.getC_AcctSchema_ID());
                MCostDetail mCostDetail = this.getCostDetail(iDocumentLine, mTransaction, mAcctSchema, mCostElement.get_ID());
                if (mCostDetail == null) {
                    mCostDetail = new MCostDetail(mAcctSchema, mTransaction.getAD_Org_ID(), mTransaction.getM_Product_ID(), mTransaction.getM_AttributeSetInstance_ID(), mCostElement.get_ID(), bigDecimal3, bigDecimal, iDocumentLine.getDescription(), mTransaction.get_TrxName());
                    if (iDocumentLine instanceof MPPCostCollector) {
                        mCostDetail.setPP_Cost_Collector_ID(iDocumentLine.get_ID());
                    }
                } else {
                    mCostDetail.setDeltaAmt(bigDecimal3.subtract(mCostDetail.getAmt()));
                    mCostDetail.setDeltaQty(mTransaction.getMovementQty().subtract(mCostDetail.getQty()));
                    if (mCostDetail.isDelta()) {
                        mCostDetail.setProcessed(false);
                        mCostDetail.setAmt(bigDecimal3);
                        mCostDetail.setQty(mTransaction.getMovementQty());
                    }
                }
                mCostDetail.saveEx();
                this.processCostDetail(mCostDetail);
                this.log.config("" + mCostDetail);
            }
        }
    }

    private int deleteCostDetail(IDocumentLine iDocumentLine, MAcctSchema mAcctSchema, int n, int n2) {
        String string = "DELETE M_CostDetail WHERE Processed='N' AND COALESCE(DeltaAmt,0)=0 AND COALESCE(DeltaQty,0)=0 AND " + iDocumentLine.get_TableName() + "_ID=?" + " AND " + "C_AcctSchema_ID" + "=?" + " AND " + "M_AttributeSetInstance_ID" + "=?" + " AND " + "M_CostElement_ID" + "=?";
        Object[] objectArray = new Object[]{iDocumentLine.get_ID(), mAcctSchema.getC_AcctSchema_ID(), n2, n};
        int n3 = DB.executeUpdateEx(string, objectArray, iDocumentLine.get_TrxName());
        if (n3 != 0) {
            this.log.config("Deleted #" + n3);
        }
        return n3;
    }

    private void processCostDetail(MCostDetail mCostDetail) {
        if (!mCostDetail.isProcessed()) {
            mCostDetail.process();
        }
    }

    public static boolean isActivityControlElement(I_M_CostElement i_M_CostElement) {
        String string = i_M_CostElement.getCostElementType();
        return "R".equals(string) || "O".equals(string) || "B".equals(string);
    }

    private Collection<MCostElement> getCostElements(Properties properties) {
        return MCostElement.getByCostingMethod(properties, this.getCostingMethod());
    }

    private Collection<MAcctSchema> getAcctSchema(PO pO) {
        int n = pO.getAD_Org_ID();
        MAcctSchema[] mAcctSchemaArray = MAcctSchema.getClientAcctSchema(pO.getCtx(), pO.getAD_Client_ID());
        ArrayList<MAcctSchema> arrayList = new ArrayList<MAcctSchema>(mAcctSchemaArray.length);
        for (MAcctSchema mAcctSchema : mAcctSchemaArray) {
            if (mAcctSchema.isSkipOrg(n)) continue;
            arrayList.add(mAcctSchema);
        }
        return arrayList;
    }

    private MCostDetail getCostDetail(MPPCostCollector mPPCostCollector, int n) {
        MCostDetail mCostDetail = (MCostDetail)new Query(mPPCostCollector.getCtx(), "M_CostDetail", "PP_Cost_Collector_ID=? AND M_CostElement_ID=?", mPPCostCollector.get_TrxName()).setParameters(mPPCostCollector.getPP_Cost_Collector_ID(), n).firstOnly();
        return mCostDetail;
    }

    private MPPCostCollector createVarianceCostCollector(MPPCostCollector mPPCostCollector, String string) {
        MPPCostCollector mPPCostCollector2 = new MPPCostCollector(mPPCostCollector.getCtx(), 0, mPPCostCollector.get_TrxName());
        MPPCostCollector.copyValues(mPPCostCollector, mPPCostCollector2);
        mPPCostCollector2.setProcessing(false);
        mPPCostCollector2.setProcessed(false);
        mPPCostCollector2.setDocStatus("DR");
        mPPCostCollector2.setDocAction("CO");
        mPPCostCollector2.setCostCollectorType(string);
        mPPCostCollector2.setDocumentNo(null);
        mPPCostCollector2.saveEx();
        return mPPCostCollector2;
    }

    private MCostDetail createVarianceCostDetail(MPPCostCollector mPPCostCollector, BigDecimal bigDecimal, BigDecimal bigDecimal2, MCostDetail mCostDetail, MProduct mProduct, MAcctSchema mAcctSchema, MCostElement mCostElement) {
        MCostDetail mCostDetail2 = new MCostDetail(mPPCostCollector.getCtx(), 0, mPPCostCollector.get_TrxName());
        if (mCostDetail != null) {
            MCostDetail.copyValues(mCostDetail, mCostDetail2);
            mCostDetail2.setProcessed(false);
        }
        if (mProduct != null) {
            mCostDetail2.setM_Product_ID(mProduct.getM_Product_ID());
            mCostDetail2.setM_AttributeSetInstance_ID(0);
        }
        if (mAcctSchema != null) {
            mCostDetail2.setC_AcctSchema_ID(mAcctSchema.getC_AcctSchema_ID());
        }
        if (mCostElement != null) {
            mCostDetail2.setM_CostElement_ID(mCostElement.getM_CostElement_ID());
        }
        mCostDetail2.setPP_Cost_Collector_ID(mPPCostCollector.getPP_Cost_Collector_ID());
        mCostDetail2.setAmt(bigDecimal);
        mCostDetail2.setQty(bigDecimal2);
        mCostDetail2.saveEx();
        this.processCostDetail(mCostDetail2);
        return mCostDetail2;
    }

    public void createActivityControl(MPPCostCollector mPPCostCollector) {
        if (!mPPCostCollector.isCostCollectorType("160")) {
            return;
        }
        MProduct mProduct = MProduct.forS_Resource_ID(mPPCostCollector.getCtx(), mPPCostCollector.getS_Resource_ID(), null);
        RoutingService routingService = RoutingServiceFactory.get().getRoutingService(mPPCostCollector.getAD_Client_ID());
        BigDecimal bigDecimal = routingService.getResourceBaseValue(mPPCostCollector.getS_Resource_ID(), mPPCostCollector);
        for (MAcctSchema mAcctSchema : this.getAcctSchema(mPPCostCollector)) {
            for (MCostElement mCostElement : this.getCostElements(mPPCostCollector.getCtx())) {
                if (!CostEngine.isActivityControlElement(mCostElement)) continue;
                CostDimension costDimension = new CostDimension(mProduct, mAcctSchema, mAcctSchema.getM_CostType_ID(), 0, 0, mCostElement.getM_CostElement_ID());
                BigDecimal bigDecimal2 = this.getResourceActualCostRate(mPPCostCollector, mPPCostCollector.getS_Resource_ID(), costDimension, mPPCostCollector.get_TrxName());
                BigDecimal bigDecimal3 = bigDecimal2.multiply(bigDecimal);
                if (bigDecimal3.scale() > mAcctSchema.getCostingPrecision()) {
                    bigDecimal3 = bigDecimal3.setScale(mAcctSchema.getCostingPrecision(), RoundingMode.HALF_UP);
                }
                MCostDetail mCostDetail = new MCostDetail(mAcctSchema, 0, costDimension.getM_Product_ID(), 0, mCostElement.getM_CostElement_ID(), bigDecimal3.negate(), bigDecimal.negate(), "", mPPCostCollector.get_TrxName());
                mCostDetail.setPP_Cost_Collector_ID(mPPCostCollector.getPP_Cost_Collector_ID());
                mCostDetail.saveEx();
                this.processCostDetail(mCostDetail);
            }
        }
    }

    public void createUsageVariances(MPPCostCollector mPPCostCollector) {
        BigDecimal bigDecimal;
        MProduct mProduct;
        if (!mPPCostCollector.isCostCollectorType("120")) {
            throw new IllegalArgumentException("Cost Collector is not Material Usage Variance");
        }
        if (mPPCostCollector.getPP_Order_BOMLine_ID() > 0) {
            mProduct = MProduct.get(mPPCostCollector.getCtx(), mPPCostCollector.getM_Product_ID());
            bigDecimal = mPPCostCollector.getMovementQty();
        } else {
            mProduct = MProduct.forS_Resource_ID(mPPCostCollector.getCtx(), mPPCostCollector.getS_Resource_ID(), null);
            RoutingService routingService = RoutingServiceFactory.get().getRoutingService(mPPCostCollector.getAD_Client_ID());
            bigDecimal = routingService.getResourceBaseValue(mPPCostCollector.getS_Resource_ID(), mPPCostCollector);
        }
        for (MAcctSchema mAcctSchema : this.getAcctSchema(mPPCostCollector)) {
            for (MCostElement mCostElement : this.getCostElements(mPPCostCollector.getCtx())) {
                BigDecimal bigDecimal2 = this.getProductActualCostPrice(mPPCostCollector, mProduct, mAcctSchema, mCostElement, mPPCostCollector.get_TrxName());
                BigDecimal bigDecimal3 = this.roundCost(bigDecimal2.multiply(bigDecimal), mAcctSchema.getC_AcctSchema_ID());
                this.createVarianceCostDetail(mPPCostCollector, bigDecimal3, bigDecimal, null, mProduct, mAcctSchema, mCostElement);
            }
        }
    }

    public void createRateVariances(MPPCostCollector mPPCostCollector) {
        MProduct mProduct;
        Object object;
        if (mPPCostCollector.isCostCollectorType("160")) {
            object = mPPCostCollector.getPP_Order_Node().getAD_WF_Node();
            mProduct = MProduct.forS_Resource_ID(mPPCostCollector.getCtx(), object.getS_Resource_ID(), null);
        } else if (mPPCostCollector.isCostCollectorType("110")) {
            object = mPPCostCollector.getPP_Order_BOMLine();
            mProduct = MProduct.get(mPPCostCollector.getCtx(), object.getM_Product_ID());
        } else {
            return;
        }
        object = null;
        for (MAcctSchema mAcctSchema : this.getAcctSchema(mPPCostCollector)) {
            for (MCostElement mCostElement : this.getCostElements(mPPCostCollector.getCtx())) {
                BigDecimal bigDecimal;
                MCostDetail mCostDetail = this.getCostDetail(mPPCostCollector, mCostElement.getM_CostElement_ID());
                if (mCostDetail == null) continue;
                BigDecimal bigDecimal2 = mCostDetail.getQty();
                BigDecimal bigDecimal3 = this.getProductStandardCostPrice(mPPCostCollector, mProduct, mAcctSchema, mCostElement);
                BigDecimal bigDecimal4 = this.getProductActualCostPrice(mPPCostCollector, mProduct, mAcctSchema, mCostElement, mPPCostCollector.get_TrxName());
                BigDecimal bigDecimal5 = this.roundCost(bigDecimal3.multiply(bigDecimal2), mAcctSchema.getC_AcctSchema_ID());
                if (bigDecimal5.compareTo(bigDecimal = this.roundCost(bigDecimal4.multiply(bigDecimal2), mAcctSchema.getC_AcctSchema_ID())) == 0) continue;
                if (object == null) {
                    object = this.createVarianceCostCollector(mPPCostCollector, "140");
                }
                this.createVarianceCostDetail((MPPCostCollector)object, bigDecimal.negate(), bigDecimal2.negate(), mCostDetail, null, mAcctSchema, mCostElement);
                this.createVarianceCostDetail((MPPCostCollector)object, bigDecimal5, bigDecimal2, mCostDetail, null, mAcctSchema, mCostElement);
            }
        }
        if (object != null) {
            boolean bl = ((MPPCostCollector)object).processIt("CO");
            ((PO)object).saveEx();
            if (!bl) {
                throw new AdempiereException(((MPPCostCollector)object).getProcessMsg());
            }
        }
    }

    public void createMethodVariances(MPPCostCollector mPPCostCollector) {
        int n;
        if (!mPPCostCollector.isCostCollectorType("160")) {
            return;
        }
        int n2 = mPPCostCollector.getPP_Order_Node().getAD_WF_Node().getS_Resource_ID();
        if (n2 == (n = mPPCostCollector.getS_Resource_ID())) {
            return;
        }
        MPPCostCollector mPPCostCollector2 = null;
        RoutingService routingService = RoutingServiceFactory.get().getRoutingService(mPPCostCollector.getAD_Client_ID());
        for (MAcctSchema mAcctSchema : this.getAcctSchema(mPPCostCollector)) {
            for (MCostElement mCostElement : this.getCostElements(mPPCostCollector.getCtx())) {
                BigDecimal bigDecimal;
                MProduct mProduct = MProduct.forS_Resource_ID(mPPCostCollector.getCtx(), n2, null);
                MProduct mProduct2 = MProduct.forS_Resource_ID(mPPCostCollector.getCtx(), n, null);
                BigDecimal bigDecimal2 = this.getProductActualCostPrice(mPPCostCollector, mProduct, mAcctSchema, mCostElement, mPPCostCollector.get_TrxName());
                if (bigDecimal2.compareTo(bigDecimal = this.getProductActualCostPrice(mPPCostCollector, mProduct2, mAcctSchema, mCostElement, mPPCostCollector.get_TrxName())) == 0) continue;
                if (mPPCostCollector2 == null) {
                    mPPCostCollector2 = this.createVarianceCostCollector(mPPCostCollector, "130");
                }
                BigDecimal bigDecimal3 = routingService.getResourceBaseValue(mPPCostCollector.getS_Resource_ID(), mPPCostCollector);
                BigDecimal bigDecimal4 = bigDecimal2.multiply(bigDecimal3);
                BigDecimal bigDecimal5 = bigDecimal.multiply(bigDecimal3);
                this.createVarianceCostDetail(mPPCostCollector2, bigDecimal5, bigDecimal3, null, mProduct2, mAcctSchema, mCostElement);
                this.createVarianceCostDetail(mPPCostCollector2, bigDecimal4.negate(), bigDecimal3.negate(), null, mProduct, mAcctSchema, mCostElement);
            }
        }
        if (mPPCostCollector2 != null) {
            boolean bl = mPPCostCollector2.processIt("CO");
            mPPCostCollector2.saveEx();
            if (!bl) {
                throw new AdempiereException(mPPCostCollector2.getProcessMsg());
            }
        }
    }
}

