/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.model.engines;

import java.util.ArrayList;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MProduct;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class CostDimension {
    public static final int ANY = -10;
    private int AD_Client_ID;
    private int AD_Org_ID;
    private int M_Product_ID;
    private int S_Resource_ID;
    private int M_AttributeSetInstance_ID;
    private int M_CostType_ID;
    private int C_AcctSchema_ID;
    private int M_CostElement_ID;

    public CostDimension(MProduct mProduct, MAcctSchema mAcctSchema, int n, int n2, int n3, int n4) {
        this.AD_Client_ID = mAcctSchema.getAD_Client_ID();
        this.AD_Org_ID = n2;
        this.M_Product_ID = mProduct != null ? mProduct.get_ID() : -10;
        this.M_AttributeSetInstance_ID = n3;
        this.M_CostType_ID = n;
        this.C_AcctSchema_ID = mAcctSchema.get_ID();
        this.M_CostElement_ID = n4;
        this.updateForProduct(mProduct, mAcctSchema);
    }

    public CostDimension(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.AD_Client_ID = n;
        this.AD_Org_ID = n2;
        this.M_Product_ID = n3;
        this.M_AttributeSetInstance_ID = n4;
        this.M_CostType_ID = n5;
        this.C_AcctSchema_ID = n6;
        this.M_CostElement_ID = n7;
        this.updateForProduct(null, null);
    }

    public CostDimension(CostDimension costDimension) {
        this.AD_Client_ID = costDimension.AD_Client_ID;
        this.AD_Org_ID = costDimension.AD_Org_ID;
        this.M_Product_ID = costDimension.M_Product_ID;
        this.M_AttributeSetInstance_ID = costDimension.M_AttributeSetInstance_ID;
        this.M_CostType_ID = costDimension.M_CostType_ID;
        this.C_AcctSchema_ID = costDimension.C_AcctSchema_ID;
        this.M_CostElement_ID = costDimension.M_CostElement_ID;
    }

    private Properties getCtx() {
        return Env.getCtx();
    }

    private void updateForProduct(MProduct mProduct, MAcctSchema mAcctSchema) {
        String string;
        if (mProduct == null) {
            mProduct = MProduct.get(this.getCtx(), this.M_Product_ID);
        }
        if (mProduct == null) {
            return;
        }
        if (mAcctSchema == null) {
            mAcctSchema = MAcctSchema.get(this.getCtx(), this.C_AcctSchema_ID);
        }
        if ("C".equals(string = mProduct.getCostingLevel(mAcctSchema))) {
            this.AD_Org_ID = 0;
            this.M_AttributeSetInstance_ID = 0;
        } else if ("O".equals(string)) {
            this.M_AttributeSetInstance_ID = 0;
        } else if ("B".equals(string)) {
            this.AD_Org_ID = 0;
        }
        this.S_Resource_ID = mProduct.getS_Resource_ID();
    }

    public int getAD_Client_ID() {
        return this.AD_Client_ID;
    }

    public int getAD_Org_ID() {
        return this.AD_Org_ID;
    }

    public int getM_Product_ID() {
        return this.M_Product_ID;
    }

    public int getS_Resource_ID() {
        return this.S_Resource_ID;
    }

    public CostDimension setM_Product_ID(int n) {
        CostDimension costDimension = new CostDimension(this);
        costDimension.M_Product_ID = n;
        costDimension.updateForProduct(null, null);
        return costDimension;
    }

    public CostDimension setM_Product(MProduct mProduct) {
        CostDimension costDimension = new CostDimension(this);
        costDimension.M_Product_ID = mProduct.get_ID();
        costDimension.updateForProduct(mProduct, null);
        return costDimension;
    }

    public int getM_AttributeSetInstance_ID() {
        return this.M_AttributeSetInstance_ID;
    }

    public int getM_CostType_ID() {
        return this.M_CostType_ID;
    }

    public int getC_AcctSchema_ID() {
        return this.C_AcctSchema_ID;
    }

    public int getM_CostElement_ID() {
        return this.M_CostElement_ID;
    }

    public Query toQuery(Class<?> clazz, String string) {
        return this.toQuery(clazz, null, null, string);
    }

    public Query toQuery(Class<?> clazz, String string, Object[] objectArray, String string2) {
        String string3;
        try {
            string3 = (String)clazz.getField("Table_Name").get(null);
        }
        catch (Exception exception) {
            throw new AdempiereException(exception);
        }
        Properties properties = Env.getCtx();
        MTable mTable = MTable.get(properties, string3);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("AD_Client_ID=?");
        arrayList.add(this.AD_Client_ID);
        stringBuffer.append(" AND AD_Org_ID=?");
        arrayList.add(this.AD_Org_ID);
        stringBuffer.append(" AND M_Product_ID=?");
        arrayList.add(this.M_Product_ID);
        stringBuffer.append(" AND M_AttributeSetInstance_ID=?");
        arrayList.add(this.M_AttributeSetInstance_ID);
        stringBuffer.append(" AND C_AcctSchema_ID=?");
        arrayList.add(this.C_AcctSchema_ID);
        if (this.M_CostElement_ID != -10) {
            stringBuffer.append(" AND M_CostElement_ID=?");
            arrayList.add(this.M_CostElement_ID);
        }
        if (this.M_CostType_ID != -10 && mTable.getColumn("M_CostType_ID") != null) {
            stringBuffer.append(" AND M_CostType_ID=?");
            arrayList.add(this.M_CostType_ID);
        }
        if (!Util.isEmpty(string, true)) {
            stringBuffer.append(" AND (").append(string).append(")");
            if (objectArray != null && objectArray.length > 0) {
                for (Object object : objectArray) {
                    arrayList.add(object);
                }
            }
        }
        return new Query(properties, string3, stringBuffer.toString(), string2).setParameters(arrayList);
    }

    protected Object clone() {
        return new CostDimension(this);
    }

    public String toString() {
        String string = "";
        string = "CostDimension{AD_Client_ID = " + this.AD_Client_ID + ";" + "AD_Org_ID = " + this.AD_Org_ID + ";" + "M_Product_ID = " + this.M_Product_ID + ";" + "M_AttributeSetInstance_ID = " + this.M_AttributeSetInstance_ID + ";" + "M_CostType_ID = " + this.M_CostType_ID + ";" + "C_AcctSchema_ID = " + this.C_AcctSchema_ID + ";" + "M_CostElement_ID = " + this.M_CostElement_ID + ";" + "}";
        return string;
    }
}

