/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.model.MPromotionDistribution;
import org.adempiere.model.MPromotionLine;
import org.adempiere.model.MPromotionReward;
import org.adempiere.model.PromotionValidator;
import org.compiere.model.I_M_Promotion;
import org.compiere.model.I_M_PromotionDistribution;
import org.compiere.model.I_M_PromotionLine;
import org.compiere.model.I_M_PromotionReward;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class PromotionRule {
    public static void applyPromotions(MOrder order) throws Exception {
        Map<Integer, List<Integer>> promotions;
        LinkedHashMap<Integer, BigDecimal> orderLineQty = new LinkedHashMap<Integer, BigDecimal>();
        HashMap<Integer, MOrderLine> orderLineIndex = new HashMap<Integer, MOrderLine>();
        MOrderLine[] lines = order.getLines();
        boolean hasDeleteLine = false;
        MOrderLine[] mOrderLineArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            Number id;
            MOrderLine ol = mOrderLineArray[n2];
            if (ol.getM_Product_ID() > 0) {
                if (ol.getQtyOrdered().signum() > 0) {
                    orderLineQty.put(ol.getC_OrderLine_ID(), ol.getQtyOrdered());
                    orderLineIndex.put(ol.getC_OrderLine_ID(), ol);
                }
            } else if (ol.getC_Charge_ID() > 0 && (id = (Number)ol.get_Value("M_Promotion_ID")) != null && id.intValue() > 0) {
                ol.delete(false);
                hasDeleteLine = true;
            }
            ++n2;
        }
        if (orderLineQty.isEmpty()) {
            return;
        }
        if (hasDeleteLine) {
            order.getLines(true, null);
            order.getTaxes(true);
            order.setGrandTotal(DB.getSQLValueBD(order.get_TrxName(), "SELECT GrandTotal From C_Order WHERE C_Order_ID = ?", order.getC_Order_ID()));
        }
        if ((promotions = PromotionRule.findM_Promotion_ID(order)) == null || promotions.isEmpty()) {
            return;
        }
        BigDecimal orderAmount = order.getGrandTotal();
        LinkedHashMap<Integer, DistributionSet> distributions = new LinkedHashMap<Integer, DistributionSet>();
        HashMap<Integer, String> sortingType = new HashMap<Integer, String>();
        OrderLineComparator olComparator = new OrderLineComparator(orderLineIndex);
        block1: for (Map.Entry<Integer, List<Integer>> entry : promotions.entrySet()) {
            Query query = new Query(Env.getCtx(), MTable.get(order.getCtx(), I_M_PromotionDistribution.Table_ID), "M_PromotionDistribution.M_Promotion_ID = ? AND M_PromotionDistribution.IsActive = 'Y'", order.get_TrxName());
            query.setParameters(entry.getKey());
            query.setOrderBy("SeqNo");
            List list = query.list();
            Query rewardQuery = new Query(Env.getCtx(), MTable.get(order.getCtx(), I_M_PromotionReward.Table_ID), "M_PromotionReward.M_Promotion_ID = ? AND M_PromotionReward.IsActive = 'Y'", order.get_TrxName());
            rewardQuery.setParameters(entry.getKey());
            rewardQuery.setOrderBy("SeqNo");
            List rewardList = rewardQuery.list();
            ArrayList<MPromotionLine> promotionLines = new ArrayList<MPromotionLine>();
            for (Integer M_PromotionLine_ID : entry.getValue()) {
                MPromotionLine promotionLine = new MPromotionLine(order.getCtx(), M_PromotionLine_ID, order.get_TrxName());
                promotionLines.add(promotionLine);
            }
            block3: while (true) {
                DistributionSet distributionSet2;
                boolean hasDistributionSet = false;
                HashSet<Integer> promotionLineSet = new HashSet<Integer>();
                HashSet<Integer> mandatoryLineSet = new HashSet<Integer>();
                boolean mandatoryLineNotFound = false;
                ArrayList<Integer> validPromotionLineIDs = new ArrayList<Integer>();
                for (MPromotionLine promotionLine : promotionLines) {
                    if (promotionLine.getM_PromotionGroup_ID() != 0 || promotionLine.getMinimumAmt() == null || promotionLine.getMinimumAmt().signum() < 0) continue;
                    if (orderAmount.compareTo(promotionLine.getMinimumAmt()) >= 0) {
                        orderAmount = orderAmount.subtract(promotionLine.getMinimumAmt());
                        validPromotionLineIDs.add(promotionLine.getM_PromotionLine_ID());
                        continue;
                    }
                    if (!promotionLine.isMandatoryPL()) continue;
                    mandatoryLineNotFound = true;
                    break;
                }
                if (mandatoryLineNotFound) continue block1;
                for (MPromotionDistribution pd : list) {
                    DistributionSet prevSet;
                    if (!entry.getValue().contains(pd.getM_PromotionLine_ID())) continue;
                    ArrayList<Integer> orderLineIdList = new ArrayList<Integer>();
                    orderLineIdList.addAll(orderLineQty.keySet());
                    if (pd.getDistributionSorting() != null) {
                        Comparator<Integer> cmp = olComparator;
                        if (pd.getDistributionSorting().equals("D")) {
                            cmp = Collections.reverseOrder(cmp);
                        }
                        Collections.sort(orderLineIdList, cmp);
                    }
                    if ((distributionSet2 = PromotionRule.calculateDistributionQty(pd, prevSet = (DistributionSet)distributions.get(pd.getM_PromotionDistribution_ID()), validPromotionLineIDs, orderLineQty, orderLineIdList, order.get_TrxName())) != null && distributionSet2.setQty.signum() > 0) {
                        hasDistributionSet = true;
                        promotionLineSet.add(pd.getM_PromotionLine_ID());
                    } else if (pd.getM_PromotionLine().isMandatoryPL()) {
                        mandatoryLineSet.add(pd.getM_PromotionLine_ID());
                    }
                    distributions.put(pd.getM_PromotionDistribution_ID(), distributionSet2);
                    sortingType.put(pd.getM_PromotionDistribution_ID(), pd.getDistributionSorting());
                }
                if (!hasDistributionSet) continue block1;
                if (mandatoryLineSet != null) {
                    mandatoryLineNotFound = false;
                    for (Integer id : mandatoryLineSet) {
                        if (promotionLineSet.contains(id)) continue;
                        mandatoryLineNotFound = true;
                        break;
                    }
                    if (mandatoryLineNotFound) continue block1;
                }
                Iterator<Object> iterator = rewardList.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block3;
                    MPromotionReward pr = (MPromotionReward)iterator.next();
                    if (pr.isForAllDistribution()) {
                        Collection all = distributions.values();
                        BigDecimal totalPrice = BigDecimal.ZERO;
                        for (DistributionSet distributionSet2 : all) {
                            for (Map.Entry<Integer, BigDecimal> olMap : distributionSet2.orderLines.entrySet()) {
                                BigDecimal qty = olMap.getValue();
                                int C_OrderLine_ID = olMap.getKey();
                                MOrderLine[] mOrderLineArray2 = lines;
                                int n3 = lines.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    MOrderLine ol = mOrderLineArray2[n4];
                                    if (ol.getC_OrderLine_ID() == C_OrderLine_ID) {
                                        totalPrice = totalPrice.add(ol.getPriceActual().multiply(qty));
                                        break;
                                    }
                                    ++n4;
                                }
                                distributionSet2.orderLines.put(olMap.getKey(), BigDecimal.ZERO);
                            }
                        }
                        BigDecimal discount = BigDecimal.ZERO;
                        if (pr.getRewardType().equals("A")) {
                            if (pr.getAmount().compareTo(totalPrice) < 0) {
                                discount = totalPrice.subtract(pr.getAmount());
                            }
                        } else if (pr.getRewardType().equals("F")) {
                            discount = pr.getAmount();
                        } else if (pr.getRewardType().equals("P")) {
                            discount = pr.getAmount().divide(BigDecimal.valueOf(100.0)).multiply(totalPrice);
                        }
                        if (discount.signum() <= 0) continue;
                        PromotionRule.addDiscountLine(order, null, discount, BigDecimal.valueOf(1.0), pr.getC_Charge_ID(), pr.getM_Promotion());
                        continue;
                    }
                    int M_PromotionDistribution_ID = pr.getM_PromotionDistribution_ID();
                    if (!distributions.containsKey(M_PromotionDistribution_ID)) continue;
                    int targetDistributionID = M_PromotionDistribution_ID;
                    if (!pr.isSameDistribution() && !distributions.containsKey(targetDistributionID = pr.getM_TargetDistribution_ID())) continue;
                    distributionSet2 = (DistributionSet)distributions.get(targetDistributionID);
                    if (pr.getDistributionSorting() != null) {
                        Comparator<Integer> cmp = new OrderLineComparator(orderLineIndex);
                        if (pr.getDistributionSorting().equals("D")) {
                            cmp = Collections.reverseOrder(cmp);
                        }
                        Set<Integer> keySet = distributionSet2.orderLines.keySet();
                        ArrayList<Integer> keyList = new ArrayList<Integer>();
                        keyList.addAll(keySet);
                        Collections.sort(keyList, cmp);
                        LinkedHashMap<Integer, BigDecimal> sortedMap = new LinkedHashMap<Integer, BigDecimal>();
                        for (Integer id : keyList) {
                            sortedMap.put(id, distributionSet2.orderLines.get(id));
                        }
                        distributionSet2.orderLines = sortedMap;
                    }
                    BigDecimal setBalance = distributionSet2.setQty;
                    BigDecimal toApply = pr.getQty();
                    if (toApply == null || toApply.signum() == 0) {
                        toApply = BigDecimal.valueOf(-1.0);
                    }
                    BigDecimal totalPrice = BigDecimal.ZERO;
                    for (Map.Entry<Integer, BigDecimal> olMap : distributionSet2.orderLines.entrySet()) {
                        BigDecimal qty = olMap.getValue();
                        int C_OrderLine_ID = olMap.getKey();
                        if (qty == null || qty.signum() <= 0) continue;
                        if (qty.compareTo(setBalance) >= 0) {
                            qty = setBalance;
                            setBalance = BigDecimal.ZERO;
                        } else {
                            setBalance = setBalance.subtract(qty);
                        }
                        if (toApply.signum() > 0) {
                            if (toApply.compareTo(qty) <= 0) {
                                qty = toApply;
                                toApply = BigDecimal.ZERO;
                            } else {
                                toApply = toApply.subtract(qty);
                            }
                            BigDecimal newQty = olMap.getValue();
                            newQty = newQty.subtract(qty);
                            distributionSet2.orderLines.put(olMap.getKey(), newQty);
                        }
                        MOrderLine[] mOrderLineArray3 = lines;
                        int n5 = lines.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            MOrderLine ol = mOrderLineArray3[n6];
                            if (ol.getC_OrderLine_ID() == C_OrderLine_ID) {
                                BigDecimal priceActual;
                                if (pr.getRewardType().equals("P")) {
                                    priceActual = ol.getPriceActual();
                                    BigDecimal discount = priceActual.multiply(pr.getAmount().divide(BigDecimal.valueOf(100.0)));
                                    PromotionRule.addDiscountLine(order, ol, discount, qty, pr.getC_Charge_ID(), pr.getM_Promotion());
                                } else if (pr.getRewardType().equals("F")) {
                                    PromotionRule.addDiscountLine(order, ol, pr.getAmount(), BigDecimal.valueOf(1.0), pr.getC_Charge_ID(), pr.getM_Promotion());
                                } else if (pr.getRewardType().equals("A")) {
                                    priceActual = ol.getPriceActual();
                                    totalPrice = totalPrice.add(priceActual.multiply(qty));
                                }
                            }
                            ++n6;
                        }
                        if (toApply.signum() == 0 || setBalance.signum() == 0) break;
                    }
                    if (!pr.getRewardType().equals("A") || pr.getAmount().compareTo(totalPrice) >= 0) continue;
                    PromotionRule.addDiscountLine(order, null, totalPrice.subtract(pr.getAmount()), BigDecimal.valueOf(1.0), pr.getC_Charge_ID(), pr.getM_Promotion());
                }
                break;
            }
        }
    }

    private static void addDiscountLine(MOrder order, MOrderLine ol, BigDecimal discount, BigDecimal qty, int C_Charge_ID, I_M_Promotion promotion) throws Exception {
        int M_PromotionPrecondition_ID = PromotionValidator.findPromotionPreConditionId(order, order.getPromotionCode(), promotion.getM_Promotion_ID());
        if (M_PromotionPrecondition_ID <= 0) {
            return;
        }
        String sSql = "SELECT PromotionUsageLimit - PromotionCounter FROM M_PromotionPreCondition WHERE M_PromotionPreCondition_ID = ?";
        int nAvailableUsage = DB.getSQLValue(order.get_TrxName(), sSql, M_PromotionPrecondition_ID);
        if (nAvailableUsage <= 0) {
            return;
        }
        MOrderLine nol = new MOrderLine(order.getCtx(), 0, order.get_TrxName());
        nol.setC_Order_ID(order.getC_Order_ID());
        nol.setOrder(order);
        nol.setC_Charge_ID(C_Charge_ID);
        nol.setQty(qty);
        if (discount.scale() > 2) {
            discount = discount.setScale(2, 4);
        }
        nol.setPriceActual(discount.negate());
        if (ol != null && Integer.toString(ol.getLine()).endsWith("0")) {
            int i = 0;
            while (i < 9) {
                int line = ol.getLine() + i + 1;
                int r = DB.getSQLValue(order.get_TrxName(), "SELECT C_OrderLine_ID FROM C_OrderLine WHERE C_Order_ID = ? AND Line = ?", order.getC_Order_ID(), line);
                if (r <= 0) {
                    nol.setLine(line);
                    break;
                }
                ++i;
            }
        }
        String description = promotion.getName();
        if (ol != null) {
            description = String.valueOf(description) + ", " + ol.getName();
        }
        nol.setDescription(description);
        nol.set_ValueOfColumn("M_Promotion_ID", (Object)promotion.getM_Promotion_ID());
        if (promotion.getC_Campaign_ID() > 0) {
            nol.setC_Campaign_ID(promotion.getC_Campaign_ID());
        }
        if (!nol.save()) {
            throw new AdempiereException("Failed to add discount line to order");
        }
        String sSqlUpdate = "UPDATE M_PromotionPreCondition SET PromotionCounter = PromotionCounter + 1 WHERE M_PromotionPreCondition_ID = ?";
        DB.executeUpdate(sSqlUpdate, M_PromotionPrecondition_ID, order.get_TrxName());
    }

    private static Map<Integer, List<Integer>> findM_Promotion_ID(MOrder order) throws Exception {
        String select = "SELECT M_Promotion.M_Promotion_ID From M_Promotion Inner Join M_PromotionPreCondition  ON (M_Promotion.M_Promotion_ID = M_PromotionPreCondition.M_Promotion_ID)";
        String bpFilter = "M_PromotionPreCondition.C_BPartner_ID = ? OR M_PromotionPreCondition.C_BP_Group_ID = ? OR (M_PromotionPreCondition.C_BPartner_ID IS NULL AND M_PromotionPreCondition.C_BP_Group_ID IS NULL)";
        String priceListFilter = "M_PromotionPreCondition.M_PriceList_ID IS NULL OR M_PromotionPreCondition.M_PriceList_ID = ?";
        String warehouseFilter = "M_PromotionPreCondition.M_Warehouse_ID IS NULL OR M_PromotionPreCondition.M_Warehouse_ID = ?";
        String dateFilter = "M_PromotionPreCondition.StartDate <= ? AND (M_PromotionPreCondition.EndDate >= ? OR M_PromotionPreCondition.EndDate IS NULL)";
        String sCounterFilter = "M_PromotionPreCondition.PromotionCounter < M_PromotionPreCondition.PromotionUsageLimit OR M_PromotionPreCondition.PromotionUsageLimit = 0";
        String promotionCode = (String)order.get_Value("PromotionCode");
        StringBuffer sql = new StringBuffer();
        sql.append(select).append(" WHERE").append(" (" + bpFilter + ")").append(" AND (").append(priceListFilter).append(")").append(" AND (").append(warehouseFilter).append(")").append(" AND (").append(dateFilter).append(")").append(" AND (").append(sCounterFilter).append(")");
        if (promotionCode != null && promotionCode.trim().length() > 0) {
            sql.append(" AND (M_PromotionPreCondition.PromotionCode = ?)");
        } else {
            sql.append(" AND (M_PromotionPreCondition.PromotionCode IS NULL)");
        }
        int C_Activity_ID = order.getC_Activity_ID();
        if (C_Activity_ID > 0) {
            sql.append(" AND (M_PromotionPreCondition.C_Activity_ID = ? OR M_PromotionPreCondition.C_Activity_ID IS NULL)");
        } else {
            sql.append(" AND (M_PromotionPreCondition.C_Activity_ID IS NULL)");
        }
        sql.append(" AND (M_Promotion.AD_Client_ID in (0, ?))").append(" AND (M_Promotion.AD_Org_ID in (0, ?))").append(" AND (M_Promotion.IsActive = 'Y')").append(" AND (M_PromotionPreCondition.IsActive = 'Y')").append(" ORDER BY M_Promotion.PromotionPriority Desc ");
        CPreparedStatement stmt = null;
        ResultSet rs = null;
        LinkedHashMap<Integer, List<Integer>> promotions = new LinkedHashMap<Integer, List<Integer>>();
        try {
            int pindex = 1;
            stmt = DB.prepareStatement(sql.toString(), order.get_TrxName());
            stmt.setInt(pindex++, order.getC_BPartner_ID());
            stmt.setInt(pindex++, order.getC_BPartner().getC_BP_Group_ID());
            stmt.setInt(pindex++, order.getM_PriceList_ID());
            stmt.setInt(pindex++, order.getM_Warehouse_ID());
            stmt.setTimestamp(pindex++, order.getDateOrdered());
            stmt.setTimestamp(pindex++, order.getDateOrdered());
            if (promotionCode != null && promotionCode.trim().length() > 0) {
                stmt.setString(pindex++, promotionCode);
            }
            if (C_Activity_ID > 0) {
                stmt.setInt(pindex++, C_Activity_ID);
            }
            stmt.setInt(pindex++, order.getAD_Client_ID());
            stmt.setInt(pindex++, order.getAD_Org_ID());
            rs = stmt.executeQuery();
            while (rs.next()) {
                int M_Promotion_ID = rs.getInt(1);
                List<Integer> promotionLineIDs = PromotionRule.findPromotionLine(M_Promotion_ID, order);
                if (promotionLineIDs.isEmpty()) continue;
                promotions.put(M_Promotion_ID, promotionLineIDs);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, stmt);
            throw throwable;
        }
        DB.close(rs, stmt);
        return promotions;
    }

    private static DistributionSet calculateDistributionQty(MPromotionDistribution distribution, DistributionSet prevSet, List<Integer> validPromotionLineIDs, Map<Integer, BigDecimal> orderLineQty, List<Integer> orderLineIdList, String trxName) throws Exception {
        Object rs;
        String sql = "SELECT C_OrderLine.C_OrderLine_ID FROM M_PromotionLine INNER JOIN M_PromotionGroup ON (M_PromotionLine.M_PromotionGroup_ID = M_PromotionGroup.M_PromotionGroup_ID AND M_PromotionGroup.IsActive = 'Y') INNER JOIN M_PromotionGroupLine ON (M_PromotionGroup.M_PromotionGroup_ID = M_PromotionGroupLine.M_PromotionGroup_ID AND M_PromotionGroupLine.IsActive = 'Y') INNER JOIN C_OrderLine ON (M_PromotionGroupLine.M_Product_ID = C_OrderLine.M_Product_ID) WHERE M_PromotionLine.M_PromotionLine_ID = ? AND C_OrderLine.C_OrderLine_ID = ? AND M_PromotionLine.IsActive = 'Y'";
        DistributionSet distributionSet = new DistributionSet();
        ArrayList<Integer> eligibleOrderLineIDs = new ArrayList<Integer>();
        if (distribution.getM_PromotionLine().getM_PromotionGroup_ID() == 0) {
            if (validPromotionLineIDs.contains(distribution.getM_PromotionLine_ID())) {
                eligibleOrderLineIDs.addAll(orderLineIdList);
            }
        } else {
            for (int C_OrderLine_ID : orderLineIdList) {
                BigDecimal availableQty = orderLineQty.get(C_OrderLine_ID);
                if (availableQty.signum() <= 0) continue;
                CPreparedStatement stmt = null;
                rs = null;
                try {
                    try {
                        stmt = DB.prepareStatement(sql, trxName);
                        stmt.setInt(1, distribution.getM_PromotionLine_ID());
                        stmt.setInt(2, C_OrderLine_ID);
                        rs = stmt.executeQuery();
                        if (rs.next()) {
                            eligibleOrderLineIDs.add(C_OrderLine_ID);
                        }
                    }
                    catch (Exception e) {
                        throw new AdempiereException(e.getLocalizedMessage(), e);
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, stmt);
                    throw throwable;
                }
                DB.close((ResultSet)rs, stmt);
            }
        }
        if (eligibleOrderLineIDs.isEmpty()) {
            distributionSet.setQty = BigDecimal.ZERO;
            return distributionSet;
        }
        BigDecimal compareQty = distribution.getQty();
        BigDecimal setQty = BigDecimal.ZERO;
        BigDecimal totalOrderLineQty = BigDecimal.ZERO;
        rs = eligibleOrderLineIDs.iterator();
        while (rs.hasNext()) {
            int C_OrderLine_ID = (Integer)rs.next();
            BigDecimal availableQty = orderLineQty.get(C_OrderLine_ID);
            if (availableQty.signum() <= 0) continue;
            totalOrderLineQty = totalOrderLineQty.add(availableQty);
        }
        int compare = totalOrderLineQty.compareTo(compareQty);
        boolean match = false;
        if (compare <= 0 && "<=".equals(distribution.getOperation())) {
            match = true;
        } else if (compare >= 0 && ">=".equals(distribution.getOperation())) {
            match = true;
        }
        if (match) {
            setQty = "X".equals(distribution.getDistributionType()) ? (compare > 0 ? totalOrderLineQty : distribution.getQty()) : ("I".equals(distribution.getDistributionType()) ? (compare < 0 ? totalOrderLineQty : distribution.getQty()) : (compare > 0 ? totalOrderLineQty.subtract(distribution.getQty()) : distribution.getQty().subtract(totalOrderLineQty)));
            distributionSet.setQty = setQty;
            block6: while (setQty.signum() > 0) {
                if (prevSet != null) {
                    BigDecimal recycleQty = BigDecimal.ZERO;
                    for (Map.Entry<Integer, BigDecimal> entry : prevSet.orderLines.entrySet()) {
                        if (entry.getValue().signum() <= 0) continue;
                        setQty = setQty.subtract(entry.getValue());
                        distributionSet.orderLines.put(entry.getKey(), entry.getValue());
                        recycleQty = recycleQty.add(entry.getValue());
                    }
                    if (recycleQty.signum() > 0) {
                        Iterator<Map.Entry<Integer, BigDecimal>> iterator = eligibleOrderLineIDs.iterator();
                        while (iterator.hasNext()) {
                            int C_OrderLine_ID = (Integer)((Object)iterator.next());
                            BigDecimal availableQty = orderLineQty.get(C_OrderLine_ID);
                            if (availableQty.signum() <= 0) continue;
                            if (availableQty.compareTo(recycleQty) < 0) {
                                recycleQty = recycleQty.subtract(availableQty);
                                orderLineQty.put(C_OrderLine_ID, BigDecimal.ZERO);
                            } else {
                                availableQty = availableQty.subtract(recycleQty);
                                orderLineQty.put(C_OrderLine_ID, availableQty);
                                recycleQty = BigDecimal.ZERO;
                            }
                            if (recycleQty.signum() <= 0) break;
                        }
                    }
                    if (setQty.signum() == 0) break;
                }
                Iterator iterator = eligibleOrderLineIDs.iterator();
                while (iterator.hasNext()) {
                    int C_OrderLine_ID = (Integer)iterator.next();
                    BigDecimal availableQty = orderLineQty.get(C_OrderLine_ID);
                    if (availableQty.signum() <= 0) continue;
                    if (availableQty.compareTo(setQty) < 0) {
                        setQty = setQty.subtract(availableQty);
                        distributionSet.orderLines.put(C_OrderLine_ID, availableQty);
                        orderLineQty.put(C_OrderLine_ID, BigDecimal.ZERO);
                    } else {
                        availableQty = availableQty.subtract(setQty);
                        distributionSet.orderLines.put(C_OrderLine_ID, setQty);
                        orderLineQty.put(C_OrderLine_ID, availableQty);
                        setQty = BigDecimal.ZERO;
                    }
                    if (setQty.signum() <= 0) continue block6;
                }
            }
        }
        return distributionSet;
    }

    private static List<Integer> findPromotionLine(int promotion_ID, MOrder order) throws SQLException {
        Query query = new Query(Env.getCtx(), MTable.get(order.getCtx(), I_M_PromotionLine.Table_ID), " M_PromotionLine.M_Promotion_ID = ? AND M_PromotionLine.IsActive = 'Y'", order.get_TrxName());
        query.setParameters(promotion_ID);
        List plist = query.list();
        ArrayList<Integer> applicable = new ArrayList<Integer>();
        MOrderLine[] lines = order.getLines();
        for (MPromotionLine pl : plist) {
            boolean match = false;
            if (pl.getM_PromotionGroup_ID() > 0) {
                String sql = "SELECT DISTINCT C_OrderLine.C_OrderLine_ID FROM M_PromotionGroup INNER JOIN M_PromotionGroupLine ON (M_PromotionGroup.M_PromotionGroup_ID = M_PromotionGroupLine.M_PromotionGroup_ID AND M_PromotionGroupLine.IsActive = 'Y') INNER JOIN C_OrderLine ON (M_PromotionGroupLine.M_Product_ID = C_OrderLine.M_Product_ID) INNER JOIN M_PromotionLine ON (M_PromotionLine.M_PromotionGroup_ID = M_PromotionGroup.M_PromotionGroup_ID) WHERE M_PromotionLine.M_PromotionLine_ID = ? AND C_OrderLine.C_Order_ID = ? AND M_PromotionLine.IsActive = 'Y' AND M_PromotionGroup.IsActive = 'Y'";
                CPreparedStatement stmt = null;
                ResultSet rs = null;
                try {
                    stmt = DB.prepareStatement(sql, order.get_TrxName());
                    stmt.setInt(1, pl.getM_PromotionLine_ID());
                    stmt.setInt(2, order.getC_Order_ID());
                    rs = stmt.executeQuery();
                    BigDecimal orderAmt = BigDecimal.ZERO;
                    while (rs.next()) {
                        if (pl.getMinimumAmt() != null && pl.getMinimumAmt().signum() > 0) {
                            int C_OrderLine_ID = rs.getInt(1);
                            MOrderLine[] mOrderLineArray = lines;
                            int n = lines.length;
                            int n2 = 0;
                            while (n2 < n) {
                                MOrderLine ol = mOrderLineArray[n2];
                                if (ol.getC_OrderLine_ID() == C_OrderLine_ID) {
                                    orderAmt = orderAmt.add(ol.getLineNetAmt());
                                    break;
                                }
                                ++n2;
                            }
                            if (orderAmt.compareTo(pl.getMinimumAmt()) < 0) continue;
                            match = true;
                        } else {
                            match = true;
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, stmt);
                    throw throwable;
                }
                DB.close(rs, stmt);
            } else if (pl.getMinimumAmt() != null && pl.getMinimumAmt().compareTo(order.getGrandTotal()) <= 0) {
                match = true;
            }
            if (!match && pl.isMandatoryPL()) {
                applicable.clear();
                break;
            }
            if (!match) continue;
            applicable.add(pl.getM_PromotionLine_ID());
        }
        return applicable;
    }

    static class DistributionSet {
        Map<Integer, BigDecimal> orderLines = new LinkedHashMap<Integer, BigDecimal>();
        BigDecimal setQty = BigDecimal.ZERO;

        DistributionSet() {
        }
    }

    static class OrderLineComparator
    implements Comparator<Integer> {
        Map<Integer, MOrderLine> index;

        OrderLineComparator(Map<Integer, MOrderLine> olIndex) {
            this.index = olIndex;
        }

        @Override
        public int compare(Integer ol1, Integer ol2) {
            return this.index.get(ol1).getPriceActual().compareTo(this.index.get(ol2).getPriceActual());
        }
    }
}

