/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.as.jboss;

import java.io.IOException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Login;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;

public class AdempiereLoginModule
implements LoginModule {
    private String unauthenticatedIdentity;
    private CallbackHandler handler;
    private Subject subject;
    private KeyNamePair[] roles;
    private String name;

    @Override
    public boolean abort() throws LoginException {
        this.roles = null;
        this.name = null;
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.roles == null || this.roles.length == 0) {
            this.subject.getPrincipals().add(new SimplePrincipal(this.unauthenticatedIdentity));
            SimpleGroup roleGroup = new SimpleGroup("Roles");
            this.subject.getPrincipals().add(roleGroup);
        } else {
            this.subject.getPrincipals().add(new SimplePrincipal(this.name));
            SimpleGroup roleGroup = new SimpleGroup("Roles");
            roleGroup.addMember(new SimplePrincipal("adempiereUsers"));
            for (int i = 0; i < this.roles.length; ++i) {
                roleGroup.addMember(new SimplePrincipal(this.roles[i].getName()));
            }
            this.subject.getPrincipals().add(roleGroup);
        }
        return true;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.unauthenticatedIdentity = (String)options.get("unauthenticatedIdentity");
        this.handler = callbackHandler;
        this.subject = subject;
    }

    @Override
    public boolean login() throws LoginException {
        String passwd;
        Callback[] callbacks = new Callback[]{new NameCallback("Login:"), new PasswordCallback("Password:", false)};
        try {
            this.handler.handle(callbacks);
        }
        catch (IOException e) {
        }
        catch (UnsupportedCallbackException e) {
            // empty catch block
        }
        this.name = ((NameCallback)callbacks[0]).getName();
        char[] pass = ((PasswordCallback)callbacks[1]).getPassword();
        String string = passwd = pass != null ? new String(pass) : null;
        if (this.name != null && passwd != null) {
            Login login = new Login(Env.getCtx());
            this.roles = login.getRoles(this.name, passwd);
        } else {
            this.roles = null;
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.roles = null;
        this.name = null;
        return true;
    }
}

