/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.apps.graph;

import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Calendar;
import org.adempiere.apps.graph.GraphColumn;
import org.compiere.model.MGoal;
import org.compiere.model.MMeasure;
import org.compiere.util.CLogger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.labels.CategorySeriesLabelGenerator;
import org.jfree.chart.labels.StandardCategorySeriesLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class GraphBuilder {
    protected MGoal m_goal = null;
    protected String m_X_AxisLabel = "X Axis";
    protected String m_Y_AxisLabel = "Y Axis";
    protected DefaultCategoryDataset dataset = new DefaultCategoryDataset();
    protected DefaultCategoryDataset linearDataset = new DefaultCategoryDataset();
    protected DefaultPieDataset pieDataset = new DefaultPieDataset();
    protected ArrayList<DefaultCategoryDataset> multyset = new ArrayList();
    private static final CLogger log = CLogger.getCLogger(GraphBuilder.class);

    public JFreeChart createChart(String type) {
        if ("SC".equals(type)) {
            return this.createStackedBarChart();
        }
        if ("BC".equals(type)) {
            if (this.m_goal.isSummary()) {
                return this.createMultyBarChart();
            }
            return this.createBarChart();
        }
        if ("PC".equals(type)) {
            return this.createPieChart();
        }
        if ("AC".equals(type)) {
            return this.createAreaChart();
        }
        if ("LC".equals(type)) {
            return this.createLineChart();
        }
        if ("RC".equals(type)) {
            return this.createRingChart();
        }
        if ("WC".equals(type)) {
            return this.createWaterfallChart();
        }
        throw new IllegalArgumentException("unknown chart type=" + type);
    }

    private JFreeChart createStackedBarChart() {
        JFreeChart chart = ChartFactory.createStackedBarChart((String)this.m_goal.getMeasure().getName(), (String)this.m_X_AxisLabel, (String)this.m_Y_AxisLabel, (CategoryDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        CategoryAxis axis = plot.getDomainAxis();
        axis.setMaximumCategoryLabelLines(Integer.MAX_VALUE);
        axis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)0.7853981633974483));
        BarRenderer renderer = (BarRenderer)plot.getRenderer();
        renderer.setLegendItemToolTipGenerator((CategorySeriesLabelGenerator)new StandardCategorySeriesLabelGenerator("{0}"));
        this.setupCategoryChart(chart);
        return chart;
    }

    private JFreeChart createWaterfallChart() {
        JFreeChart chart = ChartFactory.createWaterfallChart((String)this.m_goal.getMeasure().getName(), (String)this.m_X_AxisLabel, (String)this.m_Y_AxisLabel, (CategoryDataset)this.linearDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)true);
        this.setupCategoryChart(chart);
        return chart;
    }

    private JFreeChart createRingChart() {
        JFreeChart chart = ChartFactory.createRingChart((String)this.m_goal.getMeasure().getName(), (PieDataset)this.pieDataset, (boolean)false, (boolean)true, (boolean)true);
        return chart;
    }

    private JFreeChart createBarChart() {
        JFreeChart chart = ChartFactory.createBarChart3D((String)this.m_goal.getMeasure().getName(), (String)this.m_X_AxisLabel, (String)this.m_Y_AxisLabel, (CategoryDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)true);
        this.setupCategoryChart(chart);
        return chart;
    }

    private JFreeChart createMultyBarChart() {
        this.dataset = this.multyset.size() > 0 ? this.multyset.get(0) : new DefaultCategoryDataset();
        JFreeChart chart = ChartFactory.createBarChart3D((String)this.m_goal.getName(), (String)this.m_X_AxisLabel, (String)this.m_Y_AxisLabel, (CategoryDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)true);
        CategoryPlot plot = chart.getCategoryPlot();
        int i = 1;
        while (i < this.multyset.size()) {
            plot.setDataset(i, (CategoryDataset)this.multyset.get(i));
            plot.setRenderer(i, (CategoryItemRenderer)new BarRenderer3D());
            ++i;
        }
        this.setupCategoryChart(chart);
        return chart;
    }

    private JFreeChart createPieChart() {
        JFreeChart chart = ChartFactory.createPieChart3D((String)this.m_goal.getMeasure().getName(), (PieDataset)this.pieDataset, (boolean)false, (boolean)true, (boolean)true);
        return chart;
    }

    private JFreeChart createAreaChart() {
        JFreeChart chart = ChartFactory.createAreaChart((String)this.m_goal.getMeasure().getName(), (String)this.m_X_AxisLabel, (String)this.m_Y_AxisLabel, (CategoryDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)true);
        this.setupCategoryChart(chart);
        return chart;
    }

    private void setupCategoryChart(JFreeChart chart) {
        CategoryPlot plot = chart.getCategoryPlot();
        CategoryItemRenderer renderer = plot.getRenderer();
        renderer.setSeriesPaint(0, (Paint)new Color(0.36078432f, 0.69803923f, 0.9098039f));
        renderer.setSeriesPaint(1, (Paint)new Color(0.21960784f, 0.38039216f, 0.46666667f));
        renderer.setSeriesPaint(2, (Paint)new Color(0.9490196f, 0.27450982f, 0.30588236f));
        renderer.setSeriesPaint(3, (Paint)Color.orange);
        renderer.setSeriesPaint(4, (Paint)new Color(0.5764706f, 0.76862746f, 0.2f));
        renderer.setSeriesPaint(5, (Paint)new Color(0.8235294f, 0.96862745f, 0.35686275f));
        renderer.setSeriesPaint(6, (Paint)new Color(0.5058824f, 0.92156863f, 0.9764706f));
        renderer.setSeriesPaint(7, (Paint)new Color(0.23529412f, 0.32941177f, 0.03137255f));
        renderer.setSeriesPaint(8, (Paint)new Color(0.8f, 0.8f, 0.8f));
    }

    private JFreeChart createLineChart() {
        JFreeChart chart = ChartFactory.createLineChart3D((String)this.m_goal.getMeasure().getName(), (String)this.m_X_AxisLabel, (String)this.m_Y_AxisLabel, (CategoryDataset)this.linearDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)true);
        this.setupCategoryChart(chart);
        return chart;
    }

    public MGoal getMGoal() {
        return this.m_goal;
    }

    public void setMGoal(MGoal mgoal) {
        this.m_goal = mgoal;
    }

    public String getXAxisLabel() {
        return this.m_X_AxisLabel;
    }

    public void setXAxisLabel(String axisLabel) {
        this.m_X_AxisLabel = axisLabel;
    }

    public String getYAxisLabel() {
        return this.m_Y_AxisLabel;
    }

    public void setYAxisLabel(String axisLabel) {
        this.m_Y_AxisLabel = axisLabel;
    }

    public ArrayList<GraphColumn> loadData() {
        this.multyset.clear();
        if (!this.m_goal.isSummary()) {
            return this.loadData(this.m_goal);
        }
        MGoal[] goals = this.m_goal.getChildGoals(false);
        ArrayList<GraphColumn> list = new ArrayList<GraphColumn>();
        MGoal[] mGoalArray = goals;
        int n = goals.length;
        int n2 = 0;
        while (n2 < n) {
            MGoal goal = mGoalArray[n2];
            ArrayList<GraphColumn> single = this.loadData(goal);
            if (single != null) {
                list.addAll(single);
                this.multyset.add(this.dataset);
            }
            ++n2;
        }
        if (list.size() == 0) {
            return null;
        }
        return list;
    }

    public ArrayList<GraphColumn> loadData(MGoal goal) {
        MMeasure measure = goal.getMeasure();
        if (measure == null) {
            log.warning("No Measure for " + goal);
            return null;
        }
        ArrayList<GraphColumn> list = measure.getGraphColumnList(goal);
        this.pieDataset = new DefaultPieDataset();
        this.dataset = new DefaultCategoryDataset();
        int i = 0;
        while (i < list.size()) {
            String series = this.m_X_AxisLabel;
            if (list.get(i).getDate() != null) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(list.get(i).getDate());
                series = Integer.toString(cal.get(1));
            }
            if (measure.getMeasureDataType().equals("X")) {
                this.dataset.addValue(list.get(i).getValue(), (Comparable)((Object)list.get(i).getSeries()), (Comparable)((Object)list.get(i).getCategory()));
            } else {
                this.dataset.addValue(list.get(i).getValue(), (Comparable)((Object)series), (Comparable)((Object)list.get(i).getLabel()));
            }
            this.linearDataset.addValue(list.get(i).getValue(), (Comparable)((Object)this.m_X_AxisLabel), (Comparable)((Object)list.get(i).getLabel()));
            this.pieDataset.setValue((Comparable)((Object)list.get(i).getLabel()), list.get(i).getValue());
            ++i;
        }
        return list;
    }
}

