/*
 * Decompiled with CFR 0.152.
 */
package it.nectosoft.util;

import com.f3p.adempiere.util.ModelFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.compiere.model.I_M_InOut;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MPeriod;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_M_InOut;
import org.compiere.model.X_M_MatchInv;

public class Helper {
    public static MPeriod getFirstStdPeriod(Properties ctx, int C_Year_ID, boolean onlyActive, String trxName) {
        return Helper.getFirstPeriod(ctx, C_Year_ID, "S", onlyActive, trxName);
    }

    public static MPeriod getFirstPeriod(Properties ctx, int C_Year_ID, String type, boolean onlyActive, String trxName) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(C_Year_ID);
        params.add(type);
        String wh = "C_YEAR_ID = ? AND PERIODTYPE = ?";
        MPeriod period = (MPeriod)new Query(ctx, "C_Period", wh, trxName).setParameters(params).setOrderBy("StartDate").setOnlyActiveRecords(onlyActive).first();
        return period;
    }

    public static MPeriod getLastStdPeriod(Properties ctx, int C_Year_ID, boolean onlyActive, String trxName) {
        return Helper.getLastPeriod(ctx, C_Year_ID, "S", onlyActive, trxName);
    }

    public static MPeriod getLastPeriod(Properties ctx, int C_Year_ID, String type, boolean onlyActive, String trxName) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(C_Year_ID);
        params.add(type);
        String wh = "C_YEAR_ID = ? AND PERIODTYPE = ?";
        MPeriod period = (MPeriod)new Query(ctx, "C_Period", wh, trxName).setParameters(params).setOrderBy("StartDate DESC").setOnlyActiveRecords(onlyActive).first();
        return period;
    }

    public static MPeriod[] getAllPeriodsOfYear(Properties ctx, int C_Year_ID, String type, boolean onlyActive, String trxName) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(C_Year_ID);
        params.add(type);
        String wh = "C_YEAR_ID = ? AND PERIODTYPE = ?";
        List<MPeriod> periods = new Query(ctx, "C_Period", wh, trxName).setParameters(params).setOrderBy("StartDate").setOnlyActiveRecords(onlyActive).list();
        return periods.toArray(new MPeriod[periods.size()]);
    }

    public static boolean isReturnsRelated(PO model) {
        boolean bIsRelated = false;
        if (model instanceof X_M_InOut) {
            bIsRelated = Helper.isReturnsInOut((I_M_InOut)((Object)model));
        } else if (model instanceof X_M_MatchInv) {
            X_M_MatchInv mMatchInv = (X_M_MatchInv)model;
            MInOutLine mInOutLine = ModelFactory.getInOutLine(model.getCtx(), mMatchInv.getM_InOutLine_ID(), model.get_TrxName());
            if (mInOutLine != null) {
                MInOut mInOut = mInOutLine.getParent();
                bIsRelated = Helper.isReturnsInOut(mInOut);
            }
        }
        return bIsRelated;
    }

    public static boolean isReturnsInOut(I_M_InOut mInOut) {
        boolean bIsRelated = false;
        String sMovType = mInOut.getMovementType();
        if (sMovType != null && (sMovType.equals("C+") || sMovType.equals("V-"))) {
            bIsRelated = true;
        }
        return bIsRelated;
    }
}

