/*
 * Decompiled with CFR 0.152.
 */
package it.nectosoft.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MConversionType;
import org.compiere.model.MElementValue;
import org.compiere.model.MJournal;
import org.compiere.model.MJournalBatch;
import org.compiere.model.MJournalLine;
import org.compiere.model.MPeriod;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class YearClosingBalance
extends SvrProcess {
    private static final int MAX_LINE = 9999999;
    private int m_AD_Org_ID = 0;
    private String m_Postingtype = "A";
    private int m_GL_Category_ID = 0;
    private Timestamp m_DateFrom = null;
    private Timestamp m_DateTo = null;
    private int m_C_Acctschema_ID = 0;
    private int m_LoseProfit_Account_ID = 0;
    private int m_Close_Account_ID = 0;
    private int m_Open_Account_ID = 0;
    private Timestamp m_OpenDate = null;
    private int m_C_DocType_ID = 0;
    private MJournalBatch batchClose = null;
    private MJournalBatch batchOpen = null;
    private MJournal journalClose = null;
    private MAcctSchema acctSchema = null;
    private MAccount loseProfitAcct = null;
    private MAccount closeAcct = null;
    private MAccount openAcct = null;
    MElementValue lose = null;
    MElementValue open = null;
    private int m_BSCloseBalance_Account_ID = 0;
    private int m_BSOpenBalance_Account_ID = 0;
    private MAccount balanceSheetCloseAcct = null;
    private MAccount balanceSheetOpenAcct = null;
    private MJournal journalBSOpen = null;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("AD_Org_ID")) {
                this.m_AD_Org_ID = para[i].getParameterAsInt();
            } else if (name.equals("PostingType")) {
                this.m_Postingtype = para[i].getParameter().toString();
            } else if (name.equals("GL_Category_ID")) {
                this.m_GL_Category_ID = para[i].getParameterAsInt();
            } else if (name.equals("DateAcct")) {
                this.m_DateFrom = (Timestamp)para[i].getParameter();
                this.m_DateTo = (Timestamp)para[i].getParameter_To();
            } else if (name.equals("C_AcctSchema_ID")) {
                this.m_C_Acctschema_ID = para[i].getParameterAsInt();
            } else if (name.equals("LoseProfit_Acct")) {
                this.m_LoseProfit_Account_ID = para[i].getParameterAsInt();
            } else if (name.equals("BalanceClosing_Acct")) {
                this.m_Close_Account_ID = para[i].getParameterAsInt();
            } else if (name.equals("BalanceOpening_Acct")) {
                this.m_Open_Account_ID = para[i].getParameterAsInt();
            } else if (name.equals("OpenDate")) {
                this.m_OpenDate = (Timestamp)para[i].getParameter();
            } else if (name.equals("C_DocType_ID")) {
                this.m_C_DocType_ID = para[i].getParameterAsInt();
            } else if (name.equals("BS_BalanceClosing_Acct")) {
                this.m_BSCloseBalance_Account_ID = para[i].getParameterAsInt();
            } else if (name.equals("BS_BalanceOpening_Acct")) {
                this.m_BSOpenBalance_Account_ID = para[i].getParameterAsInt();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.acctSchema = new MAcctSchema(this.getCtx(), this.m_C_Acctschema_ID, this.get_TrxName());
        this.loseProfitAcct = new MAccount(this.getCtx(), this.m_LoseProfit_Account_ID, this.get_TrxName());
        this.closeAcct = new MAccount(this.getCtx(), this.m_Close_Account_ID, this.get_TrxName());
        this.openAcct = new MAccount(this.getCtx(), this.m_Open_Account_ID, this.get_TrxName());
        this.lose = this.loseProfitAcct.getAccount();
        this.open = this.openAcct.getAccount();
        if (this.m_BSCloseBalance_Account_ID > 0) {
            this.balanceSheetCloseAcct = new MAccount(this.getCtx(), this.m_BSCloseBalance_Account_ID, this.get_TrxName());
        }
        if (this.m_BSOpenBalance_Account_ID > 0) {
            this.balanceSheetOpenAcct = new MAccount(this.getCtx(), this.m_BSOpenBalance_Account_ID, this.get_TrxName());
        }
        try {
            this.closeProfitAndLoss();
            if (this.balanceSheetCloseAcct != null && this.balanceSheetCloseAcct != null) {
                this.closeBalanceSheet();
            }
            this.commitEx();
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, Msg.getMsg(this.getCtx(), "Error generating a Year Closing Balance", true), e);
            throw e;
        }
        if (this.batchClose != null) {
            this.addLog(String.valueOf(this.batchClose.getDocumentInfo()) + " " + this.batchClose.getDescription());
        }
        if (this.batchOpen != null) {
            this.addLog(String.valueOf(this.batchOpen.getDocumentInfo()) + " " + this.batchOpen.getDescription());
        }
        return "OK";
    }

    private void closeProfitAndLoss() throws Exception {
        BigDecimal totalBalance = Env.ZERO;
        String acctValue = null;
        String acctName = null;
        BigDecimal lineBalance = Env.ZERO;
        int C_ElementValue_ID = -1;
        String sql = "SELECT  CE.VALUE, CE.NAME, CE.ACCOUNTTYPE,CE.C_ELEMENTVALUE_ID,  COALESCE(SUM(FA.AMTACCTDR-FA.AMTACCTCR),0) AS BALANCE  FROM C_ELEMENTVALUE CE  INNER JOIN FACT_ACCT FA ON (FA.ACCOUNT_ID = CE.C_ELEMENTVALUE_ID)  WHERE  CE.ACCOUNTTYPE IN ('E','R' )  AND FA.AD_CLIENT_ID = ? AND FA.AD_ORG_ID=? AND FA.C_ACCTSCHEMA_ID=? AND FA.DATEACCT between ? and ?  GROUP BY CE.ACCOUNTTYPE, CE.VALUE, CE.NAME, CE.C_ELEMENTVALUE_ID  ORDER BY CE.ACCOUNTTYPE, CE.VALUE, CE.NAME ";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
                pstmt.setInt(1, this.getAD_Client_ID());
                pstmt.setInt(2, this.m_AD_Org_ID);
                pstmt.setInt(3, this.m_C_Acctschema_ID);
                pstmt.setTimestamp(4, this.m_DateFrom);
                pstmt.setTimestamp(5, this.m_DateTo);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    acctValue = rs.getString("VALUE");
                    acctName = rs.getString("NAME");
                    lineBalance = rs.getBigDecimal("BALANCE");
                    C_ElementValue_ID = rs.getInt("C_ELEMENTVALUE_ID");
                    totalBalance = totalBalance.add(lineBalance);
                    if (lineBalance.signum() == 0) continue;
                    this.generateCloseLine(this.closeAcct, acctValue, acctName, lineBalance, C_ElementValue_ID);
                }
                if (totalBalance.signum() != 0) {
                    this.generateClosePL(totalBalance);
                    this.generateOpenJournal(totalBalance);
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, Msg.getMsg(this.getCtx(), "Error executing query", true), e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
    }

    private void closeBalanceSheet() throws Exception {
        BigDecimal totalBalance = Env.ZERO;
        String acctValue = null;
        String acctName = null;
        BigDecimal lineBalance = Env.ZERO;
        int C_ElementValue_ID = -1;
        String sql = "SELECT  CE.VALUE, CE.NAME, CE.ACCOUNTTYPE,CE.C_ELEMENTVALUE_ID,  COALESCE(SUM(FA.AMTACCTDR-FA.AMTACCTCR),0) AS BALANCE  FROM C_ELEMENTVALUE CE  INNER JOIN FACT_ACCT FA ON (FA.ACCOUNT_ID = CE.C_ELEMENTVALUE_ID)  WHERE  CE.ACCOUNTTYPE IN ('A','L','O' )  AND FA.AD_CLIENT_ID = ? AND FA.AD_ORG_ID=? AND FA.C_ACCTSCHEMA_ID=? AND FA.DATEACCT <=  ?  GROUP BY CE.ACCOUNTTYPE, CE.VALUE, CE.NAME, CE.C_ELEMENTVALUE_ID  ORDER BY CE.ACCOUNTTYPE, CE.VALUE, CE.NAME ";
        if (this.batchClose == null) {
            this.createBatchClose();
        }
        this.journalClose = new MJournal(this.batchClose);
        this.journalClose.setC_AcctSchema_ID(this.m_C_Acctschema_ID);
        this.journalClose.setDescription("Chiusura Stato Patrimoniale " + this.batchClose.getC_Period().getC_Year().getFiscalYear());
        this.journalClose.setC_ConversionType_ID(MConversionType.getDefault(this.getAD_Client_ID()));
        this.journalClose.setGL_Category_ID(this.m_GL_Category_ID);
        this.journalClose.saveEx();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
                pstmt.setInt(1, this.getAD_Client_ID());
                pstmt.setInt(2, this.m_AD_Org_ID);
                pstmt.setInt(3, this.m_C_Acctschema_ID);
                pstmt.setTimestamp(4, this.m_DateTo);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    acctValue = rs.getString("VALUE");
                    acctName = rs.getString("NAME");
                    lineBalance = rs.getBigDecimal("BALANCE");
                    C_ElementValue_ID = rs.getInt("C_ELEMENTVALUE_ID");
                    totalBalance = totalBalance.add(lineBalance);
                    if (lineBalance.signum() == 0) continue;
                    this.generateCloseLine(this.balanceSheetCloseAcct, acctValue, acctName, lineBalance, C_ElementValue_ID);
                    this.generateBSOpenLine(this.balanceSheetOpenAcct, acctValue, acctName, lineBalance, C_ElementValue_ID);
                }
                if (totalBalance.signum() != 0) {
                    this.lose = this.loseProfitAcct.getAccount();
                    this.generateCloseLine(this.balanceSheetCloseAcct, this.lose.getValue(), this.lose.getName(), totalBalance.negate(), this.lose.getC_ElementValue_ID());
                    this.generateBSOpenLine(this.balanceSheetOpenAcct, this.lose.getValue(), this.lose.getName(), totalBalance.negate(), this.lose.getC_ElementValue_ID());
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, Msg.getMsg(this.getCtx(), "Error executing query", true), e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
    }

    private void generateCloseLine(MAccount acctClose, String acctValue, String acctName, BigDecimal amt, int C_ElementValue_ID) throws Exception {
        try {
            if (this.batchClose == null) {
                this.createBatchClose();
                this.journalClose = new MJournal(this.batchClose);
                this.journalClose.setC_AcctSchema_ID(this.m_C_Acctschema_ID);
                this.journalClose.setDescription(this.batchClose.getDescription());
                this.journalClose.setC_ConversionType_ID(MConversionType.getDefault(this.getAD_Client_ID()));
                this.journalClose.setGL_Category_ID(this.m_GL_Category_ID);
                this.journalClose.saveEx();
            }
            MJournalLine line = new MJournalLine(this.journalClose);
            line.setDescription("Chiusura " + acctValue + " " + acctName);
            line.setC_ValidCombination_ID(acctClose);
            if (amt.signum() > 0) {
                line.setAmtSourceCr(amt.abs());
            } else {
                line.setAmtSourceDr(amt.abs());
            }
            line.setLine(C_ElementValue_ID);
            line.saveEx();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, Msg.getMsg(this.getCtx(), "Error creating Journal", true), e);
            throw e;
        }
    }

    private void generateBSOpenLine(MAccount acctOpen, String acctValue, String acctName, BigDecimal amt, int C_ElementValue_ID) throws Exception {
        try {
            if (this.journalBSOpen == null) {
                if (this.batchOpen == null) {
                    this.createBatchOpen();
                }
                this.journalBSOpen = new MJournal(this.batchOpen);
                this.journalBSOpen.setC_AcctSchema_ID(this.m_C_Acctschema_ID);
                this.journalBSOpen.setDescription("Apertura Stato Patrimoniale " + this.batchOpen.getC_Period().getC_Year().getFiscalYear());
                this.journalBSOpen.setC_ConversionType_ID(MConversionType.getDefault(this.getAD_Client_ID()));
                this.journalBSOpen.setGL_Category_ID(this.m_GL_Category_ID);
                this.journalBSOpen.saveEx();
            }
            MJournalLine line = new MJournalLine(this.journalBSOpen);
            line.setDescription("Apertura " + acctValue + " " + acctName);
            line.setC_ValidCombination_ID(acctOpen);
            if (amt.signum() <= 0) {
                line.setAmtSourceCr(amt.abs());
            } else {
                line.setAmtSourceDr(amt.abs());
            }
            line.setLine(C_ElementValue_ID);
            line.saveEx();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, Msg.getMsg(this.getCtx(), "Error creating Journal", true), e);
            throw e;
        }
    }

    private void generateClosePL(BigDecimal closeBalance) throws Exception {
        MJournalLine line = new MJournalLine(this.journalClose);
        line.setDescription("Chiusura " + this.lose.getValue() + " " + this.lose.getName());
        line.setC_ValidCombination_ID(this.loseProfitAcct);
        if (closeBalance.signum() < 0) {
            line.setAmtSourceCr(closeBalance.abs());
        } else {
            line.setAmtSourceDr(closeBalance.abs());
        }
        line.setLine(9999999);
        line.saveEx();
    }

    private void generateOpenJournal(BigDecimal openBalance) throws Exception {
        try {
            if (this.batchOpen == null) {
                this.createBatchOpen();
            }
            MJournal journalOpen = new MJournal(this.batchOpen);
            journalOpen.setC_AcctSchema_ID(this.m_C_Acctschema_ID);
            journalOpen.setDescription(this.batchOpen.getDescription());
            journalOpen.setC_ConversionType_ID(this.journalClose.getC_ConversionType_ID());
            journalOpen.setGL_Category_ID(this.m_GL_Category_ID);
            journalOpen.saveEx();
            MJournalLine linePL = new MJournalLine(journalOpen);
            linePL.setDescription("Apertura " + this.lose.getValue() + " " + this.lose.getName());
            linePL.setC_ValidCombination_ID(this.loseProfitAcct);
            if (openBalance.signum() < 0) {
                linePL.setAmtSourceDr(openBalance.abs());
            } else {
                linePL.setAmtSourceCr(openBalance.abs());
            }
            linePL.setLine(10);
            linePL.saveEx();
            MJournalLine linePLPP = new MJournalLine(journalOpen);
            linePLPP.setDescription("Apertura " + this.open.getValue() + " " + this.open.getName());
            linePLPP.setC_ValidCombination_ID(this.openAcct);
            if (openBalance.signum() > 0) {
                linePLPP.setAmtSourceDr(openBalance.abs());
            } else {
                linePLPP.setAmtSourceCr(openBalance.abs());
            }
            linePLPP.setLine(20);
            linePLPP.saveEx();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, Msg.getMsg(this.getCtx(), "Error to create Journal", true), e);
            throw e;
        }
    }

    protected void createBatchClose() {
        this.batchClose = new MJournalBatch(this.getCtx(), 0, this.get_TrxName());
        this.batchClose.setAD_Org_ID(this.m_AD_Org_ID);
        MPeriod period = MPeriod.get(this.getCtx(), this.m_DateTo, this.m_AD_Org_ID);
        this.batchClose.setDateAcct(period.getEndDate());
        this.batchClose.setDateDoc(period.getEndDate());
        this.batchClose.setGL_Category_ID(this.m_GL_Category_ID);
        this.batchClose.setPostingType(this.m_Postingtype);
        this.batchClose.setC_Currency_ID(this.acctSchema.getC_Currency_ID());
        this.batchClose.setDescription("Chiusura Contabile " + period.getC_Year().getFiscalYear());
        this.batchClose.setC_DocType_ID(this.m_C_DocType_ID);
        this.batchClose.saveEx();
    }

    protected void createBatchOpen() {
        this.batchOpen = new MJournalBatch(this.getCtx(), 0, this.get_TrxName());
        this.batchOpen.setAD_Org_ID(this.m_AD_Org_ID);
        MPeriod period = MPeriod.get(this.getCtx(), this.m_OpenDate, this.m_AD_Org_ID);
        this.batchOpen.setC_Currency_ID(this.acctSchema.getC_Currency_ID());
        this.batchOpen.setDateAcct(period.getStartDate());
        this.batchOpen.setDateDoc(period.getStartDate());
        this.batchOpen.setGL_Category_ID(this.m_GL_Category_ID);
        this.batchOpen.setPostingType(this.m_Postingtype);
        this.batchOpen.setDescription("Apertura Contabile " + period.getC_Year().getFiscalYear());
        this.batchOpen.setC_DocType_ID(this.m_C_DocType_ID);
        this.batchOpen.saveEx();
    }
}

