/*
 * Decompiled with CFR 0.152.
 */
package it.nectosoft.process;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.compiere.util.Env;
import org.jfree.util.Log;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLBancheHandlerCSV
extends DefaultHandler {
    public static final String XML_BANCA_TAG = "dati_intermediario";
    public static final String XML_AGENZIA_TAG = "succursale";
    public static final String XML_ELENCO_TAG = "elenco_intermediari";
    public static final String XML_SUCCURSALI_TAG = "succursali";
    private HashMap<String, String> m_comuni = null;
    private String s_Abi;
    private String s_Banca;
    private Formatter fmt;
    private int nr = 0;
    private int scarti = 0;
    private Properties ctx = null;
    private int clientID = 0;
    private int orgID = 0;
    private String date = null;
    private Set<String> codici = new HashSet<String>();

    public XMLBancheHandlerCSV(String fileName, HashMap<String, String> mComuni) throws IOException {
        this.fmt = new Formatter(fileName);
        this.m_comuni = mComuni;
        this.ctx = Env.getCtx();
        this.clientID = Env.getAD_Client_ID(this.ctx);
        this.orgID = Env.getAD_Org_ID(this.ctx);
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        this.date = sdf.format(cal.getTime());
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals(XML_BANCA_TAG)) {
            this.s_Abi = attributes.getValue("codice_meccanografico").substring(0, 5);
            this.s_Banca = attributes.getValue("denominazione");
            int i = this.s_Banca.indexOf(" (IN FORMA ABBREVIATA");
            if (i == -1) {
                i = this.s_Banca.indexOf(" (IN ");
            }
            if (i != -1) {
                this.s_Banca = this.s_Banca.substring(0, i);
            }
            this.s_Banca = this.s_Banca.replaceAll("\"", "");
            if (this.s_Banca.length() > 60) {
                this.s_Banca = this.s_Banca.substring(0, 60);
            }
        }
        if (qName.equals(XML_AGENZIA_TAG)) {
            String s_Cab = attributes.getValue("cab");
            String s_abicab = String.format("%s-%s", this.s_Abi, s_Cab);
            String s_Indirizzo = attributes.getValue("indirizzo");
            s_Indirizzo = s_Indirizzo.replaceAll("\"", "");
            String s_Cap = attributes.getValue("cap");
            String s_Comune = this.m_comuni.get(attributes.getValue("comune"));
            String s_Data = attributes.getValue("data_chiusura");
            String s_Comp = XMLBancheHandlerCSV.removeNonUtf8CompliantCharacters(String.format("%s %s %s", s_Indirizzo, s_Cap, s_Comune));
            if (s_Data.startsWith("9999") && !this.codici.contains(s_abicab)) {
                this.codici.add(s_abicab);
                this.fmt.format("%d;%d;100;100;\"%s\";\"%s\";\"%s\";\"%s\";\"%s\";%d\n", this.clientID, this.orgID, this.date, this.date, s_abicab, this.s_Banca, s_Comp, 1100000 + this.nr++);
            } else {
                ++this.scarti;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals(XML_SUCCURSALI_TAG)) {
            this.fmt.close();
            Log.info((Object)("Creati: " + this.nr + " Scarti: " + this.scarti));
        }
    }

    public HashMap<String, String> getComuni() {
        return this.m_comuni;
    }

    private static String removeNonUtf8CompliantCharacters(String inString) {
        if (inString == null) {
            return null;
        }
        byte[] byteArr = inString.getBytes();
        int i = 0;
        while (i < byteArr.length) {
            byte ch = byteArr[i];
            if ((ch <= 31 || ch >= 253) && ch != 9 && ch != 10 && ch != 13) {
                byteArr[i] = 32;
            }
            ++i;
        }
        return new String(byteArr);
    }
}

