/*
 * Decompiled with CFR 0.152.
 */
package it.nectosoft.process;

import java.util.HashMap;
import java.util.Properties;
import org.compiere.model.MBank;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLBancheHandler
extends DefaultHandler {
    public static final String XML_BANCA_TAG = "dati_intermediario";
    public static final String XML_AGENZIA_TAG = "succursale";
    private HashMap<String, String> m_comuni = null;
    private String s_Abi;
    private String s_Banca;
    private String m_trx;
    private Properties m_ctx;

    public XMLBancheHandler(Properties ctx, String trx, HashMap<String, String> mComuni) {
        this.m_trx = trx;
        this.m_ctx = ctx;
        this.m_comuni = mComuni;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals(XML_BANCA_TAG)) {
            this.s_Abi = attributes.getValue("cod_intermediario").substring(0, 5);
            this.s_Banca = attributes.getValue("denominazione");
            int i = this.s_Banca.indexOf("(IN FORMA ABBREVIATA");
            if (i != -1) {
                this.s_Banca = this.s_Banca.substring(0, i);
            }
        }
        if (qName.equals(XML_AGENZIA_TAG)) {
            String s_Cab = attributes.getValue("cab");
            String s_Indirizzo = attributes.getValue("indirizzo");
            String s_Cap = attributes.getValue("cap");
            String s_Comune = this.m_comuni.get(attributes.getValue("cod_comune"));
            MBank bank = new MBank(this.m_ctx, 0, this.m_trx);
            bank.setName(this.s_Banca);
            bank.setDescription(String.format("%s %s %s", s_Indirizzo, s_Cap, s_Comune));
            bank.setRoutingNo(String.format("%s-%s", this.s_Abi, s_Cab));
            bank.save();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
    }

    public HashMap<String, String> getComuni() {
        return this.m_comuni;
    }
}

