/*
 * Decompiled with CFR 0.152.
 */
package it.nectosoft.process;

import it.nectosoft.process.LIT_CBI_FixedLengthFile;
import it.nectosoft.process.LIT_CBI_Generate_BON;
import java.lang.reflect.Constructor;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentBatch;
import org.compiere.model.MPaymentProcessor;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;

public class LIT_ProcessPaymentBatch
extends SvrProcess {
    private int p_Record_ID = 0;
    private String p_FileName = "";
    private String p_SIACode = "";
    private Timestamp p_ValueDate = null;
    private MPaymentBatch mpb = null;
    private MPaymentProcessor mpp = null;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("FileName")) {
                    this.p_FileName = (String)para[i].getParameter();
                } else if (name.equals("SIACode")) {
                    this.p_SIACode = (String)para[i].getParameter();
                } else if (name.equals("ValueDate")) {
                    this.p_ValueDate = (Timestamp)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.p_Record_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        this.mpb = new MPaymentBatch(this.getCtx(), this.p_Record_ID, this.get_TrxName());
        this.mpp = new MPaymentProcessor(this.getCtx(), this.mpb.getC_PaymentProcessor_ID(), this.get_TrxName());
        int cnt = 0;
        Query query = MTable.get(this.getCtx(), "C_Payment").createQuery("C_PaymentBatch_ID=?", this.get_TrxName());
        query.setParameters(this.mpb.getC_PaymentBatch_ID());
        List payments = query.list();
        if (payments.size() > 0) {
            String className = this.mpp.getPayProcessorClass();
            if (className == null) {
                className = LIT_CBI_Generate_BON.class.getCanonicalName();
            }
            Class<?> clazz = Class.forName(className);
            Constructor<?> constructor = null;
            try {
                constructor = clazz.getDeclaredConstructor(Properties.class);
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "Constructor not found for " + clazz, e);
                return e.toString();
            }
            try {
                LIT_CBI_FixedLengthFile cbifile = (LIT_CBI_FixedLengthFile)constructor.newInstance(this.getCtx());
                cbifile.writeHeader(this.p_FileName, this.mpb.getDocumentNo(), this.p_SIACode, this.mpp.getC_BankAccount_ID(), this.p_ValueDate);
                for (MPayment mPayment : payments) {
                    if (cbifile.writePayment(mPayment) <= 0) continue;
                    ++cnt;
                }
                cbifile.writeTail();
            }
            catch (Exception e) {
                this.addLog(e.toString());
            }
        }
        return "@Selected@=" + payments.size() + " @Inserted@=" + cnt;
    }
}

