/*
 * Decompiled with CFR 0.152.
 */
package it.nectosoft.process;

import com.f3p.adempiere.util.ModelFactory;
import it.adempiere.maintenance.model.MCOrderMntExpense;
import it.adempiere.maintenance.model.MNTMProduct;
import it.adempiere.maintenance.model.MNTMRequest;
import it.adempiere.maintenance.model.MNTMRequestType;
import it.adempiere.maintenance.model.MRRequestAsset;
import it.adempiere.maintenance.model.MRRequestResource;
import it.adempiere.maintenance.model.X_R_RequestResource;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.I_C_UOM;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPrice;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.model.MRequest;
import org.compiere.model.MRequestType;
import org.compiere.model.MResource;
import org.compiere.model.MResourceAssignment;
import org.compiere.model.MResourceType;
import org.compiere.model.MUOM;
import org.compiere.model.MUOMConversion;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class LIT_Generate_OOW
extends SvrProcess {
    private int p_R_Request_ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("R_Request_ID")) {
                    this.p_R_Request_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        MRequest request = new MRequest(this.getCtx(), this.p_R_Request_ID, this.get_TrxName());
        boolean ismnt = false;
        BigDecimal prjqty = Env.ZERO;
        try {
            if (request.getC_BPartner_ID() <= 0) {
                throw new AdempiereException("@Error@: @C_BPartner_ID@");
            }
            MProject project = new MProject(this.getCtx(), 0, this.get_TrxName());
            MRRequestResource[] reqresource = MRRequestResource.getRequestResource(request);
            project.setAD_User_ID(request.getAD_User_ID());
            project.setDateContract(request.getStartDate());
            project.setDateFinish(request.getCloseDate());
            MBPartner partner = new MBPartner(this.getCtx(), request.getC_BPartner_ID(), this.get_TrxName());
            project.setC_BPartner_ID(partner.getC_BPartner_ID());
            int requestlocation = MNTMRequest.getC_BPartner_Location_ID(request);
            if (requestlocation == 0) {
                MBPartnerLocation[] bplocation = MBPartnerLocation.getForBPartner(this.getCtx(), request.getC_BPartner_ID(), this.get_TrxName());
                if (bplocation == null || bplocation.length == 0) {
                    throw new AdempiereException("@Error@: @C_BPartner_Location_ID@");
                }
                int C_BPLocation_ID = bplocation[0].getC_BPartner_Location_ID();
                if (bplocation.length > 1) {
                    int i = 1;
                    while (i > bplocation.length) {
                        if (bplocation[i].isShipTo()) {
                            C_BPLocation_ID = bplocation[i].getC_BPartner_Location_ID();
                            break;
                        }
                        ++i;
                    }
                }
                project.setC_BPartner_Location_ID(C_BPLocation_ID);
            } else {
                project.setC_BPartner_Location_ID(requestlocation);
            }
            project.setName(request.getSummary());
            project.setValue(String.valueOf(request.getDocumentNo()) + " " + partner.getName());
            if (request.getC_Order_ID() <= 0) {
                throw new AdempiereException("@Error@ @C_Order_ID@");
            }
            MOrder order = new MOrder(this.getCtx(), request.getC_Order_ID(), this.get_TrxName());
            boolean bManualOrder = order.getDeliveryRule().equals("M");
            if (request.getA_Asset_ID() != 0) {
                ismnt = this.IsMaintAsset(request.getA_Asset_ID(), request.getC_Order_ID());
            } else {
                MRRequestAsset[] rasset;
                MRRequestAsset[] mRRequestAssetArray = rasset = MRRequestAsset.getRequestAsset(request);
                int n = rasset.length;
                int n2 = 0;
                while (n2 < n) {
                    MRRequestAsset mRequestAsset = mRRequestAssetArray[n2];
                    ismnt = this.IsMaintAsset(mRequestAsset.getA_Asset_ID(), request.getC_Order_ID());
                    if (ismnt) break;
                    ++n2;
                }
            }
            project.setC_PaymentTerm_ID(order.getC_PaymentTerm_ID());
            project.setM_Warehouse_ID(order.getM_Warehouse_ID());
            project.setC_Campaign_ID(order.getC_Campaign_ID());
            MPriceList mntpriceList = new MPriceList(this.getCtx(), order.getM_PriceList_ID(), this.get_TrxName());
            MPriceListVersion mntvpricel = mntpriceList.getPriceListVersion(project.getDateContract());
            project.setM_PriceList_Version_ID(mntvpricel.getM_PriceList_Version_ID());
            project.setC_Currency_ID(mntpriceList.getC_Currency_ID());
            project.saveEx();
            MRequestType mRequestType = ModelFactory.getRequestType(this.getCtx(), request.getR_RequestType_ID(), this.get_TrxName());
            HashSet<Integer> setAddedExpense = new HashSet<Integer>();
            int iC_BPartner_Location_ID = project.getC_BPartner_Location_ID();
            String sMntReqType = MNTMRequestType.getIsMaintRequest(mRequestType);
            Set<Integer> setExpenseProducts = LIT_Generate_OOW.getExpenses(this.getCtx(), this.get_TrxName());
            MCOrderMntExpense[] mntexp = MCOrderMntExpense.getMCOrderMntExpense(order);
            PO[] pOArray = mntexp;
            int n = mntexp.length;
            int n3 = 0;
            while (n3 < n) {
                MCOrderMntExpense mCOrderMntExpense = pOArray[n3];
                if (mCOrderMntExpense.getReqTypeUse().equals("A") || mCOrderMntExpense.getReqTypeUse().equals(sMntReqType)) {
                    int iEffectiveProductID = -1;
                    if (mCOrderMntExpense.getC_BPartner_Location_ID() <= 0 && mCOrderMntExpense.getC_SalesRegion_ID() <= 0) {
                        iEffectiveProductID = mCOrderMntExpense.getM_Product_ID();
                    } else if (iC_BPartner_Location_ID > 0) {
                        if (mCOrderMntExpense.getC_BPartner_Location_ID() == iC_BPartner_Location_ID) {
                            iEffectiveProductID = mCOrderMntExpense.getM_Product_ID();
                        } else {
                            MBPartnerLocation mBPLoc = new MBPartnerLocation(this.getCtx(), iC_BPartner_Location_ID, this.get_TrxName());
                            if (mBPLoc.getC_SalesRegion_ID() == mCOrderMntExpense.getC_SalesRegion_ID()) {
                                iEffectiveProductID = mCOrderMntExpense.getM_Product_ID();
                            }
                        }
                    }
                    if (iEffectiveProductID >= 0 && !setAddedExpense.contains(iEffectiveProductID)) {
                        setAddedExpense.add(iEffectiveProductID);
                        MProjectLine projectline = new MProjectLine(project);
                        projectline.setM_Product_ID(mCOrderMntExpense.getM_Product_ID());
                        MProduct mntprod = new MProduct(this.getCtx(), mCOrderMntExpense.getM_Product_ID(), this.get_TrxName());
                        projectline.setDescription(mntprod.getName());
                        MProductPrice price = MProductPrice.get(this.getCtx(), mntvpricel.getM_PriceList_Version_ID(), mntprod.getM_Product_ID(), this.get_TrxName());
                        if (price == null) {
                            throw new AdempiereException("@Invalid@ @ProductPriceD@");
                        }
                        if (bManualOrder) {
                            projectline.setPlannedPrice(price.getPriceStd());
                        } else {
                            projectline.setPlannedPrice(Env.ZERO);
                        }
                        projectline.setPlannedQty(mCOrderMntExpense.getQtyToInvoice());
                        if (!setExpenseProducts.contains(iEffectiveProductID)) {
                            projectline.setCommittedQty(projectline.getPlannedQty());
                        }
                        projectline.saveEx();
                    }
                }
                ++n3;
            }
            pOArray = reqresource;
            n = reqresource.length;
            n3 = 0;
            while (n3 < n) {
                MResourceType rtype;
                PO mRequestResource = pOArray[n3];
                MResourceAssignment assresource = new MResourceAssignment(this.getCtx(), ((X_R_RequestResource)mRequestResource).getS_ResourceAssignment_ID(), this.get_TrxName());
                int S_ResourceType_ID = ((X_R_RequestResource)mRequestResource).getS_ResourceType_ID();
                if (S_ResourceType_ID <= 0) {
                    MResource mRes = ModelFactory.getResource(this.getCtx(), assresource.getS_Resource_ID(), this.get_TrxName());
                    S_ResourceType_ID = mRes.getS_ResourceType_ID();
                }
                if ((rtype = new MResourceType(this.getCtx(), S_ResourceType_ID, this.get_TrxName())).get_ValueAsInt("M_Product_ID") <= 0) {
                    throw new AdempiereException("@Missing@ @M_Product_ID@ " + rtype.getName());
                }
                MProduct product = new MProduct(this.getCtx(), rtype.get_ValueAsInt("M_Product_ID"), this.get_TrxName());
                I_C_UOM mUom = product.getC_UOM();
                BigDecimal bdRate = MUOMConversion.getProductRateFrom(this.getCtx(), product.getM_Product_ID(), rtype.getC_UOM_ID());
                if (bdRate == null && (bdRate = MUOMConversion.getRate(rtype.getC_UOM_ID(), product.getC_UOM_ID())) == null) {
                    MUOM mUomRType = MUOM.get(this.getCtx(), rtype.getC_UOM_ID());
                    MUOM mUomProd = MUOM.get(this.getCtx(), product.getC_UOM_ID());
                    throw new AdempiereException("@NoUOMConversion@ " + product.getName() + " (" + (mUomProd != null ? mUomProd.getName() : "<ND>") + " -> " + (mUomRType != null ? mUomRType.getName() : "<ND>") + ")");
                }
                String sql = "M_Product_ID=? AND C_Project_ID=?";
                MProjectLine sameres = (MProjectLine)new Query(Env.getCtx(), "C_ProjectLine", "M_Product_ID=? AND C_Project_ID=?", request.get_TrxName()).setParameters(product.getM_Product_ID(), project.getC_Project_ID()).setOrderBy("M_Product_ID").first();
                if (sameres == null || sameres.getM_Product_ID() != product.getM_Product_ID()) {
                    prjqty = Env.ZERO;
                    MProjectLine projectline = new MProjectLine(project);
                    projectline.setM_Product_ID(product.getM_Product_ID());
                    projectline.setM_Product_Category_ID(product.getM_Product_Category_ID());
                    if (!ismnt) {
                        String sql2 = "M_Product_ID=? AND C_Order_ID=?";
                        MOrderLine olineproduct = (MOrderLine)new Query(Env.getCtx(), "C_OrderLine", "M_Product_ID=? AND C_Order_ID=?", request.get_TrxName()).setParameters(product.getM_Product_ID(), order.get_ID()).first();
                        if (olineproduct == null) {
                            MPriceList priceList = new MPriceList(this.getCtx(), order.getM_PriceList_ID(), this.get_TrxName());
                            MPriceListVersion vpricel = priceList.getPriceListVersion(project.getDateContract());
                            project.setM_PriceList_Version_ID(vpricel.getM_PriceList_Version_ID());
                            MProductPrice price = MProductPrice.get(this.getCtx(), vpricel.getM_PriceList_Version_ID(), product.getM_Product_ID(), this.get_TrxName());
                            projectline.setPlannedPrice(price.getPriceStd());
                        } else {
                            projectline.setPlannedPrice(olineproduct.getPriceActual());
                        }
                    }
                    if (ismnt || !bManualOrder) {
                        projectline.setPlannedPrice(Env.ZERO);
                    }
                    projectline.setDescription(product.getName());
                    projectline.setPlannedQty(assresource.getQty().multiply(bdRate).setScale(mUom.getStdPrecision(), 4));
                    prjqty = prjqty.add(assresource.getQty().multiply(bdRate).setScale(mUom.getStdPrecision(), 4));
                    projectline.saveEx();
                } else {
                    prjqty = prjqty.add(assresource.getQty().multiply(bdRate).setScale(mUom.getStdPrecision(), 4));
                    sameres.setPlannedQty(prjqty);
                    sameres.saveEx();
                }
                ++n3;
            }
            String sDocSubTypeSO = order.getC_DocTypeTarget().getDocSubTypeSO();
            boolean isMaintOrder = false;
            if (sDocSubTypeSO != null && sDocSubTypeSO.equals("MN")) {
                MOrderLine[] mOrderLines;
                MOrderLine[] mOrderLineArray = mOrderLines = order.getLines();
                int n4 = mOrderLines.length;
                int n5 = 0;
                while (n5 < n4) {
                    int isResourceType;
                    MProduct mProduct;
                    MOrderLine mOrderLine = mOrderLineArray[n5];
                    if (mOrderLine.getM_Product_ID() > 0 && !(mProduct = MProduct.get(this.getCtx(), mOrderLine.getM_Product_ID())).getProductType().equals("I") && (isResourceType = DB.getSQLValue(this.get_TrxName(), "SELECT 1 from S_ResourceType WHERE M_Product_ID = ?", mProduct.getM_Product_ID())) <= 0) {
                        MProjectLine mPrjLine = new MProjectLine(project);
                        mPrjLine.setM_Product_ID(mProduct.getM_Product_ID());
                        mPrjLine.setM_Product_Category_ID(mProduct.getM_Product_Category_ID());
                        mPrjLine.setDescription(mProduct.getName());
                        mPrjLine.setPlannedQty(mOrderLine.getQtyEntered());
                        if (bManualOrder) {
                            mPrjLine.setPlannedPrice(mOrderLine.getPriceActual());
                        } else {
                            mPrjLine.setPlannedPrice(Env.ZERO);
                        }
                        if (setExpenseProducts.contains(mProduct.getM_Product_ID())) {
                            mPrjLine.setCommittedQty(BigDecimal.ZERO);
                        } else {
                            mPrjLine.setCommittedQty(mPrjLine.getPlannedQty());
                        }
                        mPrjLine.saveEx();
                    }
                    ++n5;
                }
            }
            this.addLog("@C_Project_ID@=" + project.getValue());
            request.setC_Project_ID(project.getC_Project_ID());
            try {
                request.saveEx();
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "Cannot save request", e);
                throw new AdempiereException(e);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Cannot create Project", e);
            throw new AdempiereException(e);
        }
        return "@Ok@";
    }

    public boolean IsMaintAsset(int assetid, int orderid) throws Exception {
        boolean ismnt = false;
        String sql = "SELECT l.ISMNTLINE FROM C_ORDERLINE l INNER JOIN C_ORDERLINEASSET a ON a.C_ORDERLINE_ID = l.C_ORDERLINE_ID WHERE a.A_ASSET_ID = ? AND l.C_ORDER_ID = ? and a.IsActive = 'Y'  and l.IsActive = 'Y' and l.IsResIncl = 'Y'  and l.IsSuppLine = 'Y' ";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement("SELECT l.ISMNTLINE FROM C_ORDERLINE l INNER JOIN C_ORDERLINEASSET a ON a.C_ORDERLINE_ID = l.C_ORDERLINE_ID WHERE a.A_ASSET_ID = ? AND l.C_ORDER_ID = ? and a.IsActive = 'Y'  and l.IsActive = 'Y' and l.IsResIncl = 'Y'  and l.IsSuppLine = 'Y' ", null);
                pstmt.setInt(1, assetid);
                pstmt.setInt(2, orderid);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    ismnt = true;
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, Msg.getMsg(this.getCtx(), "Cannot execute query for asset table", true), e);
                throw new Exception(Msg.getMsg(this.getCtx(), "Cannot execute query for asset table", true));
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return ismnt;
    }

    public static Set<Integer> getExpenses(Properties ctx, String sTrx) {
        List<MProduct> lstProduct = MNTMProduct.getExpenses(ctx, sTrx);
        HashSet<Integer> setExpenses = new HashSet<Integer>();
        if (lstProduct != null && lstProduct.size() > 0) {
            for (MProduct mProd : lstProduct) {
                setExpenses.add(mProd.getM_Product_ID());
            }
        }
        return setExpenses;
    }
}

