/*
 * Decompiled with CFR 0.152.
 */
package it.nectosoft.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MDocType;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MInvoiceTax;
import org.compiere.model.MPInstance;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTax;
import org.compiere.model.MTaxDeclaration;
import org.compiere.model.MTaxDeclarationAcct;
import org.compiere.model.MTaxDeclarationLine;
import org.compiere.model.Query;
import org.compiere.model.X_LIT_VATLedgerDef;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class LIT_GenerateVATReg
extends SvrProcess {
    private Timestamp p_DateTrx = null;
    private BigDecimal p_ProRata = Env.ZERO;
    private int p_Period_ID = 0;
    private boolean p_createdocuments = false;
    private boolean p_DeleteOldTax = false;
    private MInvoice m_iv = null;
    private MInvoiceTax m_it = null;
    private MTaxDeclaration m_td = null;
    private X_LIT_VATLedgerDef m_vl = null;
    private int m_noLegders = 0;
    private int m_noLines = 0;
    private int m_noAccts = 0;
    private Timestamp m_datefrom = null;
    private Timestamp m_dateto = null;
    private MPInstance m_pinstance = null;
    private MInvoice VATdocument = null;
    private int m_AD_Client_ID = 0;
    private int m_AD_Org_ID = 0;
    private Properties m_ctx = null;
    private static final String LIT_VAT_DECLARATION_DOCTYPE_NAME = "LIT_VAT_DECLARATION_DOCTYPE_NAME";
    private static final String LIT_VAT_DECLARATION_BPARTNER_VALUE = "LIT_VAT_DECLARATION_BPARTNER_VALUE";
    private int m_docType_ID = 0;
    private int m_BPartner_ID = 0;
    private int m_Project_ID = 0;
    private boolean hasErrors = false;

    @Override
    protected void prepare() {
        this.m_ctx = this.getCtx();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("DateTrx")) {
                    this.p_DateTrx = (Timestamp)para[i].getParameter();
                } else if (name.equals("IsTransferred")) {
                    this.p_createdocuments = "Y".equals(para[i].getParameter());
                } else if (name.equals("Rate")) {
                    this.p_ProRata = (BigDecimal)para[i].getParameter();
                } else if (name.equals("DeleteOld")) {
                    this.p_DeleteOldTax = "Y".equals(para[i].getParameter());
                } else if (name.equals("C_Period_ID")) {
                    this.p_Period_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.m_pinstance = new MPInstance(this.m_ctx, this.getAD_PInstance_ID(), this.get_TrxName());
        this.m_AD_Client_ID = this.m_pinstance.getAD_Client_ID();
        this.m_AD_Org_ID = this.m_pinstance.getAD_Org_ID();
    }

    @Override
    protected String doIt() throws Exception {
        block12: {
            String docName = MSysConfig.getValue(LIT_VAT_DECLARATION_DOCTYPE_NAME, "DICHIARAZIONE IVA", this.m_AD_Client_ID, this.m_AD_Org_ID);
            this.m_docType_ID = DB.getSQLValue(this.get_TrxName(), "SELECT C_DOCTYPE_ID FROM C_DOCTYPE WHERE UPPER(NAME) = UPPER(?) AND AD_CLIENT_ID = ?", docName, this.m_AD_Client_ID);
            if (this.m_docType_ID == -1) {
                throw new AdempiereException("No DocType found, please create it: " + docName);
            }
            String bpValue = MSysConfig.getValue(LIT_VAT_DECLARATION_BPARTNER_VALUE, "IVA C/VERSAMENTI", this.m_AD_Client_ID, this.m_AD_Org_ID);
            this.m_BPartner_ID = DB.getSQLValue(this.get_TrxName(), "SELECT C_BPARTNER_ID FROM C_BPARTNER WHERE UPPER(VALUE) = UPPER(?) AND AD_CLIENT_ID = ?", bpValue, this.m_AD_Client_ID);
            if (this.m_BPartner_ID == -1) {
                throw new AdempiereException("No BPartner found, please create it: " + bpValue);
            }
            this.m_Project_ID = DB.getSQLValue(this.get_TrxName(), "SELECT C_PROJECT_ID FROM C_PROJECT WHERE C_BPARTNER_ID = ?", this.m_BPartner_ID);
            if (this.m_Project_ID == -1 && "Y".equals(Env.getContext(this.getCtx(), "$Element_PJ"))) {
                throw new AdempiereException("No Project assigned to BPartner, please assign one to: " + bpValue);
            }
            MPeriod period = new MPeriod(this.m_ctx, this.p_Period_ID, this.get_TrxName());
            this.m_datefrom = period.getStartDate();
            this.m_dateto = period.getEndDate();
            MDocType docType = new MDocType(this.m_ctx, this.m_docType_ID, this.get_TrxName());
            if (!period.isOpen(docType.getDocBaseType(), this.p_DateTrx)) {
                throw new AdempiereException("@PeriodClosed@:" + period.toString());
            }
            if (this.p_DeleteOldTax) {
                this.deleteoldtax();
            }
            String sql = "SELECT * FROM LIT_VATLedgerDef WHERE AD_CLIENT_ID=? AND AD_ORG_ID IN (0,?) AND ISACTIVE='Y' ORDER BY ISSOTRX";
            String msg = null;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.m_AD_Client_ID);
                    pstmt.setInt(2, this.m_AD_Org_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        this.m_vl = new X_LIT_VATLedgerDef(this.m_ctx, rs, this.get_TrxName());
                        ++this.m_noLegders;
                        this.createDeclaration();
                    }
                    if (this.p_createdocuments && !this.hasErrors) {
                        msg = this.createDocument();
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block12;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return "@LIT_VATLedgerDef_ID@ #" + this.m_noLegders;
    }

    private void deleteoldtax() {
        try {
            int no = 0;
            String where = " WHERE td.datefrom = " + DB.TO_DATE(this.m_datefrom) + " AND td.dateto = " + DB.TO_DATE(this.m_dateto) + " AND AD_CLIENT_ID= " + this.m_pinstance.getAD_Client_ID() + " AND AD_ORG_ID IN (0," + this.m_pinstance.getAD_Org_ID() + ")";
            String sql1 = "DELETE FROM c_taxdeclarationacct ta WHERE ta.c_taxdeclaration_id IN (SELECT td.c_taxdeclaration_id FROM c_taxdeclaration td " + where + ")";
            no = DB.executeUpdate(sql1, this.get_TrxName());
            String sql2 = "DELETE FROM c_taxdeclaration td " + where;
            no = DB.executeUpdate(sql2, this.get_TrxName());
            this.commitEx();
        }
        catch (Exception e) {
            this.rollback();
            this.log.log(Level.SEVERE, "DELETE TAXDECLARATION", e);
        }
    }

    protected void createDeclaration() throws Exception {
        int noInvoices;
        block10: {
            SimpleDateFormat date = new SimpleDateFormat("yyyy-MM ");
            this.m_td = new MTaxDeclaration(this.m_ctx, 0, this.get_TrxName());
            this.m_td.setName(String.valueOf(date.format(this.p_DateTrx)) + this.m_vl.getName());
            this.m_td.setDescription(String.valueOf(date.format(this.p_DateTrx)) + this.m_vl.getName());
            this.m_td.setDateTrx(this.p_DateTrx);
            this.m_td.setDateFrom(this.m_datefrom);
            this.m_td.setDateTo(this.m_dateto);
            this.m_td.set_CustomColumn("LIT_VATLedgerDef_ID", this.m_vl.getLIT_VATLedgerDef_ID());
            this.m_td.save();
            String sql = "SELECT * FROM (SELECT DISTINCT IT.*,I.DATEINVOICED, T2.C_TAX_ID TAXID2, DECODE('Y',T.ISSALESTAX,'Y',T2.ISSALESTAX,'Y','N') AS UNDEDUCTIBLE, CASE DR.ISINTRAVAT WHEN 'N' THEN I.VATLEDGERNO ELSE  IA.VATLEDGERNO END AS VATLEDGERNO, CASE DR.ISINTRAVAT WHEN 'N' THEN I.VATLEDGERDATE ELSE  IA.VATLEDGERDATE END AS VATLEDGERDATE, DR.ISINTRAVAT FROM LIT_VATLEDGERDEF VD INNER JOIN LIT_VATLEDGERDEFRULE DR ON (DR.LIT_VATLEDGERDEF_ID = VD.LIT_VATLEDGERDEF_ID) INNER JOIN C_INVOICE I ON (I.PROCESSED='Y' AND DR.C_DOCTYPE_ID = I.C_DOCTYPE_ID AND I.VATLEDGERDATE BETWEEN ? and ?) INNER JOIN C_INVOICETAX IT ON (DR.C_TAX_ID = IT.C_TAX_ID AND I.C_INVOICE_ID = IT.C_INVOICE_ID) INNER JOIN C_TAX T ON (T.C_TAX_ID = IT.C_TAX_ID) LEFT JOIN C_TAX T2 ON (T2.PARENT_TAX_ID = T.PARENT_TAX_ID AND T.C_TAX_ID <> T2.C_TAX_ID) LEFT JOIN LIT_INVOICE_AUTO IA ON (IA.C_INVOICE_ID = I.C_INVOICE_ID) WHERE VD.LIT_VATLEDGERDEF_ID = ? AND I.AD_CLIENT_ID = ? AND I.AD_ORG_ID = ?) X  ORDER BY X.VATLEDGERDATE,X.VATLEDGERNO";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            noInvoices = 0;
            this.m_noLines = 0;
            this.m_noAccts = 0;
            long lastProtocol = 0L;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setTimestamp(1, this.m_td.getDateFrom());
                    pstmt.setTimestamp(2, this.m_td.getDateTo());
                    pstmt.setInt(3, this.m_vl.getLIT_VATLedgerDef_ID());
                    pstmt.setInt(4, this.m_AD_Client_ID);
                    pstmt.setInt(5, this.m_AD_Org_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        long curProtocol;
                        this.m_it = new MInvoiceTax(this.m_ctx, rs, null);
                        int C_Tax_ID2 = rs.getInt("TAXID2");
                        boolean undeductible = rs.getString("UNDEDUCTIBLE").equals("Y");
                        String noProt = rs.getString("VATLEDGERNO");
                        if (noProt == null) {
                            this.addLog("Registrazione senza Protocollo IVA (ID): " + this.m_vl.getName() + this.m_it.getC_Invoice_ID());
                            this.hasErrors = true;
                        } else if (lastProtocol != 0L && (curProtocol = Long.parseLong(noProt.replaceAll("\\D", ""))) != lastProtocol + 1L) {
                            this.addLog("Errore nella sequenza del Protocollo IVA (ID): " + this.m_vl.getName() + this.m_it.getC_Invoice_ID());
                            this.hasErrors = true;
                        }
                        this.create(this.m_it, rs.getTimestamp("VATLEDGERDATE"), rs.getString("VATLEDGERNO"), C_Tax_ID2, undeductible, this.m_vl.isSOTrx());
                        ++noInvoices;
                    }
                    if (this.m_vl.isSOTrx() && this.m_vl.get_Value("IsSuspendedVAT").equals(true)) {
                        this.createSuspendedVATDeclaration();
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    this.hasErrors = true;
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.addLog(String.valueOf(this.m_td.getDescription()) + " (righe lette: " + noInvoices + ", righe scritte: " + this.m_noLines + ", riferimenti alla contabilit\u00c3\u00a0: " + this.m_noAccts + ")");
    }

    private void create(MInvoiceTax invoiceTax, Timestamp VATLedgerDate, String VATLedgerNo, int C_Tax_ID2, boolean undeductible, boolean isSOTrx) {
        block17: {
            BigDecimal netAmount = Env.ZERO;
            if (this.m_iv == null || this.m_iv.getC_Invoice_ID() != invoiceTax.getC_Invoice_ID()) {
                this.m_iv = new MInvoice(this.m_ctx, invoiceTax.getC_Invoice_ID(), this.get_TrxName());
            }
            try {
                MTaxDeclarationLine tdl = new MTaxDeclarationLine(this.m_td, this.m_iv, invoiceTax);
                MTax tax = MTax.get(this.m_ctx, invoiceTax.getC_Tax_ID());
                tdl.setLine((this.m_noLines + 1) * 10);
                tdl.setDescription(this.m_iv.getDescription());
                tdl.set_CustomColumn("VATLedgerDate", VATLedgerDate);
                tdl.set_CustomColumn("VATLedgerNo", VATLedgerNo);
                if (undeductible) {
                    BigDecimal pRate = null;
                    if (tax.getParent_Tax_ID() > 0) {
                        MTax parentTax = new MTax(this.m_ctx, tax.getParent_Tax_ID(), this.get_TrxName());
                        pRate = parentTax.getRate();
                    }
                    if (pRate == null || pRate.signum() == 0) {
                        pRate = Env.ONE;
                    }
                    MTax siblingTax = new MTax(this.m_ctx, C_Tax_ID2, this.get_TrxName());
                    netAmount = invoiceTax.getTaxBaseAmt().multiply(tax.getRate().divide(pRate)).setScale(this.m_iv.getPrecision(), 4);
                    if (tax.isSalesTax()) {
                        netAmount = invoiceTax.getTaxBaseAmt().subtract(invoiceTax.getTaxBaseAmt().multiply(siblingTax.getRate().divide(pRate)).setScale(this.m_iv.getPrecision(), 4));
                    }
                    tdl.setTaxBaseAmt(netAmount);
                }
                if (this.m_iv.isSOTrx() ^ isSOTrx) {
                    tdl.setTaxBaseAmt(tdl.getTaxBaseAmt().negate());
                    tdl.setTaxAmt(tdl.getTaxAmt().negate());
                }
                if (this.m_iv.isCreditMemo()) {
                    tdl.setTaxBaseAmt(tdl.getTaxBaseAmt().negate());
                    tdl.setTaxAmt(tdl.getTaxAmt().negate());
                }
                if (this.m_iv.get_Value("IsIntraVAT").equals(true) && !this.m_iv.isSOTrx() && isSOTrx) {
                    tdl.setTaxBaseAmt(tdl.getTaxBaseAmt().negate());
                }
                if (tdl.save()) {
                    ++this.m_noLines;
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, e.toString());
            }
            String sql = "SELECT * FROM Fact_Acct WHERE AD_Table_ID=? AND Record_ID=? AND C_Tax_ID=? AND Line_ID is null";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, MInvoice.Table_ID);
                    pstmt.setInt(2, invoiceTax.getC_Invoice_ID());
                    pstmt.setInt(3, invoiceTax.getC_Tax_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MFactAcct fact = new MFactAcct(this.m_ctx, rs, null);
                        MTaxDeclarationAcct tda = new MTaxDeclarationAcct(this.m_td, fact);
                        tda.setLine((this.m_noAccts + 1) * 10);
                        if (!tda.save()) continue;
                        ++this.m_noAccts;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block17;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
    }

    private void createSuspendedVATDeclaration() {
        String sql = "SELECT  TC.COMMODITYCODE AS CC,AL.C_ALLOCATIONLINE_ID,AL.DATETRX,AL.C_INVOICE_ID,I.VATLEDGERDATE,I.VATLEDGERNO,  SUM(AL.AMOUNT) AS AMOUNT,  SUM(FA.AMTACCTDR-FA.AMTACCTCR) AS TAXAMT, T.C_TAX_ID, I.C_BPARTNER_ID , I.C_CURRENCY_ID, I.DATEACCT  FROM C_ALLOCATIONLINE AL  INNER JOIN C_PAYMENT P ON (P.C_PAYMENT_ID=AL.C_PAYMENT_ID)  INNER JOIN C_DOCTYPE DT ON (DT.C_DOCTYPE_ID = P.C_DOCTYPE_ID)  INNER JOIN C_INVOICE I ON (I.C_INVOICE_ID=AL.C_INVOICE_ID)  INNER JOIN AD_CLIENTINFO CI ON (CI.AD_CLIENT_ID = AL.AD_CLIENT_ID)  INNER JOIN C_ACCTSCHEMA_DEFAULT ASD ON (ASD.C_ACCTSCHEMA_ID = CI.C_ACCTSCHEMA1_ID)  INNER JOIN C_VALIDCOMBINATION VC ON (VC.C_VALIDCOMBINATION_ID = ASD.T_SUSPENDED_ACCT)  INNER JOIN FACT_ACCT FA ON (FA.ACCOUNT_ID = VC.ACCOUNT_ID AND FA.AD_TABLE_ID = 735 AND FA.RECORD_ID=AL.C_ALLOCATIONHDR_ID AND FA.LINE_ID = AL.C_ALLOCATIONLINE_ID)  INNER JOIN C_TAX T ON (T.C_TAX_ID = FA.C_TAX_ID)  INNER JOIN C_TAXCATEGORY TC ON (TC.C_TAXCATEGORY_ID = T.C_TAXCATEGORY_ID)  WHERE  P.DATEACCT BETWEEN ? AND ?  AND I.ISSUSPENDEDVAT = 'Y' AND AL.AD_CLIENT_ID = ? AND AL.AD_ORG_ID = ?  GROUP BY TC.COMMODITYCODE, AL.C_ALLOCATIONLINE_ID, AL.DATETRX, AL.C_INVOICE_ID,I.VATLEDGERDATE,I.VATLEDGERNO,T.C_TAX_ID,  I.C_BPARTNER_ID, I.C_CURRENCY_ID,I.DATEACCT  ORDER BY TC.COMMODITYCODE ";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setTimestamp(1, this.m_td.getDateFrom());
            pstmt.setTimestamp(2, this.m_td.getDateTo());
            pstmt.setInt(3, this.m_AD_Client_ID);
            pstmt.setInt(4, this.m_AD_Org_ID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MTaxDeclarationLine tdl = null;
                tdl = new MTaxDeclarationLine(this.m_ctx, 0, this.get_TrxName());
                tdl.setLine((this.m_noLines + 1) * 10);
                tdl.setAD_Org_ID(this.m_td.getAD_Org_ID());
                tdl.setC_TaxDeclaration_ID(this.m_td.getC_TaxDeclaration_ID());
                tdl.setIsManual(false);
                tdl.setDescription("Sospesa Pagata");
                tdl.setC_Invoice_ID(rs.getInt("C_INVOICE_ID"));
                tdl.setC_BPartner_ID(rs.getInt("C_BPARTNER_ID"));
                tdl.setC_Currency_ID(rs.getInt("C_CURRENCY_ID"));
                tdl.setDateAcct(rs.getTimestamp("DATEACCT"));
                tdl.setTaxBaseAmt(rs.getBigDecimal("AMOUNT"));
                tdl.setTaxAmt(rs.getBigDecimal("TAXAMT"));
                tdl.setC_Tax_ID(rs.getInt("C_TAX_ID"));
                tdl.setC_AllocationLine_ID(rs.getInt("C_ALLOCATIONLINE_ID"));
                tdl.setDescription(this.m_iv.getDescription());
                tdl.set_ValueOfColumn("VATLedgerDate", (Object)rs.getTimestamp("VATLEDGERDATE"));
                tdl.set_ValueOfColumn("VATLedgerNo", (Object)rs.getString("VATLEDGERNO"));
                if (tdl.save()) {
                    ++this.m_noLines;
                }
                String sql2 = "SELECT * FROM Fact_Acct WHERE AD_Table_ID=? AND Record_ID=? AND C_Tax_ID=? AND Line_ID IS NULL";
                CPreparedStatement pstmt2 = null;
                ResultSet rs2 = null;
                try {
                    try {
                        pstmt2 = DB.prepareStatement(sql2, null);
                        pstmt2.setInt(1, MInvoice.Table_ID);
                        pstmt2.setInt(2, rs.getInt("C_INVOICE_ID"));
                        pstmt2.setInt(3, rs.getInt("C_TAX_ID"));
                        rs2 = pstmt2.executeQuery();
                        while (rs2.next()) {
                            MFactAcct fact = new MFactAcct(this.m_ctx, rs2, null);
                            MTaxDeclarationAcct tda = new MTaxDeclarationAcct(this.m_td, fact);
                            tda.setLine((this.m_noAccts + 1) * 10);
                            if (!tda.save()) continue;
                            ++this.m_noAccts;
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, sql2, e);
                        DB.close(rs2, pstmt2);
                        rs2 = null;
                        pstmt2 = null;
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs2, pstmt2);
                    rs2 = null;
                    pstmt2 = null;
                    throw throwable;
                }
                DB.close(rs2, pstmt2);
                rs2 = null;
                pstmt2 = null;
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String createDocument() {
        ResultSet rs;
        CPreparedStatement pstmt;
        block8: {
            this.VATdocument = new MInvoice(this.m_ctx, 0, this.get_TrxName());
            pstmt = null;
            rs = null;
            try {
                this.VATdocument.setAD_Org_ID(this.m_td.getAD_Org_ID());
                this.VATdocument.setPaymentRule("D");
                this.VATdocument.setDateAcct(this.m_td.getDateTrx());
                this.VATdocument.setDateInvoiced(this.m_td.getDateTrx());
                this.VATdocument.setIsSOTrx(false);
                this.VATdocument.setDescription("Saldo IVA -" + this.m_td.getDateTrx());
                this.VATdocument.setC_DocTypeTarget_ID(this.m_docType_ID);
                MBPartner BP = new MBPartner(this.m_ctx, this.m_BPartner_ID, this.get_TrxName());
                this.VATdocument.setBPartner(BP);
                this.VATdocument.setC_Project_ID(this.m_Project_ID);
                if (!this.VATdocument.save()) {
                    this.addLog("Errore nel salvataggio del documento Saldo IVA");
                }
                String sql = "SELECT  CASE VD.ISSOTRX WHEN 'Y' THEN SUM(TAXAMT) ELSE SUM(-TAXAMT) END AS  SALDO, CASE VD.ISSOTRX WHEN 'Y' THEN SUM(TAXBASEAMT) ELSE SUM(-TAXBASEAMT) END AS  IMPONIBILE, VD.ISSOTRX, VD.NAME   FROM C_TAXDECLARATIONLINE TDL  INNER JOIN C_TAXDECLARATION TD ON (TDL.C_TAXDECLARATION_ID=TD.C_TAXDECLARATION_ID) INNER JOIN LIT_VATLEDGERDEF VD ON (VD.LIT_VATLEDGERDEF_ID = TD.LIT_VATLEDGERDEF_ID)  INNER JOIN C_TAX TX ON ( TDL.C_TAX_ID = TX.C_TAX_ID )  INNER JOIN C_INVOICE I ON (I.C_INVOICE_ID = TDL.C_INVOICE_ID)  WHERE TRUNC(TD.DATEFROM) = ? AND TRUNC(TD.DATETO) = ? AND TDL.AD_Client_ID = ? AND TX.ISSALESTAX ='N' AND (TDL.C_ALLOCATIONLINE_ID IS NOT NULL OR I.ISSUSPENDEDVAT = 'N')  GROUP BY VD.NAME,VD.ISSOTRX";
                pstmt = DB.prepareStatement(sql, this.get_TrxName());
                pstmt.setTimestamp(1, this.m_td.getDateFrom());
                pstmt.setTimestamp(2, this.m_td.getDateTo());
                pstmt.setInt(3, this.m_AD_Client_ID);
                rs = pstmt.executeQuery();
                String whereClause = "UPC = ? AND AD_Org_ID in (0,?)";
                while (rs.next()) {
                    MInvoiceLine iline = new MInvoiceLine(this.VATdocument);
                    iline.setQty(Env.ONE);
                    BigDecimal saldo = Env.ZERO;
                    BigDecimal SaldoAttuale = Env.ZERO;
                    SaldoAttuale = saldo = rs.getBigDecimal("SALDO");
                    String name = rs.getString("NAME");
                    iline.setDescription(String.valueOf(name) + " " + this.p_DateTrx.toString());
                    MProduct prodotto = (MProduct)new Query(this.m_ctx, "M_Product", whereClause, this.get_TrxName()).setClient_ID().setParameters(name, this.m_AD_Org_ID).setOrderBy("AD_Org_ID DESC").first();
                    if (prodotto == null) {
                        this.addLog("Prodotto IVA con codice a barre non trovato valore = " + name);
                        break block8;
                    }
                    iline.setProduct(prodotto);
                    iline.setPrice(SaldoAttuale);
                    iline.setC_Project_ID(this.m_Project_ID);
                    iline.save();
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
            {
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "Errore nella creazione del documento" + this.VATdocument.toString(), e);
                    DB.close(rs, pstmt);
                    return "Errore nella creazione del documento di Giroconto IVA";
                    break;
                }
            }
            DB.close(rs, pstmt);
            return null;
        }
        DB.close(rs, pstmt);
        return "@Error@";
    }
}

