/*
 * Decompiled with CFR 0.152.
 */
package it.nectosoft.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.logging.Level;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceTax;
import org.compiere.model.MTaxDeclaration;
import org.compiere.model.MTaxDeclarationAcct;
import org.compiere.model.MTaxDeclarationLine;
import org.compiere.model.X_LIT_VATLedgerDef;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class LIT_GenerateVATDeclaration
extends SvrProcess {
    private int p_Record_ID = 0;
    private Timestamp p_DateTrx = null;
    private Timestamp p_DateInvoiced_From = null;
    private Timestamp p_DateInvoiced_To = null;
    private int p_LIT_VATLedgerDef_ID = 0;
    private int p_C_TaxDeclaration_ID = 0;
    private boolean p_DeleteOld = true;
    private MInvoice m_iv = null;
    private MInvoiceTax m_it = null;
    private MTaxDeclaration m_td = null;
    private X_LIT_VATLedgerDef m_vl = null;
    private int m_noLines = 0;
    private int m_noAccts = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("DateTrx")) {
                    this.p_DateTrx = (Timestamp)para[i].getParameter();
                } else if (name.equals("DateInvoiced")) {
                    this.p_DateInvoiced_From = (Timestamp)para[i].getParameter();
                    this.p_DateInvoiced_To = (Timestamp)para[i].getParameter_To();
                } else if (name.equals("LIT_VATLedgerDef_ID")) {
                    this.p_LIT_VATLedgerDef_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("C_TaxDeclaration_ID")) {
                    this.p_C_TaxDeclaration_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("DeleteOld")) {
                    this.p_DeleteOld = "Y".equals(para[i].getParameter());
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.p_Record_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        int noInvoices;
        block11: {
            String sql;
            this.m_vl = new X_LIT_VATLedgerDef(this.getCtx(), this.p_LIT_VATLedgerDef_ID, this.get_TrxName());
            if (this.p_C_TaxDeclaration_ID > 0) {
                this.m_td = new MTaxDeclaration(this.getCtx(), this.p_C_TaxDeclaration_ID, this.get_TrxName());
                if (this.p_DeleteOld) {
                    sql = "DELETE C_TaxDeclarationLine WHERE C_TaxDeclaration_ID=?";
                    int no = DB.executeUpdate(sql, this.p_C_TaxDeclaration_ID, false, this.get_TrxName());
                    if (no != 0) {
                        this.log.config("Delete Line #" + no);
                    }
                    if ((no = DB.executeUpdate(sql = "DELETE C_TaxDeclarationAcct WHERE C_TaxDeclaration_ID=?", this.p_C_TaxDeclaration_ID, false, this.get_TrxName())) != 0) {
                        this.log.config("Delete Acct #" + no);
                    }
                }
            } else {
                SimpleDateFormat date = new SimpleDateFormat("yyyy-MM ");
                this.m_td = new MTaxDeclaration(this.getCtx(), 0, this.get_TrxName());
                this.m_td.setName(String.valueOf(date.format(this.p_DateTrx)) + this.m_vl.getName());
                this.m_td.setDescription(String.valueOf(date.format(this.p_DateTrx)) + this.m_vl.getName());
            }
            this.m_td.setDateTrx(this.p_DateTrx);
            this.m_td.setDateFrom(this.p_DateInvoiced_From);
            this.m_td.setDateTo(this.p_DateInvoiced_To);
            this.m_td.set_CustomColumn("LIT_VATLedgerDef_ID", this.p_LIT_VATLedgerDef_ID);
            this.m_td.save();
            sql = "SELECT DISTINCT IT.*,I.DATEINVOICED,  CASE DR.ISINTRAVAT WHEN 'N' THEN I.VATLEDGERNO ELSE  IA.VATLEDGERNO END AS VATLEDGERNO, CASE DR.ISINTRAVAT WHEN 'N' THEN I.VATLEDGERDATE ELSE  IA.VATLEDGERDATE END AS VATLEDGERDATE FROM LIT_VATLEDGERDEF VD INNER JOIN LIT_VATLEDGERDEFRULE DR ON (DR.LIT_VATLEDGERDEF_ID = VD.LIT_VATLEDGERDEF_ID) INNER JOIN C_INVOICE I ON (I.PROCESSED='Y' AND DR.C_DOCTYPE_ID = I.C_DOCTYPE_ID AND I.DATEINVOICED BETWEEN ? and ?) INNER JOIN C_INVOICETAX IT ON (DR.C_TAX_ID = IT.C_TAX_ID AND I.C_INVOICE_ID = IT.C_INVOICE_ID) LEFT JOIN LIT_INVOICE_AUTO IA ON (IA.C_INVOICE_ID = I.C_INVOICE_ID) WHERE VD.LIT_VATLEDGERDEF_ID = ? ORDER BY I.DATEINVOICED";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            noInvoices = 0;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setTimestamp(1, this.m_td.getDateFrom());
                    pstmt.setTimestamp(2, this.m_td.getDateTo());
                    pstmt.setInt(3, this.p_LIT_VATLedgerDef_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        this.m_it = new MInvoiceTax(this.getCtx(), rs, null);
                        this.create(this.m_it, rs.getTimestamp("VATLEDGERDATE"), rs.getString("VATLEDGERNO"), this.m_vl.isSOTrx());
                        ++noInvoices;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block11;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return "@C_Invoice_ID@ #" + noInvoices + " (" + this.m_noLines + ", " + this.m_noAccts + ")";
    }

    private void create(MInvoiceTax invoiceTax, Timestamp VATLedgerDate, String VATLedgerNo, boolean isSOTrx) {
        block10: {
            if (this.m_iv == null || this.m_iv.getC_Invoice_ID() != invoiceTax.getC_Invoice_ID()) {
                this.m_iv = new MInvoice(this.getCtx(), invoiceTax.getC_Invoice_ID(), this.get_TrxName());
            }
            MTaxDeclarationLine tdl = new MTaxDeclarationLine(this.m_td, this.m_iv, invoiceTax);
            tdl.setLine((this.m_noLines + 1) * 10);
            tdl.setDescription(this.m_iv.getDescription());
            tdl.set_CustomColumn("VATLedgerDate", VATLedgerDate);
            tdl.set_CustomColumn("VATLedgerNo", VATLedgerNo);
            if (this.m_iv.isSOTrx() ^ isSOTrx) {
                tdl.setTaxBaseAmt(invoiceTax.getTaxBaseAmt().negate());
                tdl.setTaxAmt(invoiceTax.getTaxAmt().negate());
            }
            if (this.m_iv.isCreditMemo()) {
                tdl.setTaxBaseAmt(invoiceTax.getTaxBaseAmt().negate());
                tdl.setTaxAmt(invoiceTax.getTaxAmt().negate());
            }
            if (tdl.save()) {
                ++this.m_noLines;
            }
            String sql = "SELECT * FROM Fact_Acct WHERE AD_Table_ID=? AND Record_ID=? AND C_Tax_ID=? AND Line_ID is null";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, MInvoice.Table_ID);
                    pstmt.setInt(2, invoiceTax.getC_Invoice_ID());
                    pstmt.setInt(3, invoiceTax.getC_Tax_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MFactAcct fact = new MFactAcct(this.getCtx(), rs, null);
                        MTaxDeclarationAcct tda = new MTaxDeclarationAcct(this.m_td, fact);
                        tda.setLine((this.m_noAccts + 1) * 10);
                        if (!tda.save()) continue;
                        ++this.m_noAccts;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
    }
}

