/*
 * Decompiled with CFR 0.152.
 */
package it.nectosoft.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.logging.Level;
import org.compiere.model.MTaxDeclaration;
import org.compiere.model.MTaxDeclarationLine;
import org.compiere.model.X_LIT_VATLedgerDef;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class LIT_GenerateVATCorrespondings
extends SvrProcess {
    private int p_Record_ID = 0;
    private Timestamp p_DateInvoiced_From = null;
    private Timestamp p_DateInvoiced_To = null;
    private int p_C_BPartner_ID = 0;
    private int p_LIT_VATLedgerDef_ID = 0;
    private boolean p_DeleteOld = true;
    private Timestamp m_Date_From = null;
    private Timestamp m_Date_To = null;
    private MTaxDeclaration m_td = null;
    private X_LIT_VATLedgerDef m_vl = null;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_BPartner_ID")) {
                    this.p_C_BPartner_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("DateInvoiced")) {
                    this.p_DateInvoiced_From = (Timestamp)para[i].getParameter();
                    this.p_DateInvoiced_To = (Timestamp)para[i].getParameter_To();
                } else if (name.equals("LIT_VATLedgerDef_ID")) {
                    this.p_LIT_VATLedgerDef_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("DeleteOld")) {
                    this.p_DeleteOld = "Y".equals(para[i].getParameter());
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.p_Record_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        int noLines;
        block8: {
            this.m_vl = new X_LIT_VATLedgerDef(this.getCtx(), this.p_LIT_VATLedgerDef_ID, this.get_TrxName());
            this.getYearDates();
            if (this.m_Date_From == null || this.m_Date_To == null) {
                throw new AdempiereSystemError("No period defined for the supplyed dates");
            }
            this.getDeclaration();
            if (this.m_td == null) {
                throw new AdempiereSystemError("Cannot create TaxDeclaration, see log for errors");
            }
            String sql = "SELECT I.DATEINVOICED, I.C_CURRENCY_ID, IT.C_TAX_ID, MIN(I.DOCUMENTNO), MAX(I.DOCUMENTNO),SUM(CASE WHEN SUBSTR(DT.DOCBASETYPE,3,1) = 'C' THEN -IT.TAXBASEAMT ELSE IT.TAXBASEAMT END)AS TAXBASEAMT, SUM(CASE WHEN VD.ISSOTRX = I.ISSOTRX THEN  CASE WHEN SUBSTR(DT.DOCBASETYPE,3,1) = 'C' THEN -IT.TAXAMT  ELSE IT.TAXAMT END ELSE  CASE WHEN SUBSTR(DT.DOCBASETYPE,3,1) = 'C' THEN IT.TAXAMT  ELSE -IT.TAXAMT END  END)AS TAXAMT FROM LIT_VATLEDGERDEF VD INNER JOIN LIT_VATLEDGERDEFRULE DR ON (DR.LIT_VATLEDGERDEF_ID = VD.LIT_VATLEDGERDEF_ID) INNER JOIN C_INVOICE I ON (DR.C_DOCTYPE_ID = I.C_DOCTYPE_ID AND I.DOCSTATUS = 'CO' AND I.DATEINVOICED BETWEEN ? and ?) INNER JOIN C_DOCTYPE DT ON (DT.C_DOCTYPE_ID = I.C_DOCTYPE_ID) INNER JOIN C_INVOICETAX IT ON (DR.C_TAX_ID = IT.C_TAX_ID AND I.C_INVOICE_ID = IT.C_INVOICE_ID) WHERE VD.LIT_VATLEDGERDEF_ID = ? GROUP BY I.DATEINVOICED, I.C_CURRENCY_ID, IT.C_TAX_IDORDER BY I.DATEINVOICED, I.C_CURRENCY_ID, IT.C_TAX_ID";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            noLines = 0;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setTimestamp(1, this.p_DateInvoiced_From);
                    pstmt.setTimestamp(2, this.p_DateInvoiced_To);
                    pstmt.setInt(3, this.p_LIT_VATLedgerDef_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MTaxDeclarationLine tdl = new MTaxDeclarationLine(this.getCtx(), 0, this.get_TrxName());
                        tdl.setAD_Org_ID(this.m_td.getAD_Org_ID());
                        tdl.setC_TaxDeclaration_ID(this.m_td.getC_TaxDeclaration_ID());
                        tdl.setIsManual(true);
                        tdl.setC_BPartner_ID(this.p_C_BPartner_ID);
                        tdl.setDateAcct(rs.getTimestamp(1));
                        tdl.setC_Currency_ID(rs.getInt(2));
                        tdl.setC_Tax_ID(rs.getInt(3));
                        tdl.setDescription(String.format("Dalla fattura %s alla fattura %s", rs.getString(4), rs.getString(5)));
                        tdl.setTaxBaseAmt(rs.getBigDecimal(6));
                        tdl.setTaxAmt(rs.getBigDecimal(7));
                        tdl.save();
                        ++noLines;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return "@C_TaxDeclaration_ID@ #" + noLines;
    }

    private void getDeclaration() {
        block9: {
            String sql = "SELECT * FROM C_TaxDeclaration WHERE DATEFROM=? AND DATETO=? AND AD_CLIENT_ID = ? AND ISACTIVE='Y'";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, this.getAD_Client_ID());
                    pstmt.setTimestamp(2, this.p_DateInvoiced_From);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        this.m_td = new MTaxDeclaration(this.getCtx(), rs, this.get_TrxName());
                        if (this.p_DeleteOld) {
                            sql = "DELETE C_TaxDeclarationLine WHERE C_TaxDeclaration_ID=? AND DateAcct BETWEEN (? AND ?)";
                            int no = DB.executeUpdate(sql, new Object[]{this.m_td.get_ID(), this.m_Date_From, this.m_Date_To}, true, this.get_TrxName());
                            if (no != 0) {
                                this.log.config("Delete Line #" + no);
                            }
                        }
                    } else {
                        SimpleDateFormat date = new SimpleDateFormat("yyyy");
                        this.m_td = new MTaxDeclaration(this.getCtx(), 0, this.get_TrxName());
                        this.m_td.setName(String.valueOf(date.format(this.m_Date_To)) + this.m_vl.getName());
                        this.m_td.setDescription(String.valueOf(date.format(this.m_Date_To)) + this.m_vl.getName());
                        this.m_td.setDateTrx(this.m_Date_To);
                        this.m_td.setDateFrom(this.m_Date_From);
                        this.m_td.setDateTo(this.m_Date_To);
                        this.m_td.set_CustomColumn("LIT_VATLedgerDef_ID", this.p_LIT_VATLedgerDef_ID);
                        this.m_td.save();
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
    }

    private void getYearDates() {
        block6: {
            String sql = "SELECT min(StartDate),max(EndDate) FROM C_Period WHERE C_Year_ID IN (SELECT p.C_Year_ID FROM AD_ClientInfo c INNER JOIN C_Year y ON (c.C_Calendar_ID=y.C_Calendar_ID) INNER JOIN C_Period p ON (y.C_Year_ID=p.C_Year_ID) WHERE c.AD_Client_ID=?\tAND ? BETWEEN StartDate AND EndDate) AND IsActive='Y' AND PeriodType='S' GROUP BY c_year_id";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, this.getAD_Client_ID());
                    pstmt.setTimestamp(2, this.p_DateInvoiced_From);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        this.m_Date_From = rs.getTimestamp(1);
                        this.m_Date_To = rs.getTimestamp(2);
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
    }
}

