/*
 * Decompiled with CFR 0.152.
 */
package it.nectosoft.process;

import com.ancientprogramming.fixedformat4j.annotation.Align;
import com.ancientprogramming.fixedformat4j.annotation.Field;
import com.ancientprogramming.fixedformat4j.annotation.FixedFormatDecimal;
import com.ancientprogramming.fixedformat4j.annotation.FixedFormatPattern;
import com.ancientprogramming.fixedformat4j.annotation.Record;
import com.ancientprogramming.fixedformat4j.format.FixedFormatManager;
import com.ancientprogramming.fixedformat4j.format.impl.FixedFormatManagerImpl;
import it.nectosoft.process.LIT_CBI_FixedLengthFile;
import it.nectosoft.process.LIT_CBI_Generate_BON;
import java.io.File;
import java.io.FileWriter;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MBank;
import org.compiere.model.MBankAccount;
import org.compiere.model.MCountry;
import org.compiere.model.MCurrency;
import org.compiere.model.MLocation;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPayment;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class LIT_CBI_Generate_BON_Int
implements LIT_CBI_FixedLengthFile {
    private int noLines = 0;
    private int nPayment = 0;
    private FileWriter fw = null;
    private String m_sia = null;
    private int m_bankaccount_id = 0;
    private BigDecimal totale = Env.ZERO;
    private BigDecimal importo_cvs = Env.ZERO;
    private MOrg m_Org = null;
    private MOrgInfo m_OrgInfo = null;
    private MLocation m_OrgLoc = null;
    private MBPBankAccount m_ToBank = null;
    private MBankAccount m_FromBank = null;
    private Properties m_ctx = null;
    private static FixedFormatManager ffmanager = new FixedFormatManagerImpl();
    private static char[] eol = new char[]{'\r', '\n'};
    private CBI_BON_PE m_cbi_pe;
    private CBI_BON_EF m_cbi_ef;
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private static CLogger s_log = CLogger.getCLogger(LIT_CBI_Generate_BON.class);

    public LIT_CBI_Generate_BON_Int(Properties a_ctx) {
        this.m_ctx = a_ctx;
        this.m_Org = new MOrg(this.m_ctx, Env.getAD_Org_ID(this.m_ctx), null);
        this.m_OrgInfo = MOrgInfo.get(this.m_ctx, this.m_Org.getAD_Org_ID(), null);
        this.m_OrgLoc = new MLocation(this.m_ctx, this.m_OrgInfo.getC_Location_ID(), null);
    }

    @Override
    public int writeHeader(String a_file, String supportName, String Sia, int c_bankaccount_id, Timestamp a_datetrx) throws Exception {
        File file;
        block8: {
            file = null;
            try {
                file = new File(a_file);
                if (file.isDirectory()) {
                    this.log.log(Level.WARNING, String.valueOf(Msg.getMsg(this.m_ctx, "FileDir", true)) + file.getAbsolutePath());
                    throw new Exception(String.valueOf(Msg.getMsg(this.m_ctx, "FileDir", true)) + file.getAbsolutePath());
                }
                if (Sia != null && c_bankaccount_id != 0) break block8;
                return 0;
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, String.valueOf(Msg.getMsg(this.m_ctx, "FileCannotCreate", true)) + file.getAbsolutePath(), e);
                throw new Exception(String.valueOf(Msg.getMsg(this.m_ctx, "FileCannotCreate", true)) + file.getAbsolutePath());
            }
        }
        this.m_sia = Sia;
        this.m_bankaccount_id = c_bankaccount_id;
        if (file.exists()) {
            file.delete();
        }
        file.createNewFile();
        try {
            this.fw = new FileWriter(file);
            this.m_FromBank = new MBankAccount(this.m_ctx, this.m_bankaccount_id, null);
            this.m_cbi_pe = new CBI_BON_PE();
            this.noLines = 1;
            this.m_cbi_pe.setSIAMittente(this.m_sia);
            if (this.m_FromBank.getIBAN().startsWith("IT") || this.m_FromBank.getIBAN().startsWith("SM")) {
                this.m_cbi_pe.setABIRicevente(this.m_FromBank.getIBAN().substring(5, 10));
            }
            this.m_cbi_pe.setDataCreazione(a_datetrx);
            this.m_cbi_pe.setNomesupporto(supportName);
            this.fw.write(ffmanager.export(this.m_cbi_pe));
            this.fw.write(eol);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, Msg.getMsg(this.m_ctx, "FileWriteError", true), e);
            throw new Exception(Msg.getMsg(this.m_ctx, "FileWriteError", true));
        }
        return this.noLines;
    }

    @Override
    public int writeTail() {
        try {
            this.m_cbi_ef = new CBI_BON_EF();
            ++this.noLines;
            this.m_cbi_ef.setSIAMittente(this.m_cbi_pe.getSIAMittente());
            this.m_cbi_ef.setABIRicevente(this.m_cbi_pe.getABIRicevente());
            this.m_cbi_ef.setDataCreazione(this.m_cbi_pe.getDataCreazione());
            this.m_cbi_ef.setNomesupporto(this.m_cbi_pe.getNomesupporto());
            this.m_cbi_ef.setNumeroDisposizioni(this.nPayment);
            this.m_cbi_ef.setNumeroRecord(this.noLines);
            this.m_cbi_ef.setTotImporti(this.totale);
            this.fw.write(ffmanager.export(this.m_cbi_ef));
            this.fw.write(eol);
            this.fw.flush();
            this.fw.close();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", e);
        }
        return this.noLines;
    }

    @Override
    public int writePayment(MPayment a_payment) throws Exception {
        RifDoc rfd;
        if (a_payment.getC_BP_BankAccount_ID() == 0) {
            this.log.log(Level.SEVERE, Msg.getMsg(this.m_ctx, "BankBPAcc", true), a_payment);
            throw new Exception(String.valueOf(Msg.getMsg(this.m_ctx, "BankBPAcc", true)) + a_payment);
        }
        this.m_ToBank = new MBPBankAccount(this.m_ctx, a_payment.getC_BP_BankAccount_ID(), null);
        MBPartner bp = new MBPartner(this.m_ctx, a_payment.getC_BPartner_ID(), null);
        MBPartnerLocation[] bpls = bp.getLocations(false);
        MLocation bpl = null;
        String bpIban = this.m_ToBank.get_ValueAsString("IBAN");
        if (bpIban.length() < 5) {
            this.log.log(Level.SEVERE, Msg.getMsg(this.m_ctx, "BankBPIban", true), a_payment);
            throw new Exception(String.valueOf(Msg.getMsg(this.m_ctx, "BankBPIban", true)) + a_payment);
        }
        if (bpls.length == 1) {
            bpl = new MLocation(this.m_ctx, bpls[0].getC_Location_ID(), null);
        } else {
            MBPartnerLocation abpl;
            MBPartnerLocation[] mBPartnerLocationArray = bpls;
            if (bpls.length != 0 && (abpl = mBPartnerLocationArray[0]).isRemitTo()) {
                bpl = new MLocation(this.m_ctx, abpl.getC_Location_ID(), null);
            }
        }
        if (bpl == null) {
            this.log.log(Level.SEVERE, Msg.getMsg(this.m_ctx, "BankBPRemit", true), bp);
            throw new Exception(String.valueOf(Msg.getMsg(this.m_ctx, "BankBPRemit", true)) + bp);
        }
        ArrayList<RifDoc> rif = new ArrayList<RifDoc>();
        String sql = "SELECT I.DOCUMENTNO,BP.NAME FROM C_INVOICE I INNER JOIN C_ALLOCATIONLINE AL ON (AL.C_INVOICE_ID = I.C_INVOICE_ID)INNER JOIN C_BPARTNER BP ON (BP.C_BPARTNER_ID = I.C_BPARTNER_ID)WHERE AL.C_PAYMENT_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, a_payment.getC_Payment_ID());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    rfd = new RifDoc();
                    rfd.setNumeroDocumento(rs.getString(1));
                    rfd.setBpName(rs.getString(2));
                    rif.add(rfd);
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql, e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (rif.size() == 0) {
            rfd = new RifDoc();
            rfd.setNumeroDocumento(String.format("Pagamento n. %1$s", a_payment.getDocumentNo()));
            rfd.setBpName(bp.getName());
            rif.add(rfd);
        }
        CBI_BON_H1 m_cbi_h1 = new CBI_BON_H1();
        ++this.nPayment;
        ++this.noLines;
        m_cbi_h1.setRiferimento(LIT_CBI_Generate_BON_Int.ffmanager.export((RifDoc)rif.get(0)));
        m_cbi_h1.setNumeroProgressivo(this.nPayment);
        m_cbi_h1.setDataCreazione(this.m_cbi_pe.getDataCreazione());
        m_cbi_h1.setDataEsecuzione(this.m_cbi_pe.getDataCreazione());
        m_cbi_h1.setDataValuta(this.m_cbi_pe.getDataCreazione());
        try {
            this.fw.write(ffmanager.export(m_cbi_h1));
            this.fw.write(eol);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, Msg.getMsg(this.m_ctx, "FileWriteError", true), e);
            throw new Exception(Msg.getMsg(this.m_ctx, "FileWriteError", true));
        }
        MCurrency CurrencyFrom = new MCurrency(this.m_ctx, this.m_FromBank.getC_Currency_ID(), null);
        MCurrency CurrencyTo = new MCurrency(this.m_ctx, a_payment.getC_Currency_ID(), null);
        MBank OwnBank = this.m_FromBank.getBank();
        MBank TheyrBank = this.m_ToBank.getBank();
        ++this.noLines;
        CBI_BON_P1 m_cbi_p1 = new CBI_BON_P1();
        m_cbi_p1.setNumeroProgressivo(this.nPayment);
        m_cbi_p1.setImporto(a_payment.getPayAmt());
        this.importo_cvs = a_payment.getPayAmt();
        this.totale = this.totale.add(a_payment.getPayAmt());
        m_cbi_p1.setDivisaAddebitoISO(CurrencyFrom.getISO_Code());
        m_cbi_p1.setDivisaAccreditoISO(CurrencyTo.getISO_Code());
        try {
            this.fw.write(ffmanager.export(m_cbi_p1));
            this.fw.write(eol);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, Msg.getMsg(this.m_ctx, "FileWriteError", true), e);
            throw new Exception(Msg.getMsg(this.m_ctx, "FileWriteError", true));
        }
        if (this.m_FromBank.getIBAN() != null) {
            ++this.noLines;
            CBI_BON_PH m_cbi_ph = new CBI_BON_PH();
            m_cbi_ph.setNumeroProgressivo(this.nPayment);
            m_cbi_ph.setIBANordinante(this.m_FromBank.getIBAN());
            m_cbi_ph.setSwiftordinante(OwnBank.getSwiftCode());
            m_cbi_ph.setIBANbeneficiario(bpIban);
            m_cbi_ph.setSwiftbeneficiario(TheyrBank.getSwiftCode());
            try {
                this.fw.write(ffmanager.export(m_cbi_ph));
                this.fw.write(eol);
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, Msg.getMsg(this.m_ctx, "FileWriteError", true), e);
                throw new Exception(Msg.getMsg(this.m_ctx, "FileWriteError", true));
            }
        }
        ++this.noLines;
        CBI_BON_P5 m_cbi_p5 = new CBI_BON_P5();
        m_cbi_p5.setNumeroProgressivo(this.nPayment);
        m_cbi_p5.setNomeOrdinante(this.m_Org.getName());
        m_cbi_p5.setIndirizzo(this.m_OrgLoc.getAddress1());
        m_cbi_p5.setLocalita(this.m_OrgLoc.getCity());
        try {
            this.fw.write(ffmanager.export(m_cbi_p5));
            this.fw.write(eol);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, Msg.getMsg(this.m_ctx, "FileWriteError", true), e);
            throw new Exception(Msg.getMsg(this.m_ctx, "FileWriteError", true));
        }
        ++this.noLines;
        CBI_BON_P9 m_cbi_p9 = new CBI_BON_P9();
        m_cbi_p9.setNumeroProgressivo(this.nPayment);
        MBPartnerLocation bplocation = new MBPartnerLocation(bp);
        MLocation localita = new MLocation(this.m_ctx, bplocation.getC_BPartner_Location_ID(), null);
        MCountry bpcountry = new MCountry(this.m_ctx, localita.getC_Country_ID(), null);
        MCurrency bpcurrency = new MCurrency(this.m_ctx, bpcountry.getC_Currency_ID(), null);
        m_cbi_p9.setUICCurrencyCode(bpcurrency.get_Value("UICCurrencyCode").toString());
        m_cbi_p9.setUICCountryCode(bpcountry.get_Value("UICCountryCode").toString());
        try {
            this.fw.write(ffmanager.export(m_cbi_p9));
            this.fw.write(eol);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, Msg.getMsg(this.m_ctx, "FileWriteError", true), e);
            throw new Exception(Msg.getMsg(this.m_ctx, "FileWriteError", true));
        }
        return this.noLines;
    }

    @Record(length=120, paddingChar=32)
    public class CBI_BON_EF {
        private String mittente;
        private String abiricevente;
        private Date datacreazione;
        private String nomesupporto;
        private String campolibero;
        private int numerodisposizioni;
        private BigDecimal totimporti;
        private int numerorecord;

        @Field(offset=2, length=2)
        public String getTipoRecord() {
            return "EF";
        }

        void setSIAMittente(String SIA_Mittente) {
            this.mittente = SIA_Mittente;
        }

        @Field(offset=4, length=5)
        public String getSIAMittente() {
            return this.mittente;
        }

        void setABIRicevente(String ABI_Ricevente) {
            this.abiricevente = ABI_Ricevente;
        }

        @Field(offset=9, length=5)
        public String getABIRicevente() {
            return this.abiricevente;
        }

        void setDataCreazione(Date dataCreazione) {
            this.datacreazione = dataCreazione;
        }

        @Field(offset=14, length=6)
        @FixedFormatPattern(value="ddMMyy")
        public Date getDataCreazione() {
            return this.datacreazione;
        }

        void setNomesupporto(String nomeSupporto) {
            this.nomesupporto = nomeSupporto;
        }

        @Field(offset=20, length=20)
        public String getNomesupporto() {
            return this.nomesupporto;
        }

        void setCampoLibero(String campoLibero) {
            this.campolibero = campoLibero;
        }

        @Field(offset=40, length=6)
        public String getCampoLibero() {
            return this.campolibero;
        }

        void setNumeroDisposizioni(int numeroDisposizioni) {
            this.numerodisposizioni = numeroDisposizioni;
        }

        @Field(offset=46, length=7, align=Align.RIGHT, paddingChar=48)
        public int getNumeroDisposizioni() {
            return this.numerodisposizioni;
        }

        private void setTotImporti(BigDecimal totImporti) {
            this.totimporti = totImporti;
        }

        @Field(offset=65, length=18, align=Align.RIGHT, paddingChar=48)
        @FixedFormatDecimal(decimals=2, useDecimalDelimiter=true, decimalDelimiter=44)
        public BigDecimal getTotImporti() {
            return this.totimporti;
        }

        private void setNumeroRecord(int numeroRecord) {
            this.numerorecord = numeroRecord;
        }

        @Field(offset=83, length=7, align=Align.RIGHT, paddingChar=48)
        public int getNumeroRecord() {
            return this.numerorecord;
        }
    }

    @Record(length=120, paddingChar=32)
    public class CBI_BON_H1 {
        private int numeroprogressivo;
        private Date dataesecuzione;
        private Date datavaluta;
        private Date datacreazione;
        private String riferimento;

        @Field(offset=2, length=2)
        public String getTipoRecord() {
            return "H1";
        }

        private void setNumeroProgressivo(int numeroprogressivo) {
            this.numeroprogressivo = numeroprogressivo;
        }

        @Field(offset=4, length=7, align=Align.RIGHT, paddingChar=48)
        public int getNumeroProgressivo() {
            return this.numeroprogressivo;
        }

        @Field(offset=11, length=14, align=Align.RIGHT, paddingChar=32)
        public String getMessageIdentifier() {
            return "PAYORDD93AUN";
        }

        @Field(offset=25, length=3)
        public String getNameMessage() {
            return "450";
        }

        private void setRiferimento(String riferimento) {
            this.riferimento = riferimento;
        }

        @Field(offset=28, length=34)
        public String getRiferimento() {
            return this.riferimento;
        }

        @Field(offset=63, length=1)
        public String getNameMessage2() {
            return "9 ";
        }

        @Field(offset=65, length=3)
        public String getDateQualifier() {
            return "137";
        }

        void setDataCreazione(Date datacreazione) {
            this.datacreazione = datacreazione;
        }

        @Field(offset=68, length=8)
        @FixedFormatPattern(value="yyyyMMdd")
        public Date getDataCreazione() {
            return this.datacreazione;
        }

        @Field(offset=76, length=3)
        public String getFormatoData() {
            return "102";
        }

        @Field(offset=65, length=3)
        public String getQualificatoreDataEsecuzione() {
            return "203";
        }

        private void setDataEsecuzione(Date dataesecuzione) {
            this.dataesecuzione = dataesecuzione;
        }

        @Field(offset=82, length=8)
        @FixedFormatPattern(value="yyyyMMdd")
        public Date getDataEsecuzione() {
            return this.dataesecuzione;
        }

        @Field(offset=90, length=3)
        public String getFormatoDataEsecuzione() {
            return "102";
        }

        @Field(offset=93, length=3)
        public String getQualificatoreDataValuta() {
            return "140";
        }

        private void setDataValuta(Date datavaluta) {
            this.datavaluta = datavaluta;
        }

        @Field(offset=96, length=8)
        @FixedFormatPattern(value="yyyyMMdd")
        public Date getDataValuta() {
            return this.datavaluta;
        }

        @Field(offset=104, length=3)
        public String getFormatoDataValuta() {
            return "102";
        }

        @Field(offset=107, length=2)
        public String getTipoTransazione() {
            return "IN";
        }
    }

    @Record(length=120, paddingChar=32)
    public class CBI_BON_P1 {
        private int numeroprogressivo;
        private String divisa;
        private String divisa2;
        private BigDecimal importo;

        @Field(offset=2, length=2)
        public String getTipoRecord() {
            return "P1";
        }

        private void setNumeroProgressivo(int numeroprogressivo) {
            this.numeroprogressivo = numeroprogressivo;
        }

        @Field(offset=4, length=7, align=Align.RIGHT, paddingChar=48)
        public int getNumeroProgressivo() {
            return this.numeroprogressivo;
        }

        @Field(offset=11, length=3)
        public String getRelazioneDivisa() {
            return "9  ";
        }

        private void setImporto(BigDecimal importo) {
            this.importo = importo;
        }

        @Field(offset=14, length=18, align=Align.RIGHT, paddingChar=48)
        @FixedFormatDecimal(decimals=2, useDecimalDelimiter=true, decimalDelimiter=44)
        public BigDecimal getImporto() {
            return this.importo;
        }

        private void setDivisaAddebitoISO(String divisa) {
            this.divisa = divisa;
        }

        @Field(offset=32, length=3)
        public String getDivisaAddebitoISO() {
            return this.divisa;
        }

        @Field(offset=35, length=2)
        public String getCampoGenerico() {
            return "2 ";
        }

        private void setDivisaAccreditoISO(String divisa2) {
            this.divisa2 = divisa2;
        }

        @Field(offset=38, length=3)
        public String getDivisaAccreditoISO() {
            return this.divisa2;
        }
    }

    @Record(length=120, paddingChar=32)
    public class CBI_BON_P5 {
        private int numeroprogressivo;
        private String nomeordinante;
        private String indirizzo;
        private String localita;

        @Field(offset=2, length=2)
        public String getTipoRecord() {
            return "P5";
        }

        private void setNumeroProgressivo(int numeroprogressivo) {
            this.numeroprogressivo = numeroprogressivo;
        }

        @Field(offset=4, length=7, align=Align.RIGHT, paddingChar=48)
        public int getNumeroProgressivo() {
            return this.numeroprogressivo;
        }

        @Field(offset=2, length=2)
        public String getCodiceGenerico() {
            return "BE";
        }

        private void setNomeOrdinante(String nomeOrdinante) {
            this.nomeordinante = nomeOrdinante;
        }

        @Field(offset=14, length=35)
        public String getNomeOrdinante() {
            return this.nomeordinante;
        }

        private void setIndirizzo(String indirizzo) {
            this.indirizzo = indirizzo;
        }

        @Field(offset=49, length=35)
        public String getIndirizzo() {
            return this.indirizzo;
        }

        private void setLocalita(String localita) {
            this.localita = localita;
        }

        @Field(offset=84, length=32)
        public String getLocalita() {
            return this.localita;
        }
    }

    @Record(length=120, paddingChar=32)
    public class CBI_BON_P9 {
        private int numeroprogressivo;
        private String uiccountrycode;
        private String uiccurrencycode;

        @Field(offset=2, length=2)
        public String getTipoRecord() {
            return "P9";
        }

        private void setNumeroProgressivo(int numeroprogressivo) {
            this.numeroprogressivo = numeroprogressivo;
        }

        @Field(offset=4, length=7, align=Align.RIGHT, paddingChar=48)
        public int getNumeroProgressivo() {
            return this.numeroprogressivo;
        }

        @Field(offset=11, length=2)
        public String getCodiceGenerico1() {
            return "ZZ";
        }

        @Field(offset=14, length=2)
        public String getCodiceGenerico3() {
            return "RA";
        }

        @Field(offset=17, length=2)
        public String getTipocvs() {
            return "INF";
        }

        private void setUICCurrencyCode(String uiccurrencycode) {
            this.uiccurrencycode = uiccurrencycode;
        }

        @Field(offset=60, length=5)
        public String getUICCurrencyCode() {
            return this.uiccurrencycode;
        }

        private void setUICCountryCode(String uiccountrycode) {
            this.uiccountrycode = uiccountrycode;
        }

        @Field(offset=103, length=3)
        public String getUICCountryCode() {
            return this.uiccountrycode;
        }
    }

    @Record(length=120, paddingChar=32)
    public class CBI_BON_PE {
        private String mittente;
        private String abiricevente;
        private Date datacreazione;
        private String nomesupporto;
        private String campolibero;

        @Field(offset=2, length=2)
        public String getTipoRecord() {
            return "PE";
        }

        void setSIAMittente(String SIA_Mittente) {
            this.mittente = SIA_Mittente;
        }

        @Field(offset=4, length=5)
        public String getSIAMittente() {
            return this.mittente;
        }

        void setABIRicevente(String ABI_Ricevente) {
            this.abiricevente = ABI_Ricevente;
        }

        @Field(offset=9, length=5)
        public String getABIRicevente() {
            return this.abiricevente;
        }

        void setDataCreazione(Date dataCreazione) {
            this.datacreazione = dataCreazione;
        }

        @Field(offset=14, length=6)
        @FixedFormatPattern(value="yyyyMMdd")
        public Date getDataCreazione() {
            return this.datacreazione;
        }

        void setNomesupporto(String nomeSupporto) {
            this.nomesupporto = nomeSupporto;
        }

        @Field(offset=20, length=20)
        public String getNomesupporto() {
            return this.nomesupporto;
        }

        void setCampoLibero(String campoLibero) {
            this.campolibero = campoLibero;
        }

        @Field(offset=40, length=6)
        public String getCampoLibero() {
            return this.campolibero;
        }
    }

    @Record(length=120, paddingChar=32)
    public class CBI_BON_PH {
        private int numeroprogressivo;
        private String IBANbeneficiario;
        private String IBANordinante;
        private String swiftordinante;
        private String swiftbeneficiario;

        @Field(offset=2, length=2)
        public String getTipoRecord() {
            return "PH";
        }

        private void setNumeroProgressivo(int numeroprogressivo) {
            this.numeroprogressivo = numeroprogressivo;
        }

        @Field(offset=4, length=7, align=Align.RIGHT, paddingChar=48)
        public int getNumeroProgressivo() {
            return this.numeroprogressivo;
        }

        private void setIBANordinante(String IBAN_Ordinante) {
            this.IBANordinante = IBAN_Ordinante;
        }

        @Field(offset=11, length=27)
        public String getIBANordinante() {
            return this.IBANordinante;
        }

        private void setSwiftordinante(String swiftordinante) {
            this.swiftordinante = swiftordinante;
        }

        @Field(offset=45, length=11)
        public String getSwiftordinante() {
            return this.swiftordinante;
        }

        private void setIBANbeneficiario(String IBAN_Beneficiario) {
            this.IBANbeneficiario = IBAN_Beneficiario;
        }

        @Field(offset=61, length=27)
        public String getIBANbeneficiario() {
            return this.IBANbeneficiario;
        }

        private void setSwiftbeneficiario(String swiftbeneficiario) {
            this.swiftbeneficiario = swiftbeneficiario;
        }

        @Field(offset=95, length=11)
        public String getSwiftbeneficiario() {
            return this.swiftbeneficiario;
        }
    }

    @Record(length=34, paddingChar=32)
    public class RifDoc {
        private String numerodocumento;
        private String bpname;

        private void setNumeroDocumento(String numeroDocumento) {
            this.numerodocumento = numeroDocumento;
        }

        @Field(offset=1, length=10)
        public String getNumeroDocumento() {
            return this.numerodocumento;
        }

        private void setBpName(String bpname) {
            this.bpname = bpname;
        }

        @Field(offset=20, length=24)
        public String getBpName() {
            return this.bpname;
        }
    }
}

