/*
 * Decompiled with CFR 0.152.
 */
package it.nectosoft.process;

import com.ancientprogramming.fixedformat4j.annotation.Align;
import com.ancientprogramming.fixedformat4j.annotation.Field;
import com.ancientprogramming.fixedformat4j.annotation.FixedFormatDecimal;
import com.ancientprogramming.fixedformat4j.annotation.FixedFormatPattern;
import com.ancientprogramming.fixedformat4j.annotation.Record;
import com.ancientprogramming.fixedformat4j.format.FixedFormatManager;
import com.ancientprogramming.fixedformat4j.format.impl.FixedFormatManagerImpl;
import it.nectosoft.process.LIT_CBI_FixedLengthFile;
import java.io.File;
import java.io.FileWriter;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MBPartner;
import org.compiere.model.MBankAccount;
import org.compiere.model.MLocation;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPayment;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class LIT_CBI_Generate_BON
implements LIT_CBI_FixedLengthFile {
    private int noLines = 0;
    private int nPayment = 0;
    private FileWriter fw = null;
    private String m_sia = null;
    private int m_bankaccount_id = 0;
    private BigDecimal totale = Env.ZERO;
    private MOrg m_Org = null;
    private MOrgInfo m_OrgInfo = null;
    private MLocation m_OrgLoc = null;
    private MBPBankAccount m_ToBank = null;
    private MBankAccount m_FromBank = null;
    private Properties m_ctx = null;
    private static FixedFormatManager ffmanager = new FixedFormatManagerImpl();
    private static char[] eol = new char[]{'\r', '\n'};
    private CBI_BON_PC m_cbi_pc;
    private CBI_BON_EF m_cbi_ef;
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private static CLogger s_log = CLogger.getCLogger(LIT_CBI_Generate_BON.class);

    public LIT_CBI_Generate_BON(Properties a_ctx) {
        this.m_ctx = a_ctx;
        this.m_Org = new MOrg(this.m_ctx, Env.getAD_Org_ID(this.m_ctx), null);
        this.m_OrgInfo = MOrgInfo.get(this.m_ctx, this.m_Org.getAD_Org_ID(), null);
        this.m_OrgLoc = new MLocation(this.m_ctx, this.m_OrgInfo.getC_Location_ID(), null);
    }

    @Override
    public int writeHeader(String a_file, String supportName, String Sia, int c_bankaccount_id, Timestamp a_datetrx) throws Exception {
        File file;
        block8: {
            file = null;
            try {
                file = new File(a_file);
                if (file.isDirectory()) {
                    this.log.log(Level.WARNING, String.valueOf(Msg.getMsg(this.m_ctx, "FileDir", true)) + file.getAbsolutePath());
                    throw new Exception(String.valueOf(Msg.getMsg(this.m_ctx, "FileDir", true)) + file.getAbsolutePath());
                }
                if (Sia != null && c_bankaccount_id != 0) break block8;
                return 0;
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, String.valueOf(Msg.getMsg(this.m_ctx, "FileCannotCreate", true)) + file.getAbsolutePath(), e);
                throw new Exception(String.valueOf(Msg.getMsg(this.m_ctx, "FileCannotCreate", true)) + file.getAbsolutePath());
            }
        }
        this.m_sia = Sia;
        this.m_bankaccount_id = c_bankaccount_id;
        if (file.exists()) {
            file.delete();
        }
        file.createNewFile();
        try {
            this.fw = new FileWriter(file);
            this.m_FromBank = new MBankAccount(this.m_ctx, this.m_bankaccount_id, null);
            this.m_cbi_pc = new CBI_BON_PC();
            this.noLines = 1;
            this.m_cbi_pc.setSIAMittente(this.m_sia);
            if (this.m_FromBank.getIBAN().startsWith("IT") || this.m_FromBank.getIBAN().startsWith("SM")) {
                this.m_cbi_pc.setABIRicevente(this.m_FromBank.getIBAN().substring(5, 10));
            }
            this.m_cbi_pc.setDataCreazione(a_datetrx);
            this.m_cbi_pc.setNomesupporto(supportName);
            this.fw.write(ffmanager.export(this.m_cbi_pc));
            this.fw.write(eol);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, Msg.getMsg(this.m_ctx, "FileWriteError", true), e);
            throw new Exception(Msg.getMsg(this.m_ctx, "FileWriteError", true));
        }
        return this.noLines;
    }

    @Override
    public int writeTail() {
        try {
            this.m_cbi_ef = new CBI_BON_EF();
            ++this.noLines;
            this.m_cbi_ef.setSIAMittente(this.m_cbi_pc.getSIAMittente());
            this.m_cbi_ef.setABIRicevente(this.m_cbi_pc.getABIRicevente());
            this.m_cbi_ef.setDataCreazione(this.m_cbi_pc.getDataCreazione());
            this.m_cbi_ef.setNomesupporto(this.m_cbi_pc.getNomesupporto());
            this.m_cbi_ef.setNumeroDisposizioni(this.nPayment);
            this.m_cbi_ef.setNumeroRecord(this.noLines);
            this.m_cbi_ef.setTotImporti(this.totale);
            this.fw.write(ffmanager.export(this.m_cbi_ef));
            this.fw.write(eol);
            this.fw.flush();
            this.fw.close();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", e);
        }
        return this.noLines;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int writePayment(MPayment a_payment) throws Exception {
        if (a_payment.getC_BP_BankAccount_ID() == 0) {
            this.log.log(Level.SEVERE, Msg.getMsg(this.m_ctx, "BankBPAcc", true), a_payment);
            throw new Exception(String.valueOf(Msg.getMsg(this.m_ctx, "BankBPAcc", true)) + a_payment);
        }
        this.m_ToBank = new MBPBankAccount(this.m_ctx, a_payment.getC_BP_BankAccount_ID(), null);
        bp = new MBPartner(this.m_ctx, a_payment.getC_BPartner_ID(), null);
        bpls = bp.getLocations(false);
        bpl = null;
        bpIban = this.m_ToBank.get_ValueAsString("IBAN");
        if (bpIban.length() < 5) {
            this.log.log(Level.SEVERE, Msg.getMsg(this.m_ctx, "BankBPIban", true), a_payment);
            throw new Exception(String.valueOf(Msg.getMsg(this.m_ctx, "BankBPIban", true)) + a_payment);
        }
        if (bpls.length == 1) {
            bpl = new MLocation(this.m_ctx, bpls[0].getC_Location_ID(), null);
        } else {
            var7_6 = bpls;
            if (bpls.length != 0 && (abpl = var7_6[0]).isRemitTo()) {
                bpl = new MLocation(this.m_ctx, abpl.getC_Location_ID(), null);
            }
        }
        if (bpl == null) {
            this.log.log(Level.SEVERE, Msg.getMsg(this.m_ctx, "BankBPRemit", true), bp);
            throw new Exception(String.valueOf(Msg.getMsg(this.m_ctx, "BankBPRemit", true)) + bp);
        }
        m_cbi_10 = new CBI_BON_10();
        ++this.nPayment;
        ++this.noLines;
        CBI_BON_10.access$0(m_cbi_10, this.nPayment);
        CBI_BON_10.access$1(m_cbi_10, this.m_cbi_pc.getDataCreazione());
        CBI_BON_10.access$2(m_cbi_10, this.m_cbi_pc.getDataCreazione());
        CBI_BON_10.access$3(m_cbi_10, "48000");
        CBI_BON_10.access$4(m_cbi_10, a_payment.getPayAmt());
        this.totale = this.totale.add(a_payment.getPayAmt());
        CBI_BON_10.access$5(m_cbi_10, this.m_FromBank.getIBAN().substring(5));
        CBI_BON_10.access$6(m_cbi_10, bpIban.substring(5));
        CBI_BON_10.access$7(m_cbi_10, "3");
        CBI_BON_10.access$8(m_cbi_10, bp.getTaxID());
        CBI_BON_10.access$9(m_cbi_10, "1");
        try {
            this.fw.write(LIT_CBI_Generate_BON.ffmanager.export(m_cbi_10));
            this.fw.write(LIT_CBI_Generate_BON.eol);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, Msg.getMsg(this.m_ctx, "FileWriteError", true), e);
            throw new Exception(Msg.getMsg(this.m_ctx, "FileWriteError", true));
        }
        if (this.m_FromBank.getIBAN() != null) {
            ++this.noLines;
            m_cbi_16 = new CBI_BON_16();
            CBI_BON_16.access$0(m_cbi_16, this.nPayment);
            CBI_BON_16.access$1(m_cbi_16, this.m_FromBank.getIBAN());
            try {
                this.fw.write(LIT_CBI_Generate_BON.ffmanager.export(m_cbi_16));
                this.fw.write(LIT_CBI_Generate_BON.eol);
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, Msg.getMsg(this.m_ctx, "FileWriteError", true), e);
                throw new Exception(Msg.getMsg(this.m_ctx, "FileWriteError", true));
            }
        }
        ++this.noLines;
        m_cbi_17 = new CBI_BON_17();
        CBI_BON_17.access$0(m_cbi_17, this.nPayment);
        CBI_BON_17.access$1(m_cbi_17, bpIban);
        try {
            this.fw.write(LIT_CBI_Generate_BON.ffmanager.export(m_cbi_17));
            this.fw.write(LIT_CBI_Generate_BON.eol);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, Msg.getMsg(this.m_ctx, "FileWriteError", true), e);
            throw new Exception(Msg.getMsg(this.m_ctx, "FileWriteError", true));
        }
        ++this.noLines;
        m_cbi_20 = new CBI_BON_20();
        CBI_BON_20.access$0(m_cbi_20, this.nPayment);
        CBI_BON_20.access$1(m_cbi_20, this.m_Org.getName());
        CBI_BON_20.access$2(m_cbi_20, this.m_OrgLoc.getAddress1());
        CBI_BON_20.access$3(m_cbi_20, this.m_OrgLoc.getCity());
        CBI_BON_20.access$4(m_cbi_20, this.m_OrgInfo.getTaxID());
        try {
            this.fw.write(LIT_CBI_Generate_BON.ffmanager.export(m_cbi_20));
            this.fw.write(LIT_CBI_Generate_BON.eol);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, Msg.getMsg(this.m_ctx, "FileWriteError", true), e);
            throw new Exception(Msg.getMsg(this.m_ctx, "FileWriteError", true));
        }
        ++this.noLines;
        m_cbi_30 = new CBI_BON_30();
        CBI_BON_30.access$0(m_cbi_30, this.nPayment);
        CBI_BON_30.access$1(m_cbi_30, bp.getName());
        CBI_BON_30.access$2(m_cbi_30, bp.getTaxID());
        try {
            this.fw.write(LIT_CBI_Generate_BON.ffmanager.export(m_cbi_30));
            this.fw.write(LIT_CBI_Generate_BON.eol);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, Msg.getMsg(this.m_ctx, "FileWriteError", true), e);
            throw new Exception(Msg.getMsg(this.m_ctx, "FileWriteError", true));
        }
        ++this.noLines;
        m_cbi_40 = new CBI_BON_40();
        CBI_BON_40.access$0(m_cbi_40, this.nPayment);
        CBI_BON_40.access$1(m_cbi_40, bpl.getAddress1());
        CBI_BON_40.access$2(m_cbi_40, bpl.getCity());
        CBI_BON_40.access$3(m_cbi_40, bpl.getPostal());
        try {
            this.fw.write(LIT_CBI_Generate_BON.ffmanager.export(m_cbi_40));
            this.fw.write(LIT_CBI_Generate_BON.eol);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, Msg.getMsg(this.m_ctx, "FileWriteError", true), e);
            throw new Exception(Msg.getMsg(this.m_ctx, "FileWriteError", true));
        }
        rif = new ArrayList<RifDoc>();
        if (a_payment.isPrepayment() && !a_payment.isAllocated()) {
            sql = "SELECT DOCUMENTNO,DATEORDERED FROM C_ORDER WHERE C_ORDER_ID=?";
            pstmt = null;
            rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, a_payment.getC_Order_ID());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        rfd = new RifDoc();
                        RifDoc.access$0(rfd, String.format("Anticipo Ordine %1$s", new Object[]{rs.getString(1)}));
                        RifDoc.access$1(rfd, rs.getTimestamp(2));
                        rif.add(rfd);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, Msg.getMsg(this.m_ctx, "FileWriteError", true), e);
                    throw new Exception(Msg.getMsg(this.m_ctx, "FileWriteError", true));
                }
            }
            catch (Throwable var16_27) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw var16_27;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        } else {
            sql = "SELECT I.DOCUMENTNO,I.DATEINVOICED FROM C_INVOICE I INNER JOIN C_ALLOCATIONLINE AL ON (AL.C_INVOICE_ID = I.C_INVOICE_ID)WHERE AL.C_PAYMENT_ID=?";
            pstmt = null;
            rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, a_payment.getC_Payment_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        rfd = new RifDoc();
                        RifDoc.access$0(rfd, rs.getString(1));
                        RifDoc.access$1(rfd, rs.getTimestamp(2));
                        rif.add(rfd);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    throw e;
                }
            }
            catch (Throwable var16_28) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw var16_28;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (rif.size() == 0) {
            rfd = new RifDoc();
            RifDoc.access$0(rfd, String.format("Pagamento n. %1$s", new Object[]{a_payment.getDocumentNo()}));
            RifDoc.access$1(rfd, a_payment.getDateTrx());
            rif.add(rfd);
        }
        if (rif.size() > 3) ** GOTO lbl207
        ++this.noLines;
        m_cbi_5060 = new CBI_BON_5060();
        CBI_BON_5060.access$0(m_cbi_5060, "50");
        CBI_BON_5060.access$1(m_cbi_5060, this.nPayment);
        CBI_BON_5060.access$2(m_cbi_5060, LIT_CBI_Generate_BON.ffmanager.export((RifDoc)rif.get(0)));
        if (rif.size() > 1) {
            CBI_BON_5060.access$3(m_cbi_5060, LIT_CBI_Generate_BON.ffmanager.export((RifDoc)rif.get(1)));
        }
        if (rif.size() > 2) {
            CBI_BON_5060.access$4(m_cbi_5060, LIT_CBI_Generate_BON.ffmanager.export((RifDoc)rif.get(2)));
        }
        try {
            this.fw.write(LIT_CBI_Generate_BON.ffmanager.export(m_cbi_5060));
            this.fw.write(LIT_CBI_Generate_BON.eol);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, Msg.getMsg(this.m_ctx, "FileWriteError", true), e);
            throw new Exception(Msg.getMsg(this.m_ctx, "FileWriteError", true));
        }
lbl-1000:
        // 1 sources

        {
            ++this.noLines;
            m_cbi_5060 = new CBI_BON_5060();
            CBI_BON_5060.access$0(m_cbi_5060, "60");
            CBI_BON_5060.access$1(m_cbi_5060, this.nPayment);
            CBI_BON_5060.access$2(m_cbi_5060, LIT_CBI_Generate_BON.ffmanager.export((RifDoc)rif.get(0)));
            rif.remove(0);
            if (rif.size() > 0) {
                CBI_BON_5060.access$3(m_cbi_5060, LIT_CBI_Generate_BON.ffmanager.export((RifDoc)rif.get(0)));
                rif.remove(0);
            }
            if (rif.size() > 0) {
                CBI_BON_5060.access$4(m_cbi_5060, LIT_CBI_Generate_BON.ffmanager.export((RifDoc)rif.get(0)));
                rif.remove(0);
            }
            try {
                this.fw.write(LIT_CBI_Generate_BON.ffmanager.export(m_cbi_5060));
                this.fw.write(LIT_CBI_Generate_BON.eol);
                continue;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, Msg.getMsg(this.m_ctx, "FileWriteError", true), e);
                throw new Exception(Msg.getMsg(this.m_ctx, "FileWriteError", true));
            }
lbl207:
            // 2 sources

            ** while (rif.size() > 0)
        }
lbl208:
        // 2 sources

        rif.clear();
        ++this.noLines;
        m_cbi_70 = new CBI_BON_70();
        CBI_BON_70.access$0(m_cbi_70, this.nPayment);
        try {
            this.fw.write(LIT_CBI_Generate_BON.ffmanager.export(m_cbi_70));
            this.fw.write(LIT_CBI_Generate_BON.eol);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, Msg.getMsg(this.m_ctx, "FileWriteError", true), e);
            throw new Exception(Msg.getMsg(this.m_ctx, "FileWriteError", true));
        }
        return this.noLines;
    }

    @Record(length=120, paddingChar=32)
    public class CBI_BON_10 {
        public static final String CAUSALE_Emolumenti_Generici = "27000";
        public static final String CAUSALE_Emolumenti_Pensione = "27010";
        public static final String CAUSALE_Emolumenti_Stipendi = "27020";
        public static final String CAUSALE_Giroconto = "34000";
        public static final String CAUSALE_Bonifici_Generici = "48000";
        public static final String CAUSALE_Bonifici_Previdenza = "48015";
        public static final String CAUSALE_Girofondi = "79000";
        public static final String CAUSALE_Rimborsi_Utenti_RID = "ZV000";
        public static final String CAUSALE_Bonifici_CC_Esercenti = "ZZ000";
        public static final String TIPOCODICE_Utenza = "1";
        public static final String TIPOCODICE_Matricola = "2";
        public static final String TIPOCODICE_Codice_Fiscale = "3";
        public static final String TIPOCODICE_Codice_Cliente = "4";
        public static final String TIPOCODICE_Codice_Fornitore = "5";
        public static final String TIPOCODICE_Portafoglio_Commerciale = "6";
        public static final String TIPOCODICE_Altro = "9";
        public static final String MODALITAPAGAMENTO_Bonifico_Giroconto_Girofondo = "1";
        public static final String MODALITAPAGAMENTO_Assegno_Circolare = "2";
        public static final String MODALITAPAGAMENTO_Assegno_Circolare_Non_Trasferibile = "3";
        public static final String MODALITAPAGAMENTO_Assegno_Di_Quietanza = "4";
        private int numeroprogressivo;
        private Date dataesecuzione;
        private Date datavaluta;
        private String causale;
        private BigDecimal importo;
        private String ABICABContoordinante;
        private String ABICABContodestinataria;
        private String SIAordinante;
        private String tipocodice;
        private String codicebeneficiario;
        private String modalitapagamento;

        @Field(offset=2, length=2)
        public String getTipoRecord() {
            return "10";
        }

        private void setNumeroProgressivo(int numeroprogressivo) {
            this.numeroprogressivo = numeroprogressivo;
        }

        @Field(offset=4, length=7, align=Align.RIGHT, paddingChar=48)
        public int getNumeroProgressivo() {
            return this.numeroprogressivo;
        }

        private void setDataEsecuzione(Date dataesecuzione) {
            this.dataesecuzione = dataesecuzione;
        }

        @Field(offset=17, length=6)
        @FixedFormatPattern(value="ddMMyy")
        public Date getDataEsecuzione() {
            return this.dataesecuzione;
        }

        private void setDataValuta(Date datavaluta) {
            this.datavaluta = datavaluta;
        }

        @Field(offset=23, length=6)
        @FixedFormatPattern(value="ddMMyy")
        public Date getDataValuta() {
            return this.datavaluta;
        }

        private void setCausale(String causale) {
            this.causale = causale;
        }

        @Field(offset=29, length=5)
        public String getCausale() {
            return this.causale;
        }

        private void setImporto(BigDecimal importo) {
            this.importo = importo;
        }

        @Field(offset=34, length=13, align=Align.RIGHT, paddingChar=48)
        @FixedFormatDecimal(decimals=2, useDecimalDelimiter=false)
        public BigDecimal getImporto() {
            return this.importo;
        }

        @Field(offset=47, length=1)
        public String getSegno() {
            return "+";
        }

        private void setABICABContoOrdinante(String ABICABConto_Ordinante) {
            this.ABICABContoordinante = ABICABConto_Ordinante;
        }

        @Field(offset=48, length=22)
        public String getABICABContoOrdinante() {
            return this.ABICABContoordinante;
        }

        private void setABICABContoDestinataria(String ABICABConto_Destinataria) {
            this.ABICABContodestinataria = ABICABConto_Destinataria;
        }

        @Field(offset=70, length=22)
        public String getABICABContoDestinataria() {
            return this.ABICABContodestinataria;
        }

        private void setSIAOrdinante(String SIA_Ordinante) {
            this.SIAordinante = SIA_Ordinante;
        }

        @Field(offset=92, length=5)
        public String getSIAOrdinante() {
            return this.SIAordinante;
        }

        private void setTipoCodice(String tipocodice) {
            this.tipocodice = tipocodice;
        }

        public String getTipoCodice() {
            return this.tipocodice;
        }

        private void setCodiceBeneficiario(String codiceBeneficiario) {
            this.codicebeneficiario = codiceBeneficiario;
        }

        @Field(offset=98, length=16)
        public String getCodiceBeneficiario() {
            return this.codicebeneficiario;
        }

        private void setModalitaPagamento(String modalitaPagamento) {
            this.modalitapagamento = modalitaPagamento;
        }

        @Field(offset=114, length=1)
        public String getModalitaPagamento() {
            return this.modalitapagamento;
        }

        @Field(offset=120, length=1)
        public String getDivisa() {
            return "E";
        }

        static /* synthetic */ void access$0(CBI_BON_10 cBI_BON_10, int n) {
            cBI_BON_10.setNumeroProgressivo(n);
        }

        static /* synthetic */ void access$1(CBI_BON_10 cBI_BON_10, Date date) {
            cBI_BON_10.setDataEsecuzione(date);
        }

        static /* synthetic */ void access$2(CBI_BON_10 cBI_BON_10, Date date) {
            cBI_BON_10.setDataValuta(date);
        }

        static /* synthetic */ void access$3(CBI_BON_10 cBI_BON_10, String string) {
            cBI_BON_10.setCausale(string);
        }

        static /* synthetic */ void access$4(CBI_BON_10 cBI_BON_10, BigDecimal bigDecimal) {
            cBI_BON_10.setImporto(bigDecimal);
        }

        static /* synthetic */ void access$5(CBI_BON_10 cBI_BON_10, String string) {
            cBI_BON_10.setABICABContoOrdinante(string);
        }

        static /* synthetic */ void access$6(CBI_BON_10 cBI_BON_10, String string) {
            cBI_BON_10.setABICABContoDestinataria(string);
        }

        static /* synthetic */ void access$7(CBI_BON_10 cBI_BON_10, String string) {
            cBI_BON_10.setTipoCodice(string);
        }

        static /* synthetic */ void access$8(CBI_BON_10 cBI_BON_10, String string) {
            cBI_BON_10.setCodiceBeneficiario(string);
        }

        static /* synthetic */ void access$9(CBI_BON_10 cBI_BON_10, String string) {
            cBI_BON_10.setModalitaPagamento(string);
        }
    }

    @Record(length=120, paddingChar=32)
    public class CBI_BON_16 {
        private int numeroprogressivo;
        private String IBANordinante;

        @Field(offset=2, length=2)
        public String getTipoRecord() {
            return "16";
        }

        private void setNumeroProgressivo(int numeroprogressivo) {
            this.numeroprogressivo = numeroprogressivo;
        }

        @Field(offset=4, length=7, align=Align.RIGHT, paddingChar=48)
        public int getNumeroProgressivo() {
            return this.numeroprogressivo;
        }

        private void setIBANordinante(String IBAN_Ordinante) {
            this.IBANordinante = IBAN_Ordinante;
        }

        @Field(offset=11, length=27)
        public String getIBANordinante() {
            return this.IBANordinante;
        }

        static /* synthetic */ void access$0(CBI_BON_16 cBI_BON_16, int n) {
            cBI_BON_16.setNumeroProgressivo(n);
        }

        static /* synthetic */ void access$1(CBI_BON_16 cBI_BON_16, String string) {
            cBI_BON_16.setIBANordinante(string);
        }
    }

    @Record(length=120, paddingChar=32)
    public class CBI_BON_17 {
        private int numeroprogressivo;
        private String IBANbeneficiario;

        @Field(offset=2, length=2)
        public String getTipoRecord() {
            return "17";
        }

        private void setNumeroProgressivo(int numeroprogressivo) {
            this.numeroprogressivo = numeroprogressivo;
        }

        @Field(offset=4, length=7, align=Align.RIGHT, paddingChar=48)
        public int getNumeroProgressivo() {
            return this.numeroprogressivo;
        }

        private void setIBANbeneficiario(String IBAN_Beneficiario) {
            this.IBANbeneficiario = IBAN_Beneficiario;
        }

        @Field(offset=11, length=27)
        public String getIBANbeneficiario() {
            return this.IBANbeneficiario;
        }

        static /* synthetic */ void access$0(CBI_BON_17 cBI_BON_17, int n) {
            cBI_BON_17.setNumeroProgressivo(n);
        }

        static /* synthetic */ void access$1(CBI_BON_17 cBI_BON_17, String string) {
            cBI_BON_17.setIBANbeneficiario(string);
        }
    }

    @Record(length=120, paddingChar=32)
    public class CBI_BON_20 {
        private int numeroprogressivo;
        private String IBANbeneficiario;
        private String nomeordinante;
        private String indirizzo;
        private String localita;
        private String codicefiscale;

        @Field(offset=2, length=2)
        public String getTipoRecord() {
            return "20";
        }

        private void setNumeroProgressivo(int numeroprogressivo) {
            this.numeroprogressivo = numeroprogressivo;
        }

        @Field(offset=4, length=7, align=Align.RIGHT, paddingChar=48)
        public int getNumeroProgressivo() {
            return this.numeroprogressivo;
        }

        private void setNomeOrdinante(String nomeOrdinante) {
            this.nomeordinante = nomeOrdinante;
        }

        @Field(offset=11, length=30)
        public String getNomeOrdinante() {
            return this.nomeordinante;
        }

        private void setIndirizzo(String indirizzo) {
            this.indirizzo = indirizzo;
        }

        @Field(offset=41, length=30)
        public String getIndirizzo() {
            return this.indirizzo;
        }

        private void setLocalita(String localita) {
            this.localita = localita;
        }

        @Field(offset=71, length=30)
        public String getLocalita() {
            return this.localita;
        }

        private void setCodicefiscale(String codicefiscale) {
            this.codicefiscale = codicefiscale;
        }

        @Field(offset=101, length=16)
        public String getCodicefiscale() {
            return this.codicefiscale;
        }

        static /* synthetic */ void access$0(CBI_BON_20 cBI_BON_20, int n) {
            cBI_BON_20.setNumeroProgressivo(n);
        }

        static /* synthetic */ void access$1(CBI_BON_20 cBI_BON_20, String string) {
            cBI_BON_20.setNomeOrdinante(string);
        }

        static /* synthetic */ void access$2(CBI_BON_20 cBI_BON_20, String string) {
            cBI_BON_20.setIndirizzo(string);
        }

        static /* synthetic */ void access$3(CBI_BON_20 cBI_BON_20, String string) {
            cBI_BON_20.setLocalita(string);
        }

        static /* synthetic */ void access$4(CBI_BON_20 cBI_BON_20, String string) {
            cBI_BON_20.setCodicefiscale(string);
        }
    }

    @Record(length=120, paddingChar=32)
    public class CBI_BON_30 {
        private int numeroprogressivo;
        private String IBANbeneficiario;
        private String nomebeneficiario;
        private String nomebeneficiario2;
        private String nomebeneficiario3;
        private String codicefiscale;

        @Field(offset=2, length=2)
        public String getTipoRecord() {
            return "30";
        }

        private void setNumeroProgressivo(int numeroprogressivo) {
            this.numeroprogressivo = numeroprogressivo;
        }

        @Field(offset=4, length=7, align=Align.RIGHT, paddingChar=48)
        public int getNumeroProgressivo() {
            return this.numeroprogressivo;
        }

        private void setNomeBeneficiario(String nomeBeneficiario) {
            this.nomebeneficiario = nomeBeneficiario;
        }

        @Field(offset=11, length=30)
        public String getNomeBeneficiario() {
            return this.nomebeneficiario;
        }

        private void setNomeBeneficiario2(String nomeBeneficiario) {
            this.nomebeneficiario2 = nomeBeneficiario;
        }

        @Field(offset=41, length=30)
        public String getNomeBeneficiario2() {
            return this.nomebeneficiario2;
        }

        private void setNomeBeneficiario3(String nomeBeneficiario) {
            this.nomebeneficiario3 = nomeBeneficiario;
        }

        @Field(offset=71, length=30)
        public String getNomeBeneficiario3() {
            return this.nomebeneficiario3;
        }

        private void setCodiceFiscale(String codicefiscale) {
            this.codicefiscale = codicefiscale;
        }

        @Field(offset=101, length=16)
        public String getCodiceFiscale() {
            return this.codicefiscale;
        }

        static /* synthetic */ void access$0(CBI_BON_30 cBI_BON_30, int n) {
            cBI_BON_30.setNumeroProgressivo(n);
        }

        static /* synthetic */ void access$1(CBI_BON_30 cBI_BON_30, String string) {
            cBI_BON_30.setNomeBeneficiario(string);
        }

        static /* synthetic */ void access$2(CBI_BON_30 cBI_BON_30, String string) {
            cBI_BON_30.setCodiceFiscale(string);
        }
    }

    @Record(length=120, paddingChar=32)
    public class CBI_BON_40 {
        private int numeroprogressivo;
        private String indirizzo;
        private String cap;
        private String comuneprovincia;
        private String banca;

        @Field(offset=2, length=2)
        public String getTipoRecord() {
            return "40";
        }

        private void setNumeroProgressivo(int numeroprogressivo) {
            this.numeroprogressivo = numeroprogressivo;
        }

        @Field(offset=4, length=7, align=Align.RIGHT, paddingChar=48)
        public int getNumeroProgressivo() {
            return this.numeroprogressivo;
        }

        private void setIndirizzo(String indirizzo) {
            this.indirizzo = indirizzo;
        }

        @Field(offset=11, length=30)
        public String getIndirizzo() {
            return this.indirizzo;
        }

        private void setCAP(String CAP) {
            this.cap = CAP;
        }

        @Field(offset=41, length=5)
        public String getCAP() {
            return this.cap;
        }

        private void setComuneProvincia(String comuneProvincia) {
            this.comuneprovincia = comuneProvincia;
        }

        @Field(offset=46, length=25)
        public String getComuneProvincia() {
            return this.comuneprovincia;
        }

        private void setBanca(String banca) {
            this.banca = banca;
        }

        @Field(offset=71, length=50)
        public String getBanca() {
            return this.banca;
        }

        static /* synthetic */ void access$0(CBI_BON_40 cBI_BON_40, int n) {
            cBI_BON_40.setNumeroProgressivo(n);
        }

        static /* synthetic */ void access$1(CBI_BON_40 cBI_BON_40, String string) {
            cBI_BON_40.setIndirizzo(string);
        }

        static /* synthetic */ void access$2(CBI_BON_40 cBI_BON_40, String string) {
            cBI_BON_40.setComuneProvincia(string);
        }

        static /* synthetic */ void access$3(CBI_BON_40 cBI_BON_40, String string) {
            cBI_BON_40.setCAP(string);
        }
    }

    @Record(length=120, paddingChar=32)
    public class CBI_BON_5060 {
        private String tiporecord;
        private int numeroprogressivo;
        private String riferimento1;
        private String riferimento2;
        private String riferimento3;

        private void setTipoRecord(String tipoRecord) {
            this.tiporecord = tipoRecord;
        }

        @Field(offset=2, length=2)
        public String getTipoRecord() {
            return this.tiporecord;
        }

        private void setNumeroProgressivo(int numeroprogressivo) {
            this.numeroprogressivo = numeroprogressivo;
        }

        @Field(offset=4, length=7, align=Align.RIGHT, paddingChar=48)
        public int getNumeroProgressivo() {
            return this.numeroprogressivo;
        }

        private void setRiferimento1(String Riferimento1) {
            this.riferimento1 = Riferimento1;
        }

        @Field(offset=11, length=30)
        public String getRiferimento1() {
            return this.riferimento1;
        }

        private void setRiferimento2(String Riferimento2) {
            this.riferimento2 = Riferimento2;
        }

        @Field(offset=41, length=30)
        public String getRiferimento2() {
            return this.riferimento2;
        }

        private void setRiferimento3(String Riferimento3) {
            this.riferimento3 = Riferimento3;
        }

        @Field(offset=71, length=30)
        public String getRiferimento3() {
            return this.riferimento3;
        }

        static /* synthetic */ void access$0(CBI_BON_5060 cBI_BON_5060, String string) {
            cBI_BON_5060.setTipoRecord(string);
        }

        static /* synthetic */ void access$1(CBI_BON_5060 cBI_BON_5060, int n) {
            cBI_BON_5060.setNumeroProgressivo(n);
        }

        static /* synthetic */ void access$2(CBI_BON_5060 cBI_BON_5060, String string) {
            cBI_BON_5060.setRiferimento1(string);
        }

        static /* synthetic */ void access$3(CBI_BON_5060 cBI_BON_5060, String string) {
            cBI_BON_5060.setRiferimento2(string);
        }

        static /* synthetic */ void access$4(CBI_BON_5060 cBI_BON_5060, String string) {
            cBI_BON_5060.setRiferimento3(string);
        }
    }

    @Record(length=120, paddingChar=32)
    public class CBI_BON_70 {
        private int numeroprogressivo;

        @Field(offset=2, length=2)
        public String getTipoRecord() {
            return "70";
        }

        private void setNumeroProgressivo(int numeroprogressivo) {
            this.numeroprogressivo = numeroprogressivo;
        }

        @Field(offset=4, length=7, align=Align.RIGHT, paddingChar=48)
        public int getNumeroProgressivo() {
            return this.numeroprogressivo;
        }

        static /* synthetic */ void access$0(CBI_BON_70 cBI_BON_70, int n) {
            cBI_BON_70.setNumeroProgressivo(n);
        }
    }

    @Record(length=120, paddingChar=32)
    public class CBI_BON_EF {
        private String mittente;
        private String abiricevente;
        private Date datacreazione;
        private String nomesupporto;
        private String campolibero;
        private int numerodisposizioni;
        private BigDecimal totimporti;
        private int numerorecord;

        @Field(offset=2, length=2)
        public String getTipoRecord() {
            return "EF";
        }

        void setSIAMittente(String SIA_Mittente) {
            this.mittente = SIA_Mittente;
        }

        @Field(offset=4, length=5)
        public String getSIAMittente() {
            return this.mittente;
        }

        void setABIRicevente(String ABI_Ricevente) {
            this.abiricevente = ABI_Ricevente;
        }

        @Field(offset=9, length=5)
        public String getABIRicevente() {
            return this.abiricevente;
        }

        void setDataCreazione(Date dataCreazione) {
            this.datacreazione = dataCreazione;
        }

        @Field(offset=14, length=6)
        @FixedFormatPattern(value="ddMMyy")
        public Date getDataCreazione() {
            return this.datacreazione;
        }

        void setNomesupporto(String nomeSupporto) {
            this.nomesupporto = nomeSupporto;
        }

        @Field(offset=20, length=20)
        public String getNomesupporto() {
            return this.nomesupporto;
        }

        void setCampoLibero(String campoLibero) {
            this.campolibero = campoLibero;
        }

        @Field(offset=40, length=6)
        public String getCampoLibero() {
            return this.campolibero;
        }

        void setNumeroDisposizioni(int numeroDisposizioni) {
            this.numerodisposizioni = numeroDisposizioni;
        }

        @Field(offset=46, length=7, align=Align.RIGHT, paddingChar=48)
        public int getNumeroDisposizioni() {
            return this.numerodisposizioni;
        }

        @Field(offset=53, length=15, align=Align.RIGHT, paddingChar=48)
        public int getTotImportiNegativi() {
            return 0;
        }

        private void setTotImporti(BigDecimal totImporti) {
            this.totimporti = totImporti;
        }

        @Field(offset=68, length=15, align=Align.RIGHT, paddingChar=48)
        @FixedFormatDecimal(decimals=2, useDecimalDelimiter=false)
        public BigDecimal getTotImporti() {
            return this.totimporti;
        }

        private void setNumeroRecord(int numeroRecord) {
            this.numerorecord = numeroRecord;
        }

        @Field(offset=83, length=7, align=Align.RIGHT, paddingChar=48)
        public int getNumeroRecord() {
            return this.numerorecord;
        }

        @Field(offset=114, length=1)
        public String getDivisa() {
            return "E";
        }
    }

    @Record(length=120, paddingChar=32)
    public class CBI_BON_PC {
        private String mittente;
        private String abiricevente;
        private Date datacreazione;
        private String nomesupporto;
        private String campolibero;

        @Field(offset=2, length=2)
        public String getTipoRecord() {
            return "PC";
        }

        void setSIAMittente(String SIA_Mittente) {
            this.mittente = SIA_Mittente;
        }

        @Field(offset=4, length=5)
        public String getSIAMittente() {
            return this.mittente;
        }

        void setABIRicevente(String ABI_Ricevente) {
            this.abiricevente = ABI_Ricevente;
        }

        @Field(offset=9, length=5)
        public String getABIRicevente() {
            return this.abiricevente;
        }

        void setDataCreazione(Date dataCreazione) {
            this.datacreazione = dataCreazione;
        }

        @Field(offset=14, length=6)
        @FixedFormatPattern(value="ddMMyy")
        public Date getDataCreazione() {
            return this.datacreazione;
        }

        void setNomesupporto(String nomeSupporto) {
            this.nomesupporto = nomeSupporto;
        }

        @Field(offset=20, length=20)
        public String getNomesupporto() {
            return this.nomesupporto;
        }

        void setCampoLibero(String campoLibero) {
            this.campolibero = campoLibero;
        }

        @Field(offset=40, length=6)
        public String getCampoLibero() {
            return this.campolibero;
        }

        @Field(offset=114, length=1)
        public String getDivisa() {
            return "E";
        }
    }

    @Record(length=30, paddingChar=32)
    public class RifDoc {
        private String numerodocumento;
        private Date datadocumento;

        private void setNumeroDocumento(String numeroDocumento) {
            this.numerodocumento = numeroDocumento;
        }

        @Field(offset=1, length=24)
        public String getNumeroDocumento() {
            return this.numerodocumento;
        }

        private void setDataDocumento(Date dataDocumento) {
            this.datadocumento = dataDocumento;
        }

        @Field(offset=25, length=6)
        @FixedFormatPattern(value="ddMMyy")
        public Date getDataDocumento() {
            return this.datadocumento;
        }

        static /* synthetic */ void access$0(RifDoc rifDoc, String string) {
            rifDoc.setNumeroDocumento(string);
        }

        static /* synthetic */ void access$1(RifDoc rifDoc, Date date) {
            rifDoc.setDataDocumento(date);
        }
    }
}

