/*
 * Decompiled with CFR 0.152.
 */
package it.nectosoft.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Savepoint;
import java.sql.Timestamp;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MPeriod;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class InvoiceDeleteREVO
extends SvrProcess {
    private int m_AD_Client_ID = 0;
    private int m_C_Invoice_ID = 0;
    private Timestamp m_DateAcct_from = null;
    private Timestamp m_DateAcct_to = null;
    private int m_C_BPartner_ID = 0;
    private String m_isSOTrx = "N";
    private Properties m_ctx = null;
    private String m_trx = null;
    private Trx localTrx = null;
    private MInvoice m_invoice = null;
    private MInvoice m_reverse = null;
    private int reverseID = 0;
    protected List<Integer> m_lstDelInvID = new LinkedList<Integer>();
    protected static final String NO_REVERSE_ID = "LIT_NoReverseID";
    protected static final String DOC_NO = "DocumentNo";

    @Override
    protected String doIt() throws Exception {
        int countError;
        int count;
        block32: {
            count = 0;
            countError = 0;
            StringBuilder sql = new StringBuilder("SELECT * FROM C_INVOICE ").append(" WHERE AD_Client_ID=?").append(" AND DocStatus in ('VO','RE')");
            if (this.m_C_Invoice_ID > 0) {
                sql.append(" AND C_Invoice_ID=?");
            } else {
                if (this.m_DateAcct_from != null && this.m_DateAcct_to != null) {
                    sql.append(" AND DateAcct BETWEEN ? AND ?");
                }
                sql.append(" AND IsSOTrx=?");
                if (this.m_C_BPartner_ID > 0) {
                    sql.append(" AND C_BPartner_ID=?");
                }
            }
            this.m_trx = Trx.createTrxName("IDRV");
            this.localTrx = Trx.get(this.m_trx, true);
            Savepoint savepoint = null;
            CPreparedStatement pstmt = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), this.m_trx);
                    int index = 1;
                    pstmt.setInt(index++, this.m_AD_Client_ID);
                    if (this.m_C_Invoice_ID > 0) {
                        pstmt.setInt(index++, this.m_C_Invoice_ID);
                    } else {
                        if (this.m_DateAcct_from != null && this.m_DateAcct_to != null) {
                            pstmt.setTimestamp(index++, this.m_DateAcct_from);
                            pstmt.setTimestamp(index++, this.m_DateAcct_to);
                        }
                        pstmt.setString(index++, this.m_isSOTrx);
                        if (this.m_C_BPartner_ID > 0) {
                            pstmt.setInt(index++, this.m_C_BPartner_ID);
                        }
                    }
                    ResultSet rs = pstmt.executeQuery();
                    while (rs.next()) {
                        block30: {
                            StringBuilder sb;
                            StringBuilder sb2;
                            String sMessage;
                            block29: {
                                this.m_invoice = new MInvoice(this.m_ctx, rs, this.m_trx);
                                MDocType dt = MDocType.get(this.m_ctx, this.m_invoice.getC_DocType_ID());
                                if (!MPeriod.isOpen(this.m_ctx, this.m_invoice.getDateAcct(), dt.getDocBaseType(), this.m_invoice.getAD_Org_ID())) continue;
                                savepoint = this.localTrx.setSavepoint(null);
                                boolean bRollback = false;
                                this.reverseID = this.m_invoice.getReversal_ID();
                                if (this.m_invoice.getDocStatus().equals("RE")) {
                                    if (this.reverseID > 0) {
                                        this.m_invoice.setReversal_ID(-1);
                                        try {
                                            this.m_invoice.saveEx(this.m_trx);
                                            if (!this.deleteReversedByID(this.reverseID)) {
                                                this.localTrx.rollback(savepoint);
                                            }
                                            break block29;
                                        }
                                        catch (Exception e) {
                                            this.log.log(Level.SEVERE, sql.toString(), e);
                                            sMessage = e.getLocalizedMessage();
                                            if (sMessage == null) {
                                                sMessage = e.getMessage();
                                            }
                                            sb2 = new StringBuilder();
                                            sb2.append(Msg.translate(Env.getCtx(), DOC_NO));
                                            sb2.append(": ").append(this.m_invoice.get_ID());
                                            sb2.append(" - ").append(sMessage);
                                            this.addLog(sb2.toString());
                                            this.localTrx.rollback(savepoint);
                                        }
                                        continue;
                                    }
                                    sb = new StringBuilder();
                                    sb.append(Msg.translate(Env.getCtx(), DOC_NO));
                                    sb.append(": ").append(this.m_invoice.get_ID());
                                    sb.append(" - ").append(Msg.getMsg(Env.getCtx(), NO_REVERSE_ID));
                                    this.addLog(sb.toString());
                                    if (!this.deleteReversed()) {
                                        this.localTrx.rollback(savepoint);
                                        continue;
                                    }
                                }
                            }
                            if (this.m_invoice.getDocStatus().equals("VO")) {
                                if (this.reverseID > 0) {
                                    this.m_invoice.setReversal_ID(-1);
                                    try {
                                        this.m_invoice.saveEx(this.m_trx);
                                        if (!this.deleteReversedByID(this.reverseID)) {
                                            this.localTrx.rollback(savepoint);
                                        }
                                        break block30;
                                    }
                                    catch (Exception e) {
                                        this.log.log(Level.SEVERE, sql.toString(), e);
                                        sMessage = e.getLocalizedMessage();
                                        if (sMessage == null) {
                                            sMessage = e.getMessage();
                                        }
                                        sb2 = new StringBuilder();
                                        sb2.append(Msg.translate(Env.getCtx(), DOC_NO));
                                        sb2.append(": ").append(this.m_invoice.get_ID());
                                        sb2.append(" - ").append(sMessage);
                                        this.addLog(sb2.toString());
                                        this.localTrx.rollback(savepoint);
                                    }
                                    continue;
                                }
                                sb = new StringBuilder();
                                sb.append(Msg.translate(Env.getCtx(), DOC_NO));
                                sb.append(": ").append(this.m_invoice.get_ID());
                                sb.append(" - ").append(Msg.getMsg(Env.getCtx(), NO_REVERSE_ID));
                                this.addLog(sb.toString());
                                if (!this.deleteReversed()) {
                                    this.localTrx.rollback(savepoint);
                                    continue;
                                }
                            }
                        }
                        if (this.deleteInvoice(this.m_invoice, false)) {
                            this.localTrx.commit(true);
                            ++count;
                            continue;
                        }
                        this.localTrx.rollback(savepoint);
                        ++countError;
                    }
                    rs.close();
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql.toString(), e);
                    String sMessage = e.getLocalizedMessage();
                    if (sMessage == null) {
                        sMessage = e.getMessage();
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append(Msg.translate(Env.getCtx(), DOC_NO));
                    sb.append(": ").append(this.m_invoice.get_ID());
                    sb.append(" - ").append(sMessage);
                    this.addLog(sb.toString());
                    DB.close(pstmt);
                    break block32;
                }
            }
            catch (Throwable throwable) {
                DB.close(pstmt);
                throw throwable;
            }
            DB.close(pstmt);
        }
        this.localTrx.close();
        return "@Completed@ = " + count + " - @Errors@=" + countError;
    }

    private boolean deleteReversedByID(int reverseID2) {
        boolean bDeleted;
        block7: {
            bDeleted = false;
            String sql = "SELECT * FROM C_INVOICE WHERE C_INVOICE_ID=?";
            CPreparedStatement pstmt = null;
            try {
                try {
                    pstmt = DB.prepareStatement("SELECT * FROM C_INVOICE WHERE C_INVOICE_ID=?", this.m_trx);
                    pstmt.setInt(1, reverseID2);
                    ResultSet rs = pstmt.executeQuery();
                    if (rs.next()) {
                        this.m_reverse = new MInvoice(this.m_ctx, rs, this.m_trx);
                        bDeleted = this.deleteInvoice(this.m_reverse, true);
                    }
                    rs.close();
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "SELECT * FROM C_INVOICE WHERE C_INVOICE_ID=?".toString(), e);
                    String sMessage = e.getLocalizedMessage();
                    if (sMessage == null) {
                        sMessage = e.getMessage();
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append(Msg.translate(Env.getCtx(), DOC_NO));
                    sb.append(": ").append(this.m_invoice.get_ID());
                    sb.append(" - ").append(sMessage);
                    this.addLog(sb.toString());
                    DB.close(pstmt);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(pstmt);
                throw throwable;
            }
            DB.close(pstmt);
        }
        return bDeleted;
    }

    private boolean deleteInvoice(MInvoice a_inv, boolean isReverse) {
        boolean bDeleted = false;
        int iInvoiceId = a_inv.get_ID();
        if (this.m_lstDelInvID.contains(iInvoiceId)) {
            bDeleted = true;
        } else {
            Object[] iparam;
            String sql;
            block10: {
                sql = null;
                iparam = new Object[]{a_inv.getC_Invoice_ID()};
                if (this.deleteAllocations(a_inv.getC_Invoice_ID())) break block10;
                return false;
            }
            try {
                sql = "DELETE FROM M_CostDetail WHERE C_InvoiceLine_ID in (SELECT C_InvoiceLine_ID FROM C_InvoiceLine WHERE C_Invoice_ID = ?)";
                DB.executeUpdateEx(sql, iparam, this.m_trx);
                sql = "DELETE FROM C_TaxDeclarationLine WHERE C_Invoice_ID = ?";
                DB.executeUpdateEx(sql, iparam, this.m_trx);
                sql = "UPDATE C_BankStatementLine SET C_Invoice_ID = NULL WHERE C_Invoice_ID = ?";
                DB.executeUpdateEx(sql, iparam, this.m_trx);
                sql = "DELETE FROM LIT_Invoice_Auto WHERE C_Invoice_ID = ?";
                DB.executeUpdateEx(sql, iparam, this.m_trx);
                if (!isReverse) {
                    sql = "DELETE FROM M_CostDetail WHERE C_InvoiceLine_ID in (SELECT C_InvoiceLine_ID FROM C_InvoiceLine WHERE C_Invoice_ID = ?)";
                    DB.executeUpdateEx(sql, iparam, this.m_trx);
                    sql = "UPDATE S_TimeExpenseLine SET C_InvoiceLine_ID = NULL WHERE C_InvoiceLine_ID in (SELECT C_InvoiceLine_ID FROM C_InvoiceLine WHERE C_Invoice_ID = ?)";
                    DB.executeUpdateEx(sql, iparam, this.m_trx);
                    sql = "UPDATE C_InvoiceLine SET Ref_InvoiceLine_ID = NULL WHERE Ref_InvoiceLine_ID in (SELECT C_InvoiceLine_ID FROM C_InvoiceLine WHERE C_Invoice_ID = ?)";
                    DB.executeUpdateEx(sql, iparam, this.m_trx);
                    sql = "UPDATE M_InOutLineConfirm SET C_InvoiceLine_ID = NULL WHERE C_InvoiceLine_ID in (SELECT C_InvoiceLine_ID FROM C_InvoiceLine WHERE C_Invoice_ID = ?)";
                    DB.executeUpdateEx(sql, iparam, this.m_trx);
                    sql = "DELETE FROM LIT_InvoiceWithholding WHERE C_Invoice_ID = ?";
                    DB.executeUpdateEx(sql, iparam, this.m_trx);
                    sql = "UPDATE C_InvoiceBatchLine SET C_Invoice_ID = NULL, C_InvoiceLine_ID = NULL WHERE C_Invoice_ID = ?";
                    DB.executeUpdateEx(sql, iparam, this.m_trx);
                    sql = "UPDATE R_Request SET C_Invoice_ID = NULL WHERE C_Invoice_ID = ?";
                    DB.executeUpdateEx(sql, iparam, this.m_trx);
                    sql = "UPDATE R_Request SET C_InvoiceRequest_ID = NULL WHERE C_InvoiceRequest_ID = ?";
                    DB.executeUpdateEx(sql, iparam, this.m_trx);
                    sql = "UPDATE R_RequestAction SET C_Invoice_ID = NULL WHERE C_Invoice_ID = ?";
                    DB.executeUpdateEx(sql, iparam, this.m_trx);
                    sql = "UPDATE M_InOut SET C_Invoice_ID = NULL WHERE C_Invoice_ID = ?";
                    DB.executeUpdateEx(sql, iparam, this.m_trx);
                    sql = "UPDATE C_Payment SET C_Invoice_ID = NULL WHERE C_Invoice_ID = ?";
                    DB.executeUpdateEx(sql, iparam, this.m_trx);
                    sql = "UPDATE M_InOutConfirm SET C_Invoice_ID = NULL WHERE C_Invoice_ID = ?";
                    DB.executeUpdateEx(sql, iparam, this.m_trx);
                }
                sql = "DELETE FROM Fact_Acct WHERE RECORD_ID = ? AND AD_Table_ID = 318";
                DB.executeUpdateEx(sql, iparam, this.m_trx);
                a_inv.setC_Order_ID(0);
                try {
                    a_inv.deleteEx(true, this.m_trx);
                    this.m_lstDelInvID.add(iInvoiceId);
                    bDeleted = true;
                }
                catch (Exception e) {
                    String sMessage = e.getLocalizedMessage();
                    if (sMessage == null) {
                        sMessage = e.getMessage();
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append(Msg.translate(Env.getCtx(), DOC_NO));
                    sb.append(": ").append(this.m_invoice.get_ID());
                    sb.append(" - ").append(sMessage);
                    this.addLog(sb.toString());
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql.toString(), e);
                String sMessage = e.getLocalizedMessage();
                if (sMessage == null) {
                    sMessage = e.getMessage();
                }
                StringBuilder sb = new StringBuilder();
                sb.append(Msg.translate(Env.getCtx(), DOC_NO));
                sb.append(": ").append(this.m_invoice.get_ID());
                sb.append(" - ").append(sMessage);
                this.addLog(sb.toString());
            }
        }
        return bDeleted;
    }

    private boolean deleteAllocations(int cInvoiceID) {
        boolean deleted;
        block10: {
            deleted = true;
            StringBuffer sql = new StringBuffer("SELECT * FROM C_ALLOCATIONHDR ").append(" WHERE C_ALLOCATIONHDR_ID IN ").append(" (SELECT DISTINCT C_ALLOCATIONHDR_ID FROM C_ALLOCATIONLINE WHERE C_INVOICE_ID=?) ");
            MAllocationHdr m_alloc = null;
            CPreparedStatement pstmt = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), this.m_trx);
                    int index = 1;
                    pstmt.setInt(index++, cInvoiceID);
                    ResultSet rs = pstmt.executeQuery();
                    while (rs.next()) {
                        m_alloc = new MAllocationHdr(this.m_ctx, rs, this.m_trx);
                        try {
                            m_alloc.deleteEx(true, this.m_trx);
                        }
                        catch (Exception e) {
                            this.log.log(Level.SEVERE, sql.toString(), e);
                            String sMessage = e.getLocalizedMessage();
                            if (sMessage == null) {
                                sMessage = e.getMessage();
                            }
                            StringBuilder sb = new StringBuilder();
                            sb.append(Msg.translate(Env.getCtx(), DOC_NO));
                            sb.append(": ").append(this.m_invoice.get_ID());
                            sb.append(" - ").append(sMessage);
                            this.addLog(sb.toString());
                        }
                    }
                    rs.close();
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql.toString(), e);
                    deleted = false;
                    String sMessage = e.getLocalizedMessage();
                    if (sMessage == null) {
                        sMessage = e.getMessage();
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append(Msg.translate(Env.getCtx(), DOC_NO));
                    sb.append(": ").append(this.m_invoice.get_ID());
                    sb.append(" - ").append(sMessage);
                    this.addLog(sb.toString());
                    DB.close(pstmt);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(pstmt);
                throw throwable;
            }
            DB.close(pstmt);
        }
        return deleted;
    }

    private boolean deleteReversed() {
        boolean bDeleted;
        block7: {
            bDeleted = false;
            StringBuffer sql = new StringBuffer("SELECT * FROM C_INVOICE ").append(" WHERE AD_Client_ID=?").append(" AND IsSOTrx=?").append(" AND DateInvoiced = ?").append(" AND C_BPartner_ID=?").append(" AND DocStatus = 'RE' AND Description LIKE '%{->" + this.m_invoice.getDocumentNo() + ")%'");
            CPreparedStatement pstmt = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), this.m_trx);
                    int index = 1;
                    pstmt.setInt(index++, this.m_AD_Client_ID);
                    pstmt.setString(index++, this.m_isSOTrx);
                    pstmt.setTimestamp(index++, this.m_invoice.getDateInvoiced());
                    pstmt.setInt(index++, this.m_invoice.getC_BPartner_ID());
                    ResultSet rs = pstmt.executeQuery();
                    if (rs.next()) {
                        this.m_reverse = new MInvoice(this.m_ctx, rs, this.m_trx);
                        bDeleted = this.deleteInvoice(this.m_reverse, true);
                    }
                    rs.close();
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql.toString(), e);
                    String sMessage = e.getLocalizedMessage();
                    if (sMessage == null) {
                        sMessage = e.getMessage();
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append(Msg.translate(Env.getCtx(), DOC_NO));
                    sb.append(": ").append(this.m_invoice.get_ID());
                    sb.append(" - ").append(sMessage);
                    this.addLog(sb.toString());
                    DB.close(pstmt);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(pstmt);
                throw throwable;
            }
            DB.close(pstmt);
        }
        return bDeleted;
    }

    @Override
    protected void prepare() {
        this.m_ctx = this.getCtx();
        this.m_AD_Client_ID = this.getAD_Client_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_Invoice_ID")) {
                    this.m_C_Invoice_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("IsSOTrx")) {
                    this.m_isSOTrx = para[i].getParameter().toString();
                } else if (name.equals("C_BPartner_ID")) {
                    this.m_C_BPartner_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("DateAcct")) {
                    this.m_DateAcct_from = (Timestamp)para[i].getParameter();
                    this.m_DateAcct_to = (Timestamp)para[i].getParameter_To();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }
}

