/*
 * Decompiled with CFR 0.152.
 */
package it.nectosoft.process;

import it.nectosoft.process.XMLBancheHandlerCSV;
import it.nectosoft.process.XMLLocalitaHandler;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.compiere.Adempiere;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ImportaBanche
extends SvrProcess {
    private String m_fileLocalita = "";
    private String m_fileBanche = "";
    private String m_fileOutput = "";
    protected SAXParser m_parser;
    private HashMap<String, String> m_comuni = null;

    @Override
    protected String doIt() throws Exception {
        FileInputStream m_stmLoc = new FileInputStream(this.m_fileLocalita);
        FileInputStream m_stmBan = new FileInputStream(this.m_fileBanche);
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            this.m_parser = factory.newSAXParser();
            XMLLocalitaHandler lh = new XMLLocalitaHandler();
            this.m_parser.parse(new InputSource(m_stmLoc), (DefaultHandler)lh);
            this.m_comuni = lh.getComuni();
            XMLBancheHandlerCSV bh = new XMLBancheHandlerCSV(this.m_fileOutput, this.m_comuni);
            this.m_parser.parse(new InputSource(m_stmBan), (DefaultHandler)bh);
        }
        catch (ParserConfigurationException e) {
            return "Unable to configure SAX parser: " + e.getMessage();
        }
        catch (SAXException e) {
            return "Unable to initialize SAX parser: " + e.getMessage();
        }
        return null;
    }

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null && name.equals("Localita")) {
                this.m_fileLocalita = (String)para[i].getParameter();
            }
            if (name.equals("Banche")) {
                this.m_fileBanche = (String)para[i].getParameter();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
    }

    public static void main(String[] args) throws Exception {
        Adempiere.startup(true);
        Env.setContext(Env.getCtx(), "#AD_Client_ID", 1000001);
        Env.setContext(Env.getCtx(), "#AD_Org_ID", 1000001);
        ImportaBanche ib = new ImportaBanche();
        ib.m_fileLocalita = "c:\\temp\\LOCGEO.XML";
        ib.m_fileBanche = "c:\\temp\\TOTSUCC.XML";
        ib.m_fileOutput = "c:\\temp\\bancheall.csv";
        try {
            ib.doIt();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }
}

